/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.internal.ws.api.wsdl.TWSDLParserContext;
import com.sun.tools.internal.ws.util.xml.XmlUtil;
import com.sun.tools.internal.ws.wsdl.document.WSDLConstants;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEConstants;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEContent;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEMultipartRelated;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEPart;
import com.sun.tools.internal.ws.wsdl.document.mime.MIMEXml;
import com.sun.tools.internal.ws.wsdl.parser.AbstractExtensionHandler;
import com.sun.tools.internal.ws.wsdl.parser.Util;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIMEExtensionHandler
extends AbstractExtensionHandler {
    public MIMEExtensionHandler(Map<String, AbstractExtensionHandler> map) {
        super(map);
    }

    @Override
    public String getNamespaceURI() {
        return "http://schemas.xmlsoap.org/wsdl/mime/";
    }

    @Override
    public boolean doHandleExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (tWSDLExtensible.getWSDLElementName().equals(WSDLConstants.QNAME_OUTPUT)) {
            return this.handleInputOutputExtension(tWSDLParserContext, tWSDLExtensible, element);
        }
        if (tWSDLExtensible.getWSDLElementName().equals(WSDLConstants.QNAME_INPUT)) {
            return this.handleInputOutputExtension(tWSDLParserContext, tWSDLExtensible, element);
        }
        if (tWSDLExtensible.getWSDLElementName().equals(MIMEConstants.QNAME_PART)) {
            return this.handleMIMEPartExtension(tWSDLParserContext, tWSDLExtensible, element);
        }
        return false;
    }

    protected boolean handleInputOutputExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_MULTIPART_RELATED)) {
            Element element2;
            tWSDLParserContext.push();
            tWSDLParserContext.registerNamespaces(element);
            MIMEMultipartRelated mIMEMultipartRelated = new MIMEMultipartRelated(tWSDLParserContext.getLocation(element));
            Iterator iterator = XmlUtil.getAllChildren((Element)element);
            while (iterator.hasNext() && (element2 = Util.nextElement(iterator)) != null) {
                if (XmlUtil.matchesTagNS(element2, MIMEConstants.QNAME_PART)) {
                    Element element3;
                    tWSDLParserContext.push();
                    tWSDLParserContext.registerNamespaces(element2);
                    MIMEPart mIMEPart = new MIMEPart(tWSDLParserContext.getLocation(element2));
                    String string = XmlUtil.getAttributeOrNull((Element)element2, (String)"name");
                    if (string != null) {
                        mIMEPart.setName(string);
                    }
                    Iterator iterator2 = XmlUtil.getAllChildren((Element)element2);
                    while (iterator2.hasNext() && (element3 = Util.nextElement(iterator2)) != null) {
                        String string2;
                        AbstractExtensionHandler abstractExtensionHandler = this.getExtensionHandlers().get(element3.getNamespaceURI());
                        boolean bl = false;
                        if (abstractExtensionHandler != null) {
                            bl = abstractExtensionHandler.doHandleExtension(tWSDLParserContext, mIMEPart, element3);
                        }
                        if (bl || (string2 = XmlUtil.getAttributeNSOrNull((Element)element3, (String)"required", (String)"http://schemas.xmlsoap.org/wsdl/")) == null || !string2.equals("true")) continue;
                        Util.fail("parsing.requiredExtensibilityElement", element3.getTagName(), element3.getNamespaceURI());
                    }
                    mIMEMultipartRelated.add(mIMEPart);
                    tWSDLParserContext.pop();
                    continue;
                }
                Util.fail("parsing.invalidElement", element2.getTagName(), element2.getNamespaceURI());
            }
            tWSDLExtensible.addExtension(mIMEMultipartRelated);
            tWSDLParserContext.pop();
            return true;
        }
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent mIMEContent = this.parseMIMEContent(tWSDLParserContext, element);
            tWSDLExtensible.addExtension(mIMEContent);
            return true;
        }
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mIMEXml = this.parseMIMEXml(tWSDLParserContext, element);
            tWSDLExtensible.addExtension(mIMEXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    @Override
    protected boolean handleMIMEPartExtension(TWSDLParserContext tWSDLParserContext, TWSDLExtensible tWSDLExtensible, Element element) {
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_CONTENT)) {
            MIMEContent mIMEContent = this.parseMIMEContent(tWSDLParserContext, element);
            tWSDLExtensible.addExtension(mIMEContent);
            return true;
        }
        if (XmlUtil.matchesTagNS(element, MIMEConstants.QNAME_MIME_XML)) {
            MIMEXml mIMEXml = this.parseMIMEXml(tWSDLParserContext, element);
            tWSDLExtensible.addExtension(mIMEXml);
            return true;
        }
        Util.fail("parsing.invalidExtensionElement", element.getTagName(), element.getNamespaceURI());
        return false;
    }

    protected MIMEContent parseMIMEContent(TWSDLParserContext tWSDLParserContext, Element element) {
        String string;
        tWSDLParserContext.push();
        tWSDLParserContext.registerNamespaces(element);
        MIMEContent mIMEContent = new MIMEContent(tWSDLParserContext.getLocation(element));
        String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"part");
        if (string2 != null) {
            mIMEContent.setPart(string2);
        }
        if ((string = XmlUtil.getAttributeOrNull((Element)element, (String)"type")) != null) {
            mIMEContent.setType(string);
        }
        tWSDLParserContext.pop();
        return mIMEContent;
    }

    protected MIMEXml parseMIMEXml(TWSDLParserContext tWSDLParserContext, Element element) {
        tWSDLParserContext.push();
        tWSDLParserContext.registerNamespaces(element);
        MIMEXml mIMEXml = new MIMEXml(tWSDLParserContext.getLocation(element));
        String string = XmlUtil.getAttributeOrNull((Element)element, (String)"part");
        if (string != null) {
            mIMEXml.setPart(string);
        }
        tWSDLParserContext.pop();
        return mIMEXml;
    }
}

