/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc;

import com.ibm.xml.resolver.CatalogManager;
import com.ibm.xml.resolver.tools.CatalogResolver;
import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.writer.FileCodeWriter;
import com.sun.codemodel.internal.writer.PrologCodeWriter;
import com.sun.tools.internal.xjc.BadCommandLineException;
import com.sun.tools.internal.xjc.Language;
import com.sun.tools.internal.xjc.Messages;
import com.sun.tools.internal.xjc.Plugin;
import com.sun.tools.internal.xjc.api.ClassNameAllocator;
import com.sun.tools.internal.xjc.api.SpecVersion;
import com.sun.tools.internal.xjc.generator.bean.field.FieldRendererFactory;
import com.sun.tools.internal.xjc.reader.Util;
import com.sun.xml.internal.bind.api.impl.NameConverter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options {
    public boolean debugMode;
    public boolean verbose;
    public boolean quiet;
    public boolean readOnly;
    public boolean noFileHeader;
    public boolean strictCheck = true;
    public boolean runtime14 = false;
    public boolean automaticNameConflictResolution = false;
    public static final int STRICT = 1;
    public static final int EXTENSION = 2;
    public int compatibilityMode = 1;
    public SpecVersion target = SpecVersion.LATEST;
    private boolean is2_2 = true;
    public File targetDir = new File(".");
    public EntityResolver entityResolver = null;
    private Language schemaLanguage = null;
    public String defaultPackage = null;
    public String defaultPackage2 = null;
    private final List<InputSource> grammars = new ArrayList<InputSource>();
    private final List<InputSource> bindFiles = new ArrayList<InputSource>();
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUser = null;
    private String proxyPassword = null;
    public final List<Plugin> activePlugins = new ArrayList<Plugin>();
    private List<Plugin> allPlugins;
    public final Set<String> pluginURIs = new HashSet<String>();
    public ClassNameAllocator classNameAllocator;
    public boolean packageLevelAnnotations = true;
    private FieldRendererFactory fieldRendererFactory = new FieldRendererFactory();
    private Plugin fieldRendererFactoryOwner = null;
    private NameConverter nameConverter = null;
    private Plugin nameConverterOwner = null;
    public final List<URL> classpaths = new ArrayList<URL>();
    private static String pluginLoadFailure;

    public boolean isExtensionMode() {
        return this.compatibilityMode == 2;
    }

    public Options() {
        if (this.is2_2) {
            try {
                Class.forName("javax.xml.bind.JAXBPermission");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.is2_2 = false;
            }
            this.target = !this.is2_2 ? SpecVersion.V2_1 : SpecVersion.LATEST;
        }
    }

    public FieldRendererFactory getFieldRendererFactory() {
        return this.fieldRendererFactory;
    }

    public void setFieldRendererFactory(FieldRendererFactory fieldRendererFactory, Plugin plugin) throws BadCommandLineException {
        if (fieldRendererFactory == null) {
            throw new IllegalArgumentException();
        }
        if (this.fieldRendererFactoryOwner != null) {
            throw new BadCommandLineException(Messages.format("FIELD_RENDERER_CONFLICT", this.fieldRendererFactoryOwner.getOptionName(), plugin.getOptionName()));
        }
        this.fieldRendererFactoryOwner = plugin;
        this.fieldRendererFactory = fieldRendererFactory;
    }

    public NameConverter getNameConverter() {
        return this.nameConverter;
    }

    public void setNameConverter(NameConverter nameConverter, Plugin plugin) throws BadCommandLineException {
        if (nameConverter == null) {
            throw new IllegalArgumentException();
        }
        if (this.nameConverter != null) {
            throw new BadCommandLineException(Messages.format("NAME_CONVERTER_CONFLICT", this.nameConverterOwner.getOptionName(), plugin.getOptionName()));
        }
        this.nameConverterOwner = plugin;
        this.nameConverter = nameConverter;
    }

    public List<Plugin> getAllPlugins() {
        if (this.allPlugins == null) {
            this.allPlugins = new ArrayList<Plugin>();
            URLClassLoader uRLClassLoader = this.getUserClassLoader(this.getClass().getClassLoader());
            for (Plugin plugin : Options.findServices(Plugin.class, uRLClassLoader)) {
                this.allPlugins.add(plugin);
            }
        }
        return this.allPlugins;
    }

    public Language getSchemaLanguage() {
        if (this.schemaLanguage == null) {
            this.schemaLanguage = this.guessSchemaLanguage();
        }
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(Language language) {
        this.schemaLanguage = language;
    }

    public InputSource[] getGrammars() {
        return this.grammars.toArray(new InputSource[this.grammars.size()]);
    }

    public void addGrammar(InputSource inputSource) {
        this.grammars.add(this.absolutize(inputSource));
    }

    private InputSource fileToInputSource(File file) {
        try {
            String string = file.toURL().toExternalForm();
            return new InputSource(Util.escapeSpace(string));
        }
        catch (MalformedURLException malformedURLException) {
            return new InputSource(file.getPath());
        }
    }

    public void addGrammar(File file) {
        this.addGrammar(this.fileToInputSource(file));
    }

    public void addGrammarRecursive(File file) {
        this.addRecursive(file, ".xsd", this.grammars);
    }

    private void addRecursive(File file, String string, List<InputSource> list) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.addRecursive(file2, string, list);
                continue;
            }
            if (!file2.getPath().endsWith(string)) continue;
            list.add(this.absolutize(this.fileToInputSource(file2)));
        }
    }

    private InputSource absolutize(InputSource inputSource) {
        try {
            URL uRL = new File(".").getCanonicalFile().toURL();
            inputSource.setSystemId(new URL(uRL, inputSource.getSystemId()).toExternalForm());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return inputSource;
    }

    public InputSource[] getBindFiles() {
        return this.bindFiles.toArray(new InputSource[this.bindFiles.size()]);
    }

    public void addBindFile(InputSource inputSource) {
        this.bindFiles.add(this.absolutize(inputSource));
    }

    public void addBindFile(File file) {
        this.bindFiles.add(this.fileToInputSource(file));
    }

    public void addBindFileRecursive(File file) {
        this.addRecursive(file, ".xjb", this.bindFiles);
    }

    public URLClassLoader getUserClassLoader(ClassLoader classLoader) {
        return new URLClassLoader(this.classpaths.toArray(new URL[this.classpaths.size()]), classLoader);
    }

    public int parseArgument(String[] stringArray, int n) throws BadCommandLineException {
        if (stringArray[n].equals("-classpath") || stringArray[n].equals("-cp")) {
            String string = this.requireArgument(stringArray[n], stringArray, ++n);
            for (String string2 : string.split(File.pathSeparator)) {
                File file = new File(string2);
                try {
                    this.classpaths.add(file.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new BadCommandLineException(Messages.format("Driver.NotAValidFileName", file), malformedURLException);
                }
            }
            return 2;
        }
        if (stringArray[n].equals("-d")) {
            this.targetDir = new File(this.requireArgument("-d", stringArray, ++n));
            if (!this.targetDir.exists()) {
                throw new BadCommandLineException(Messages.format("Driver.NonExistentDir", this.targetDir));
            }
            return 2;
        }
        if (stringArray[n].equals("-readOnly")) {
            this.readOnly = true;
            return 1;
        }
        if (stringArray[n].equals("-p")) {
            this.defaultPackage = this.requireArgument("-p", stringArray, ++n);
            if (this.defaultPackage.length() == 0) {
                this.packageLevelAnnotations = false;
            }
            return 2;
        }
        if (stringArray[n].equals("-debug")) {
            this.debugMode = true;
            this.verbose = true;
            return 1;
        }
        if (stringArray[n].equals("-nv")) {
            this.strictCheck = false;
            return 1;
        }
        if (stringArray[n].equals("-npa")) {
            this.packageLevelAnnotations = false;
            return 1;
        }
        if (stringArray[n].equals("-no-header")) {
            this.noFileHeader = true;
            return 1;
        }
        if (stringArray[n].equals("-verbose")) {
            this.verbose = true;
            return 1;
        }
        if (stringArray[n].equals("-quiet")) {
            this.quiet = true;
            return 1;
        }
        if (stringArray[n].equals("-XexplicitAnnotation")) {
            this.runtime14 = true;
            return 1;
        }
        if (stringArray[n].equals("-XautoNameResolution")) {
            this.automaticNameConflictResolution = true;
            return 1;
        }
        if (stringArray[n].equals("-b")) {
            this.addFile(this.requireArgument("-b", stringArray, ++n), this.bindFiles, ".xjb");
            return 2;
        }
        if (stringArray[n].equals("-dtd")) {
            this.schemaLanguage = Language.DTD;
            return 1;
        }
        if (stringArray[n].equals("-relaxng")) {
            this.schemaLanguage = Language.RELAXNG;
            return 1;
        }
        if (stringArray[n].equals("-relaxng-compact")) {
            this.schemaLanguage = Language.RELAXNG_COMPACT;
            return 1;
        }
        if (stringArray[n].equals("-xmlschema")) {
            this.schemaLanguage = Language.XMLSCHEMA;
            return 1;
        }
        if (stringArray[n].equals("-wsdl")) {
            this.schemaLanguage = Language.WSDL;
            return 1;
        }
        if (stringArray[n].equals("-extension")) {
            this.compatibilityMode = 2;
            return 1;
        }
        if (stringArray[n].equals("-target")) {
            String string = this.requireArgument("-target", stringArray, ++n);
            this.target = SpecVersion.parse(string);
            if (this.target == null) {
                throw new BadCommandLineException(Messages.format("Driver.ILLEGAL_TARGET_VERSION", string));
            }
            return 2;
        }
        if (stringArray[n].equals("-httpproxyfile")) {
            File file;
            if (n == stringArray.length - 1 || stringArray[n + 1].startsWith("-")) {
                throw new BadCommandLineException(Messages.format("Driver.MISSING_PROXYFILE", new Object[0]));
            }
            if (!(file = new File(stringArray[++n])).exists()) {
                throw new BadCommandLineException(Messages.format("Driver.NO_SUCH_FILE", file));
            }
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                this.parseProxy(bufferedReader.readLine());
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new BadCommandLineException(Messages.format("Driver.FailedToParse", file, iOException.getMessage()), iOException);
            }
            return 2;
        }
        if (stringArray[n].equals("-httpproxy")) {
            if (n == stringArray.length - 1 || stringArray[n + 1].startsWith("-")) {
                throw new BadCommandLineException(Messages.format("Driver.MISSING_PROXY", new Object[0]));
            }
            this.parseProxy(stringArray[++n]);
            return 2;
        }
        if (stringArray[n].equals("-host")) {
            this.proxyHost = this.requireArgument("-host", stringArray, ++n);
            return 2;
        }
        if (stringArray[n].equals("-port")) {
            this.proxyPort = this.requireArgument("-port", stringArray, ++n);
            return 2;
        }
        if (stringArray[n].equals("-catalog")) {
            File file = new File(this.requireArgument("-catalog", stringArray, ++n));
            try {
                this.addCatalog(file);
            }
            catch (IOException iOException) {
                throw new BadCommandLineException(Messages.format("Driver.FailedToParse", file, iOException.getMessage()), iOException);
            }
            return 2;
        }
        if (stringArray[n].equals("-source")) {
            String string;
            if (!(string = this.requireArgument("-source", stringArray, ++n)).equals("2.0") && !string.equals("2.1")) {
                throw new BadCommandLineException(Messages.format("Driver.DefaultVersion", new Object[0]));
            }
            return 2;
        }
        if (stringArray[n].equals("-Xtest-class-name-allocator")) {
            this.classNameAllocator = new ClassNameAllocator(){

                public String assignClassName(String string, String string2) {
                    System.out.printf("assignClassName(%s,%s)\n", string, string2);
                    return string2 + "_Type";
                }
            };
            return 1;
        }
        for (Plugin plugin : this.getAllPlugins()) {
            try {
                int n2;
                if (('-' + plugin.getOptionName()).equals(stringArray[n])) {
                    this.activePlugins.add(plugin);
                    plugin.onActivated(this);
                    this.pluginURIs.addAll(plugin.getCustomizationURIs());
                    n2 = plugin.parseArgument(this, stringArray, n);
                    if (n2 != 0) {
                        return n2;
                    }
                    return 1;
                }
                n2 = plugin.parseArgument(this, stringArray, n);
                if (n2 == 0) continue;
                return n2;
            }
            catch (IOException iOException) {
                throw new BadCommandLineException(iOException.getMessage(), iOException);
            }
        }
        return 0;
    }

    private void parseProxy(String string) throws BadCommandLineException {
        String string2 = "([^@:]+)";
        Pattern pattern = Pattern.compile("(?:" + string2 + "(?:\\:" + string2 + ")?\\@)?" + string2 + "(?:\\:" + string2 + ")");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new BadCommandLineException(Messages.format("Driver.ILLEGAL_PROXY", string));
        }
        this.proxyUser = matcher.group(1);
        this.proxyPassword = matcher.group(2);
        this.proxyHost = matcher.group(3);
        this.proxyPort = matcher.group(4);
        try {
            Integer.valueOf(this.proxyPort);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadCommandLineException(Messages.format("Driver.ILLEGAL_PROXY", string));
        }
    }

    public String requireArgument(String string, String[] stringArray, int n) throws BadCommandLineException {
        if (n == stringArray.length || stringArray[n].startsWith("-")) {
            throw new BadCommandLineException(Messages.format("Driver.MissingOperand", string));
        }
        return stringArray[n];
    }

    private void addFile(String string, List<InputSource> list, String string2) throws BadCommandLineException {
        Object object;
        try {
            object = Util.getFileOrURL(string);
        }
        catch (IOException iOException) {
            throw new BadCommandLineException(Messages.format("Driver.NotAFileNorURL", string));
        }
        if (object instanceof URL) {
            list.add(this.absolutize(new InputSource(Util.escapeSpace(((URL)object).toExternalForm()))));
        } else {
            File file = (File)object;
            if (file.isDirectory()) {
                this.addRecursive(file, string2, list);
            } else {
                list.add(this.absolutize(this.fileToInputSource(file)));
            }
        }
    }

    public void addCatalog(File file) throws IOException {
        if (this.entityResolver == null) {
            CatalogManager.getStaticManager().setIgnoreMissingProperties(true);
            this.entityResolver = new CatalogResolver(true);
        }
        ((CatalogResolver)this.entityResolver).getCatalog().parseCatalog(file.getPath());
    }

    public void parseArguments(String[] stringArray) throws BadCommandLineException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) {
                throw new BadCommandLineException();
            }
            if (stringArray[i].charAt(0) == '-') {
                int n = this.parseArgument(stringArray, i);
                if (n == 0) {
                    throw new BadCommandLineException(Messages.format("Driver.UnrecognizedParameter", stringArray[i]));
                }
                i += n - 1;
                continue;
            }
            if (stringArray[i].endsWith(".jar")) {
                this.scanEpisodeFile(new File(stringArray[i]));
                continue;
            }
            this.addFile(stringArray[i], this.grammars, ".xsd");
        }
        if (this.proxyHost != null || this.proxyPort != null) {
            if (this.proxyHost == null || this.proxyPort == null) {
                if (this.proxyHost == null) {
                    throw new BadCommandLineException(Messages.format("Driver.MissingProxyHost", new Object[0]));
                }
                throw new BadCommandLineException(Messages.format("Driver.MissingProxyPort", new Object[0]));
            }
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", this.proxyPort);
            System.setProperty("https.proxyHost", this.proxyHost);
            System.setProperty("https.proxyPort", this.proxyPort);
            if (this.proxyUser != null) {
                System.setProperty("http.proxyUser", this.proxyUser);
            }
            if (this.proxyPassword != null) {
                System.setProperty("http.proxyPassword", this.proxyPassword);
            }
        }
        if (this.grammars.size() == 0) {
            throw new BadCommandLineException(Messages.format("Driver.MissingGrammar", new Object[0]));
        }
        if (this.schemaLanguage == null) {
            this.schemaLanguage = this.guessSchemaLanguage();
        }
        if (pluginLoadFailure != null) {
            throw new BadCommandLineException(Messages.format("PLUGIN_LOAD_FAILURE", pluginLoadFailure));
        }
    }

    public void scanEpisodeFile(File file) throws BadCommandLineException {
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURL()});
            Enumeration<URL> enumeration = uRLClassLoader.findResources("META-INF/sun-jaxb.episode");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                this.addBindFile(new InputSource(uRL.toExternalForm()));
            }
        }
        catch (IOException iOException) {
            throw new BadCommandLineException(Messages.format("FAILED_TO_LOAD", file, iOException.getMessage()), iOException);
        }
    }

    public Language guessSchemaLanguage() {
        if (this.grammars != null && this.grammars.size() > 0) {
            String string = this.grammars.get(0).getSystemId().toLowerCase();
            if (string.endsWith(".rng")) {
                return Language.RELAXNG;
            }
            if (string.endsWith(".rnc")) {
                return Language.RELAXNG_COMPACT;
            }
            if (string.endsWith(".dtd")) {
                return Language.DTD;
            }
            if (string.endsWith(".wsdl")) {
                return Language.WSDL;
            }
        }
        return Language.XMLSCHEMA;
    }

    public CodeWriter createCodeWriter() throws IOException {
        return this.createCodeWriter(new FileCodeWriter(this.targetDir, this.readOnly));
    }

    public CodeWriter createCodeWriter(CodeWriter codeWriter) {
        if (this.noFileHeader) {
            return codeWriter;
        }
        return new PrologCodeWriter(codeWriter, this.getPrologComment());
    }

    public String getPrologComment() {
        String string = Messages.format("Driver.DateFormat", new Object[0]) + " '" + Messages.format("Driver.At", new Object[0]) + "' " + Messages.format("Driver.TimeFormat", new Object[0]);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return Messages.format("Driver.FilePrologComment", simpleDateFormat.format(new Date()));
    }

    private static <T> T[] findServices(Class<T> clazz, ClassLoader classLoader) {
        boolean bl = com.sun.tools.internal.xjc.util.Util.getSystemProperty(Options.class, "findServices") != null;
        try {
            Class<?> clazz2 = Class.forName("java.util.ServiceLoader");
            if (bl) {
                System.out.println("Using java.util.ServiceLoader");
            }
            Iterable iterable = (Iterable)clazz2.getMethod("load", Class.class, ClassLoader.class).invoke(null, clazz, classLoader);
            ArrayList arrayList = new ArrayList();
            for (Object t : iterable) {
                arrayList.add(t);
            }
            return arrayList.toArray((Object[])Array.newInstance(clazz, arrayList.size()));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessError illegalAccessError = new IllegalAccessError();
            illegalAccessError.initCause(illegalAccessException);
            throw illegalAccessError;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error(throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NoSuchMethodError noSuchMethodError = new NoSuchMethodError();
            noSuchMethodError.initCause(noSuchMethodException);
            throw noSuchMethodError;
        }
        String string = "META-INF/services/" + clazz.getName();
        HashSet<String> hashSet = new HashSet<String>();
        if (bl) {
            System.out.println("Looking for " + string + " for add-ons");
        }
        try {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            if (enumeration == null) {
                return (Object[])Array.newInstance(clazz, 0);
            }
            ArrayList<T> arrayList = new ArrayList<T>();
            while (enumeration.hasMoreElements()) {
                Class<?> clazz3;
                URL uRL = enumeration.nextElement();
                BufferedReader bufferedReader = null;
                if (bl) {
                    System.out.println("Checking " + uRL + " for an add-on");
                }
                try {
                    String string2;
                    bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!hashSet.add(string2 = string2.trim())) continue;
                        clazz3 = classLoader.loadClass(string2);
                        if (!clazz.isAssignableFrom(clazz3)) {
                            pluginLoadFailure = string2 + " is not a subclass of " + clazz + ". Skipping";
                            if (!bl) continue;
                            System.out.println(pluginLoadFailure);
                            continue;
                        }
                        if (bl) {
                            System.out.println("Attempting to instanciate " + string2);
                        }
                        arrayList.add(clazz.cast(clazz3.newInstance()));
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    clazz3 = new StringWriter();
                    exception.printStackTrace(new PrintWriter((Writer)((Object)clazz3)));
                    pluginLoadFailure = ((StringWriter)((Object)clazz3)).toString();
                    if (bl) {
                        System.out.println(pluginLoadFailure);
                    }
                    if (bufferedReader == null) continue;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return arrayList.toArray((Object[])Array.newInstance(clazz, arrayList.size()));
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            pluginLoadFailure = stringWriter.toString();
            if (bl) {
                System.out.println(pluginLoadFailure);
            }
            return (Object[])Array.newInstance(clazz, 0);
        }
    }

    public static String getBuildID() {
        return Messages.format("Driver.BuildID", new Object[0]);
    }
}

