/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.addon.episode;

import com.sun.tools.internal.xjc.BadCommandLineException;
import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.Plugin;
import com.sun.tools.internal.xjc.outline.ClassOutline;
import com.sun.tools.internal.xjc.outline.Outline;
import com.sun.xml.internal.bind.v2.schemagen.episode.Bindings;
import com.sun.xml.internal.txw2.TXW;
import com.sun.xml.internal.txw2.output.StreamSerializer;
import com.sun.xml.internal.txw2.output.XmlSerializer;
import com.sun.xml.internal.xsom.XSAnnotation;
import com.sun.xml.internal.xsom.XSAttGroupDecl;
import com.sun.xml.internal.xsom.XSAttributeDecl;
import com.sun.xml.internal.xsom.XSAttributeUse;
import com.sun.xml.internal.xsom.XSComplexType;
import com.sun.xml.internal.xsom.XSComponent;
import com.sun.xml.internal.xsom.XSContentType;
import com.sun.xml.internal.xsom.XSDeclaration;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSFacet;
import com.sun.xml.internal.xsom.XSIdentityConstraint;
import com.sun.xml.internal.xsom.XSModelGroup;
import com.sun.xml.internal.xsom.XSModelGroupDecl;
import com.sun.xml.internal.xsom.XSNotation;
import com.sun.xml.internal.xsom.XSParticle;
import com.sun.xml.internal.xsom.XSSchema;
import com.sun.xml.internal.xsom.XSSimpleType;
import com.sun.xml.internal.xsom.XSWildcard;
import com.sun.xml.internal.xsom.XSXPath;
import com.sun.xml.internal.xsom.visitor.XSFunction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PluginImpl
extends Plugin {
    private File episodeFile;
    private static final XSFunction<String> SCD = new XSFunction<String>(){

        private String name(XSDeclaration xSDeclaration) {
            if (xSDeclaration.getTargetNamespace().equals("")) {
                return xSDeclaration.getName();
            }
            return "tns:" + xSDeclaration.getName();
        }

        @Override
        public String complexType(XSComplexType xSComplexType) {
            return "~" + this.name(xSComplexType);
        }

        @Override
        public String simpleType(XSSimpleType xSSimpleType) {
            return "~" + this.name(xSSimpleType);
        }

        @Override
        public String elementDecl(XSElementDecl xSElementDecl) {
            return this.name(xSElementDecl);
        }

        @Override
        public String annotation(XSAnnotation xSAnnotation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String attGroupDecl(XSAttGroupDecl xSAttGroupDecl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String attributeDecl(XSAttributeDecl xSAttributeDecl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String attributeUse(XSAttributeUse xSAttributeUse) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String schema(XSSchema xSSchema) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String facet(XSFacet xSFacet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String notation(XSNotation xSNotation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String identityConstraint(XSIdentityConstraint xSIdentityConstraint) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String xpath(XSXPath xSXPath) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String particle(XSParticle xSParticle) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String empty(XSContentType xSContentType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String wildcard(XSWildcard xSWildcard) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String modelGroup(XSModelGroup xSModelGroup) {
            throw new UnsupportedOperationException();
        }
    };

    public String getOptionName() {
        return "episode";
    }

    public String getUsage() {
        return "  -episode <FILE>    :  generate the episode file for separate compilation";
    }

    public int parseArgument(Options options, String[] stringArray, int n) throws BadCommandLineException, IOException {
        if (stringArray[n].equals("-episode")) {
            this.episodeFile = new File(options.requireArgument("-episode", stringArray, ++n));
            return 2;
        }
        return 0;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) throws SAXException {
        try {
            Bindings bindings;
            HashMap<XSSchema, Bindings> hashMap = new HashMap<XSSchema, Bindings>();
            boolean bl = false;
            for (ClassOutline classOutline2 : outline.getClasses()) {
                XSDeclaration xSDeclaration;
                XSComponent xSComponent = classOutline2.target.getSchemaComponent();
                if (xSComponent == null || !(xSComponent instanceof XSDeclaration) || (xSDeclaration = (XSDeclaration)xSComponent).isLocal()) continue;
                bindings = (Bindings)hashMap.get(xSDeclaration.getOwnerSchema());
                if (bindings == null) {
                    bindings = new ArrayList();
                    hashMap.put(xSDeclaration.getOwnerSchema(), bindings);
                }
                bindings.add(classOutline2);
                if (!xSDeclaration.getTargetNamespace().equals("")) continue;
                bl = true;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.episodeFile);
            Bindings bindings2 = (Bindings)TXW.create(Bindings.class, (XmlSerializer)new StreamSerializer((OutputStream)fileOutputStream, "UTF-8"));
            if (bl) {
                bindings2._namespace("http://java.sun.com/xml/ns/jaxb", "jaxb");
            } else {
                bindings2._namespace("http://java.sun.com/xml/ns/jaxb", "");
            }
            bindings2.version("2.1");
            bindings2._comment((Object)("\n\n" + options.getPrologComment() + "\n  "));
            for (Map.Entry entry : hashMap.entrySet()) {
                bindings = bindings2.bindings();
                String string = ((XSSchema)entry.getKey()).getTargetNamespace();
                if (!string.equals("")) {
                    bindings._namespace(string, "tns");
                }
                bindings.scd("x-schema::" + (string.equals("") ? "" : "tns"));
                bindings.schemaBindings().map(false);
                for (ClassOutline classOutline : (List)entry.getValue()) {
                    Bindings bindings3 = bindings.bindings();
                    bindings3.scd(classOutline.target.getSchemaComponent().apply(SCD));
                    bindings3.klass().ref(classOutline.implClass.fullName());
                }
                bindings.commit(true);
            }
            bindings2.commit();
            return true;
        }
        catch (IOException iOException) {
            errorHandler.error(new SAXParseException("Failed to write to " + this.episodeFile, null, iOException));
            return false;
        }
    }
}

