/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.gbind;

import com.sun.tools.internal.xjc.reader.gbind.ConnectedComponent;
import com.sun.tools.internal.xjc.reader.gbind.ElementSet;
import com.sun.tools.internal.xjc.reader.gbind.Expression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element
extends Expression
implements ElementSet {
    final Set<Element> foreEdges = new LinkedHashSet<Element>();
    final Set<Element> backEdges = new LinkedHashSet<Element>();
    Element prevPostOrder;
    private ConnectedComponent cc;

    protected Element() {
    }

    @Override
    ElementSet lastSet() {
        return this;
    }

    @Override
    boolean isNullable() {
        return false;
    }

    boolean isSource() {
        return false;
    }

    boolean isSink() {
        return false;
    }

    @Override
    void buildDAG(ElementSet elementSet) {
        elementSet.addNext(this);
    }

    @Override
    public void addNext(Element element) {
        this.foreEdges.add(element);
        element.backEdges.add(this);
    }

    @Override
    public boolean contains(ElementSet elementSet) {
        return this == elementSet || elementSet == ElementSet.EMPTY_SET;
    }

    @Override
    public Iterator<Element> iterator() {
        return Collections.singleton(this).iterator();
    }

    Element assignDfsPostOrder(Element element) {
        if (this.prevPostOrder != null) {
            return element;
        }
        this.prevPostOrder = this;
        for (Element element2 : this.foreEdges) {
            element = element2.assignDfsPostOrder(element);
        }
        this.prevPostOrder = element;
        return this;
    }

    public void buildStronglyConnectedComponents(List<ConnectedComponent> list) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = this;
        while (element != element.prevPostOrder && !arrayList.contains(element)) {
            arrayList.add(element);
            if (!element.belongsToSCC()) {
                ConnectedComponent connectedComponent = new ConnectedComponent();
                list.add(connectedComponent);
                element.formConnectedComponent(connectedComponent);
            }
            element = element.prevPostOrder;
        }
    }

    private boolean belongsToSCC() {
        return this.cc != null || this.isSource() || this.isSink();
    }

    private void formConnectedComponent(ConnectedComponent connectedComponent) {
        if (this.belongsToSCC()) {
            return;
        }
        this.cc = connectedComponent;
        connectedComponent.add(this);
        for (Element element : this.backEdges) {
            element.formConnectedComponent(connectedComponent);
        }
    }

    public boolean hasSelfLoop() {
        assert (this.foreEdges.contains(this) == this.backEdges.contains(this));
        return this.foreEdges.contains(this);
    }

    final boolean checkCutSet(ConnectedComponent connectedComponent, Set<Element> set) {
        assert (this.belongsToSCC());
        if (this.isSink()) {
            return false;
        }
        if (!set.add(this)) {
            return true;
        }
        if (this.cc == connectedComponent) {
            return true;
        }
        for (Element element : this.foreEdges) {
            if (element.checkCutSet(connectedComponent, set)) continue;
            return false;
        }
        return true;
    }
}

