/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.xmlschema;

import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.CReferencePropertyInfo;
import com.sun.tools.internal.xjc.reader.xmlschema.CollisionInfo;
import com.sun.tools.internal.xjc.reader.xmlschema.Messages;
import com.sun.tools.internal.xjc.reader.xmlschema.ParticleBinder;
import com.sun.tools.internal.xjc.reader.xmlschema.RawTypeSetBuilder;
import com.sun.tools.internal.xjc.reader.xmlschema.bindinfo.BIProperty;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSModelGroup;
import com.sun.xml.internal.xsom.XSModelGroupDecl;
import com.sun.xml.internal.xsom.XSParticle;
import com.sun.xml.internal.xsom.XSTerm;
import com.sun.xml.internal.xsom.XSWildcard;
import com.sun.xml.internal.xsom.visitor.XSTermVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultParticleBinder
extends ParticleBinder {
    DefaultParticleBinder() {
    }

    @Override
    public void build(XSParticle xSParticle, Collection<XSParticle> collection) {
        Checker checker = this.checkCollision(xSParticle, collection);
        if (checker.hasNameCollision()) {
            CReferencePropertyInfo cReferencePropertyInfo = new CReferencePropertyInfo(this.getCurrentBean().getBaseClass() == null ? "Content" : "Rest", true, false, false, xSParticle, this.builder.getBindInfo(xSParticle).toCustomizationList(), xSParticle.getLocator(), false, false, false);
            RawTypeSetBuilder.build(xSParticle, false).addTo(cReferencePropertyInfo);
            cReferencePropertyInfo.javadoc = Messages.format("DefaultParticleBinder.FallbackJavadoc", checker.getCollisionInfo().toString());
            this.getCurrentBean().addProperty(cReferencePropertyInfo);
        } else {
            new Builder(checker.markedParticles).particle(xSParticle);
        }
    }

    @Override
    public boolean checkFallback(XSParticle xSParticle) {
        return this.checkCollision(xSParticle, Collections.<XSParticle>emptyList()).hasNameCollision();
    }

    private Checker checkCollision(XSParticle xSParticle, Collection<XSParticle> collection) {
        Checker checker = new Checker(collection);
        CClassInfo cClassInfo = this.getCurrentBean().getBaseClass();
        if (cClassInfo != null) {
            checker.readSuperClass(cClassInfo);
        }
        checker.particle(xSParticle);
        return checker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Builder
    implements XSTermVisitor {
        private final Map<XSParticle, String> markedParticles;
        private boolean insideOptionalParticle;

        Builder(Map<XSParticle, String> map) {
            this.markedParticles = map;
        }

        private boolean marked(XSParticle xSParticle) {
            return this.markedParticles.containsKey(xSParticle);
        }

        private String getLabel(XSParticle xSParticle) {
            return this.markedParticles.get(xSParticle);
        }

        public void particle(XSParticle xSParticle) {
            XSTerm xSTerm = xSParticle.getTerm();
            if (this.marked(xSParticle)) {
                BIProperty bIProperty = BIProperty.getCustomization(xSParticle);
                CPropertyInfo cPropertyInfo = bIProperty.createElementOrReferenceProperty(this.getLabel(xSParticle), false, xSParticle, RawTypeSetBuilder.build(xSParticle, this.insideOptionalParticle));
                DefaultParticleBinder.this.getCurrentBean().addProperty(cPropertyInfo);
            } else {
                assert (!xSParticle.isRepeated());
                boolean bl = this.insideOptionalParticle;
                this.insideOptionalParticle |= xSParticle.getMinOccurs() == 0;
                xSTerm.visit(this);
                this.insideOptionalParticle = bl;
            }
        }

        @Override
        public void elementDecl(XSElementDecl xSElementDecl) {
            assert (false);
        }

        @Override
        public void wildcard(XSWildcard xSWildcard) {
            assert (false);
        }

        @Override
        public void modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
            this.modelGroup(xSModelGroupDecl.getModelGroup());
        }

        @Override
        public void modelGroup(XSModelGroup xSModelGroup) {
            boolean bl = this.insideOptionalParticle;
            this.insideOptionalParticle |= xSModelGroup.getCompositor() == XSModelGroup.CHOICE;
            for (XSParticle xSParticle : xSModelGroup.getChildren()) {
                this.particle(xSParticle);
            }
            this.insideOptionalParticle = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Checker
    implements XSTermVisitor {
        private CollisionInfo collisionInfo = null;
        private final NameCollisionChecker cchecker = new NameCollisionChecker();
        private final Collection<XSParticle> forcedProps;
        private XSParticle outerParticle;
        public final Map<XSParticle, String> markedParticles = new HashMap<XSParticle, String>();
        private final Map<XSParticle, String> labelCache = new Hashtable<XSParticle, String>();

        Checker(Collection<XSParticle> collection) {
            this.forcedProps = collection;
        }

        boolean hasNameCollision() {
            return this.collisionInfo != null;
        }

        CollisionInfo getCollisionInfo() {
            return this.collisionInfo;
        }

        public void particle(XSParticle xSParticle) {
            if (DefaultParticleBinder.this.getLocalPropCustomization(xSParticle) != null || DefaultParticleBinder.this.builder.getLocalDomCustomization(xSParticle) != null) {
                this.check(xSParticle);
                this.mark(xSParticle);
                return;
            }
            XSTerm xSTerm = xSParticle.getTerm();
            if (xSParticle.isRepeated() && (xSTerm.isModelGroup() || xSTerm.isModelGroupDecl())) {
                this.mark(xSParticle);
                return;
            }
            if (this.forcedProps.contains(xSParticle)) {
                this.mark(xSParticle);
                return;
            }
            this.outerParticle = xSParticle;
            xSTerm.visit(this);
        }

        @Override
        public void elementDecl(XSElementDecl xSElementDecl) {
            this.check(this.outerParticle);
            this.mark(this.outerParticle);
        }

        @Override
        public void modelGroup(XSModelGroup xSModelGroup) {
            if (xSModelGroup.getCompositor() == XSModelGroup.Compositor.CHOICE && DefaultParticleBinder.this.builder.getGlobalBinding().isChoiceContentPropertyEnabled()) {
                this.mark(this.outerParticle);
                return;
            }
            for (XSParticle xSParticle : xSModelGroup.getChildren()) {
                this.particle(xSParticle);
            }
        }

        @Override
        public void modelGroupDecl(XSModelGroupDecl xSModelGroupDecl) {
            this.modelGroup(xSModelGroupDecl.getModelGroup());
        }

        @Override
        public void wildcard(XSWildcard xSWildcard) {
            this.check(this.outerParticle);
            this.mark(this.outerParticle);
        }

        void readSuperClass(CClassInfo cClassInfo) {
            this.cchecker.readSuperClass(cClassInfo);
        }

        private void check(XSParticle xSParticle) {
            if (this.collisionInfo == null) {
                this.collisionInfo = this.cchecker.check(xSParticle);
            }
        }

        private void mark(XSParticle xSParticle) {
            this.markedParticles.put(xSParticle, this.computeLabel(xSParticle));
        }

        private String computeLabel(XSParticle xSParticle) {
            String string = this.labelCache.get(xSParticle);
            if (string == null) {
                string = DefaultParticleBinder.this.computeLabel(xSParticle);
                this.labelCache.put(xSParticle, string);
            }
            return string;
        }

        private final class NameCollisionChecker {
            private final List<XSParticle> particles = new ArrayList<XSParticle>();
            private final Map<String, CPropertyInfo> occupiedLabels = new HashMap<String, CPropertyInfo>();

            private NameCollisionChecker() {
            }

            CollisionInfo check(XSParticle xSParticle) {
                String string = Checker.this.computeLabel(xSParticle);
                if (this.occupiedLabels.containsKey(string)) {
                    return new CollisionInfo(string, xSParticle.getLocator(), this.occupiedLabels.get((Object)string).locator);
                }
                for (XSParticle xSParticle2 : this.particles) {
                    if (this.check(xSParticle, xSParticle2)) continue;
                    return new CollisionInfo(string, xSParticle.getLocator(), xSParticle2.getLocator());
                }
                this.particles.add(xSParticle);
                return null;
            }

            private boolean check(XSParticle xSParticle, XSParticle xSParticle2) {
                return !Checker.this.computeLabel(xSParticle).equals(Checker.this.computeLabel(xSParticle2));
            }

            void readSuperClass(CClassInfo cClassInfo) {
                while (cClassInfo != null) {
                    for (CPropertyInfo cPropertyInfo : cClassInfo.getProperties()) {
                        this.occupiedLabels.put(cPropertyInfo.getName(true), cPropertyInfo);
                    }
                    cClassInfo = cClassInfo.getBaseClass();
                }
            }
        }
    }
}

