/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DefaultFileManager;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Position;
import com.sun.tools.javac.util.Version;
import java.nio.CharBuffer;

@Version(value="@(#)Scanner.java\t1.73 10/03/23")
public class Scanner
implements Lexer {
    private static boolean scannerDebug = false;
    private Token token;
    private boolean allowHexFloats;
    private int pos;
    private int endPos;
    private int prevEndPos;
    private int errPos = -1;
    private Name name;
    private int radix;
    protected boolean deprecatedFlag = false;
    private char[] sbuf = new char[128];
    private int sp;
    private char[] buf;
    private int bp;
    private int buflen;
    private int eofPos;
    private char ch;
    private int unicodeConversionBp = -1;
    private final Log log;
    private final Name.Table names;
    private final Keywords keywords;
    private static final boolean hexFloatsWork = Scanner.hexFloatsWork();
    static final boolean surrogatesSupported = Scanner.surrogatesSupported();

    private Scanner(Factory factory) {
        this.log = factory.log;
        this.names = factory.names;
        this.keywords = factory.keywords;
        this.allowHexFloats = factory.source.allowHexFloats();
    }

    private static boolean hexFloatsWork() {
        try {
            Float.valueOf("0x1.0p1");
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected Scanner(Factory factory, CharBuffer charBuffer) {
        this(factory, DefaultFileManager.toArray(charBuffer), charBuffer.limit());
    }

    protected Scanner(Factory factory, char[] cArray, int n) {
        this(factory);
        this.eofPos = n;
        if (n == cArray.length) {
            if (cArray.length > 0 && Character.isWhitespace(cArray[cArray.length - 1])) {
                --n;
            } else {
                char[] cArray2 = new char[n + 1];
                System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                cArray = cArray2;
            }
        }
        this.buf = cArray;
        this.buflen = n;
        this.buf[this.buflen] = 26;
        this.bp = -1;
        this.scanChar();
    }

    private void lexError(int n, String string, Object ... objectArray) {
        this.log.error(n, string, objectArray);
        this.token = Token.ERROR;
        this.errPos = n;
    }

    private void lexError(String string, Object ... objectArray) {
        this.lexError(this.pos, string, objectArray);
    }

    private int digit(int n) {
        char c = this.ch;
        int n2 = Character.digit(c, n);
        if (n2 >= 0 && c > '\u007f') {
            this.lexError(this.pos + 1, "illegal.nonascii.digit", new Object[0]);
            this.ch = "0123456789abcdef".charAt(n2);
        }
        return n2;
    }

    private void convertUnicode() {
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                } while (this.ch == 'u');
                int n = this.bp + 3;
                if (n < this.buflen) {
                    int n2;
                    int n3 = n2 = this.digit(16);
                    while (this.bp < n && n2 >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        n2 = this.digit(16);
                        n3 = (n3 << 4) + n2;
                    }
                    if (n2 >= 0) {
                        this.ch = (char)n3;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
                this.lexError(this.bp, "illegal.unicode.esc", new Object[0]);
            } else {
                --this.bp;
                this.ch = (char)92;
            }
        }
    }

    private void scanChar() {
        this.ch = this.buf[++this.bp];
        if (this.ch == '\\') {
            this.convertUnicode();
        }
    }

    private void scanCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void putChar(char c) {
        if (this.sp == this.sbuf.length) {
            char[] cArray = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
            this.sbuf = cArray;
        }
        this.sbuf[this.sp++] = c;
    }

    private void dch() {
        System.err.print(this.ch);
        System.out.flush();
    }

    private void scanLitChar() {
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                this.putChar('\\');
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char c = this.ch;
                        int n = this.digit(8);
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '7') {
                            n = n * 8 + this.digit(8);
                            this.scanChar();
                            if (c <= '3' && '0' <= this.ch && this.ch <= '7') {
                                n = n * 8 + this.digit(8);
                                this.scanChar();
                            }
                        }
                        this.putChar((char)n);
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        this.scanChar();
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanChar();
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanChar();
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanChar();
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanChar();
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanChar();
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanChar();
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        this.scanChar();
                        break;
                    }
                    default: {
                        this.lexError(this.bp, "illegal.esc.char", new Object[0]);
                        break;
                    }
                }
            }
        } else if (this.bp != this.buflen) {
            this.putChar(this.ch);
            this.scanChar();
        }
    }

    private void scanHexExponentAndSuffix() {
        if (this.ch == 'p' || this.ch == 'P') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                if (!this.allowHexFloats) {
                    this.lexError("unsupported.fp.lit", new Object[0]);
                    this.allowHexFloats = true;
                } else if (!hexFloatsWork) {
                    this.lexError("unsupported.cross.fp.lit", new Object[0]);
                }
            } else {
                this.lexError("malformed.fp.lit", new Object[0]);
            }
        } else {
            this.lexError("malformed.fp.lit", new Object[0]);
        }
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Token.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Token.DOUBLELITERAL;
        }
    }

    private void scanFraction() {
        while (this.digit(10) >= 0) {
            this.putChar(this.ch);
            this.scanChar();
        }
        int n = this.sp;
        if (this.ch == 'e' || this.ch == 'E') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                return;
            }
            this.lexError("malformed.fp.lit", new Object[0]);
            this.sp = n;
        }
    }

    private void scanFractionAndSuffix() {
        this.radix = 10;
        this.scanFraction();
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Token.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Token.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(boolean bl) {
        this.radix = 16;
        assert (this.ch == '.');
        this.putChar(this.ch);
        this.scanChar();
        while (this.digit(16) >= 0) {
            bl = true;
            this.putChar(this.ch);
            this.scanChar();
        }
        if (!bl) {
            this.lexError("invalid.hex.number", new Object[0]);
        } else {
            this.scanHexExponentAndSuffix();
        }
    }

    private void scanNumber(int n) {
        this.radix = n;
        int n2 = n <= 10 ? 10 : 16;
        boolean bl = false;
        while (this.digit(n2) >= 0) {
            bl = true;
            this.putChar(this.ch);
            this.scanChar();
        }
        if (n == 16 && this.ch == '.') {
            this.scanHexFractionAndSuffix(bl);
        } else if (bl && n == 16 && (this.ch == 'p' || this.ch == 'P')) {
            this.scanHexExponentAndSuffix();
        } else if (n <= 10 && this.ch == '.') {
            this.putChar(this.ch);
            this.scanChar();
            this.scanFractionAndSuffix();
        } else if (n <= 10 && (this.ch == 'e' || this.ch == 'E' || this.ch == 'f' || this.ch == 'F' || this.ch == 'd' || this.ch == 'D')) {
            this.scanFractionAndSuffix();
        } else if (this.ch == 'l' || this.ch == 'L') {
            this.scanChar();
            this.token = Token.LONGLITERAL;
        } else {
            this.token = Token.INTLITERAL;
        }
    }

    private void scanIdent() {
        block4: while (true) {
            boolean bl;
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
            } else {
                this.sbuf[this.sp++] = this.ch;
            }
            this.scanChar();
            switch (this.ch) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '\u007f': {
                    continue block4;
                }
                case '\u001a': {
                    if (this.bp < this.buflen) continue block4;
                    this.name = this.names.fromChars(this.sbuf, 0, this.sp);
                    this.token = this.keywords.key(this.name);
                    return;
                }
            }
            if (this.ch < '\u0080') {
                bl = false;
            } else {
                char c = this.scanSurrogates();
                if (c != '\u0000') {
                    if (this.sp == this.sbuf.length) {
                        this.putChar(c);
                    } else {
                        this.sbuf[this.sp++] = c;
                    }
                    bl = Character.isJavaIdentifierPart(Character.toCodePoint(c, this.ch));
                } else {
                    bl = Character.isJavaIdentifierPart(this.ch);
                }
            }
            if (!bl) break;
        }
        this.name = this.names.fromChars(this.sbuf, 0, this.sp);
        this.token = this.keywords.key(this.name);
    }

    private static boolean surrogatesSupported() {
        try {
            Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return false;
        }
    }

    private char scanSurrogates() {
        if (surrogatesSupported && Character.isHighSurrogate(this.ch)) {
            char c = this.ch;
            this.scanChar();
            if (Character.isLowSurrogate(this.ch)) {
                return c;
            }
            this.ch = c;
        }
        return '\u0000';
    }

    private boolean isSpecial(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.putChar(this.ch);
            Name name = this.names.fromChars(this.sbuf, 0, this.sp);
            if (this.keywords.key(name) == Token.IDENTIFIER) {
                --this.sp;
                break;
            }
            this.name = name;
            this.token = this.keywords.key(name);
            this.scanChar();
        } while (this.isSpecial(this.ch));
    }

    private void scanDocComment() {
        boolean bl = false;
        block5: while (this.bp < this.buflen) {
            while (this.bp < this.buflen && (this.ch == ' ' || this.ch == '\t' || this.ch == '\f')) {
                this.scanCommentChar();
            }
            while (this.bp < this.buflen && this.ch == '*') {
                this.scanCommentChar();
                if (this.ch != '/') continue;
                return;
            }
            while (this.bp < this.buflen && (this.ch == ' ' || this.ch == '\t' || this.ch == '\f')) {
                this.scanCommentChar();
            }
            bl = false;
            if (this.bp < this.buflen && this.ch == '@' && !this.deprecatedFlag) {
                this.scanCommentChar();
                if (this.bp < this.buflen && this.ch == 'd') {
                    this.scanCommentChar();
                    if (this.bp < this.buflen && this.ch == 'e') {
                        this.scanCommentChar();
                        if (this.bp < this.buflen && this.ch == 'p') {
                            this.scanCommentChar();
                            if (this.bp < this.buflen && this.ch == 'r') {
                                this.scanCommentChar();
                                if (this.bp < this.buflen && this.ch == 'e') {
                                    this.scanCommentChar();
                                    if (this.bp < this.buflen && this.ch == 'c') {
                                        this.scanCommentChar();
                                        if (this.bp < this.buflen && this.ch == 'a') {
                                            this.scanCommentChar();
                                            if (this.bp < this.buflen && this.ch == 't') {
                                                this.scanCommentChar();
                                                if (this.bp < this.buflen && this.ch == 'e') {
                                                    this.scanCommentChar();
                                                    if (this.bp < this.buflen && this.ch == 'd') {
                                                        bl = true;
                                                        this.scanCommentChar();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (bl && this.bp < this.buflen) {
                if (Character.isWhitespace(this.ch)) {
                    this.deprecatedFlag = true;
                } else if (this.ch == '*') {
                    this.scanCommentChar();
                    if (this.ch == '/') {
                        this.deprecatedFlag = true;
                        return;
                    }
                }
            }
            block9: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case '*': {
                        this.scanCommentChar();
                        if (this.ch != '/') continue block9;
                        return;
                    }
                    case '\r': {
                        this.scanCommentChar();
                        if (this.ch != '\n') continue block5;
                    }
                    case '\n': {
                        this.scanCommentChar();
                        continue block5;
                    }
                }
                this.scanCommentChar();
            }
        }
    }

    public String stringVal() {
        return new String(this.sbuf, 0, this.sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextToken() {
        try {
            this.prevEndPos = this.endPos;
            this.sp = 0;
            block39: while (true) {
                this.pos = this.bp;
                switch (this.ch) {
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        do {
                            this.scanChar();
                        } while (this.ch == ' ' || this.ch == '\t' || this.ch == '\f');
                        this.endPos = this.bp;
                        this.processWhiteSpace();
                        continue block39;
                    }
                    case '\n': {
                        this.scanChar();
                        this.endPos = this.bp;
                        this.processLineTerminator();
                        continue block39;
                    }
                    case '\r': {
                        this.scanChar();
                        if (this.ch == '\n') {
                            this.scanChar();
                        }
                        this.endPos = this.bp;
                        this.processLineTerminator();
                        continue block39;
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.scanIdent();
                        return;
                    }
                    case '0': {
                        this.scanChar();
                        if (this.ch == 'x' || this.ch == 'X') {
                            this.scanChar();
                            if (this.ch == '.') {
                                this.scanHexFractionAndSuffix(false);
                            } else if (this.digit(16) < 0) {
                                this.lexError("invalid.hex.number", new Object[0]);
                            } else {
                                this.scanNumber(16);
                            }
                        } else {
                            this.putChar('0');
                            this.scanNumber(8);
                        }
                        return;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.scanNumber(10);
                        return;
                    }
                    case '.': {
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '9') {
                            this.putChar('.');
                            this.scanFractionAndSuffix();
                        } else if (this.ch == '.') {
                            this.putChar('.');
                            this.putChar('.');
                            this.scanChar();
                            if (this.ch == '.') {
                                this.scanChar();
                                this.putChar('.');
                                this.token = Token.ELLIPSIS;
                            } else {
                                this.lexError("malformed.fp.lit", new Object[0]);
                            }
                        } else {
                            this.token = Token.DOT;
                        }
                        return;
                    }
                    case ',': {
                        this.scanChar();
                        this.token = Token.COMMA;
                        return;
                    }
                    case ';': {
                        this.scanChar();
                        this.token = Token.SEMI;
                        return;
                    }
                    case '(': {
                        this.scanChar();
                        this.token = Token.LPAREN;
                        return;
                    }
                    case ')': {
                        this.scanChar();
                        this.token = Token.RPAREN;
                        return;
                    }
                    case '[': {
                        this.scanChar();
                        this.token = Token.LBRACKET;
                        return;
                    }
                    case ']': {
                        this.scanChar();
                        this.token = Token.RBRACKET;
                        return;
                    }
                    case '{': {
                        this.scanChar();
                        this.token = Token.LBRACE;
                        return;
                    }
                    case '}': {
                        this.scanChar();
                        this.token = Token.RBRACE;
                        return;
                    }
                    case '/': {
                        this.scanChar();
                        if (this.ch == '/') {
                            do {
                                this.scanCommentChar();
                            } while (this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen);
                            if (this.bp >= this.buflen) continue block39;
                            this.endPos = this.bp;
                            this.processComment(CommentStyle.LINE);
                            continue block39;
                        }
                        if (this.ch == '*') {
                            CommentStyle commentStyle;
                            this.scanChar();
                            if (this.ch == '*') {
                                commentStyle = CommentStyle.JAVADOC;
                                this.scanDocComment();
                            } else {
                                commentStyle = CommentStyle.BLOCK;
                                while (this.bp < this.buflen) {
                                    if (this.ch == '*') {
                                        this.scanChar();
                                        if (this.ch != '/') continue;
                                        break;
                                    }
                                    this.scanCommentChar();
                                }
                            }
                            if (this.ch == '/') {
                                this.scanChar();
                                this.endPos = this.bp;
                                this.processComment(commentStyle);
                                continue block39;
                            }
                            this.lexError("unclosed.comment", new Object[0]);
                            return;
                        }
                        if (this.ch == '=') {
                            this.name = this.names.slashequals;
                            this.token = Token.SLASHEQ;
                            this.scanChar();
                        } else {
                            this.name = this.names.slash;
                            this.token = Token.SLASH;
                        }
                        return;
                    }
                    case '\'': {
                        this.scanChar();
                        if (this.ch == '\'') {
                            this.lexError("empty.char.lit", new Object[0]);
                        } else {
                            if (this.ch == '\r' || this.ch == '\n') {
                                this.lexError(this.pos, "illegal.line.end.in.char.lit", new Object[0]);
                            }
                            this.scanLitChar();
                            if (this.ch == '\'') {
                                this.scanChar();
                                this.token = Token.CHARLITERAL;
                            } else {
                                this.lexError(this.pos, "unclosed.char.lit", new Object[0]);
                            }
                        }
                        return;
                    }
                    case '\"': {
                        this.scanChar();
                        while (this.ch != '\"' && this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen) {
                            this.scanLitChar();
                        }
                        if (this.ch == '\"') {
                            this.token = Token.STRINGLITERAL;
                            this.scanChar();
                        } else {
                            this.lexError(this.pos, "unclosed.str.lit", new Object[0]);
                        }
                        return;
                    }
                }
                break;
            }
            if (this.isSpecial(this.ch)) {
                this.scanOperator();
            } else {
                boolean bl;
                if (this.ch < '\u0080') {
                    bl = false;
                } else {
                    char c = this.scanSurrogates();
                    if (c != '\u0000') {
                        if (this.sp == this.sbuf.length) {
                            this.putChar(c);
                        } else {
                            this.sbuf[this.sp++] = c;
                        }
                        bl = Character.isJavaIdentifierStart(Character.toCodePoint(c, this.ch));
                    } else {
                        bl = Character.isJavaIdentifierStart(this.ch);
                    }
                }
                if (bl) {
                    this.scanIdent();
                } else if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
                    this.token = Token.EOF;
                    this.pos = this.bp = this.eofPos;
                } else {
                    this.lexError("illegal.char", String.valueOf((int)this.ch));
                    this.scanChar();
                }
            }
            return;
        }
        finally {
            this.endPos = this.bp;
            if (scannerDebug) {
                System.out.println("nextToken(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
            }
        }
    }

    public Token token() {
        return this.token;
    }

    public void token(Token token) {
        this.token = token;
    }

    public int pos() {
        return this.pos;
    }

    public int endPos() {
        return this.endPos;
    }

    public int prevEndPos() {
        return this.prevEndPos;
    }

    public int errPos() {
        return this.errPos;
    }

    public void errPos(int n) {
        this.errPos = n;
    }

    public Name name() {
        return this.name;
    }

    public int radix() {
        return this.radix;
    }

    public boolean deprecatedFlag() {
        return this.deprecatedFlag;
    }

    public void resetDeprecatedFlag() {
        this.deprecatedFlag = false;
    }

    public String docComment() {
        return null;
    }

    public char[] getRawCharacters() {
        char[] cArray = new char[this.buflen];
        System.arraycopy(this.buf, 0, cArray, 0, this.buflen);
        return cArray;
    }

    public char[] getRawCharacters(int n, int n2) {
        int n3 = n2 - n;
        char[] cArray = new char[n3];
        System.arraycopy(this.buf, n, cArray, 0, n3);
        return cArray;
    }

    protected void processComment(CommentStyle commentStyle) {
        if (scannerDebug) {
            System.out.println("processComment(" + this.pos + "," + this.endPos + "," + (Object)((Object)commentStyle) + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
        }
    }

    protected void processWhiteSpace() {
        if (scannerDebug) {
            System.out.println("processWhitespace(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
        }
    }

    protected void processLineTerminator() {
        if (scannerDebug) {
            System.out.println("processTerminator(" + this.pos + "," + this.endPos + ")=|" + new String(this.getRawCharacters(this.pos, this.endPos)) + "|");
        }
    }

    public Position.LineMap getLineMap() {
        return Position.makeLineMap(this.buf, this.buflen, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommentStyle {
        LINE,
        BLOCK,
        JAVADOC;

    }

    public static class Factory {
        public static final Context.Key<Factory> scannerFactoryKey = new Context.Key();
        final Log log;
        final Name.Table names;
        final Source source;
        final Keywords keywords;

        public static Factory instance(Context context) {
            Factory factory = context.get(scannerFactoryKey);
            if (factory == null) {
                factory = new Factory(context);
            }
            return factory;
        }

        protected Factory(Context context) {
            context.put(scannerFactoryKey, this);
            this.log = Log.instance(context);
            this.names = Name.Table.instance(context);
            this.source = Source.instance(context);
            this.keywords = Keywords.instance(context);
        }

        public Scanner newScanner(CharSequence charSequence) {
            if (charSequence instanceof CharBuffer) {
                return new Scanner(this, (CharBuffer)charSequence);
            }
            char[] cArray = ((Object)charSequence).toString().toCharArray();
            return this.newScanner(cArray, cArray.length);
        }

        public Scanner newScanner(char[] cArray, int n) {
            return new Scanner(this, cArray, n);
        }
    }
}

