/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Version(value="@(#)TreeScanner.java\t1.26 10/03/23")
public class TreeScanner
extends JCTree.Visitor {
    public void scan(JCTree jCTree) {
        if (jCTree != null) {
            jCTree.accept(this);
        }
    }

    public void scan(List<? extends JCTree> list) {
        if (list != null) {
            List<JCTree> list2 = list;
            while (list2.nonEmpty()) {
                this.scan((JCTree)list2.head);
                list2 = list2.tail;
            }
        }
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        this.scan(jCCompilationUnit.packageAnnotations);
        this.scan(jCCompilationUnit.pid);
        this.scan(jCCompilationUnit.defs);
    }

    @Override
    public void visitImport(JCTree.JCImport jCImport) {
        this.scan(jCImport.qualid);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        this.scan(jCClassDecl.mods);
        this.scan(jCClassDecl.typarams);
        this.scan(jCClassDecl.extending);
        this.scan(jCClassDecl.implementing);
        this.scan(jCClassDecl.defs);
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        this.scan(jCMethodDecl.mods);
        this.scan(jCMethodDecl.restype);
        this.scan(jCMethodDecl.typarams);
        this.scan(jCMethodDecl.params);
        this.scan(jCMethodDecl.thrown);
        this.scan(jCMethodDecl.body);
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        this.scan(jCVariableDecl.mods);
        this.scan(jCVariableDecl.vartype);
        this.scan(jCVariableDecl.init);
    }

    @Override
    public void visitSkip(JCTree.JCSkip jCSkip) {
    }

    @Override
    public void visitBlock(JCTree.JCBlock jCBlock) {
        this.scan(jCBlock.stats);
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        this.scan(jCDoWhileLoop.body);
        this.scan(jCDoWhileLoop.cond);
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        this.scan(jCWhileLoop.cond);
        this.scan(jCWhileLoop.body);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        this.scan(jCForLoop.init);
        this.scan(jCForLoop.cond);
        this.scan(jCForLoop.step);
        this.scan(jCForLoop.body);
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        this.scan(jCEnhancedForLoop.var);
        this.scan(jCEnhancedForLoop.expr);
        this.scan(jCEnhancedForLoop.body);
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        this.scan(jCLabeledStatement.body);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        this.scan(jCSwitch.selector);
        this.scan(jCSwitch.cases);
    }

    @Override
    public void visitCase(JCTree.JCCase jCCase) {
        this.scan(jCCase.pat);
        this.scan(jCCase.stats);
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        this.scan(jCSynchronized.lock);
        this.scan(jCSynchronized.body);
    }

    @Override
    public void visitTry(JCTree.JCTry jCTry) {
        this.scan(jCTry.body);
        this.scan(jCTry.catchers);
        this.scan(jCTry.finalizer);
    }

    @Override
    public void visitCatch(JCTree.JCCatch jCCatch) {
        this.scan(jCCatch.param);
        this.scan(jCCatch.body);
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        this.scan(jCConditional.cond);
        this.scan(jCConditional.truepart);
        this.scan(jCConditional.falsepart);
    }

    @Override
    public void visitIf(JCTree.JCIf jCIf) {
        this.scan(jCIf.cond);
        this.scan(jCIf.thenpart);
        this.scan(jCIf.elsepart);
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        this.scan(jCExpressionStatement.expr);
    }

    @Override
    public void visitBreak(JCTree.JCBreak jCBreak) {
    }

    @Override
    public void visitContinue(JCTree.JCContinue jCContinue) {
    }

    @Override
    public void visitReturn(JCTree.JCReturn jCReturn) {
        this.scan(jCReturn.expr);
    }

    @Override
    public void visitThrow(JCTree.JCThrow jCThrow) {
        this.scan(jCThrow.expr);
    }

    @Override
    public void visitAssert(JCTree.JCAssert jCAssert) {
        this.scan(jCAssert.cond);
        this.scan(jCAssert.detail);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        this.scan(jCMethodInvocation.meth);
        this.scan(jCMethodInvocation.args);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        this.scan(jCNewClass.encl);
        this.scan(jCNewClass.clazz);
        this.scan(jCNewClass.args);
        this.scan(jCNewClass.def);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        this.scan(jCNewArray.elemtype);
        this.scan(jCNewArray.dims);
        this.scan(jCNewArray.elems);
    }

    @Override
    public void visitParens(JCTree.JCParens jCParens) {
        this.scan(jCParens.expr);
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        this.scan(jCAssign.lhs);
        this.scan(jCAssign.rhs);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        this.scan(jCAssignOp.lhs);
        this.scan(jCAssignOp.rhs);
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        this.scan(jCUnary.arg);
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        this.scan(jCBinary.lhs);
        this.scan(jCBinary.rhs);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        this.scan(jCTypeCast.clazz);
        this.scan(jCTypeCast.expr);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        this.scan(jCInstanceOf.expr);
        this.scan(jCInstanceOf.clazz);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        this.scan(jCArrayAccess.indexed);
        this.scan(jCArrayAccess.index);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        this.scan(jCFieldAccess.selected);
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
        this.scan(jCArrayTypeTree.elemtype);
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
        this.scan(jCTypeApply.clazz);
        this.scan(jCTypeApply.arguments);
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
        this.scan(jCTypeParameter.bounds);
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        if (jCWildcard.inner != null) {
            this.scan(jCWildcard.inner);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers jCModifiers) {
        this.scan(jCModifiers.annotations);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
        this.scan(jCAnnotation.annotationType);
        this.scan(jCAnnotation.args);
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr letExpr) {
        this.scan(letExpr.defs);
        this.scan(letExpr.expr);
    }

    @Override
    public void visitTree(JCTree jCTree) {
        assert (false);
    }
}

