/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.dtdparser;

import com.sun.xml.internal.dtdparser.DTDEventListener;
import com.sun.xml.internal.dtdparser.DTDHandlerBase;
import com.sun.xml.internal.dtdparser.EndOfInputException;
import com.sun.xml.internal.dtdparser.ExternalEntity;
import com.sun.xml.internal.dtdparser.InputEntity;
import com.sun.xml.internal.dtdparser.InternalEntity;
import com.sun.xml.internal.dtdparser.MessageCatalog;
import com.sun.xml.internal.dtdparser.Resolver;
import com.sun.xml.internal.dtdparser.SimpleHashtable;
import com.sun.xml.internal.dtdparser.XmlChars;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DTDParser {
    public static final String TYPE_CDATA = "CDATA";
    public static final String TYPE_ID = "ID";
    public static final String TYPE_IDREF = "IDREF";
    public static final String TYPE_IDREFS = "IDREFS";
    public static final String TYPE_ENTITY = "ENTITY";
    public static final String TYPE_ENTITIES = "ENTITIES";
    public static final String TYPE_NMTOKEN = "NMTOKEN";
    public static final String TYPE_NMTOKENS = "NMTOKENS";
    public static final String TYPE_NOTATION = "NOTATION";
    public static final String TYPE_ENUMERATION = "ENUMERATION";
    private InputEntity in;
    private StringBuffer strTmp;
    private char[] nameTmp;
    private NameCache nameCache;
    private char[] charTmp = new char[2];
    private boolean doLexicalPE;
    protected final Set declaredElements = new HashSet();
    private SimpleHashtable params = new SimpleHashtable(7);
    Hashtable notations = new Hashtable(7);
    SimpleHashtable entities = new SimpleHashtable(17);
    private SimpleHashtable ids = new SimpleHashtable();
    private DTDEventListener dtdHandler;
    private EntityResolver resolver;
    private Locale locale;
    static final String strANY = "ANY";
    static final String strEMPTY = "EMPTY";
    private static final String XmlLang = "xml:lang";
    static final Catalog messages = new Catalog();

    public void setLocale(Locale locale) throws SAXException {
        if (locale != null && !messages.isLocaleSupported(locale.toString())) {
            throw new SAXException(messages.getMessage(this.locale, "P-078", new Object[]{locale}));
        }
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Locale chooseLocale(String[] stringArray) throws SAXException {
        Locale locale = messages.chooseLocale(stringArray);
        if (locale != null) {
            this.setLocale(locale);
        }
        return locale;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setDtdHandler(DTDEventListener dTDEventListener) {
        this.dtdHandler = dTDEventListener;
        if (dTDEventListener != null) {
            dTDEventListener.setDocumentLocator(new Locator(){

                public String getPublicId() {
                    return DTDParser.this.getPublicId();
                }

                public String getSystemId() {
                    return DTDParser.this.getSystemId();
                }

                public int getLineNumber() {
                    return DTDParser.this.getLineNumber();
                }

                public int getColumnNumber() {
                    return DTDParser.this.getColumnNumber();
                }
            });
        }
    }

    public DTDEventListener getDtdHandler() {
        return this.dtdHandler;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.init();
        this.parseInternal(inputSource);
    }

    public void parse(String string) throws IOException, SAXException {
        this.init();
        InputSource inputSource = this.resolver.resolveEntity(null, string);
        if (inputSource == null) {
            inputSource = Resolver.createInputSource(new URL(string), false);
        } else if (inputSource.getSystemId() == null) {
            this.warning("P-065", null);
            inputSource.setSystemId(string);
        }
        this.parseInternal(inputSource);
    }

    private void init() {
        this.in = null;
        this.strTmp = new StringBuffer();
        this.nameTmp = new char[20];
        this.nameCache = new NameCache();
        this.doLexicalPE = false;
        this.entities.clear();
        this.notations.clear();
        this.params.clear();
        this.declaredElements.clear();
        this.builtin("amp", "&#38;");
        this.builtin("lt", "&#60;");
        this.builtin("gt", ">");
        this.builtin("quot", "\"");
        this.builtin("apos", "'");
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        if (this.resolver == null) {
            this.resolver = new Resolver();
        }
        if (this.dtdHandler == null) {
            this.dtdHandler = new DTDHandlerBase();
        }
    }

    private void builtin(String string, String string2) {
        InternalEntity internalEntity = new InternalEntity(string, string2.toCharArray());
        this.entities.put(string, internalEntity);
    }

    private void parseInternal(InputSource inputSource) throws IOException, SAXException {
        if (inputSource == null) {
            this.fatal("P-000");
        }
        try {
            this.in = InputEntity.getInputEntity(this.dtdHandler, this.locale);
            this.in.init(inputSource, null, null, false);
            this.dtdHandler.startDTD(this.in);
            ExternalEntity externalEntity = new ExternalEntity(this.in);
            this.externalParameterEntity(externalEntity);
            if (!this.in.isEOF()) {
                this.fatal("P-001", new Object[]{Integer.toHexString(this.getc())});
            }
            this.afterRoot();
            this.dtdHandler.endDTD();
        }
        catch (EndOfInputException endOfInputException) {
            if (!this.in.isDocument()) {
                String string = this.in.getName();
                do {
                    this.in = this.in.pop();
                } while (this.in.isInternal());
                this.fatal("P-002", new Object[]{string});
            } else {
                this.fatal("P-003", null);
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.print("Internal DTD parser error: ");
            runtimeException.printStackTrace();
            throw new SAXParseException(runtimeException.getMessage() != null ? runtimeException.getMessage() : runtimeException.getClass().getName(), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        }
        finally {
            this.strTmp = null;
            this.nameTmp = null;
            this.nameCache = null;
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            this.params.clear();
            this.entities.clear();
            this.notations.clear();
            this.declaredElements.clear();
            this.ids.clear();
        }
    }

    void afterRoot() throws SAXException {
        Enumeration enumeration = this.ids.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Boolean bl = (Boolean)this.ids.get(string);
            if (Boolean.FALSE != bl) continue;
            this.error("V-024", new Object[]{string});
        }
    }

    private void whitespace(String string) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            this.fatal("P-004", new Object[]{messages.getMessage(this.locale, string)});
        }
    }

    private boolean maybeWhitespace() throws IOException, SAXException {
        if (!this.doLexicalPE) {
            return this.in.maybeWhitespace();
        }
        char c = this.getc();
        boolean bl = false;
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            bl = true;
            if (this.in.isEOF() && !this.in.isInternal()) {
                return bl;
            }
            c = this.getc();
        }
        this.ungetc();
        return bl;
    }

    private String maybeGetName() throws IOException, SAXException {
        NameCacheEntry nameCacheEntry = this.maybeGetNameCacheEntry();
        return nameCacheEntry == null ? null : nameCacheEntry.name;
    }

    private NameCacheEntry maybeGetNameCacheEntry() throws IOException, SAXException {
        char c = this.getc();
        if (!XmlChars.isLetter(c) && c != ':' && c != '_') {
            this.ungetc();
            return null;
        }
        return this.nameCharString(c);
    }

    private String getNmtoken() throws IOException, SAXException {
        char c = this.getc();
        if (!XmlChars.isNameChar(c)) {
            this.fatal("P-006", new Object[]{new Character(c)});
        }
        return this.nameCharString((char)c).name;
    }

    private NameCacheEntry nameCharString(char c) throws IOException, SAXException {
        int n = 1;
        this.nameTmp[0] = c;
        while ((c = this.in.getNameChar()) != '\u0000') {
            if (n >= this.nameTmp.length) {
                char[] cArray = new char[this.nameTmp.length + 10];
                System.arraycopy(this.nameTmp, 0, cArray, 0, this.nameTmp.length);
                this.nameTmp = cArray;
            }
            this.nameTmp[n++] = c;
        }
        return this.nameCache.lookupEntry(this.nameTmp, n);
    }

    private void parseLiteral(boolean bl) throws IOException, SAXException {
        char c = this.getc();
        InputEntity inputEntity = this.in;
        if (c != '\'' && c != '\"') {
            this.fatal("P-007");
        }
        this.strTmp = new StringBuffer();
        while (true) {
            String string;
            if (this.in != inputEntity && this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            char c2 = this.getc();
            if (c2 == c && this.in == inputEntity) break;
            if (c2 == '&') {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-020", string);
                    if (bl) {
                        this.strTmp.append('&');
                        this.strTmp.append(string);
                        this.strTmp.append(';');
                        continue;
                    }
                    this.expandEntityInLiteral(string, this.entities, bl);
                    continue;
                }
                c2 = this.getc();
                if (c2 == '#') {
                    int n = this.parseCharNumber();
                    if (n > 65535) {
                        n = this.surrogatesToCharTmp(n);
                        this.strTmp.append(this.charTmp[0]);
                        if (n != 2) continue;
                        this.strTmp.append(this.charTmp[1]);
                        continue;
                    }
                    this.strTmp.append((char)n);
                    continue;
                }
                this.fatal("P-009");
                continue;
            }
            if (c2 == '%' && bl) {
                string = this.maybeGetName();
                if (string != null) {
                    this.nextChar(';', "F-021", string);
                    this.expandEntityInLiteral(string, this.params, bl);
                    continue;
                }
                this.fatal("P-011");
            }
            if (!bl) {
                if (c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r') {
                    this.strTmp.append(' ');
                    continue;
                }
                if (c2 == '<') {
                    this.fatal("P-012");
                }
            }
            this.strTmp.append(c2);
        }
    }

    private void expandEntityInLiteral(String string, SimpleHashtable simpleHashtable, boolean bl) throws IOException, SAXException {
        Object object = simpleHashtable.get(string);
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            this.pushReader(internalEntity.buf, string, !internalEntity.isPE);
        } else if (object instanceof ExternalEntity) {
            if (!bl) {
                this.fatal("P-013", new Object[]{string});
            }
            this.pushReader((ExternalEntity)object);
        } else if (object == null) {
            this.fatal(simpleHashtable == this.params ? "V-022" : "P-014", new Object[]{string});
        }
    }

    private String getQuotedString(String string, String string2) throws IOException, SAXException {
        char c;
        char c2 = this.in.getc();
        if (c2 != '\'' && c2 != '\"') {
            this.fatal("P-015", new Object[]{messages.getMessage(this.locale, string, new Object[]{string2})});
        }
        this.strTmp = new StringBuffer();
        while ((c = this.in.getc()) != c2) {
            this.strTmp.append(c);
        }
        return this.strTmp.toString();
    }

    private String parsePublicId() throws IOException, SAXException {
        String string = this.getQuotedString("F-033", null);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (" \r\n-'()+,./:=?;!*#@$_%0123456789".indexOf(c) != -1 || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            this.fatal("P-016", new Object[]{new Character(c)});
        }
        this.strTmp = new StringBuffer();
        this.strTmp.append(string);
        return this.normalize(false);
    }

    private boolean maybeComment(boolean bl) throws IOException, SAXException {
        if (!this.in.peek(bl ? "!--" : "<!--", null)) {
            return false;
        }
        boolean bl2 = this.doLexicalPE;
        this.doLexicalPE = false;
        boolean bl3 = false;
        if (bl3) {
            this.strTmp = new StringBuffer();
        }
        block2: while (true) {
            try {
                while (true) {
                    char c;
                    if ((c = this.getc()) == '-') {
                        c = this.getc();
                        if (c != '-') {
                            if (bl3) {
                                this.strTmp.append('-');
                            }
                            this.ungetc();
                            continue;
                        }
                        this.nextChar('>', "F-022", null);
                        break block2;
                    }
                    if (!bl3) continue;
                    this.strTmp.append(c);
                }
            }
            catch (EndOfInputException endOfInputException) {
                if (this.in.isInternal()) {
                    this.error("V-021", null);
                }
                this.fatal("P-017");
                continue;
            }
            break;
        }
        this.doLexicalPE = bl2;
        if (bl3) {
            this.dtdHandler.comment(this.strTmp.toString());
        }
        return true;
    }

    private boolean maybePI(boolean bl) throws IOException, SAXException {
        boolean bl2 = this.doLexicalPE;
        if (!this.in.peek(bl ? "?" : "<?", null)) {
            return false;
        }
        this.doLexicalPE = false;
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-018");
        }
        if ("xml".equals(string)) {
            this.fatal("P-019");
        }
        if ("xml".equalsIgnoreCase(string)) {
            this.fatal("P-020", new Object[]{string});
        }
        if (this.maybeWhitespace()) {
            this.strTmp = new StringBuffer();
            try {
                char c;
                while ((c = this.in.getc()) != '?' || !this.in.peekc('>')) {
                    this.strTmp.append(c);
                }
            }
            catch (EndOfInputException endOfInputException) {
                this.fatal("P-021");
            }
            this.dtdHandler.processingInstruction(string, this.strTmp.toString());
        } else {
            if (!this.in.peek("?>", null)) {
                this.fatal("P-022");
            }
            this.dtdHandler.processingInstruction(string, "");
        }
        this.doLexicalPE = bl2;
        return true;
    }

    private String maybeReadAttribute(String string, boolean bl) throws IOException, SAXException {
        if (!this.maybeWhitespace()) {
            if (!bl) {
                return null;
            }
            this.fatal("P-024", new Object[]{string});
        }
        if (!this.peek(string)) {
            if (bl) {
                this.fatal("P-024", new Object[]{string});
            } else {
                this.ungetc();
                return null;
            }
        }
        this.maybeWhitespace();
        this.nextChar('=', "F-023", null);
        this.maybeWhitespace();
        return this.getQuotedString("F-035", string);
    }

    private void readVersion(boolean bl, String string) throws IOException, SAXException {
        String string2 = this.maybeReadAttribute("version", bl);
        if (bl && string2 == null) {
            this.fatal("P-025", new Object[]{string});
        }
        if (string2 != null) {
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c >= '0' && c <= '9' || c == '_' || c == '.' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ':' || c == '-') continue;
                this.fatal("P-026", new Object[]{string2});
            }
        }
        if (string2 != null && !string2.equals(string)) {
            this.error("P-027", new Object[]{string, string2});
        }
    }

    private String getMarkupDeclname(String string, boolean bl) throws IOException, SAXException {
        this.whitespace(string);
        String string2 = this.maybeGetName();
        if (string2 == null) {
            this.fatal("P-005", new Object[]{messages.getMessage(this.locale, string)});
        }
        return string2;
    }

    private boolean maybeMarkupDecl() throws IOException, SAXException {
        return this.maybeElementDecl() || this.maybeAttlistDecl() || this.maybeEntityDecl() || this.maybeNotationDecl() || this.maybePI(false) || this.maybeComment(false);
    }

    private boolean isXmlLang(String string) {
        int n;
        if (string.length() < 2) {
            return false;
        }
        char c = string.charAt(1);
        if (c == '-') {
            c = string.charAt(0);
            if (c != 'i' && c != 'I' && c != 'x' && c != 'X') {
                return false;
            }
            n = 1;
        } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            c = string.charAt(0);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                return false;
            }
            n = 2;
        } else {
            return false;
        }
        while (n < string.length() && (c = string.charAt(n)) == '-') {
            while (++n < string.length() && ((c = string.charAt(n)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            }
        }
        return string.length() == n && c != '-';
    }

    private boolean maybeElementDecl() throws IOException, SAXException {
        short s;
        InputEntity inputEntity = this.peekDeclaration("!ELEMENT");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-015", true);
        if (this.declaredElements.contains(string)) {
            this.error("V-012", new Object[]{string});
        } else {
            this.declaredElements.add(string);
        }
        this.whitespace("F-000");
        if (this.peek(strEMPTY)) {
            s = 0;
            this.dtdHandler.startContentModel(string, (short)0);
        } else if (this.peek(strANY)) {
            s = 1;
            this.dtdHandler.startContentModel(string, (short)1);
        } else {
            s = this.getMixedOrChildren(string);
        }
        this.dtdHandler.endContentModel(string, s);
        this.maybeWhitespace();
        char c = this.getc();
        if (c != '>') {
            this.fatal("P-036", new Object[]{string, new Character(c)});
        }
        if (inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private short getMixedOrChildren(String string) throws IOException, SAXException {
        short s;
        this.strTmp = new StringBuffer();
        this.nextChar('(', "F-028", string);
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        this.strTmp.append('(');
        if (this.peek("#PCDATA")) {
            this.strTmp.append("#PCDATA");
            s = 2;
            this.dtdHandler.startContentModel(string, (short)2);
            this.getMixed(string, inputEntity);
        } else {
            s = 3;
            this.dtdHandler.startContentModel(string, (short)3);
            this.getcps(string, inputEntity);
        }
        return s;
    }

    private void getcps(String string, InputEntity inputEntity) throws IOException, SAXException {
        boolean bl = false;
        char c = '\u0000';
        this.dtdHandler.startModelGroup();
        block3: do {
            String string2;
            if ((string2 = this.maybeGetName()) != null) {
                this.strTmp.append(string2);
                this.dtdHandler.childElement(string2, this.getFrequency());
            } else if (this.peek("(")) {
                InputEntity inputEntity2 = this.in;
                this.strTmp.append('(');
                this.maybeWhitespace();
                this.getcps(string, inputEntity2);
            } else {
                this.fatal(c == '\u0000' ? "P-039" : (c == ',' ? "P-037" : "P-038"), new Object[]{new Character(this.getc())});
            }
            this.maybeWhitespace();
            if (bl) {
                char c2 = this.getc();
                if (c2 == c) {
                    this.strTmp.append(c);
                    this.maybeWhitespace();
                    this.reportConnector(c);
                    continue;
                }
                if (c2 == ')') {
                    this.ungetc();
                    continue;
                }
                this.fatal(c == '\u0000' ? "P-041" : "P-040", new Object[]{new Character(c2), new Character(c)});
            } else {
                c = this.getc();
                switch (c) {
                    case ',': 
                    case '|': {
                        this.reportConnector(c);
                        break;
                    }
                    default: {
                        this.ungetc();
                        continue block3;
                    }
                }
                bl = true;
                this.strTmp.append(c);
            }
            this.maybeWhitespace();
        } while (!this.peek(")"));
        if (this.in != inputEntity) {
            this.error("V-014", new Object[]{string});
        }
        this.strTmp.append(')');
        this.dtdHandler.endModelGroup(this.getFrequency());
    }

    private void reportConnector(char c) throws SAXException {
        switch (c) {
            case '|': {
                this.dtdHandler.connector((short)0);
                return;
            }
            case ',': {
                this.dtdHandler.connector((short)1);
                return;
            }
        }
        throw new Error();
    }

    private short getFrequency() throws IOException, SAXException {
        char c = this.getc();
        if (c == '?') {
            this.strTmp.append(c);
            return 2;
        }
        if (c == '+') {
            this.strTmp.append(c);
            return 1;
        }
        if (c == '*') {
            this.strTmp.append(c);
            return 0;
        }
        this.ungetc();
        return 3;
    }

    private void getMixed(String string, InputEntity inputEntity) throws IOException, SAXException {
        this.maybeWhitespace();
        if (this.peek(")*") || this.peek(")")) {
            if (this.in != inputEntity) {
                this.error("V-014", new Object[]{string});
            }
            this.strTmp.append(')');
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.peek("|")) {
            this.strTmp.append('|');
            this.maybeWhitespace();
            this.doLexicalPE = true;
            String string2 = this.maybeGetName();
            if (string2 == null) {
                this.fatal("P-042", new Object[]{string, Integer.toHexString(this.getc())});
            }
            if (arrayList.contains(string2)) {
                this.error("V-015", new Object[]{string2});
            } else {
                arrayList.add(string2);
                this.dtdHandler.mixedElement(string2);
            }
            this.strTmp.append(string2);
            this.maybeWhitespace();
        }
        if (!this.peek(")*")) {
            this.fatal("P-043", new Object[]{string, new Character(this.getc())});
        }
        if (this.in != inputEntity) {
            this.error("V-014", new Object[]{string});
        }
        this.strTmp.append(')');
    }

    private boolean maybeAttlistDecl() throws IOException, SAXException {
        InputEntity inputEntity = this.peekDeclaration("!ATTLIST");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-016", true);
        while (!this.peek(">")) {
            short s;
            String string2;
            String string3;
            this.maybeWhitespace();
            char c = this.getc();
            if (c == '%') {
                string3 = this.maybeGetName();
                if (string3 != null) {
                    this.nextChar(';', "F-021", string3);
                    this.whitespace("F-021");
                    continue;
                }
                this.fatal("P-011");
            }
            this.ungetc();
            string3 = this.maybeGetName();
            if (string3 == null) {
                this.fatal("P-044", new Object[]{new Character(this.getc())});
            }
            this.whitespace("F-001");
            Vector<String> vector = null;
            if (this.peek(TYPE_CDATA)) {
                string2 = TYPE_CDATA;
            } else if (this.peek(TYPE_IDREFS)) {
                string2 = TYPE_IDREFS;
            } else if (this.peek(TYPE_IDREF)) {
                string2 = TYPE_IDREF;
            } else if (this.peek(TYPE_ID)) {
                string2 = TYPE_ID;
            } else if (this.peek(TYPE_ENTITY)) {
                string2 = TYPE_ENTITY;
            } else if (this.peek(TYPE_ENTITIES)) {
                string2 = TYPE_ENTITIES;
            } else if (this.peek(TYPE_NMTOKENS)) {
                string2 = TYPE_NMTOKENS;
            } else if (this.peek(TYPE_NMTOKEN)) {
                string2 = TYPE_NMTOKEN;
            } else if (this.peek(TYPE_NOTATION)) {
                string2 = TYPE_NOTATION;
                this.whitespace("F-002");
                this.nextChar('(', "F-029", null);
                this.maybeWhitespace();
                vector = new Vector();
                do {
                    String string4;
                    if ((string4 = this.maybeGetName()) == null) {
                        this.fatal("P-068");
                    }
                    if (this.notations.get(string4) == null) {
                        this.notations.put(string4, string4);
                    }
                    vector.addElement(string4);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
            } else if (this.peek("(")) {
                string2 = TYPE_ENUMERATION;
                this.maybeWhitespace();
                vector = new Vector<String>();
                do {
                    String string5 = this.getNmtoken();
                    vector.addElement(string5);
                    this.maybeWhitespace();
                    if (!this.peek("|")) continue;
                    this.maybeWhitespace();
                } while (!this.peek(")"));
            } else {
                this.fatal("P-045", new Object[]{string3, new Character(this.getc())});
                string2 = null;
            }
            String string6 = null;
            this.whitespace("F-003");
            if (this.peek("#REQUIRED")) {
                s = 3;
            } else if (this.peek("#FIXED")) {
                if (string2 == TYPE_ID) {
                    this.error("V-017", new Object[]{string3});
                }
                s = 2;
                this.whitespace("F-004");
                this.parseLiteral(false);
                string6 = string2 == TYPE_CDATA ? this.normalize(false) : this.strTmp.toString();
            } else if (!this.peek("#IMPLIED")) {
                s = 1;
                if (string2 == TYPE_ID) {
                    this.error("V-018", new Object[]{string3});
                }
                this.parseLiteral(false);
                string6 = string2 == TYPE_CDATA ? this.normalize(false) : this.strTmp.toString();
            } else {
                s = 0;
            }
            if (XmlLang.equals(string3) && string6 != null && !this.isXmlLang(string6)) {
                this.error("P-033", new Object[]{string6});
            }
            String[] stringArray = vector != null ? vector.toArray(new String[0]) : null;
            this.dtdHandler.attributeDecl(string, string3, string2, stringArray, s, string6);
            this.maybeWhitespace();
        }
        if (inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private String normalize(boolean bl) {
        String string = this.strTmp.toString();
        String string2 = string.trim();
        boolean bl2 = false;
        if (string != string2) {
            string = string2;
            string2 = null;
            bl2 = true;
        }
        this.strTmp = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!XmlChars.isSpace(c)) {
                this.strTmp.append(c);
                continue;
            }
            this.strTmp.append(' ');
            while (++i < string.length() && XmlChars.isSpace(string.charAt(i))) {
                bl2 = true;
            }
            --i;
        }
        if (bl2) {
            return this.strTmp.toString();
        }
        return string;
    }

    private boolean maybeConditionalSect() throws IOException, SAXException {
        if (!this.peek("<![")) {
            return false;
        }
        InputEntity inputEntity = this.in;
        this.maybeWhitespace();
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-046");
        }
        this.maybeWhitespace();
        this.nextChar('[', "F-030", null);
        if ("INCLUDE".equals(string)) {
            while (true) {
                if (this.in.isEOF() && this.in != inputEntity) {
                    this.in = this.in.pop();
                    continue;
                }
                if (this.in.isEOF()) {
                    this.error("V-020", null);
                }
                if (!this.peek("]]>")) {
                    this.doLexicalPE = false;
                    if (this.maybeWhitespace() || this.maybePEReference()) continue;
                    this.doLexicalPE = true;
                    if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
                    this.fatal("P-047");
                    continue;
                }
                break;
            }
        } else if ("IGNORE".equals(string)) {
            int n = 1;
            this.doLexicalPE = false;
            while (n > 0) {
                char c = this.getc();
                if (c == '<') {
                    if (!this.peek("![")) continue;
                    ++n;
                    continue;
                }
                if (c != ']' || !this.peek("]>")) continue;
                --n;
            }
        } else {
            this.fatal("P-048", new Object[]{string});
        }
        return true;
    }

    private int parseCharNumber() throws IOException, SAXException {
        int n = 0;
        if (this.getc() != 'x') {
            this.ungetc();
            while (true) {
                char c;
                if ((c = this.getc()) >= '0' && c <= '9') {
                    n *= 10;
                    n += c - 48;
                    continue;
                }
                if (c == ';') {
                    return n;
                }
                this.fatal("P-049");
            }
        }
        while (true) {
            char c;
            if ((c = this.getc()) >= '0' && c <= '9') {
                n <<= 4;
                n += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                n <<= 4;
                n += 10 + (c - 97);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                n <<= 4;
                n += 10 + (c - 65);
                continue;
            }
            if (c == ';') {
                return n;
            }
            this.fatal("P-050");
        }
    }

    private int surrogatesToCharTmp(int n) throws SAXException {
        if (n <= 65535) {
            if (XmlChars.isChar(n)) {
                this.charTmp[0] = (char)n;
                return 1;
            }
        } else if (n <= 0x10FFFF) {
            this.charTmp[0] = (char)(0xD800 | (n -= 65536) >> 10 & 0x3FF);
            this.charTmp[1] = (char)(0xDC00 | n & 0x3FF);
            return 2;
        }
        this.fatal("P-051", new Object[]{Integer.toHexString(n)});
        return -1;
    }

    private boolean maybePEReference() throws IOException, SAXException {
        if (!this.in.peekc('%')) {
            return false;
        }
        String string = this.maybeGetName();
        if (string == null) {
            this.fatal("P-011");
        }
        this.nextChar(';', "F-021", string);
        Object object = this.params.get(string);
        if (object instanceof InternalEntity) {
            InternalEntity internalEntity = (InternalEntity)object;
            this.pushReader(internalEntity.buf, string, false);
        } else if (object instanceof ExternalEntity) {
            this.pushReader((ExternalEntity)object);
            this.externalParameterEntity((ExternalEntity)object);
        } else if (object == null) {
            this.error("V-022", new Object[]{string});
        }
        return true;
    }

    private boolean maybeEntityDecl() throws IOException, SAXException {
        boolean bl;
        SimpleHashtable simpleHashtable;
        InputEntity inputEntity = this.peekDeclaration("!ENTITY");
        if (inputEntity == null) {
            return false;
        }
        this.doLexicalPE = false;
        this.whitespace("F-005");
        if (this.in.peekc('%')) {
            this.whitespace("F-006");
            simpleHashtable = this.params;
        } else {
            simpleHashtable = this.entities;
        }
        this.ungetc();
        this.doLexicalPE = true;
        String string = this.getMarkupDeclname("F-017", false);
        this.whitespace("F-007");
        ExternalEntity externalEntity = this.maybeExternalID();
        boolean bl2 = bl = simpleHashtable.get(string) == null;
        if (!bl && simpleHashtable == this.entities) {
            this.warning("P-054", new Object[]{string});
        }
        if (externalEntity == null) {
            this.doLexicalPE = false;
            this.parseLiteral(true);
            this.doLexicalPE = true;
            if (bl) {
                char[] cArray = new char[this.strTmp.length()];
                if (cArray.length != 0) {
                    this.strTmp.getChars(0, cArray.length, cArray, 0);
                }
                InternalEntity internalEntity = new InternalEntity(string, cArray);
                internalEntity.isPE = simpleHashtable == this.params;
                internalEntity.isFromInternalSubset = false;
                simpleHashtable.put(string, internalEntity);
                if (simpleHashtable == this.entities) {
                    this.dtdHandler.internalGeneralEntityDecl(string, new String(cArray));
                }
            }
        } else {
            if (simpleHashtable == this.entities && this.maybeWhitespace() && this.peek("NDATA")) {
                externalEntity.notation = this.getMarkupDeclname("F-018", false);
                if (this.notations.get(externalEntity.notation) == null) {
                    this.notations.put(externalEntity.notation, Boolean.TRUE);
                }
            }
            externalEntity.name = string;
            externalEntity.isPE = simpleHashtable == this.params;
            externalEntity.isFromInternalSubset = false;
            if (bl) {
                simpleHashtable.put(string, externalEntity);
                if (externalEntity.notation != null) {
                    this.dtdHandler.unparsedEntityDecl(string, externalEntity.publicId, externalEntity.systemId, externalEntity.notation);
                } else if (simpleHashtable == this.entities) {
                    this.dtdHandler.externalGeneralEntityDecl(string, externalEntity.publicId, externalEntity.systemId);
                }
            }
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-031", string);
        if (inputEntity != this.in) {
            this.error("V-013", null);
        }
        return true;
    }

    private ExternalEntity maybeExternalID() throws IOException, SAXException {
        String string = null;
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            string = this.parsePublicId();
        } else if (!this.peek("SYSTEM")) {
            return null;
        }
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        externalEntity.publicId = string;
        this.whitespace("F-008");
        externalEntity.systemId = this.parseSystemId();
        return externalEntity;
    }

    private String parseSystemId() throws IOException, SAXException {
        String string = this.getQuotedString("F-034", null);
        int n = string.indexOf(58);
        if (n == -1 || string.indexOf(47) < n) {
            String string2 = this.in.getSystemId();
            if (string2 == null) {
                this.fatal("P-055", new Object[]{string});
            }
            if (string.length() == 0) {
                string = ".";
            }
            string2 = string2.substring(0, string2.lastIndexOf(47) + 1);
            if (string.charAt(0) != '/') {
                string = string2 + string;
            } else {
                throw new InternalError();
            }
        }
        if (string.indexOf(35) != -1) {
            this.error("P-056", new Object[]{string});
        }
        return string;
    }

    private void maybeTextDecl() throws IOException, SAXException {
        if (this.peek("<?xml")) {
            this.readVersion(false, "1.0");
            this.readEncoding(true);
            this.maybeWhitespace();
            if (!this.peek("?>")) {
                this.fatal("P-057");
            }
        }
    }

    private void externalParameterEntity(ExternalEntity externalEntity) throws IOException, SAXException {
        InputEntity inputEntity = this.in;
        this.maybeTextDecl();
        while (!inputEntity.isEOF()) {
            if (this.in.isEOF()) {
                this.in = this.in.pop();
                continue;
            }
            this.doLexicalPE = false;
            if (this.maybeWhitespace() || this.maybePEReference()) continue;
            this.doLexicalPE = true;
            if (this.maybeMarkupDecl() || this.maybeConditionalSect()) continue;
        }
        if (!inputEntity.isEOF()) {
            this.fatal("P-059", new Object[]{this.in.getName()});
        }
    }

    private void readEncoding(boolean bl) throws IOException, SAXException {
        String string = this.maybeReadAttribute("encoding", bl);
        if (string == null) {
            return;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || i != 0 && (c >= '0' && c <= '9' || c == '-' || c == '_' || c == '.')) continue;
            this.fatal("P-060", new Object[]{new Character(c)});
        }
        String string2 = this.in.getEncoding();
        if (string2 != null && !string.equalsIgnoreCase(string2)) {
            this.warning("P-061", new Object[]{string, string2});
        }
    }

    private boolean maybeNotationDecl() throws IOException, SAXException {
        Object v;
        InputEntity inputEntity = this.peekDeclaration("!NOTATION");
        if (inputEntity == null) {
            return false;
        }
        String string = this.getMarkupDeclname("F-019", false);
        ExternalEntity externalEntity = new ExternalEntity(this.in);
        this.whitespace("F-011");
        if (this.peek("PUBLIC")) {
            this.whitespace("F-009");
            externalEntity.publicId = this.parsePublicId();
            if (this.maybeWhitespace()) {
                if (!this.peek(">")) {
                    externalEntity.systemId = this.parseSystemId();
                } else {
                    this.ungetc();
                }
            }
        } else if (this.peek("SYSTEM")) {
            this.whitespace("F-008");
            externalEntity.systemId = this.parseSystemId();
        } else {
            this.fatal("P-062");
        }
        this.maybeWhitespace();
        this.nextChar('>', "F-032", string);
        if (inputEntity != this.in) {
            this.error("V-013", null);
        }
        if (externalEntity.systemId != null && externalEntity.systemId.indexOf(35) != -1) {
            this.error("P-056", new Object[]{externalEntity.systemId});
        }
        if ((v = this.notations.get(string)) != null && v instanceof ExternalEntity) {
            this.warning("P-063", new Object[]{string});
        } else {
            this.notations.put(string, externalEntity);
            this.dtdHandler.notationDecl(string, externalEntity.publicId, externalEntity.systemId);
        }
        return true;
    }

    private char getc() throws IOException, SAXException {
        if (!this.doLexicalPE) {
            char c = this.in.getc();
            return c;
        }
        while (this.in.isEOF()) {
            if (this.in.isInternal() || this.doLexicalPE && !this.in.isDocument()) {
                this.in = this.in.pop();
                continue;
            }
            this.fatal("P-064", new Object[]{this.in.getName()});
        }
        char c = this.in.getc();
        if (c == '%' && this.doLexicalPE) {
            String string = this.maybeGetName();
            if (string == null) {
                this.fatal("P-011");
            }
            this.nextChar(';', "F-021", string);
            Object object = this.params.get(string);
            this.pushReader(" ".toCharArray(), null, false);
            if (object instanceof InternalEntity) {
                this.pushReader(((InternalEntity)object).buf, string, false);
            } else if (object instanceof ExternalEntity) {
                this.pushReader((ExternalEntity)object);
            } else if (object == null) {
                this.fatal("V-022");
            } else {
                throw new InternalError();
            }
            this.pushReader(" ".toCharArray(), null, false);
            return this.in.getc();
        }
        return c;
    }

    private void ungetc() {
        this.in.ungetc();
    }

    private boolean peek(String string) throws IOException, SAXException {
        return this.in.peek(string, null);
    }

    private InputEntity peekDeclaration(String string) throws IOException, SAXException {
        if (!this.in.peekc('<')) {
            return null;
        }
        InputEntity inputEntity = this.in;
        if (this.in.peek(string, null)) {
            return inputEntity;
        }
        this.in.ungetc();
        return null;
    }

    private void nextChar(char c, String string, String string2) throws IOException, SAXException {
        while (this.in.isEOF() && !this.in.isDocument()) {
            this.in = this.in.pop();
        }
        if (!this.in.peekc(c)) {
            this.fatal("P-008", new Object[]{new Character(c), messages.getMessage(this.locale, string), string2 == null ? "" : '\"' + string2 + '\"'});
        }
    }

    private void pushReader(char[] cArray, String string, boolean bl) throws SAXException {
        InputEntity inputEntity = InputEntity.getInputEntity(this.dtdHandler, this.locale);
        inputEntity.init(cArray, string, this.in, !bl);
        this.in = inputEntity;
    }

    private boolean pushReader(ExternalEntity externalEntity) throws IOException, SAXException {
        InputSource inputSource;
        InputEntity inputEntity = InputEntity.getInputEntity(this.dtdHandler, this.locale);
        try {
            inputSource = externalEntity.getInputSource(this.resolver);
        }
        catch (IOException iOException) {
            String string = "unable to open the external entity from :" + externalEntity.systemId;
            if (externalEntity.publicId != null) {
                string = string + " (public id:" + externalEntity.publicId + ")";
            }
            SAXParseException sAXParseException = new SAXParseException(string, this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber(), iOException);
            this.dtdHandler.fatalError(sAXParseException);
            throw iOException;
        }
        inputEntity.init(inputSource, externalEntity.name, this.in, externalEntity.isPE);
        this.in = inputEntity;
        return true;
    }

    public String getPublicId() {
        return this.in == null ? null : this.in.getPublicId();
    }

    public String getSystemId() {
        return this.in == null ? null : this.in.getSystemId();
    }

    public int getLineNumber() {
        return this.in == null ? -1 : this.in.getLineNumber();
    }

    public int getColumnNumber() {
        return this.in == null ? -1 : this.in.getColumnNumber();
    }

    private void warning(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        this.dtdHandler.warning(sAXParseException);
    }

    void error(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        this.dtdHandler.error(sAXParseException);
    }

    private void fatal(String string) throws SAXException {
        this.fatal(string, null);
    }

    private void fatal(String string, Object[] objectArray) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(messages.getMessage(this.locale, string, objectArray), this.getPublicId(), this.getSystemId(), this.getLineNumber(), this.getColumnNumber());
        this.dtdHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }

    static final class Catalog
    extends MessageCatalog {
        Catalog() {
            super(DTDParser.class);
        }
    }

    static class NameCache {
        NameCacheEntry[] hashtable = new NameCacheEntry[541];

        NameCache() {
        }

        String lookup(char[] cArray, int n) {
            return this.lookupEntry((char[])cArray, (int)n).name;
        }

        NameCacheEntry lookupEntry(char[] cArray, int n) {
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = n2 * 31 + cArray[i];
            }
            n2 &= Integer.MAX_VALUE;
            NameCacheEntry nameCacheEntry = this.hashtable[n2 %= this.hashtable.length];
            while (nameCacheEntry != null) {
                if (nameCacheEntry.matches(cArray, n)) {
                    return nameCacheEntry;
                }
                nameCacheEntry = nameCacheEntry.next;
            }
            nameCacheEntry = new NameCacheEntry();
            nameCacheEntry.chars = new char[n];
            System.arraycopy(cArray, 0, nameCacheEntry.chars, 0, n);
            nameCacheEntry.name = new String(nameCacheEntry.chars);
            nameCacheEntry.name = nameCacheEntry.name.intern();
            nameCacheEntry.next = this.hashtable[n2];
            this.hashtable[n2] = nameCacheEntry;
            return nameCacheEntry;
        }
    }

    static class NameCacheEntry {
        String name;
        char[] chars;
        NameCacheEntry next;

        NameCacheEntry() {
        }

        boolean matches(char[] cArray, int n) {
            if (this.chars.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (cArray[i] == this.chars[i]) continue;
                return false;
            }
            return true;
        }
    }
}

