/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.impl.parser;

import com.sun.xml.internal.xsom.XSDeclaration;
import com.sun.xml.internal.xsom.XSSimpleType;
import com.sun.xml.internal.xsom.XmlString;
import com.sun.xml.internal.xsom.impl.ForeignAttributesImpl;
import com.sun.xml.internal.xsom.impl.SchemaImpl;
import com.sun.xml.internal.xsom.impl.UName;
import com.sun.xml.internal.xsom.impl.parser.DefaultAnnotationParser;
import com.sun.xml.internal.xsom.impl.parser.Messages;
import com.sun.xml.internal.xsom.impl.parser.ParserContext;
import com.sun.xml.internal.xsom.impl.parser.Patch;
import com.sun.xml.internal.xsom.impl.parser.PatcherManager;
import com.sun.xml.internal.xsom.impl.parser.SchemaDocumentImpl;
import com.sun.xml.internal.xsom.impl.parser.state.NGCCRuntime;
import com.sun.xml.internal.xsom.impl.parser.state.Schema;
import com.sun.xml.internal.xsom.impl.util.Uri;
import com.sun.xml.internal.xsom.parser.AnnotationParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Stack;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class NGCCRuntimeEx
extends NGCCRuntime
implements PatcherManager {
    public final ParserContext parser;
    public SchemaImpl currentSchema;
    public int finalDefault = 0;
    public int blockDefault = 0;
    public boolean elementFormDefault = false;
    public boolean attributeFormDefault = false;
    public boolean chameleonMode = false;
    private String documentSystemId;
    private final Stack<String> elementNames = new Stack();
    private final NGCCRuntimeEx referer;
    public SchemaDocumentImpl document;
    private Context currentContext = null;
    public static final String XMLSchemaNSURI = "http://www.w3.org/2001/XMLSchema";

    NGCCRuntimeEx(ParserContext parserContext) {
        this(parserContext, false, null);
    }

    private NGCCRuntimeEx(ParserContext parserContext, boolean bl, NGCCRuntimeEx nGCCRuntimeEx) {
        this.parser = parserContext;
        this.chameleonMode = bl;
        this.referer = nGCCRuntimeEx;
        this.currentContext = new Context("", "", null);
        this.currentContext = new Context("xml", "http://www.w3.org/XML/1998/namespace", this.currentContext);
    }

    public void checkDoubleDefError(XSDeclaration xSDeclaration) throws SAXException {
        if (xSDeclaration == null || NGCCRuntimeEx.ignorableDuplicateComponent(xSDeclaration)) {
            return;
        }
        this.reportError(Messages.format("DoubleDefinition", xSDeclaration.getName()));
        this.reportError(Messages.format("DoubleDefinition.Original", new Object[0]), xSDeclaration.getLocator());
    }

    public static boolean ignorableDuplicateComponent(XSDeclaration xSDeclaration) {
        if (xSDeclaration.getTargetNamespace().equals(XMLSchemaNSURI)) {
            if (xSDeclaration instanceof XSSimpleType) {
                return true;
            }
            if (xSDeclaration.isGlobal() && xSDeclaration.getName().equals("anyType")) {
                return true;
            }
        }
        return false;
    }

    public void addPatcher(Patch patch) {
        this.parser.patcherManager.addPatcher(patch);
    }

    public void addErrorChecker(Patch patch) {
        this.parser.patcherManager.addErrorChecker(patch);
    }

    public void reportError(String string, Locator locator) throws SAXException {
        this.parser.patcherManager.reportError(string, locator);
    }

    public void reportError(String string) throws SAXException {
        this.reportError(string, this.getLocator());
    }

    private InputSource resolveRelativeURL(String string, String string2) throws SAXException {
        try {
            InputSource inputSource;
            EntityResolver entityResolver;
            String string3 = this.getLocator().getSystemId();
            if (string3 == null) {
                string3 = this.documentSystemId;
            }
            String string4 = null;
            if (string2 != null) {
                string4 = Uri.resolve(string3, string2);
            }
            if ((entityResolver = this.parser.getEntityResolver()) != null && (inputSource = entityResolver.resolveEntity(string, string4)) != null) {
                return inputSource;
            }
            if (string4 != null) {
                return new InputSource(string4);
            }
            return null;
        }
        catch (IOException iOException) {
            SAXParseException sAXParseException = new SAXParseException(iOException.getMessage(), this.getLocator(), iOException);
            this.parser.errorHandler.error(sAXParseException);
            return null;
        }
    }

    public void includeSchema(String string) throws SAXException {
        NGCCRuntimeEx nGCCRuntimeEx = new NGCCRuntimeEx(this.parser, this.chameleonMode, this);
        nGCCRuntimeEx.currentSchema = this.currentSchema;
        nGCCRuntimeEx.blockDefault = this.blockDefault;
        nGCCRuntimeEx.finalDefault = this.finalDefault;
        if (string == null) {
            SAXParseException sAXParseException = new SAXParseException(Messages.format("MissingSchemaLocation", new Object[0]), this.getLocator());
            this.parser.errorHandler.fatalError(sAXParseException);
            throw sAXParseException;
        }
        nGCCRuntimeEx.parseEntity(this.resolveRelativeURL(null, string), true, this.currentSchema.getTargetNamespace(), this.getLocator());
    }

    public void importSchema(String string, String string2) throws SAXException {
        NGCCRuntimeEx nGCCRuntimeEx = new NGCCRuntimeEx(this.parser, false, this);
        InputSource inputSource = this.resolveRelativeURL(string, string2);
        if (inputSource != null) {
            nGCCRuntimeEx.parseEntity(inputSource, false, string, this.getLocator());
        }
    }

    public boolean hasAlreadyBeenRead() {
        if (this.documentSystemId != null && this.documentSystemId.startsWith("file:///")) {
            this.documentSystemId = "file:/" + this.documentSystemId.substring(8);
        }
        assert (this.document == null);
        this.document = new SchemaDocumentImpl(this.currentSchema, this.documentSystemId);
        SchemaDocumentImpl schemaDocumentImpl = this.parser.parsedDocuments.get(this.document);
        if (schemaDocumentImpl == null) {
            this.parser.parsedDocuments.put(this.document, this.document);
        } else {
            this.document = schemaDocumentImpl;
        }
        assert (this.document != null);
        if (this.referer != null) {
            assert (this.referer.document != null) : "referer " + this.referer.documentSystemId + " has docIdentity==null";
            this.referer.document.references.add(this.document);
            this.document.referers.add(this.referer.document);
        }
        return schemaDocumentImpl != null;
    }

    public void parseEntity(InputSource inputSource, boolean bl, String string, Locator locator) throws SAXException {
        this.documentSystemId = inputSource.getSystemId();
        try {
            Schema schema = new Schema(this, bl, string);
            this.setRootHandler(schema);
            try {
                this.parser.parser.parse(inputSource, this, this.getErrorHandler(), this.parser.getEntityResolver());
            }
            catch (IOException iOException) {
                SAXParseException sAXParseException = new SAXParseException(iOException.toString(), locator, iOException);
                this.parser.errorHandler.fatalError(sAXParseException);
                throw sAXParseException;
            }
        }
        catch (SAXException sAXException) {
            this.parser.setErrorFlag();
            throw sAXException;
        }
    }

    public AnnotationParser createAnnotationParser() {
        if (this.parser.getAnnotationParserFactory() == null) {
            return DefaultAnnotationParser.theInstance;
        }
        return this.parser.getAnnotationParserFactory().create();
    }

    public String getAnnotationContextElementName() {
        return (String)this.elementNames.get(this.elementNames.size() - 2);
    }

    public Locator copyLocator() {
        return new LocatorImpl(this.getLocator());
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.errorHandler;
    }

    public void onEnterElementConsumed(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.onEnterElementConsumed(string, string2, string3, attributes);
        this.elementNames.push(string2);
    }

    public void onLeaveElementConsumed(String string, String string2, String string3) throws SAXException {
        super.onLeaveElementConsumed(string, string2, string3);
        this.elementNames.pop();
    }

    public ValidationContext createValidationContext() {
        return this.currentContext;
    }

    public XmlString createXmlString(String string) {
        if (string == null) {
            return null;
        }
        return new XmlString(string, this.createValidationContext());
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        this.currentContext = new Context(string, string2, this.currentContext);
    }

    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
        this.currentContext = this.currentContext.previous;
    }

    public UName parseUName(String string) throws SAXException {
        int n = string.indexOf(58);
        if (n < 0) {
            String string2 = this.resolveNamespacePrefix("");
            if (string2.equals("") && this.chameleonMode) {
                string2 = this.currentSchema.getTargetNamespace();
            }
            return new UName(string2, string, string);
        }
        String string3 = string.substring(0, n);
        String string4 = this.currentContext.resolveNamespacePrefix(string3);
        if (string4 == null) {
            this.reportError(Messages.format("UndefinedPrefix", string3));
            string4 = "undefined";
        }
        return new UName(string4, string.substring(n + 1), string);
    }

    public boolean parseBoolean(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.trim()).equals("true") || string.equals("1");
    }

    protected void unexpectedX(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(MessageFormat.format("Unexpected {0} appears at line {1} column {2}", string, this.getLocator().getLineNumber(), this.getLocator().getColumnNumber()), this.getLocator());
        this.parser.errorHandler.fatalError(sAXParseException);
        throw sAXParseException;
    }

    public ForeignAttributesImpl parseForeignAttributes(ForeignAttributesImpl foreignAttributesImpl) {
        ForeignAttributesImpl foreignAttributesImpl2 = new ForeignAttributesImpl(this.createValidationContext(), this.copyLocator(), foreignAttributesImpl);
        Attributes attributes = this.getCurrentAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (attributes.getURI(i).length() <= 0) continue;
            foreignAttributesImpl2.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        return foreignAttributesImpl2;
    }

    private static class Context
    implements ValidationContext {
        private final String prefix;
        private final String uri;
        private final Context previous;

        Context(String string, String string2, Context context) {
            this.previous = context;
            this.prefix = string;
            this.uri = string2;
        }

        public String resolveNamespacePrefix(String string) {
            if (string.equals(this.prefix)) {
                return this.uri;
            }
            if (this.previous == null) {
                return null;
            }
            return this.previous.resolveNamespacePrefix(string);
        }

        public String getBaseUri() {
            return null;
        }

        public boolean isNotation(String string) {
            return false;
        }

        public boolean isUnparsedEntity(String string) {
            return false;
        }
    }
}

