/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.impl.scd;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterators {
    private static final Iterator EMPTY = Collections.EMPTY_LIST.iterator();

    public static <T> Iterator<T> empty() {
        return EMPTY;
    }

    public static <T> Iterator<T> singleton(T t) {
        return new Singleton<T>(t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Adapter<T, U>
    extends ReadOnly<T> {
        private final Iterator<? extends U> core;

        public Adapter(Iterator<? extends U> iterator) {
            this.core = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.core.hasNext();
        }

        @Override
        public T next() {
            return this.filter(this.core.next());
        }

        protected abstract T filter(U var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Array<T>
    extends ReadOnly<T> {
        private final T[] items;
        private int index = 0;

        public Array(T[] TArray) {
            this.items = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.items.length;
        }

        @Override
        public T next() {
            return this.items[this.index++];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Filter<T>
    extends ReadOnly<T> {
        private final Iterator<? extends T> core;
        private T next;

        protected Filter(Iterator<? extends T> iterator) {
            this.core = iterator;
        }

        protected abstract boolean matches(T var1);

        @Override
        public boolean hasNext() {
            while (this.core.hasNext() && this.next == null) {
                this.next = this.core.next();
                if (this.matches(this.next)) continue;
                this.next = null;
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T t = this.next;
            this.next = null;
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Map<T, U>
    extends ReadOnly<T> {
        private final Iterator<? extends U> core;
        private Iterator<? extends T> current;

        protected Map(Iterator<? extends U> iterator) {
            this.core = iterator;
        }

        @Override
        public boolean hasNext() {
            while (this.current == null || !this.current.hasNext()) {
                if (!this.core.hasNext()) {
                    return false;
                }
                this.current = this.apply(this.core.next());
            }
            return true;
        }

        @Override
        public T next() {
            return this.current.next();
        }

        protected abstract Iterator<? extends T> apply(U var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ReadOnly<T>
    implements Iterator<T> {
        ReadOnly() {
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Singleton<T>
    extends ReadOnly<T> {
        private T next;

        Singleton(T t) {
            this.next = t;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            T t = this.next;
            this.next = null;
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Union<T>
    extends ReadOnly<T> {
        private final Iterator<? extends T> first;
        private final Iterator<? extends T> second;

        public Union(Iterator<? extends T> iterator, Iterator<? extends T> iterator2) {
            this.first = iterator;
            this.second = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.first.hasNext() || this.second.hasNext();
        }

        @Override
        public T next() {
            if (this.first.hasNext()) {
                return this.first.next();
            }
            return this.second.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Unique<T>
    extends Filter<T> {
        private Set<T> values = new HashSet<T>();

        public Unique(Iterator<? extends T> iterator) {
            super(iterator);
        }

        @Override
        protected boolean matches(T t) {
            return this.values.add(t);
        }
    }
}

