/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import sun.tools.javap.AttrData;
import sun.tools.javap.ClassData;
import sun.tools.javap.LineNumData;
import sun.tools.javap.LocVarData;
import sun.tools.javap.StackMapData;
import sun.tools.javap.StackMapTableData;
import sun.tools.javap.TrapData;
import sun.tools.javap.TypeSignature;

public class MethodData {
    ClassData cls;
    int access;
    int name_index;
    int descriptor_index;
    int attributes_count;
    byte[] code;
    Vector exception_table = new Vector(0);
    Vector lin_num_tb = new Vector(0);
    Vector loc_var_tb = new Vector(0);
    StackMapTableData[] stackMapTable;
    StackMapData[] stackMap;
    int[] exc_index_table = null;
    Vector attrs = new Vector(0);
    Vector code_attrs = new Vector(0);
    int max_stack;
    int max_locals;
    boolean isSynthetic = false;
    boolean isDeprecated = false;

    public MethodData(ClassData classData) {
        this.cls = classData;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.access = dataInputStream.readUnsignedShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.descriptor_index = dataInputStream.readUnsignedShort();
        int n = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n; ++i) {
            Object object;
            int n2 = dataInputStream.readUnsignedShort();
            if (this.cls.getTag(n2) == 1) {
                AttrData attrData;
                object = this.cls.getString(n2);
                if (((String)object).equals("Code")) {
                    this.readCode(dataInputStream);
                    attrData = new AttrData(this.cls);
                    attrData.read(n2);
                    this.attrs.addElement(attrData);
                    continue;
                }
                if (((String)object).equals("Exceptions")) {
                    this.readExceptions(dataInputStream);
                    attrData = new AttrData(this.cls);
                    attrData.read(n2);
                    this.attrs.addElement(attrData);
                    continue;
                }
                if (((String)object).equals("Synthetic")) {
                    if (dataInputStream.readInt() != 0) {
                        throw new ClassFormatError("invalid Synthetic attr length");
                    }
                    this.isSynthetic = true;
                    attrData = new AttrData(this.cls);
                    attrData.read(n2);
                    this.attrs.addElement(attrData);
                    continue;
                }
                if (((String)object).equals("Deprecated")) {
                    if (dataInputStream.readInt() != 0) {
                        throw new ClassFormatError("invalid Synthetic attr length");
                    }
                    this.isDeprecated = true;
                    attrData = new AttrData(this.cls);
                    attrData.read(n2);
                    this.attrs.addElement(attrData);
                    continue;
                }
            }
            object = new AttrData(this.cls);
            ((AttrData)object).read(n2, dataInputStream);
            this.attrs.addElement(object);
        }
    }

    public void readCode(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.max_stack = dataInputStream.readUnsignedShort();
        this.max_locals = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readInt();
        this.code = new byte[n2];
        for (int i = 0; i < n2; i += dataInputStream.read(this.code, i, n2 - i)) {
        }
        boolean bl = false;
        this.readExceptionTable(dataInputStream);
        int n3 = dataInputStream.readUnsignedShort();
        for (int i = 0; i < n3; ++i) {
            int n4 = dataInputStream.readUnsignedShort();
            byte by = this.cls.getTag(n4);
            AttrData attrData = new AttrData(this.cls);
            if (by == 1) {
                String string = this.cls.getString(n4);
                if (string.equals("LineNumberTable")) {
                    this.readLineNumTable(dataInputStream);
                    attrData.read(n4);
                } else if (string.equals("LocalVariableTable")) {
                    this.readLocVarTable(dataInputStream);
                    attrData.read(n4);
                } else if (string.equals("StackMapTable")) {
                    this.readStackMapTable(dataInputStream);
                    attrData.read(n4);
                } else if (string.equals("StackMap")) {
                    this.readStackMap(dataInputStream);
                    attrData.read(n4);
                } else {
                    attrData.read(n4, dataInputStream);
                }
                this.code_attrs.addElement(attrData);
                continue;
            }
            attrData.read(n4, dataInputStream);
            this.code_attrs.addElement(attrData);
        }
    }

    void readExceptionTable(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        this.exception_table = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.exception_table.addElement(new TrapData(dataInputStream, i));
        }
    }

    void readLineNumTable(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readUnsignedShort();
        this.lin_num_tb = new Vector(n2);
        for (int i = 0; i < n2; ++i) {
            this.lin_num_tb.addElement(new LineNumData(dataInputStream));
        }
    }

    void readLocVarTable(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readUnsignedShort();
        this.loc_var_tb = new Vector(n2);
        for (int i = 0; i < n2; ++i) {
            this.loc_var_tb.addElement(new LocVarData(dataInputStream));
        }
    }

    public void readExceptions(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readUnsignedShort();
        this.exc_index_table = new int[n2];
        for (int i = 0; i < n2; ++i) {
            short s = dataInputStream.readShort();
            this.exc_index_table[i] = s;
        }
    }

    void readStackMapTable(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readUnsignedShort();
        this.stackMapTable = new StackMapTableData[n2];
        for (int i = 0; i < n2; ++i) {
            this.stackMapTable[i] = StackMapTableData.getInstance(dataInputStream, this);
        }
    }

    void readStackMap(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readUnsignedShort();
        this.stackMap = new StackMapData[n2];
        for (int i = 0; i < n2; ++i) {
            this.stackMap[i] = new StackMapData(dataInputStream, this);
        }
    }

    public String[] getAccess() {
        Vector<String> vector = new Vector<String>();
        if ((this.access & 1) != 0) {
            vector.addElement("public");
        }
        if ((this.access & 2) != 0) {
            vector.addElement("private");
        }
        if ((this.access & 4) != 0) {
            vector.addElement("protected");
        }
        if ((this.access & 8) != 0) {
            vector.addElement("static");
        }
        if ((this.access & 0x10) != 0) {
            vector.addElement("final");
        }
        if ((this.access & 0x20) != 0) {
            vector.addElement("synchronized");
        }
        if ((this.access & 0x100) != 0) {
            vector.addElement("native");
        }
        if ((this.access & 0x400) != 0) {
            vector.addElement("abstract");
        }
        if ((this.access & 0x800) != 0) {
            vector.addElement("strictfp");
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getName() {
        return this.cls.getStringValue(this.name_index);
    }

    public String getInternalSig() {
        return this.cls.getStringValue(this.descriptor_index);
    }

    public String getReturnType() {
        String string = new TypeSignature(this.getInternalSig()).getReturnType();
        return string;
    }

    public String getParameters() {
        String string = new TypeSignature(this.getInternalSig()).getParameters();
        return string;
    }

    public byte[] getCode() {
        return this.code;
    }

    public int getnumlines() {
        return this.lin_num_tb.size();
    }

    public Vector getlin_num_tb() {
        return this.lin_num_tb;
    }

    public int getloc_var_tbsize() {
        return this.loc_var_tb.size();
    }

    public Vector getloc_var_tb() {
        return this.loc_var_tb;
    }

    public StackMapData[] getStackMap() {
        return this.stackMap;
    }

    public StackMapTableData[] getStackMapTable() {
        return this.stackMapTable;
    }

    public int getArgumentlength() {
        return new TypeSignature(this.getInternalSig()).getArgumentlength();
    }

    public boolean isStatic() {
        return (this.access & 8) != 0;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public int[] get_exc_index_table() {
        return this.exc_index_table;
    }

    public Vector getexception_table() {
        return this.exception_table;
    }

    public Vector getAttributes() {
        return this.attrs;
    }

    public Vector getCodeAttributes() {
        return this.code_attrs;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }
}

