/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.DescriptorSupport;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.config.AMXConfigLoader;
import org.glassfish.admin.amx.impl.config.AttributeResolverHelper;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupport;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupportRegistry;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.Issues;
import org.glassfish.admin.amx.impl.util.MBeanInfoSupport;
import org.glassfish.admin.amx.impl.util.SingletonEnforcer;
import org.glassfish.admin.amx.impl.util.UnregistrationListener;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;
import org.jvnet.hk2.config.WriteableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
public class AMXConfigImpl
extends AMXImplBase {
    private final ConfigBean mConfigBean;
    private static MBeanInfo configMBeanInfo;
    private static final ConcurrentMap<Class<? extends ConfigBeanProxy>, MBeanInfo> mInfos;
    private static final AtomicLong sSequenceNumber;

    private static synchronized MBeanInfo getAMXConfigMBeanInfo() {
        if (configMBeanInfo == null) {
            configMBeanInfo = MBeanInfoSupport.getMBeanInfo(AMXConfigProxy.class);
        }
        return configMBeanInfo;
    }

    private static MBeanInfo createMBeanInfo(ConfigBean cb) {
        Class intf = cb.getProxyType();
        MBeanInfo newInfo = (MBeanInfo)mInfos.get(intf);
        if (newInfo != null) {
            return newInfo;
        }
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        MBeanInfo info = spt.getMBeanInfo();
        List<MBeanAttributeInfo> attrInfos = ListUtil.newListFromArray(info.getAttributes());
        MBeanInfo spiInfo = MBeanInfoSupport.getAMX_SPIMBeanInfo();
        List<MBeanAttributeInfo> spiAttrInfos = ListUtil.newListFromArray(spiInfo.getAttributes());
        if (spt.isLeaf()) {
            JMXUtil.remove(spiAttrInfos, "Children");
        }
        for (MBeanAttributeInfo attrInfo : spiAttrInfos) {
            String attrName = attrInfo.getName();
            MBeanAttributeInfo priorAttrInfo = JMXUtil.remove(attrInfos, attrName);
            if (attrName.equals("Name") && priorAttrInfo != null) {
                DescriptorSupport mergedD = JMXUtil.mergeDescriptors(attrInfo.getDescriptor(), priorAttrInfo.getDescriptor());
                MBeanAttributeInfo newAttrInfo = new MBeanAttributeInfo(attrName, attrInfo.getType(), attrInfo.getDescription(), attrInfo.isReadable(), attrInfo.isWritable(), attrInfo.isIs(), mergedD);
                attrInfos.add(newAttrInfo);
                continue;
            }
            attrInfos.add(attrInfo);
        }
        List<MBeanOperationInfo> operationInfos = ListUtil.newListFromArray(info.getOperations());
        operationInfos.addAll(ListUtil.newListFromArray(AMXConfigImpl.getAMXConfigMBeanInfo().getOperations()));
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[attrInfos.size()];
        attrInfos.toArray(attrs);
        MBeanOperationInfo[] operations = new MBeanOperationInfo[operationInfos.size()];
        operationInfos.toArray(operations);
        newInfo = new MBeanInfo(info.getClassName(), info.getDescription(), attrs, info.getConstructors(), operations, info.getNotifications(), info.getDescriptor());
        MBeanInfo oldInfo = mInfos.putIfAbsent(intf, newInfo);
        return oldInfo != null ? oldInfo : newInfo;
    }

    public AMXConfigImpl(ObjectName parentObjectName, ConfigBean configBean) {
        this(parentObjectName, AMXConfigProxy.class, configBean);
    }

    public AMXConfigImpl(ObjectName parentObjectName, Class<? extends AMXProxy> theInterface, ConfigBean configBean) {
        super(parentObjectName, AMXConfigImpl.createMBeanInfo(configBean));
        this.mConfigBean = configBean;
        this.getConfigBeanJMXSupport();
    }

    @Override
    protected void setAttributeManually(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        AttributeList attrList = new AttributeList();
        attrList.add(attr);
        try {
            AttributeList successList = this.setAttributesInConfigBean(attrList);
            if (successList.size() == 0) {
                throw new AttributeNotFoundException(attr.getName());
            }
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            throw new AttributeNotFoundException(ExceptionUtil.toString(rootCause));
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attrs) {
        try {
            return this.setAttributesTransactionally(attrs);
        }
        catch (Exception exception) {
            return new AttributeList();
        }
    }

    public AttributeList setAttributesTransactionally(AttributeList attrs) throws Exception {
        AttributeList successList = new AttributeList();
        try {
            AttributeList delegateSuccess = this.setAttributesInConfigBean(attrs);
            successList.addAll(delegateSuccess);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            throw new Exception(ExceptionUtil.toString(rootCause));
        }
        return successList;
    }

    @Override
    public String getName() {
        ConfigBean cb = this.getConfigBean();
        String name = AMXConfigLoader.getKey(cb);
        if (name == null) {
            name = cb.rawAttribute("name");
        }
        return name == null ? "" : name;
    }

    private final ConfigBean getConfigBean() {
        return this.mConfigBean;
    }

    private final ConfigBeanProxy getConfigBeanProxy() {
        return this.getConfigBean().getProxy(this.getConfigBean().getProxyType());
    }

    public String resolveAttributeValue(String varString) {
        if (!AttributeResolverHelper.needsResolving(varString)) {
            return varString;
        }
        return new AttributeResolverHelper(this.getSelf(AMXConfigProxy.class)).resolve(varString);
    }

    public String resolveAttribute(String attrName) {
        try {
            Object value = this.getAttribute(attrName);
            return this.resolveAttributeValue(value == null ? null : "" + value);
        }
        catch (AttributeNotFoundException e) {
            System.out.println("resolveAttribute: Attribute not found: " + attrName + " on " + this.getObjectName());
            return null;
        }
    }

    public Boolean resolveBoolean(String attrName) {
        return Boolean.parseBoolean(this.resolveAttribute(attrName));
    }

    public Integer resolveInteger(String attrName) {
        return Integer.parseInt(this.resolveAttribute(attrName));
    }

    public Long resolveLong(String attrName) {
        return Long.parseLong(this.resolveAttribute(attrName));
    }

    public AttributeList resolveAttributes(String[] attrNames) {
        Issues.getAMXIssues().notDone("resolveAttributes: use annotations to create the correct type");
        AttributeList attrs = this.getAttributes(attrNames);
        AttributeList resolvedAttrs = new AttributeList();
        for (Object o : attrs) {
            Attribute r = (Attribute)o;
            Object value = r.getValue();
            if (value instanceof String && AttributeResolverHelper.needsResolving((String)value)) {
                String resolvedValue = this.resolveAttributeValue((String)value);
                r = new Attribute(r.getName(), resolvedValue);
            }
            resolvedAttrs.add(r);
        }
        return resolvedAttrs;
    }

    private void checkForConflicts(List<CreateParams> children) {
        Map<String, Map<String, AMXProxy>> existingChildren = this.getSelf().childrenMaps();
        for (CreateParams params : children) {
            String type = params.type();
            Map<String, AMXProxy> childrenOfType = existingChildren.get(type);
            if (childrenOfType == null) continue;
            AMXProxy firstChild = childrenOfType.values().iterator().next();
            if (firstChild.extra().singleton()) {
                throw new IllegalArgumentException("Singleton child of type " + type + " already exists.");
            }
            if (childrenOfType.get(params.name()) == null) continue;
            throw new IllegalArgumentException("Child of type " + type + " named " + params.name() + " already exists.");
        }
    }

    ObjectName[] createChildren(List<CreateParams> children, Map<String, Object> attrs) {
        AMXConfigImpl.cdebug(children.toString());
        this.checkForConflicts(children);
        ConfigBeanProxy parent = this.getConfigBeanProxy();
        ChildrenCreator creator = new ChildrenCreator(children, attrs);
        try {
            ConfigSupport.apply((ConfigCode)creator, (ConfigBeanProxy[])new ConfigBeanProxy[]{parent});
        }
        catch (Exception e) {
            ImplUtil.getLogger().log(Level.INFO, "Can't create children", e);
            throw new RuntimeException(e);
        }
        List newMBeans = ListUtil.newList();
        List<ConfigBean> newDescendants = creator.configBeans();
        AMXConfigLoader amxLoader = SingletonEnforcer.get(AMXConfigLoader.class);
        for (ConfigBean newDescendant : newDescendants) {
            amxLoader.handleConfigBean(newDescendant, true);
            ObjectName objectName = ConfigBeanRegistry.getInstance().getObjectName(newDescendant);
            newMBeans.add(objectName);
        }
        return CollectionUtil.toArray(newMBeans, ObjectName.class);
    }

    public ObjectName[] createChildren(Map<String, Map<String, Object>[]> childrenMaps, Map<String, Object> attrs) {
        List<CreateParams> children = ListUtil.newList();
        for (String type : childrenMaps.keySet()) {
            for (Map<String, Object> m : childrenMaps.get(type)) {
                children.add(new CreateParams(type, m));
            }
        }
        return this.createChildren(children, attrs);
    }

    public ObjectName createChild(String type, Map<String, Object> params) {
        CreateParams childParams = new CreateParams(type, params);
        List<CreateParams> children = ListUtil.newList();
        children.add(childParams);
        ObjectName[] objectNames = this.createChildren(children, null);
        return objectNames[0];
    }

    Map<String, Object> replaceNameWithKey(Map<String, Object> attrs, ConfigBeanJMXSupport spt) {
        String xmlKeyName;
        String key = null;
        if (attrs.containsKey("Name")) {
            key = "Name";
        } else if (attrs.containsKey("name")) {
            key = "name";
        }
        Map<String, Object> m = attrs;
        if (key != null && (xmlKeyName = spt.getNameHint()) != null && !attrs.keySet().contains(xmlKeyName)) {
            m = new HashMap<String, Object>(attrs);
            Object value = m.remove(key);
            m.put(xmlKeyName, value);
        }
        return m;
    }

    public static List<String> listOfString() {
        return null;
    }

    public static String convertAttributeName(String s) {
        if (s.equals(s.toLowerCase()) || s.indexOf("-") >= 0) {
            return s;
        }
        return Dom.convertName((String)s);
    }

    private void setAttrs(ConfigBeanProxy target, Map<String, Object> attrs) {
        WriteableView targetW = (WriteableView)WriteableView.class.cast(Proxy.getInvocationHandler(Proxy.class.cast(target)));
        for (String attrName : attrs.keySet()) {
            Object attrValue = attrs.get(attrName);
            String xmlName = AMXConfigImpl.convertAttributeName(attrName);
            ConfigBean targetCB = (ConfigBean)Dom.unwrap((ConfigBeanProxy)target);
            ConfigModel.Property modelProp = targetCB.model.findIgnoreCase(xmlName);
            if (modelProp == null) {
                throw new IllegalArgumentException("Can't find ConfigModel.Property for attr " + xmlName + " on " + targetCB.getProxyType());
            }
            if (modelProp.isCollection()) {
                Method m;
                try {
                    m = this.getClass().getMethod("listOfString", null);
                }
                catch (Exception e) {
                    throw new IllegalStateException("impossible");
                }
                Type listOfStringClass = m.getGenericReturnType();
                List<String> list = attrValue instanceof String[] ? ListUtil.asStringList(attrValue) : TypeCast.checkList(TypeCast.asList(attrValue), String.class);
                targetW.setter(modelProp, list, listOfStringClass);
                continue;
            }
            targetW.setter(modelProp, attrValue, String.class);
        }
    }

    public ObjectName removeChild(String type) {
        ObjectName child = this.child(type);
        if (child == null) {
            System.out.println("Can't find child of type: " + type);
            return null;
        }
        return this.remove(child);
    }

    public ObjectName removeChild(String type, String name) {
        ObjectName child = this.child(type, name);
        if (child == null) {
            return null;
        }
        return this.remove(child);
    }

    private final ObjectName remove(ObjectName childObjectName) {
        ObjectName removed = null;
        try {
            ConfigBean childConfigBean = ConfigBeanRegistry.getInstance().getConfigBean(childObjectName);
            try {
                ConfigSupport.deleteChild((ConfigBean)this.getConfigBean(), (ConfigBean)childConfigBean);
                removed = childObjectName;
            }
            catch (TransactionFailure tf) {
                throw new RuntimeException("Transaction failure deleting " + JMXUtil.toString(childObjectName), tf);
            }
            UnregistrationListener myListener = new UnregistrationListener(this.getMBeanServer(), childObjectName);
            long TIMEOUT_MILLIS = 10000L;
            boolean unregisteredOK = myListener.waitForUnregister(10000L);
            if (!unregisteredOK) {
                throw new RuntimeException("Something went wrong unregistering MBean " + JMXUtil.toString(childObjectName));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem deleting " + childObjectName, e);
        }
        return removed;
    }

    private Object invokeDuckMethod(ConfigBeanJMXSupport.DuckTypedInfo info, Object[] args) throws MBeanException {
        try {
            if (!info.method().getDeclaringClass().isAssignableFrom(this.getConfigBeanProxy().getClass())) {
                throw new IllegalArgumentException("invokeDuckMethod: " + this.getConfigBean().getProxyType() + " not asssignable to " + info.method().getDeclaringClass());
            }
            Object result = info.method().invoke((Object)this.getConfigBeanProxy(), args);
            result = this.translateResult(result);
            return result;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private ObjectName getObjectName(ConfigBeanProxy cbp) {
        Dom dom = Dom.unwrap((ConfigBeanProxy)cbp);
        if (dom instanceof ConfigBean) {
            return ConfigBeanRegistry.getInstance().getObjectName((ConfigBean)dom);
        }
        return null;
    }

    private Object translateResult(Object result) {
        Class<?> componentType;
        if (result instanceof String) {
            return result;
        }
        Object out = result;
        if (result instanceof ConfigBeanProxy) {
            out = this.getObjectName((ConfigBeanProxy)result);
        } else if (result instanceof Collection) {
            Collection c = (Collection)((Object)result);
            ArrayList<Object> translated = new ArrayList<Object>();
            for (Object item : c) {
                translated.add(this.translateResult(item));
            }
            out = result instanceof Set ? new HashSet(translated) : (result instanceof AbstractQueue ? new LinkedBlockingDeque(translated) : translated);
        } else if (result instanceof Map) {
            Map resultMap = result;
            HashMap<Object, Object> outMap = new HashMap<Object, Object>();
            for (Object key : resultMap.keySet()) {
                outMap.put(this.translateResult(key), this.translateResult(resultMap.get(key)));
            }
            out = outMap;
        } else if (result.getClass().isArray() && ConfigBeanProxy.class.isAssignableFrom(componentType = result.getClass().getComponentType())) {
            Object[] items = (Object[])result;
            ObjectName[] objectNames = new ObjectName[items.length];
            for (int i = 0; i < items.length; ++i) {
                objectNames[i] = this.getObjectName((ConfigBeanProxy)items[i]);
            }
            out = objectNames;
        }
        return out;
    }

    @Override
    protected Object invokeManually(String operationName, Object[] args, String[] types) throws MBeanException, ReflectionException, NoSuchMethodException, AttributeNotFoundException {
        int numArgs = args == null ? 0 : args.length;
        Object result = null;
        this.debugMethod(operationName, args);
        ConfigBeanJMXSupport.DuckTypedInfo duckTypedInfo = null;
        ConfigBeanJMXSupport spt = this.getConfigBeanJMXSupport();
        duckTypedInfo = this.getConfigBeanJMXSupport().findDuckTyped(operationName, types);
        result = duckTypedInfo != null ? this.invokeDuckMethod(duckTypedInfo, args) : super.invokeManually(operationName, args, types);
        return result;
    }

    public void sendConfigCreatedNotification(ObjectName configObjectName) {
        this.sendNotification("org.glassfish.admin.amx.intf.ConfigCreated", "org.glassfish.admin.amx.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    public void sendConfigRemovedNotification(ObjectName configObjectName) {
        this.sendNotification("org.glassfish.admin.amx.config.ConfigRemoved", "org.glassfish.admin.amx.config.ConfigRemoved", "ConfigObjectName", configObjectName);
    }

    private final ConfigBeanJMXSupport getConfigBeanJMXSupport() {
        return ConfigBeanJMXSupportRegistry.getInstance(this.getConfigBean());
    }

    private static final Map<String, String> getDefaultValues(Class<? extends ConfigBeanProxy> intf, boolean useAMXAttributeNames) {
        return ConfigBeanJMXSupportRegistry.getInstance(intf).getDefaultValues(useAMXAttributeNames);
    }

    public final Map<String, String> getDefaultValues(String type, boolean useAMXAttributeNames) {
        Class<? extends ConfigBeanProxy> intf = this.getConfigBeanProxyClassForContainedType(type);
        return AMXConfigImpl.getDefaultValues(intf, useAMXAttributeNames);
    }

    public final Map<String, String> getDefaultValues(boolean useAMXAttributeNames) {
        return AMXConfigImpl.getDefaultValues(this.mConfigBean.getProxyType(), useAMXAttributeNames);
    }

    private Class<? extends ConfigBeanProxy> getConfigBeanProxyClassForContainedType(String type) {
        ConfigBeanJMXSupport spt = this.getConfigBeanJMXSupport();
        if (spt == null) {
            throw new IllegalArgumentException("Can't find ConfigBean @Configured class for AMX type " + type);
        }
        return ConfigBeanJMXSupportRegistry.getConfigBeanProxyClassFor(spt, type);
    }

    @Override
    protected String[] attributeNameToType(String attributeName) {
        return new String[]{Util.typeFromName(attributeName), attributeName};
    }

    @Override
    protected Object getAttributeManually(String name) throws AttributeNotFoundException, ReflectionException, MBeanException {
        return this.getAttributeFromConfigBean(name);
    }

    protected final Object getAttributeFromConfigBean(String amxName) {
        String[] result = null;
        MBeanAttributeInfo attrInfo = this.getAttributeInfo(amxName);
        if (attrInfo == null) {
            ConfigBeanJMXSupport.DuckTypedInfo info = this.getConfigBeanJMXSupport().findDuckTyped("get" + amxName, null);
            if (info == null) {
                info = this.getConfigBeanJMXSupport().findDuckTyped("is" + amxName, null);
            }
            if (info != null) {
                try {
                    result = this.invokeDuckMethod(info, null);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(new MBeanException(e, amxName));
                }
            }
            throw new RuntimeException(new AttributeNotFoundException(amxName));
        }
        String xmlName = ConfigBeanJMXSupport.xmlName(attrInfo, amxName);
        boolean isAttribute = ConfigBeanJMXSupport.isAttribute(attrInfo);
        if (isAttribute) {
            result = this.mConfigBean.rawAttribute(xmlName);
        } else if (ConfigBeanJMXSupport.isElement(attrInfo)) {
            if (String.class.getName().equals(attrInfo.getType())) {
                List leaf = this.mConfigBean.leafElements(xmlName);
                if (leaf != null) {
                    try {
                        result = (String)leaf.get(0);
                    }
                    catch (Exception e) {}
                }
            } else if (attrInfo.getType() == String[].class.getName()) {
                List leaf = this.mConfigBean.leafElements(xmlName);
                if (leaf != null) {
                    List<String> elems = TypeCast.checkList(leaf, String.class);
                    result = CollectionUtil.toArray(elems, String.class);
                }
            } else {
                throw new IllegalArgumentException("getAttributeFromConfigBean: unsupported return type: " + attrInfo.getType());
            }
        }
        return result;
    }

    private Map<String, PropertyChangeEvent> makePropertyChangeEventMap(List<PropertyChangeEvent> changeEvents) {
        HashMap<String, PropertyChangeEvent> m = new HashMap<String, PropertyChangeEvent>();
        for (PropertyChangeEvent changeEvent : changeEvents) {
            if (changeEvent.getPropertyName() == null) {
                throw new IllegalArgumentException("PropertyChangeEvent property names must be specified");
            }
            m.put(changeEvent.getPropertyName(), changeEvent);
        }
        return m;
    }

    private void joinTransaction(Transaction t, WriteableView writeable) throws TransactionFailure {
        if (!writeable.join(t)) {
            t.rollback();
            throw new TransactionFailure("Cannot enlist " + writeable.getProxyType() + " in transaction", null);
        }
    }

    private static void commit(Transaction t) throws TransactionFailure {
        try {
            t.commit();
        }
        catch (RetryableException e) {
            t.rollback();
            throw new TransactionFailure(e.getMessage(), (Throwable)e);
        }
        catch (TransactionFailure e) {
            AMXConfigImpl.cdebug("failure, not retryable...");
            t.rollback();
            throw e;
        }
    }

    static <T extends ConfigBeanProxy> WriteableView getWriteableView(T s, ConfigBean sourceBean) throws TransactionFailure {
        WriteableView f = new WriteableView(s);
        if (sourceBean.getLock().tryLock()) {
            return f;
        }
        throw new TransactionFailure("Config bean already locked " + sourceBean, null);
    }

    private static Type getCollectionGenericType() {
        try {
            return ConfigSupport.class.getDeclaredMethod("defaultPropertyValue", null).getGenericReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException();
        }
    }

    private List<String> handleCollection(WriteableView writeable, ConfigModel.Property prop, String cmd, List<String> argValues) {
        Object o = writeable.getter(prop, AMXConfigImpl.getCollectionGenericType());
        List<String> masterList = TypeCast.checkList(TypeCast.asList(o), String.class);
        if (cmd.equals("replace")) {
            masterList.retainAll(argValues);
            for (String s : argValues) {
                if (masterList.contains(s)) continue;
                masterList.add(s);
            }
        } else if (cmd.equals("remove")) {
            masterList.removeAll(argValues);
        } else if (cmd.equals("add")) {
            ArrayList<String> temp = new ArrayList<String>(argValues);
            temp.removeAll(masterList);
            masterList.addAll(temp);
        } else {
            throw new IllegalArgumentException(cmd);
        }
        return new ArrayList<String>(masterList);
    }

    protected ConfigModel.Property getConfigModel_Property(String xmlName) {
        ConfigModel.Property cmp = this.mConfigBean.model.findIgnoreCase(xmlName);
        if (cmp == null) {
            throw new IllegalArgumentException("Illegal name: " + xmlName);
        }
        return cmp;
    }

    private Map<String, Object> mapNamesAndValues(Map<String, Object> amxAttrs, Map<String, Object> noMatch) {
        HashMap<String, Object> xmlAttrs = new HashMap<String, Object>();
        Map<String, MBeanAttributeInfo> attrInfos = this.getAttributeInfos();
        for (String amxAttrName : amxAttrs.keySet()) {
            Object valueIn = amxAttrs.get(amxAttrName);
            MBeanAttributeInfo attrInfo = attrInfos.get(amxAttrName);
            if (attrInfo == null) {
                this.debug((Object)("WARNING: setAttributes(): no MBeanAttributeInfo found for: " + amxAttrName));
                noMatch.put(amxAttrName, valueIn);
                continue;
            }
            String xmlName = ConfigBeanJMXSupport.xmlName(attrInfo, amxAttrName);
            if (xmlName != null) {
                Object value = valueIn;
                if (valueIn == null || value instanceof String) {
                    xmlAttrs.put(xmlName, (String)value);
                    continue;
                }
                ConfigModel.Property prop = this.getConfigModel_Property(xmlName);
                if (prop != null && prop.isCollection()) {
                    if (valueIn instanceof String[] || valueIn instanceof List) {
                        xmlAttrs.put(xmlName, ListUtil.asStringList(valueIn));
                        continue;
                    }
                    noMatch.put(amxAttrName, valueIn);
                    continue;
                }
                noMatch.put(amxAttrName, valueIn);
                continue;
            }
            this.debug((Object)("WARNING: setAttributes(): no xmlName match found for AMX attribute: " + amxAttrName));
            noMatch.put(amxAttrName, valueIn);
        }
        return xmlAttrs;
    }

    public AttributeList setAttributesInConfigBean(AttributeList attrsIn) throws TransactionFailure {
        Map<String, Object> amxAttrs = JMXUtil.attributeListToValueMap(attrsIn);
        HashMap<String, Object> notMatched = new HashMap<String, Object>();
        Map<String, Object> xmlAttrs = this.mapNamesAndValues(amxAttrs, notMatched);
        if (notMatched.keySet().size() != 0) {
            AMXConfigImpl.cdebug("setAttributes: failed to map these AMX attributes: {" + CollectionUtil.toString(notMatched.keySet(), ", ") + "}");
        }
        AttributeList successfulAttrs = new AttributeList();
        Transactions transactions = (Transactions)this.mConfigBean.getHabitat().getComponent(Transactions.class);
        if (xmlAttrs.size() != 0) {
            MyTransactionListener myListener = new MyTransactionListener(this.mConfigBean);
            transactions.addTransactionsListener((TransactionListener)myListener);
            try {
                MakeChangesApplyer mca = new MakeChangesApplyer(this.mConfigBean, xmlAttrs);
                mca.apply();
                successfulAttrs.addAll(attrsIn);
            }
            catch (TransactionFailure tf) {
                AMXConfigImpl.cdebug(ExceptionUtil.toString(tf));
                throw tf;
            }
            finally {
                transactions.waitForDrain();
                transactions.removeTransactionsListener((TransactionListener)myListener);
            }
        }
        return successfulAttrs;
    }

    void issueAttributeChangeForXmlAttrName(String xmlAttrName, String message, Object oldValue, Object newValue, long whenChanged) {
        String attributeName;
        Map<String, String> m = this.getConfigBeanJMXSupport().getFromXMLNameMapping();
        String string = attributeName = m.containsKey(xmlAttrName) ? m.get(xmlAttrName) : xmlAttrName;
        if (attributeName.equals(xmlAttrName)) {
            AMXConfigImpl.cdebug("issueAttributeChangeForXmlAttrName(): MBean attribute name not found for xml name, using xml name: " + xmlAttrName);
        }
        String attributeType = String.class.getName();
        this.getLogger().fine(this.getObjectName() + " -- " + attributeName + " = " + newValue + " <== " + oldValue);
        long sequenceNumber = sSequenceNumber.getAndIncrement();
        AttributeChangeNotification notif = new AttributeChangeNotification(this.getObjectName(), sequenceNumber, whenChanged, message, attributeName, attributeType, oldValue, newValue);
        this.sendNotification(notif);
    }

    static {
        mInfos = new ConcurrentHashMap<Class<? extends ConfigBeanProxy>, MBeanInfo>();
        sSequenceNumber = new AtomicLong(0L);
    }

    private class Applyer {
        final Transaction mTransaction;
        final ConfigBean mConfigBean;
        final WriteableView mWriteable;

        public Applyer(ConfigBean cb) throws TransactionFailure {
            this(cb, new Transaction());
        }

        public Applyer(ConfigBean cb, Transaction t) throws TransactionFailure {
            this.mConfigBean = cb;
            this.mTransaction = t;
            ConfigBeanProxy readableView = cb.getProxy(cb.getProxyType());
            this.mWriteable = AMXConfigImpl.getWriteableView(readableView, cb);
        }

        protected void makeChanges() throws TransactionFailure {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void apply() throws TransactionFailure {
            try {
                AMXConfigImpl.this.joinTransaction(this.mTransaction, this.mWriteable);
                this.makeChanges();
                AMXConfigImpl.commit(this.mTransaction);
            }
            finally {
                this.mConfigBean.getLock().unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ChildrenCreator
    implements ConfigCode {
        protected final List<CreateParams> mChildrenMaps;
        protected final Map<String, Object> mAttrs;
        protected final List<ConfigBean> mNewConfigBeans;

        ChildrenCreator(List<CreateParams> childrenMaps, Map<String, Object> attrs) {
            this.mChildrenMaps = childrenMaps;
            this.mAttrs = attrs;
            this.mNewConfigBeans = ListUtil.newList();
        }

        public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
            if (params.length != 1) {
                throw new IllegalArgumentException();
            }
            ConfigBeanProxy parent = params[0];
            ConfigBean source = (ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)parent);
            ConfigSupport configSupport = (ConfigSupport)source.getHabitat().getComponent(ConfigSupport.class);
            return this._run(parent, configSupport);
        }

        public Object _run(ConfigBeanProxy parent, ConfigSupport configSupport) throws PropertyVetoException, TransactionFailure {
            WriteableView parentW = (WriteableView)WriteableView.class.cast(Proxy.getInvocationHandler(Proxy.class.cast(parent)));
            if (this.mAttrs != null) {
                AMXConfigImpl.this.setAttrs(parent, this.mAttrs);
            }
            SubElementsCallback callback = new SubElementsCallback(this.mChildrenMaps);
            ConfigBeanJMXSupport sptRoot = ConfigBeanJMXSupportRegistry.getInstance(Dom.unwrap((ConfigBeanProxy)parent).getProxyType());
            List newDescendants = callback.recursiveCreate(parentW, sptRoot, this.mChildrenMaps);
            this.mNewConfigBeans.addAll(newDescendants);
            return null;
        }

        public List<ConfigBean> configBeans() {
            return this.mNewConfigBeans;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CreateParams {
        final String mType;
        final Map<String, Object> mAttrs = MapUtil.newMap();
        final List<CreateParams> mChildren = ListUtil.newList();

        public CreateParams(String type, Map<String, ?> values) {
            this.mType = type;
            if (values == null) {
                return;
            }
            for (String nameAsProvided : values.keySet()) {
                String xmlName = ConfigBeanJMXSupport.toXMLName(nameAsProvided);
                Object value = values.get(nameAsProvided);
                if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean) {
                    String valueString = value == null ? null : "" + value;
                    this.mAttrs.put(xmlName, valueString);
                    continue;
                }
                if (value instanceof String[]) {
                    this.mAttrs.put(xmlName, ListUtil.asStringList(value));
                    continue;
                }
                if (value instanceof Map) {
                    Map<String, Object> m = TypeCast.checkMap((Map)Map.class.cast(value), String.class, Object.class);
                    CreateParams child = new CreateParams(xmlName, m);
                    this.mChildren.add(child);
                    continue;
                }
                if (value instanceof Map[]) {
                    Map[] maps;
                    for (Map m : maps = (Map[])value) {
                        Map<String, Object> mTyped = TypeCast.checkMap(m, String.class, Object.class);
                        CreateParams child = new CreateParams(xmlName, mTyped);
                        this.mChildren.add(child);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Value of class " + value.getClass().getName() + " not supported for attribute " + nameAsProvided);
            }
        }

        public String type() {
            return this.mType;
        }

        public String name() {
            return (String)this.mAttrs.get("name");
        }

        public Map<String, Object> attrs() {
            return Collections.unmodifiableMap(this.mAttrs);
        }

        public List<CreateParams> children() {
            return Collections.unmodifiableList(this.mChildren);
        }

        List<ConfigSupport.AttributeChanges> toAttributeChanges(Map<String, Object> values) {
            if (values == null) {
                return null;
            }
            List<ConfigSupport.AttributeChanges> changes = ListUtil.newList();
            for (String xmlName : this.mAttrs.keySet()) {
                Object value = this.mAttrs.get(xmlName);
                if (value instanceof String) {
                    changes.add((ConfigSupport.AttributeChanges)new ConfigSupport.SingleAttributeChange(xmlName, (String)value));
                    continue;
                }
                throw new IllegalArgumentException();
            }
            return changes;
        }

        public String toString(String prefix) {
            StringBuilder buf = new StringBuilder();
            String NL = StringUtil.LS;
            buf.append(prefix + this.mType + " = " + this.mAttrs + NL);
            if (this.mChildren.size() != 0) {
                buf.append(prefix + "[");
                for (CreateParams child : this.mChildren) {
                    buf.append(child.toString("    " + prefix) + NL);
                }
                buf.append(prefix + "]");
            }
            return buf.toString();
        }

        public String toString() {
            return this.toString("");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MakeChangesApplyer
    extends Applyer {
        private final Map<String, Object> mChanges;

        public MakeChangesApplyer(ConfigBean cb, Map<String, Object> changes) throws TransactionFailure {
            super(cb);
            this.mChanges = changes;
        }

        @Override
        protected void makeChanges() throws TransactionFailure {
            for (String xmlName : this.mChanges.keySet()) {
                Object value = this.mChanges.get(xmlName);
                ConfigModel.Property prop = AMXConfigImpl.this.getConfigModel_Property(xmlName);
                if (prop.isCollection()) {
                    List results = AMXConfigImpl.this.handleCollection(this.mWriteable, prop, "replace", ListUtil.asStringList(value));
                    continue;
                }
                if (value == null || value instanceof String) {
                    this.mWriteable.setter(prop, value, String.class);
                    continue;
                }
                throw new TransactionFailure("Illegal data type for attribute " + xmlName + ": " + value.getClass().getName());
            }
        }
    }

    private final class ModifyCollectionApplyer
    extends Applyer {
        private volatile List<String> mResult;
        private final String mElementName;
        private final String mCmd;
        private final String[] mValues;

        public ModifyCollectionApplyer(ConfigBean cb, String elementName, String cmd, String[] values) throws TransactionFailure {
            super(cb);
            this.mElementName = elementName;
            this.mCmd = cmd;
            this.mValues = values;
            this.mResult = null;
        }

        protected void makeChanges() throws TransactionFailure {
            ConfigModel.Property prop = AMXConfigImpl.this.getConfigModel_Property(this.mElementName);
            this.mResult = AMXConfigImpl.this.handleCollection(this.mWriteable, prop, this.mCmd, ListUtil.asStringList(this.mValues));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyTransactionListener
    implements TransactionListener {
        private final List<PropertyChangeEvent> mChangeEvents = new ArrayList<PropertyChangeEvent>();
        private final ConfigBean mTarget;

        MyTransactionListener(ConfigBean target) {
            this.mTarget = target;
        }

        public void transactionCommited(List<PropertyChangeEvent> changes) {
            for (PropertyChangeEvent event : changes) {
                Dom dom;
                Object source = event.getSource();
                if (!(source instanceof ConfigBeanProxy) || !((dom = Dom.unwrap((ConfigBeanProxy)((ConfigBeanProxy)source))) instanceof ConfigBean) || this.mTarget != (ConfigBean)dom) continue;
                this.mChangeEvents.add(event);
            }
        }

        public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
        }

        List<PropertyChangeEvent> getChangeEvents() {
            return this.mChangeEvents;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SubElementsCallback
    implements ConfigSupport.TransactionCallBack<WriteableView> {
        private final List<CreateParams> mSubs;

        public SubElementsCallback(List<CreateParams> subs) {
            this.mSubs = subs;
        }

        public void performOn(WriteableView item) throws TransactionFailure {
            ConfigBeanJMXSupport sptRoot = ConfigBeanJMXSupportRegistry.getInstance(Domain.class);
            ConfigSupport configSupport = (ConfigSupport)AMXConfigImpl.this.mConfigBean.getHabitat().getComponent(ConfigSupport.class);
            this.recursiveCreate(item, sptRoot, this.mSubs);
        }

        private void addToList(WriteableView parent, ConfigBeanProxy child) {
            Class parentClass = parent.getProxyType();
            Class childClass = Dom.unwrap((ConfigBeanProxy)child).getProxyType();
            ConfigBeanJMXSupport parentSpt = ConfigBeanJMXSupportRegistry.getInstance(parentClass);
            ConfigBeanJMXSupport.ElementMethodInfo elementInfo = parentSpt.getElementMethodInfo(childClass);
            ConfigBean parentBean = (ConfigBean)Dom.unwrap((ConfigBeanProxy)parent.getProxy(parentClass));
            if (elementInfo != null && Collection.class.isAssignableFrom(elementInfo.method().getReturnType())) {
                ConfigModel.Property modelProp = parentBean.model.findIgnoreCase(elementInfo.xmlName());
                List list = (List)parent.getter(modelProp, elementInfo.method().getGenericReturnType());
                list.add(child);
            } else {
                ConfigModel.Property modelProp = parentBean.model.findIgnoreCase(elementInfo.xmlName());
                if (modelProp == null) {
                    throw new IllegalArgumentException("Can't find ConfigModel.Property for \"" + elementInfo.xmlName() + "\"");
                }
                parent.setter(modelProp, (Object)child, (Type)childClass);
            }
        }

        private List<ConfigBean> recursiveCreate(WriteableView parent, ConfigBeanJMXSupport sptRoot, List<CreateParams> subs) throws TransactionFailure {
            List<ConfigBean> newChildren = ListUtil.newList();
            for (CreateParams childParams : subs) {
                String type = childParams.type();
                Class<? extends ConfigBeanProxy> clazz = ConfigBeanJMXSupportRegistry.getConfigBeanProxyClassFor(sptRoot, type);
                if (clazz == null) {
                    throw new IllegalArgumentException("@Configured interface for type " + type + " cannot be found");
                }
                ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(clazz);
                ConfigBeanProxy childProxy = parent.allocateProxy(clazz);
                Dom newBean = Dom.unwrap((ConfigBeanProxy)childProxy);
                newBean.addDefaultChildren();
                this.addToList(parent, childProxy);
                ConfigBean child = (ConfigBean)Dom.unwrap((ConfigBeanProxy)childProxy);
                newChildren.add(child);
                WriteableView childW = (WriteableView)WriteableView.class.cast(Proxy.getInvocationHandler(Proxy.class.cast(childProxy)));
                Map<String, Object> childAttrs = AMXConfigImpl.this.replaceNameWithKey(childParams.attrs(), spt);
                AMXConfigImpl.this.setAttrs(childProxy, childAttrs);
                if (childParams.children().size() == 0) continue;
                List<ConfigBean> more = this.recursiveCreate(childW, spt, childParams.children());
                newChildren.addAll(more);
            }
            return newChildren;
        }
    }
}

