/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.Calendar;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Field;
import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.OptionGroup;
import com.sun.webui.jsf.model.UploadedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.glassfish.admingui.common.handlers.MonitoringHandlers;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.util.SunOptionUtil;

public class WoodstockHandler {
    private Option[] jumpMenuOptions = null;

    public static void uploadFileToTempDir(HandlerContext handlerCtx) {
        Logger logger = GuiUtil.getLogger();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(GuiUtil.getCommonMessage((String)"log.inUploadFileToTmpDir"));
        }
        UploadedFile uploadedFile = (UploadedFile)handlerCtx.getInputValue("file");
        File tmpFile = null;
        String uploadTmpFile = "";
        if (uploadedFile != null) {
            int index;
            String name = uploadedFile.getOriginalName();
            logger.info("uploadFileName=" + name);
            int lastIndex = name.lastIndexOf("\\");
            if (lastIndex != -1) {
                name = name.substring(lastIndex + 1, name.length());
            }
            if ((index = name.indexOf(".")) <= 0) {
                logger.info("name=" + name + ",index=" + index);
                String mesg = GuiUtil.getMessage((String)"msg.deploy.nullArchiveError");
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)mesg);
                return;
            }
            String suffix = name.substring(index);
            String prefix = name.substring(0, index);
            handlerCtx.setOutputValue("origPath", (Object)prefix);
            try {
                if (prefix.length() <= 2) {
                    prefix = prefix + new Random().nextInt(100000);
                }
                tmpFile = File.createTempFile(prefix, suffix);
                tmpFile.deleteOnExit();
                logger.fine(GuiUtil.getCommonMessage((String)"log.writeToTmpFile"));
                uploadedFile.write(tmpFile);
                logger.fine(GuiUtil.getCommonMessage((String)"log.afterWriteToTmpFile"));
                uploadTmpFile = tmpFile.getCanonicalPath();
            }
            catch (IOException ioex) {
                try {
                    uploadTmpFile = tmpFile.getAbsolutePath();
                }
                catch (Exception ex) {}
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        logger.fine(GuiUtil.getCommonMessage((String)"log.successfullyUploadedTmp") + uploadTmpFile);
        handlerCtx.setOutputValue("uploadedTempFile", (Object)uploadTmpFile);
    }

    public static void setDisableConnectionPoolTableField(HandlerContext handlerCtx) {
        String methodValue = (String)handlerCtx.getInputValue("methodValue");
        DropDown tableDD = (DropDown)handlerCtx.getInputValue("tableDD");
        Field validationField = (Field)handlerCtx.getInputValue("validationField");
        if ("table".equals(methodValue)) {
            tableDD.setDisabled(false);
            validationField.setDisabled(true);
        } else if ("custom-validation".equals(methodValue)) {
            tableDD.setDisabled(true);
            validationField.setDisabled(false);
        } else {
            tableDD.setDisabled(true);
            validationField.setDisabled(true);
        }
    }

    public static void createHyperlinkArray(HandlerContext handlerCtx) {
        FacesContext ctx = handlerCtx.getFacesContext();
        ExternalContext extCtx = ctx.getExternalContext();
        Map reqParams = extCtx.getRequestParameterValuesMap();
        String[] linkText = (String[])reqParams.get("text");
        String[] linkUrl = (String[])reqParams.get("urls");
        if (linkText == null) {
            return;
        }
        int len = linkText.length;
        Hyperlink[] arr = new Hyperlink[len];
        String url = null;
        String ctxPath = extCtx.getRequestContextPath();
        int ctxPathSize = ctxPath.length();
        for (int idx = 0; idx < len; ++idx) {
            arr[idx] = new Hyperlink();
            arr[idx].setId("bcLnk" + idx);
            arr[idx].setRendererType("com.sun.webui.jsf.Hyperlink");
            arr[idx].setText((Object)linkText[idx]);
            url = linkUrl[idx];
            if (url.startsWith(ctxPath)) {
                url = url.substring(ctxPathSize);
            }
            arr[idx].setUrl(url);
        }
        handlerCtx.setOutputValue("links", (Object)arr);
    }

    public static void dummyHyperlinkArray(HandlerContext handlerCtx) {
        Hyperlink[] arr = new Hyperlink[]{new Hyperlink()};
        arr[0].setText((Object)">");
        handlerCtx.setOutputValue("links", (Object)arr);
    }

    public static void stringArrayToSelectItemArray(HandlerContext handlerCtx) {
        String[] stringArray = (String[])handlerCtx.getInputValue("stringArray");
        handlerCtx.setOutputValue("item", (Object)SunOptionUtil.getOptions(stringArray));
    }

    public static void selectItemArrayToStrArray(HandlerContext handlerCtx) {
        SelectItem[] item = (SelectItem[])handlerCtx.getInputValue("item");
        if (item == null || item.length == 0) {
            handlerCtx.setOutputValue("strAry", (Object)new String[0]);
            return;
        }
        String[] strAry = new String[item.length];
        for (int i = 0; i < item.length; ++i) {
            strAry[i] = (String)item[i].getValue();
        }
        handlerCtx.setOutputValue("strAry", (Object)strAry);
    }

    public static void convertListToOptionArray(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        if (list == null || list.isEmpty()) {
            handlerCtx.setOutputValue("optionArray", (Object)new Option[0]);
            return;
        }
        handlerCtx.setOutputValue("optionArray", (Object)SunOptionUtil.getOptionsArray(list.toArray(new String[0])));
    }

    public static void getDatePattern(HandlerContext handlerCtx) {
        Calendar calendar = (Calendar)handlerCtx.getInputValue("calendarComponent");
        String pattern = calendar.getDateFormatPattern();
        if (!(pattern != null && pattern.length() != 0 || (pattern = calendar.getDatePicker().getDateFormatPattern()) != null && pattern.length() != 0)) {
            pattern = "MM/dd/yyyy";
        }
        handlerCtx.setOutputValue("pattern", (Object)pattern);
    }

    public void populateServerMonitorDropDown(HandlerContext handlerCtx) {
        OptionGroup tsMenuOptions;
        OptionGroup gcMenuOptions;
        OptionGroup nlMenuOptions;
        List vsList = (List)handlerCtx.getInputValue("VSList");
        List threadList = (List)handlerCtx.getInputValue("ThreadSystemList");
        List gcList = (List)handlerCtx.getInputValue("GCList");
        List nlList = (List)handlerCtx.getInputValue("NLList");
        ArrayList<Object> menuList = new ArrayList<Object>();
        menuList.add(new Option((Object)"", ""));
        OptionGroup vsMenuOptions = WoodstockHandler.getMenuOptions(vsList, "virtual-server", "", false);
        if (vsMenuOptions != null) {
            menuList.add(vsMenuOptions);
        }
        if ((nlMenuOptions = WoodstockHandler.getMenuOptions(nlList, "http-listener", "", false)) != null) {
            menuList.add(nlMenuOptions);
        }
        if ((gcMenuOptions = WoodstockHandler.getMenuOptions(gcList, "garbage-collector", "", false)) != null) {
            menuList.add(gcMenuOptions);
        }
        if ((tsMenuOptions = WoodstockHandler.getMenuOptions(threadList, "thread-system", "", false)) != null) {
            menuList.add(tsMenuOptions);
        }
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("MonitorList", (Object)this.jumpMenuOptions);
    }

    public void populateResourceMonitorDropDown(HandlerContext handlerCtx) {
        List rList = (List)handlerCtx.getInputValue("ResourceList");
        ArrayList<OptionGroup> menuList = new ArrayList<OptionGroup>();
        ArrayList<Option> resList = new ArrayList<Option>();
        String firstItem = null;
        if (rList != null) {
            ListIterator rl = rList.listIterator();
            while (rl.hasNext()) {
                String name = (String)rl.next();
                resList.add(new Option((Object)name, name));
                if (firstItem != null) continue;
                firstItem = name;
            }
        }
        Option[] groupedOptions1 = resList.toArray(new Option[resList.size()]);
        OptionGroup jumpGroup1 = new OptionGroup();
        jumpGroup1.setLabel("resources");
        jumpGroup1.setOptions(groupedOptions1);
        menuList.add(jumpGroup1);
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("MonitorList", (Object)this.jumpMenuOptions);
        handlerCtx.setOutputValue("FirstItem", (Object)firstItem);
    }

    public void populateApplicationsMonitorDropDown(HandlerContext handlerCtx) {
        List aList = (List)handlerCtx.getInputValue("AppsList");
        ArrayList<Object> menuList = new ArrayList<Object>();
        String firstItem = null;
        Object title = null;
        if (aList != null) {
            ListIterator al = aList.listIterator();
            while (al.hasNext()) {
                ArrayList<String> moduleList = new ArrayList<String>();
                String appName = (String)al.next();
                Set<Object> modules = new HashSet();
                try {
                    modules = RestUtil.getChildMap((String)(GuiUtil.getSessionValue((String)"REST_URL") + "/applications/application/" + appName + "/module")).keySet();
                }
                catch (Exception ex) {
                    GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
                }
                for (String moduleName : modules) {
                    if (!MonitoringHandlers.doesAppProxyExist((String)appName, (String)moduleName).booleanValue()) continue;
                    moduleList.add(moduleName);
                }
                if (moduleList.isEmpty()) {
                    menuList.add(new Option((Object)appName, appName));
                    if (firstItem != null) continue;
                    firstItem = appName;
                    continue;
                }
                OptionGroup menuOptions = WoodstockHandler.getMenuOptions(moduleList, appName, "", false);
                menuList.add(menuOptions);
                if (firstItem != null) continue;
                firstItem = (String)moduleList.get(0);
            }
        }
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("MonitorList", (Object)this.jumpMenuOptions);
        handlerCtx.setOutputValue("FirstItem", firstItem);
    }

    public void populateComponentDropDown(HandlerContext handlerCtx) {
        String moduleName = (String)handlerCtx.getInputValue("ModuleName");
        String appname = (String)handlerCtx.getInputValue("AppName");
        String monitorURL = (String)handlerCtx.getInputValue("MonitorURL");
        List vsList = (List)handlerCtx.getInputValue("VSList");
        ArrayList<Option> menuList = new ArrayList<Option>();
        menuList.add(new Option((Object)"", ""));
        if (appname != null && !appname.isEmpty()) {
            List servletInstanceMenuOptions = WoodstockHandler.getWebComponentMenuOptions(appname, moduleName, vsList, monitorURL, handlerCtx);
            menuList.addAll(servletInstanceMenuOptions);
            Map compsMap = MonitoringHandlers.getSubComponents((String)appname, (String)moduleName);
            if (compsMap != null && compsMap.size() > 0) {
                for (Map.Entry e : compsMap.entrySet()) {
                    if (e.getValue().equals("Servlet")) continue;
                    List compMenuOptions = WoodstockHandler.getEJBComponentMenuOptions(appname, moduleName, (String)e.getKey(), monitorURL, handlerCtx);
                    menuList.addAll(compMenuOptions);
                }
            }
        }
        this.jumpMenuOptions = menuList.toArray(new Option[menuList.size()]);
        handlerCtx.setOutputValue("ComponentList", (Object)this.jumpMenuOptions);
    }

    private static List getEJBComponentMenuOptions(String appname, String modulename, String compName, String monitorURL, HandlerContext handlerCtx) {
        String endpoint = monitorURL + "/applications/" + appname + "/" + modulename + "/" + compName;
        ArrayList<String> compMenuList = new ArrayList<String>();
        ArrayList<OptionGroup> menuList = new ArrayList<OptionGroup>();
        Set compChildSet = null;
        try {
            if (appname.equals(modulename)) {
                endpoint = monitorURL + "/applications/" + appname + "/" + compName;
            }
            compChildSet = RestUtil.getChildMap((String)endpoint).keySet();
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getEJBComponentMenuOptions ; \nendpoint = " + endpoint + "method=GET");
        }
        if (compChildSet != null) {
            for (String child : compChildSet) {
                Set subCompChildSet = null;
                try {
                    subCompChildSet = RestUtil.getChildMap((String)(endpoint + "/" + child)).keySet();
                }
                catch (Exception ex) {
                    GuiUtil.getLogger().severe("Error in getEJBComponentMenuOptions ; \nendpoint = " + endpoint + "/" + child + "method=GET");
                }
                if (subCompChildSet != null && subCompChildSet.size() > 0) {
                    OptionGroup childCompMenuOptions = WoodstockHandler.getMenuOptions(new ArrayList(subCompChildSet), child, compName, true);
                    menuList.add(childCompMenuOptions);
                    continue;
                }
                compMenuList.add(child);
            }
        }
        compMenuList.add(0, compName);
        OptionGroup compMenuOptions = WoodstockHandler.getMenuOptions(compMenuList, compName, "", true);
        menuList.add(0, compMenuOptions);
        return menuList;
    }

    private static List getWebComponentMenuOptions(String appname, String modulename, List vsList, String monitorURL, HandlerContext handlerCtx) {
        String endpoint = monitorURL + "/applications/" + appname;
        ArrayList<OptionGroup> menuList = new ArrayList<OptionGroup>();
        if (vsList != null) {
            ListIterator vl = vsList.listIterator();
            while (vl.hasNext()) {
                String name = (String)vl.next();
                try {
                    ArrayList servlets = new ArrayList(RestUtil.getChildMap((String)(endpoint + "/" + name)).keySet());
                    if (servlets.isEmpty()) continue;
                    OptionGroup menuOptions = WoodstockHandler.getMenuOptions(servlets, name, "", true);
                    menuList.add(menuOptions);
                }
                catch (Exception ex) {
                    GuiUtil.getLogger().severe("Error in getWebComponentMenuOptions ; \nendpoint = " + endpoint + "/" + name + "method=GET");
                }
            }
        }
        return menuList;
    }

    private static OptionGroup getMenuOptions(List values, String label, String label2, boolean addLabel) {
        if (values == null) {
            return null;
        }
        ArrayList<Option> nList = new ArrayList<Option>();
        Collections.sort(values);
        ListIterator nl = values.listIterator();
        while (nl.hasNext()) {
            String name = (String)nl.next();
            if (addLabel && label2.equals("")) {
                if (!label.equals(name)) {
                    nList.add(new Option((Object)(label + "/" + name), name));
                    continue;
                }
                nList.add(new Option((Object)name, name));
                continue;
            }
            if (addLabel && !label2.equals("")) {
                nList.add(new Option((Object)(label2 + "/" + label + "/" + name), name));
                continue;
            }
            nList.add(new Option((Object)name, name));
        }
        Option[] groupedOptions3 = nList.toArray(new Option[nList.size()]);
        OptionGroup jumpGroup3 = new OptionGroup();
        jumpGroup3.setLabel(label);
        jumpGroup3.setOptions(groupedOptions3);
        return jumpGroup3;
    }
}

