/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DomainConfig
extends RepositoryConfig {
    public static final String K_USER = "domain.user";
    public static final String K_PASSWORD = "domain.password";
    public static final String K_NEW_MASTER_PASSWORD = "domain.newMasterPassword";
    public static final String K_MASTER_PASSWORD = "domain.masterPassword";
    public static final String K_SAVE_MASTER_PASSWORD = "domain.saveMasterPassword";
    public static final String K_ADMIN_PORT = "domain.adminPort";
    public static final String K_INSTANCE_PORT = "domain.instancePort";
    public static final String K_PROFILE = "domain.profile";
    public static final String K_DOMAINS_ROOT = "domains.root";
    public static final String K_HOST_NAME = "domain.hostName";
    public static final String K_JMS_PORT = "jms.port";
    public static final String K_ORB_LISTENER_PORT = "orb.listener.port";
    public static final String K_SERVERID = "server.id";
    public static final String K_TEMPLATE_NAME = "template.name";
    public static final String K_HTTP_SSL_PORT = "http.ssl.port";
    public static final String K_IIOP_SSL_PORT = "orb.ssl.port";
    public static final String K_IIOP_MUTUALAUTH_PORT = "orb.mutualauth.port";
    public static final String K_OSGI_SHELL_TELNET_PORT = "osgi.shell.telnet.port";
    public static final String K_JAVA_DEBUGGER_PORT = "java.debugger.port";
    public static final String K_DEBUG = "domain.debug";
    public static final String K_VERBOSE = "domain.verbose";
    public static final String K_VALIDATE_PORTS = "domain.validatePorts";
    public static final String K_JMX_PORT = "domain.jmxPort";
    public static final String K_EXTRA_PASSWORDS = "domain.extraPasswords";
    public static final int K_FLAG_START_DOMAIN_NEEDS_ADMIN_USER = 1;
    public static final String KEYTOOLOPTIONS = "keytooloptions";

    public DomainConfig(String domainName, String domainRoot) throws DomainException {
        super(domainName, domainRoot);
        try {
            this.put(K_DOMAINS_ROOT, domainRoot);
            ASenvPropertyReader pr = new ASenvPropertyReader();
            Map<String, String> envProperties = pr.getProps();
            this.put(K_HOST_NAME, envProperties.get("com.sun.aas.hostName"));
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    public DomainConfig(String domainName, Integer adminPort, String domainRoot, String adminUser, String adminPassword, String masterPassword, Boolean saveMasterPassword, Integer instancePort, Integer jmsPort, Integer orbPort, Integer httpSSLPort, Integer iiopSSLPort, Integer iiopMutualAuthPort, Integer jmxAdminPort, Integer osgiShellTelnetPort, Integer javaDebuggerPort, Properties domainProperties) throws DomainException {
        this(domainName, domainRoot);
        try {
            this.put(K_ADMIN_PORT, adminPort);
            this.put(K_PASSWORD, adminPassword);
            this.put(K_MASTER_PASSWORD, masterPassword);
            this.put(K_SAVE_MASTER_PASSWORD, saveMasterPassword);
            this.put(K_USER, adminUser);
            this.put(K_INSTANCE_PORT, instancePort);
            this.put(K_JMS_PORT, jmsPort);
            this.put(K_ORB_LISTENER_PORT, orbPort);
            this.put(K_HTTP_SSL_PORT, httpSSLPort);
            this.put(K_IIOP_SSL_PORT, iiopSSLPort);
            this.put(K_IIOP_MUTUALAUTH_PORT, iiopMutualAuthPort);
            this.put(K_JMX_PORT, jmxAdminPort);
            this.put(K_OSGI_SHELL_TELNET_PORT, osgiShellTelnetPort);
            this.put(K_JAVA_DEBUGGER_PORT, javaDebuggerPort);
            if (domainProperties != null) {
                for (String string : domainProperties.keySet()) {
                    String value = (String)domainProperties.get(string);
                    this.put(string, value);
                }
            }
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    public String getDomainName() {
        return super.getRepositoryName();
    }

    public String getDomainRoot() {
        return super.getRepositoryRoot();
    }

    public Map getPorts() {
        Iterator it = this.keySet().iterator();
        HashMap result = new HashMap();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.toLowerCase().endsWith("port")) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public String getProfile() {
        return (String)this.get(K_PROFILE);
    }
}

