/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.security.SecurityUpgradeService;
import com.sun.enterprise.security.admin.cli.EnableSecureAdminCommand;
import com.sun.enterprise.security.admin.cli.SecureAdminCommand;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.NetworkListeners;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Ssl;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.GrizzlyConfigSchemaMigrator;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class SecureAdminConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    private static final String DAS_CONFIG_NAME = "server-config";
    private static final String ADMIN_LISTENER_NAME = "admin-listener";
    private static final String ASADMIN_LISTENER_PORT = "${ASADMIN_LISTENER_PORT}";
    private static final String ASADMIN_LISTENER_TRANSPORT = "tcp";
    private static final String ASADMIN_LISTENER_THREADPOOL = "http-thread-pool";
    private static final String ASADMIN_VS_NAME = "__asadmin";
    private static final Logger logger = Logger.getAnonymousLogger();
    @Inject
    private GrizzlyConfigSchemaMigrator grizzlyMigrator;
    @Inject
    private SecurityUpgradeService securityUpgradeService;
    @Inject
    private Habitat habitat;
    @Inject
    private Configs configs;

    public void postConstruct() {
        try {
            this.ensureNonDASConfigsHaveAdminNetworkListener();
            logger.log(Level.INFO, "Added admin-listener network listeners to non-DAS configurations");
        }
        catch (TransactionFailure tf) {
            logger.log(Level.SEVERE, "Error adding admin-listener to non-DAS configuration", tf);
            return;
        }
        if (this.requiresSecureAdmin()) {
            EnableSecureAdminCommand enableSecureAdminCommand = (EnableSecureAdminCommand)this.habitat.getComponent(EnableSecureAdminCommand.class);
            try {
                enableSecureAdminCommand.run();
                logger.log(Level.INFO, "Upgraded secure admin set-up");
            }
            catch (TransactionFailure tf) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error upgrading secure admin set-up", tf);
            }
            catch (SecureAdminCommand.SecureAdminCommandException ex) {
                logger.log(Level.INFO, "Attempt to upgrade secure admin set-up failed", ex);
            }
        } else {
            logger.log(Level.INFO, "No secure admin set-up was detected in the original configuration so no upgrade of it was needed");
        }
    }

    private boolean requiresSecureAdmin() {
        return this.isOriginalAdminSecured() || this.securityUpgradeService.requiresSecureAdmin();
    }

    private void ensureNonDASConfigsHaveAdminNetworkListener() throws TransactionFailure {
        final Transaction t = new Transaction();
        for (Config c : this.configs.getConfig()) {
            final NetworkConfig nc = c.getNetworkConfig();
            NetworkListener nl = nc.getNetworkListener(ADMIN_LISTENER_NAME);
            if (nl != null) continue;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Config>(){

                public Object run(Config config_w) throws PropertyVetoException, TransactionFailure {
                    NetworkListener nl_w = SecureAdminConfigUpgrade.this.createAdminNetworkListener(t, nc);
                    VirtualServer vs_w = SecureAdminConfigUpgrade.this.createAdminVirtualServer(t, config_w);
                    return config_w;
                }
            }, (ConfigBeanProxy)c);
        }
        try {
            t.commit();
        }
        catch (RetryableException ex) {
            throw new TransactionFailure("Error adding admin-listener for a non-DAS config", (Throwable)ex);
        }
    }

    private NetworkListener createAdminNetworkListener(Transaction t, NetworkConfig nc) throws TransactionFailure {
        NetworkListeners nls_w = (NetworkListeners)t.enroll((ConfigBeanProxy)nc.getNetworkListeners());
        NetworkListener nl_w = (NetworkListener)nls_w.createChild(NetworkListener.class);
        nls_w.getNetworkListener().add(nl_w);
        nl_w.setName(ADMIN_LISTENER_NAME);
        nl_w.setProtocol(ADMIN_LISTENER_NAME);
        nl_w.setPort(ASADMIN_LISTENER_PORT);
        nl_w.setTransport(ASADMIN_LISTENER_TRANSPORT);
        nl_w.setThreadPool(ASADMIN_LISTENER_THREADPOOL);
        return nl_w;
    }

    private VirtualServer createAdminVirtualServer(Transaction t, Config config_w) throws TransactionFailure, PropertyVetoException {
        HttpService hs_w = (HttpService)t.enroll((ConfigBeanProxy)config_w.getHttpService());
        VirtualServer vs_w = (VirtualServer)hs_w.createChild(VirtualServer.class);
        hs_w.getVirtualServer().add(vs_w);
        vs_w.setId(ASADMIN_VS_NAME);
        vs_w.setNetworkListeners(ADMIN_LISTENER_NAME);
        return vs_w;
    }

    private boolean isOriginalAdminSecured() {
        Config serverConfig = this.configs.getConfigByName(DAS_CONFIG_NAME);
        if (serverConfig == null) {
            return false;
        }
        NetworkConfig nc = serverConfig.getNetworkConfig();
        if (nc == null) {
            return false;
        }
        Protocol p = nc.findProtocol(ADMIN_LISTENER_NAME);
        if (p == null) {
            return false;
        }
        Ssl ssl = p.getSsl();
        return ssl != null;
    }
}

