/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class AuthTokenManager {
    public static final String AUTH_TOKEN_OPTION_NAME = "_authtoken";
    private static final String SUPPRESSED_TOKEN_OUTPUT = "????";
    private static final int TOKEN_SIZE = 10;
    private static final long TOKEN_EXPIRATION_IN_MS = 60000L;
    private final SecureRandom rng = new SecureRandom();
    private final Map<String, TokenInfo> liveTokens = new HashMap<String, TokenInfo>();
    private final Logger logger = LogDomains.getLogger(AuthTokenManager.class, "javax.enterprise.system.tools.admin");
    private static final char REUSE_TOKEN_MARKER = '+';
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AuthTokenManager.class);
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public String createToken() {
        byte[] newToken = new byte[10];
        this.rng.nextBytes(newToken);
        String token = AuthTokenManager.toHex(newToken);
        this.liveTokens.put(token, new TokenInfo(token));
        this.logger.log(Level.FINER, "Auth token {0} created", token);
        return token;
    }

    public boolean consumeToken(String token) {
        long now = System.currentTimeMillis();
        int firstReuseMarker = token.indexOf(43);
        boolean isReusedToken = firstReuseMarker != -1;
        String tokenAsRecorded = isReusedToken ? token.substring(0, firstReuseMarker) : token;
        TokenInfo ti = this.liveTokens.get(tokenAsRecorded);
        if (ti == null) {
            this.logger.log(Level.WARNING, localStrings.getLocalString("AuthTokenNonexistent", "Attempt to use non-existent auth token {0}", this.logger.isLoggable(Level.FINER) ? tokenAsRecorded : SUPPRESSED_TOKEN_OUTPUT));
        }
        boolean result = ti != null && ti.use(isReusedToken, now);
        this.retireExpiredTokens(now);
        return result;
    }

    public static String markTokenForReuse(String token) {
        return token + '+';
    }

    private synchronized void retireExpiredTokens(long now) {
        Iterator<Map.Entry<String, TokenInfo>> it = this.liveTokens.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, TokenInfo> entry = it.next();
            if (!entry.getValue().isUsedUp(now)) continue;
            this.logger.log(Level.FINER, "Auth token {0} being retired during scan", entry.getValue().token);
            it.remove();
        }
    }

    private static String toHex(byte[] b) {
        char[] bc = new char[b.length * 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            byte bb = b[i];
            bc[j++] = hex[bb >> 4 & 0xF];
            bc[j++] = hex[bb & 0xF];
        }
        return new String(bc);
    }

    private class TokenInfo {
        private final String token;
        private int usesRemaining = 2;
        private long expiration = System.currentTimeMillis() + 60000L;

        private TokenInfo(String value) {
            this.token = value;
        }

        private synchronized boolean use(boolean isBeingReused, long now) {
            if (this.isUsedUp(now)) {
                String msg = localStrings.getLocalString("AuthTokenInvalid", "Use of auth token {2} attempted but token is invalid; usesRemaining = {0,number,integer}, expired = {1}", new Integer(this.usesRemaining), Boolean.toString(this.expiration <= now), AuthTokenManager.this.logger.isLoggable(Level.FINER) ? this.token : AuthTokenManager.SUPPRESSED_TOKEN_OUTPUT);
                return false;
            }
            if (!isBeingReused) {
                --this.usesRemaining;
            }
            AuthTokenManager.this.logger.log(Level.FINER, "Use of auth token {0} OK; isBeingReused = {2}; remaining uses = {1,number,integer}", new Object[]{this.token, new Integer(this.usesRemaining), Boolean.toString(isBeingReused)});
            this.expiration += 60000L;
            return true;
        }

        private boolean isUsedUp(long now) {
            return this.usesRemaining <= 0 || this.expiration <= now;
        }
    }
}

