/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.server.logging.commands.SetLogLevel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@CommandLock(value=CommandLock.LockType.NONE)
@Service(name="set-log-attributes")
@Scoped(value=PerLookup.class)
@I18n(value="set.log.attributes")
public class SetLogAttributes
implements AdminCommand {
    @Param(name="name_value", primary=true, separator=58)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Inject
    LoggingConfigImpl loggingConfig;
    @Inject
    Domain domain;
    @Inject
    Servers servers;
    @Inject
    Clusters clusters;
    String[] validAttributes = new String[]{"handlers", "java.util.logging.ConsoleHandler.formatter", "com.sun.enterprise.server.logging.GFFileHandler.file", "com.sun.enterprise.server.logging.GFFileHandler.rotationTimelimitInMinutes", "com.sun.enterprise.server.logging.GFFileHandler.flushFrequency", "java.util.logging.FileHandler.formatter", "com.sun.enterprise.server.logging.GFFileHandler.formatter", "java.util.logging.FileHandler.limit", "com.sun.enterprise.server.logging.GFFileHandler.logtoConsole", "com.sun.enterprise.server.logging.GFFileHandler.rotationLimitInBytes", "com.sun.enterprise.server.logging.SyslogHandler.useSystemLogging", "com.sun.enterprise.server.logging.GFFileHandler.alarms", "java.util.logging.FileHandler.count", "com.sun.enterprise.server.logging.GFFileHandler.retainErrorsStasticsForHours", "log4j.logger.org.hibernate.validator.util.Version", "com.sun.enterprise.server.logging.GFFileHandler.maxHistoryFiles", "java.util.logging.FileHandler.pattern", "com.sun.enterprise.server.logging.GFFileHandler.rotationOnDateChange", "com.sun.enterprise.server.logging.GFFileHandler.logFormatDateFormat"};
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SetLogLevel.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        boolean isCluster = false;
        boolean isDas = false;
        boolean isInstance = false;
        String successMsg = "";
        boolean success = false;
        boolean invalidAttribute = false;
        boolean isConfig = false;
        String targetConfigName = "";
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            for (Object key : this.properties.keySet()) {
                String att_name = (String)key;
                String att_value = (String)this.properties.get(att_name);
                boolean vlvl = false;
                for (String s : this.validAttributes) {
                    if (!s.equals(att_name)) continue;
                    m.put(att_name, att_value);
                    vlvl = true;
                    successMsg = successMsg + localStrings.getLocalString("set.log.attribute.properties", "{0} logging attribute set with value {1}.\n", new Object[]{att_name, att_value});
                }
                if (vlvl) continue;
                report.setMessage(localStrings.getLocalString("set.log.attribute.invalid", "Invalid logging attribute name found {0}.", new Object[]{att_name}));
                invalidAttribute = true;
                break;
            }
            if (invalidAttribute) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            } else {
                Server targetServer;
                Config config = this.domain.getConfigNamed(this.target);
                if (config != null) {
                    targetConfigName = this.target;
                    isConfig = true;
                    targetServer = this.domain.getServerNamed("server");
                    if (targetServer != null && targetServer.getConfigRef().equals(this.target)) {
                        isDas = true;
                    }
                    targetServer = null;
                } else {
                    Cluster clusterForInstance;
                    targetServer = this.domain.getServerNamed(this.target);
                    if (targetServer != null && targetServer.isDas()) {
                        isDas = true;
                    } else {
                        Cluster cluster = this.domain.getClusterNamed(this.target);
                        if (cluster != null) {
                            isCluster = true;
                            targetConfigName = cluster.getConfigRef();
                        } else if (targetServer != null) {
                            isInstance = true;
                            targetConfigName = targetServer.getConfigRef();
                        }
                    }
                    if (isInstance && (clusterForInstance = targetServer.getCluster()) != null) {
                        targetConfigName = clusterForInstance.getConfigRef();
                    }
                }
                if (isCluster || isInstance) {
                    this.loggingConfig.updateLoggingProperties(m, targetConfigName);
                    success = true;
                } else if (isDas) {
                    this.loggingConfig.updateLoggingProperties(m);
                    success = true;
                } else if (isConfig) {
                    this.loggingConfig.updateLoggingProperties(m, targetConfigName);
                    success = true;
                } else {
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target: {0}. Valid default target is a server named ''server'' (default) or cluster name.", new Object[]{this.target});
                    report.setMessage(msg);
                    return;
                }
                if (success) {
                    successMsg = successMsg + localStrings.getLocalString("set.log.attribute.success", "These logging attributes are set for {0}.", new Object[]{this.target});
                    report.setMessage(successMsg);
                    report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                }
            }
        }
        catch (IOException e) {
            report.setMessage(localStrings.getLocalString("set.log.attribute.failed", "Could not set logging attributes for {0}.", new Object[]{this.target}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

