/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgihttp;

import com.sun.enterprise.web.ContextFacade;
import com.sun.enterprise.web.WebModule;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Manager;
import org.apache.catalina.session.StandardManager;
import org.osgi.service.http.HttpContext;

public class OSGiServletContext
extends ContextFacade {
    private final HttpContext httpContext;
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public OSGiServletContext(WebModule delegate, HttpContext httpContext) {
        super(new File(delegate.getDocBase()), delegate.getContextPath(), delegate.getClassLoader());
        this.setUnwrappedContext(delegate);
        this.setName(delegate.getName());
        this.setPath(delegate.getPath());
        this.setWebContainer(delegate.getWebContainer());
        this.setJ2EEServer(delegate.getJ2EEServer());
        this.setWebModuleConfig(delegate.getWebModuleConfig());
        this.setParentClassLoader(delegate.getParentClassLoader());
        this.setRealm(delegate.getRealm());
        this.setParent(delegate.getParent());
        StandardManager mgr = new StandardManager();
        mgr.setPathname(null);
        this.setManager((Manager)mgr);
        this.httpContext = httpContext;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getMimeType(String file) {
        String mimeType = this.httpContext.getMimeType(file);
        return mimeType != null ? mimeType : super.getMimeType(file);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.httpContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        try {
            URL url = this.getResource(path);
            return url != null ? url.openStream() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

