/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.admin.ConsumerInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class GetDurablesHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetDurablesHandler.getDEBUG();

    public GetDurablesHandler(AdminDataHandler adminDataHandler) {
        super(adminDataHandler);
    }

    public boolean handle(IMQConnection iMQConnection, Packet packet, Hashtable hashtable) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + hashtable);
        }
        String string = (String)hashtable.get("JMQDestination");
        Packet packet2 = new Packet(iMQConnection.useDirectBuffers());
        packet2.setPacketType(5);
        int n = 200;
        Vector<DurableInfo> vector = null;
        String string2 = null;
        try {
            DestinationUID destinationUID = null;
            if (string != null) {
                destinationUID = DestinationUID.getUID(string, false);
            }
            Set set = Subscription.getAllSubscriptions(destinationUID);
            vector = new Vector<DurableInfo>();
            for (Subscription subscription : set) {
                DurableInfo durableInfo = new DurableInfo();
                durableInfo.name = subscription.getDurableName();
                durableInfo.clientID = subscription.getClientID();
                durableInfo.isActive = subscription.isActive();
                durableInfo.activeCount = subscription.getActiveSubscriberCnt();
                durableInfo.isShared = subscription.getShared();
                durableInfo.nMessages = subscription.numInProcessMsgs();
                durableInfo.consumer = new ConsumerInfo();
                durableInfo.consumer.destination = subscription.getDestinationUID().getName();
                durableInfo.consumer.type = 2;
                durableInfo.consumer.selector = subscription.getSelectorStr();
                durableInfo.consumer.connection = null;
                vector.add(durableInfo);
            }
        }
        catch (BrokerException brokerException) {
            string2 = brokerException.getMessage();
            n = brokerException.getStatusCode();
        }
        GetDurablesHandler.setProperties(packet2, 23, n, string2);
        this.setBodyObject(packet2, vector);
        this.parent.sendReply(iMQConnection, packet, packet2);
        return true;
    }
}

