/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterDestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;

public class DestinationUpdateHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public DestinationUpdateHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (gPacket.getType() == 13) {
            this.handleUpdateDestination(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 15) {
            this.handleRemDestination(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 14 || gPacket.getType() == 16) {
            this.handleReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "DestinationUpdateHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleUpdateDestination(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(gPacket);
        try {
            DestinationUID destinationUID = clusterDestInfo.getDestUID();
            Hashtable hashtable = clusterDestInfo.getDestProps();
            Destination destination = Destination.getDestination(destinationUID);
            if (destination == null) {
                destination = Destination.createDestination(clusterDestInfo.getDestName(), clusterDestInfo.getDestType(), !DestType.isTemporary((int)clusterDestInfo.getDestType()), false, this.selfAddress);
                destination.setDestinationProperties(hashtable);
                messageBusCallback.notifyCreateDestination(destination);
            } else {
                messageBusCallback.notifyUpdateDestination(destinationUID, hashtable);
            }
            if (clusterDestInfo.getShareccInfo() != null) {
                messageBusCallback.setLastReceivedChangeRecord(brokerAddress, clusterDestInfo.getShareccInfo());
            }
        }
        catch (Exception exception) {
            this.logger.logStack(8, "Internal Exception, unable to process message " + gPacket, (Throwable)exception);
            return;
        }
    }

    public void handleRemDestination(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        try {
            ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(gPacket);
            DestinationUID destinationUID = clusterDestInfo.getDestUID();
            messageBusCallback.notifyDestroyDestination(destinationUID);
            if (clusterDestInfo.getShareccInfo() != null) {
                messageBusCallback.setLastReceivedChangeRecord(brokerAddress, clusterDestInfo.getShareccInfo());
            }
        }
        catch (Exception exception) {
            this.logger.logStack(8, "Internal Exception, unable to process message " + gPacket, (Throwable)exception);
            return;
        }
    }

    public void handleReply(BrokerAddress brokerAddress, GPacket gPacket) {
    }
}

