/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import java.io.IOException;
import java.util.Iterator;

public class NewInterestHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public NewInterestHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            this.logger.log(4, "NewInterestHandler");
        }
        if (gPacket.getType() == 5) {
            this.handleNewInterest(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 6) {
            this.handleNewInterestAck(brokerAddress, gPacket);
        } else if (gPacket.getType() == 35) {
            this.handleAttachDurable(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 36) {
            this.handleAttachDurableReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "MessageDataHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public boolean ignoreNewInterest(ClusterConsumerInfo clusterConsumerInfo, GPacket gPacket) {
        ClusterConsumerInfo clusterConsumerInfo2 = clusterConsumerInfo;
        if (clusterConsumerInfo2 == null) {
            clusterConsumerInfo2 = ClusterConsumerInfo.newInstance(gPacket, this.c);
        }
        if (!this.p.getConfigSyncComplete() && !clusterConsumerInfo2.isConfigSyncResponse()) {
            if (DEBUG) {
                this.logger.log(8, "Ignore " + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + ", not ready yet");
            }
            return true;
        }
        return false;
    }

    public void handleNewInterest(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterConsumerInfo clusterConsumerInfo;
        if (DEBUG) {
            this.logger.log(8, "handleNewInterest from : " + brokerAddress);
        }
        if (this.ignoreNewInterest(clusterConsumerInfo = ClusterConsumerInfo.newInstance(gPacket, this.c), gPacket)) {
            return;
        }
        int n = clusterConsumerInfo.getConsumerCount();
        if (DEBUG) {
            this.logger.log(8, "handleNewInterest count : " + n);
        }
        try {
            int n2 = 0;
            Object object = null;
            Iterator iterator = clusterConsumerInfo.getConsumers();
            while (iterator.hasNext()) {
                Object object2;
                ++n2;
                Consumer consumer = null;
                try {
                    consumer = (Consumer)iterator.next();
                }
                catch (RuntimeException runtimeException) {
                    object2 = runtimeException.getCause();
                    if (object2 instanceof ConsumerAlreadyAddedException) {
                        this.logger.log(16, ((Throwable)object2).getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + ") " + brokerAddress);
                        continue;
                    }
                    throw runtimeException;
                }
                DestinationUID destinationUID = consumer.getDestinationUID();
                if (!destinationUID.isWildcard()) {
                    int n3 = destinationUID.isQueue() ? 1 : 2;
                    Destination destination = Destination.getDestination(destinationUID.getName(), n3, true, true);
                }
                messageBusCallback.interestCreated(consumer);
                if (DEBUG) {
                    this.logger.log(8, "Added newInterest(" + n + ")" + consumer + " from " + brokerAddress);
                }
                if ((object2 = clusterConsumerInfo.getShareccInfo(n2)) == null) continue;
                if (object == null) {
                    object = object2;
                    continue;
                }
                if (((ChangeRecordInfo)object2).getSeq() <= ((ChangeRecordInfo)object).getSeq()) continue;
                object = object2;
            }
            if (object != null) {
                messageBusCallback.setLastReceivedChangeRecord(brokerAddress, (ChangeRecordInfo)object);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(16, exception.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + ") " + brokerAddress + " " + gPacket, (Throwable)exception);
        }
        if (clusterConsumerInfo.needReply()) {
            GPacket gPacket2 = ClusterConsumerInfo.getReplyGPacket((short)6, 200);
            try {
                this.c.unicast(brokerAddress, gPacket2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleNewInterestAck(BrokerAddress brokerAddress, GPacket gPacket) {
        this.logger.log(4, "MessageBus: Received G_NEW_INTEREST_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Object)((Integer)gPacket.getProp((Object)"S")));
    }

    public void handleAttachDurable(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        String string;
        ClusterSubscriptionInfo clusterSubscriptionInfo;
        block18: {
            if (DEBUG) {
                this.logger.log(8, "handleAttachDurable from : " + brokerAddress);
            }
            clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(gPacket, this.c);
            try {
                boolean bl;
                string = clusterSubscriptionInfo.getDurableName();
                String string2 = clusterSubscriptionInfo.getClientID();
                Boolean bl2 = clusterSubscriptionInfo.allowsNonDurable();
                boolean bl3 = bl = bl2 == null ? false : bl2;
                if (string2 == null || !bl && string == null) {
                    this.logger.log(8, "Internal Error in handleAttachDurable : " + string + ":" + string2);
                    return;
                }
                Consumer consumer = null;
                try {
                    consumer = clusterSubscriptionInfo.getConsumer();
                }
                catch (IOException iOException) {
                    Throwable throwable = iOException.getCause();
                    if (throwable instanceof ConsumerAlreadyAddedException) {
                        this.logger.log(16, throwable.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + ") " + brokerAddress);
                        return;
                    }
                    throw iOException;
                }
                Subscription subscription = null;
                if (string == null) {
                    DestinationUID destinationUID = consumer.getDestinationUID();
                    String string3 = consumer.getSelectorStr();
                    subscription = Subscription.findNonDurableSubscription(string2, destinationUID, string3);
                } else {
                    subscription = Subscription.findDurableSubscription(string2, string);
                }
                if (DEBUG) {
                    this.logger.log(8, "handleAttachDurable:dname=" + string + ", subscription=" + subscription + ", consumer=" + consumer + " from " + brokerAddress);
                }
                if (subscription == null) {
                    this.logger.log(8, "Internal Error in handleAttachDurable.  Subscription not found : " + string + ":" + string2);
                    return;
                }
                try {
                    subscription.attachConsumer(consumer);
                    messageBusCallback.interestCreated(consumer);
                }
                catch (Exception exception) {
                    if (exception instanceof ConsumerAlreadyAddedException) {
                        this.logger.log(8, exception.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + ")");
                        break block18;
                    }
                    if (exception instanceof BrokerException && ((BrokerException)exception).getStatusCode() == 409) {
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2211", exception.getMessage()));
                        break block18;
                    }
                    this.logger.log(32, Globals.getBrokerResources().getKString("B2211", exception.getMessage()), (Throwable)exception);
                }
            }
            catch (Exception exception) {
                this.logger.logStack(16, exception.getMessage() + " (" + ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()) + ") " + brokerAddress + " " + gPacket, (Throwable)exception);
            }
        }
        if (clusterSubscriptionInfo.needReply()) {
            string = ClusterSubscriptionInfo.getReplyGPacket((short)36, 200);
            try {
                this.c.unicast(brokerAddress, (GPacket)string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleAttachDurableReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.logger.log(4, "MessageBus: Received G_DURABLE_ATTACH_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Object)((Integer)gPacket.getProp((Object)"S")));
    }
}

