/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.ConfigRecordStore;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.DestinationStore;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.InterestStore;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.PropertiesStore;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.TxnStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryStore
extends Store {
    public static final int STORE_VERSION = 100;
    static final String INMEMORY_PROP_PREFIX = "imq.persist.inmemory.";
    private static final ConsumerUID[] emptyiid = new ConsumerUID[0];
    private static final int[] emptystate = new int[0];
    private AtomicBoolean isClosed = new AtomicBoolean(true);
    private MsgStore msgStore = null;
    private InterestStore intStore = null;
    private DestinationStore dstStore = null;
    private TxnStore txnStore = null;
    private ConfigRecordStore configStoreStore = null;
    private PropertiesStore propStore = null;

    public InMemoryStore() {
        logger.logToAll(16, "Using in-memory store - ALL DATA WILL BE LOST WHEN THE BROKER IS SHUT DOWN!");
        this.dstStore = new DestinationStore(this);
        this.msgStore = new MsgStore(this);
        this.intStore = new InterestStore();
        this.txnStore = new TxnStore();
        this.configStoreStore = new ConfigRecordStore();
        this.propStore = new PropertiesStore();
        this.isClosed.set(false);
    }

    @Override
    public final int getStoreVersion() {
        return 100;
    }

    @Override
    public void close(boolean bl) {
        this.setClosedAndWait();
        this.dstStore.close(bl);
        this.msgStore.close(bl);
        this.intStore.close(bl);
        this.txnStore.close(bl);
        this.configStoreStore.close(bl);
        this.propStore.close(bl);
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.close(" + bl + ") done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll(boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.clearAll() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.clearAll();
            this.intStore.clearAll();
            this.dstStore.clearAll(false);
            this.txnStore.clearAll();
            this.configStoreStore.clearAll();
            this.propStore.clearAll();
            if (Store.getDEBUG()) {
                logger.log(4, "InMemory store cleared");
            }
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(DestinationUID destinationUID, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeMessage() called for " + packet.getSysMessageID());
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destinationUID == null || packet == null || consumerUIDArray == null || nArray == null) {
                throw new NullPointerException();
            }
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            this.msgStore.storeMessage(destinationUID, packet, consumerUIDArray, nArray);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(DestinationUID destinationUID, Packet packet, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeMessage() called for " + packet.getSysMessageID());
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.storeMessage(destinationUID, packet, emptyiid, emptystate);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessage(DestinationUID destinationUID, SysMessageID sysMessageID, boolean bl, boolean bl2) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "FileStore.removeMessage() called for " + destinationUID + ";" + sysMessageID);
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeMessage(destinationUID, sysMessageID);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveMessage(Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.moveMessage() called for: " + packet.getSysMessageID() + " from " + destinationUID + " to " + destinationUID2);
        }
        if (packet == null || destinationUID == null || destinationUID2 == null) {
            throw new NullPointerException();
        }
        if (consumerUIDArray == null) {
            consumerUIDArray = emptyiid;
            nArray = emptystate;
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.moveMessage(packet, destinationUID, destinationUID2, consumerUIDArray, nArray);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMessages(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.removeAllMessages(Destination) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.msgStore.removeAllMessages(destination.getDestinationUID(), bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.messageEnumeration(Destination) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Enumeration enumeration = this.msgStore.messageEnumeration(destination.getDestinationUID());
            return enumeration;
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Packet getMessage(DestinationUID destinationUID, String string) throws BrokerException {
        return this.getMessage(destinationUID, SysMessageID.get((String)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Packet getMessage(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getMessage() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            Packet packet = this.msgStore.getMessage(destinationUID, sysMessageID);
            return packet;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID[] consumerUIDArray, int[] nArray, boolean bl, Packet packet) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeInterestStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUIDArray == null || nArray == null) {
                throw new NullPointerException();
            }
            if (consumerUIDArray.length == 0 || consumerUIDArray.length != nArray.length) {
                throw new BrokerException(br.getString("B3085"));
            }
            this.msgStore.storeInterestStates(destinationUID, sysMessageID, consumerUIDArray, nArray, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl, TransactionUID transactionUID, boolean bl2) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.updateInterestState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (sysMessageID == null || consumerUID == null) {
                throw new NullPointerException();
            }
            this.msgStore.updateInterestState(destinationUID, sysMessageID, consumerUID, n, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInterestState(DestinationUID destinationUID, SysMessageID sysMessageID, ConsumerUID consumerUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getInterestState() called");
        }
        if (sysMessageID == null || consumerUID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            int n = this.msgStore.getInterestState(destinationUID, sysMessageID, consumerUID);
            return n;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getInterestStates(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getInterestStates() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getInterestStates(destinationUID, sysMessageID);
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerUID[] getConsumerUIDs(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getConsumerUIDs() called");
        }
        if (sysMessageID == null) {
            throw new NullPointerException();
        }
        this.checkClosedAndSetInProgress();
        try {
            ConsumerUID[] consumerUIDArray = this.msgStore.getConsumerUIDs(destinationUID, sysMessageID);
            return consumerUIDArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMessageBeenAcked(DestinationUID destinationUID, SysMessageID sysMessageID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.hasMessageBeenAcked() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            boolean bl = this.msgStore.hasMessageBeenAcked(destinationUID, sysMessageID);
            return bl;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeInterest() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.intStore.storeInterest(consumer);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterest(Consumer consumer, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.removeInterest() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.intStore.removeInterest(consumer);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer[] getAllInterests() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getAllInterests() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Consumer[] consumerArray = this.intStore.getAllInterests();
            return consumerArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeDestination() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstStore.storeDestination(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDestination(Destination destination, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.updateDestination() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstStore.updateDestination(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDestination(Destination destination, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.removeDestination() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destination == null) {
                throw new NullPointerException();
            }
            this.dstStore.removeDestination(destination);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination getDestination(DestinationUID destinationUID) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getDestination() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (destinationUID == null) {
                throw new NullPointerException();
            }
            Destination destination = this.dstStore.getDestination(destinationUID);
            return destination;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination[] getAllDestinations() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getAllDestinations() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Destination[] destinationArray = this.dstStore.getAllDestinations();
            return destinationArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransaction(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionState == null) {
                throw new NullPointerException();
            }
            this.txnStore.storeTransaction(transactionUID, transactionState, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public void removeTransaction(TransactionUID transactionUID, boolean bl) throws IOException, BrokerException {
        this.removeTransaction(transactionUID, false, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransaction(TransactionUID transactionUID, boolean bl, boolean bl2) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.removeTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            if (bl) {
                this.txnStore.removeTransactionAck(transactionUID);
            }
            this.txnStore.removeTransaction(transactionUID, bl2);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTransactionState(TransactionUID transactionUID, TransactionState transactionState, boolean bl) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.updateTransactionState( id=" + transactionUID + ", ts=" + transactionState.getState() + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.txnStore.updateTransactionState(transactionUID, transactionState.getState(), bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllTransactionStates() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getAllTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.txnStore.getAllTransactionStates();
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransactionAck(TransactionUID transactionUID, TransactionAcknowledgement transactionAcknowledgement, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeTransactionAck() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null || transactionAcknowledgement == null) {
                throw new NullPointerException();
            }
            this.txnStore.storeTransactionAck(transactionUID, transactionAcknowledgement, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionAck(TransactionUID transactionUID, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.removeTransactionAck() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            this.txnStore.removeTransactionAck(transactionUID);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionAcknowledgement[] getTransactionAcks(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (transactionUID == null) {
                throw new NullPointerException();
            }
            TransactionAcknowledgement[] transactionAcknowledgementArray = this.txnStore.getTransactionAcks(transactionUID);
            return transactionAcknowledgementArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllTransactionAcks() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getAllTransactionAcks() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.txnStore.getAllTransactionAcks();
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTransaction(TransactionUID transactionUID, TransactionInfo transactionInfo, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.storeTransaction(transactionUID, transactionInfo, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeClusterTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeClusterTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.storeClusterTransaction(transactionUID, transactionState, transactionBrokerArray, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransaction(TransactionUID transactionUID, TransactionBroker[] transactionBrokerArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.updateClusterTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.updateClusterTransaction(transactionUID, transactionBrokerArray, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.updateClusterTransactionBrokerState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            TransactionBroker[] transactionBrokerArray = this.txnStore.getClusterTransactionBrokers(transactionUID);
            return transactionBrokerArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateClusterTransactionBrokerState(TransactionUID transactionUID, int n, TransactionBroker transactionBroker, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.updateClusterTransactionBrokerState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.updateTransactionBrokerState(transactionUID, n, transactionBroker, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeRemoteTransaction(TransactionUID transactionUID, TransactionState transactionState, TransactionAcknowledgement[] transactionAcknowledgementArray, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeRemoteTransaction() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.txnStore.storeRemoteTransaction(transactionUID, transactionState, transactionAcknowledgementArray, brokerAddress, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrokerAddress getRemoteTransactionHomeBroker(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getRemoteTransactionHomeBroker() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            BrokerAddress brokerAddress = this.txnStore.getRemoteTransactionHomeBroker(transactionUID);
            return brokerAddress;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getAllRemoteTransactionStates() throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getAllRemoteTransactionStates() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.txnStore.getAllRemoteTransactionStates();
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionState getTransactionState(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getTransactionState() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            TransactionState transactionState = this.txnStore.getTransactionState(transactionUID);
            return transactionState;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionInfo getTransactionInfo(TransactionUID transactionUID) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getTransactionInfo() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            TransactionInfo transactionInfo = this.txnStore.getTransactionInfo(transactionUID);
            return transactionInfo;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getTransactions(String string) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getTransactions() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Collection collection = this.txnStore.getAllTransactions();
            return collection;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProperty(String string, Object object, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.updateProperty() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            this.propStore.updateProperty(string, object);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String string) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getProperty() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (string == null) {
                throw new NullPointerException();
            }
            Object object = this.propStore.getProperty(string);
            return object;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPropertyNames() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getPropertyNames() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            String[] stringArray = this.propStore.getPropertyNames();
            return stringArray;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getAllProperties() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getAllProperties() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            Properties properties = this.propStore.getProperties();
            return properties;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.storeConfigChangeRecord() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            if (l <= 0L) {
                logger.log(32, "B3074", (Object)new Long(l));
                throw new BrokerException(br.getString("B3074", new Long(l)));
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            this.configStoreStore.storeConfigChangeRecord(l, byArray, bl);
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long l) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getConfigChangeRecordsSince() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            ArrayList<ChangeRecordInfo> arrayList = this.configStoreStore.getConfigChangeRecordsSince(l);
            return arrayList;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getAllConfigRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            List<ChangeRecordInfo> list = this.configStoreStore.getAllConfigRecords();
            return list;
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllConfigChangeRecords(boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.clearAllConfigChangeRecords() called");
        }
        this.checkClosedAndSetInProgress();
        try {
            this.configStoreStore.clearAll();
        }
        finally {
            this.setInProgress(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getMessageStorageInfo(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getMessageStorageInfo(Destination) called");
        }
        this.checkClosedAndSetInProgress();
        try {
            DestinationUID destinationUID = destination.getDestinationUID();
            HashMap<String, Number> hashMap = new HashMap<String, Number>(2);
            hashMap.put("numMsgs", new Integer(this.msgStore.getMessageCount(destinationUID)));
            hashMap.put("totalMsgBytes", new Long(this.msgStore.getByteCount(destinationUID)));
            HashMap<String, Number> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public String getStoreType() {
        return "inmemory";
    }

    @Override
    public boolean isJDBCStore() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getStorageInfo(Destination destination) throws BrokerException {
        if (Store.getDEBUG()) {
            logger.log(4, "InMemoryStore.getStorageInfo(" + destination + ") called");
        }
        this.checkClosedAndSetInProgress();
        try {
            HashMap hashMap = this.msgStore.getStorageInfo(destination);
            return hashMap;
        }
        finally {
            this.setInProgress(false);
        }
    }

    @Override
    public Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("InMemoryStore version", String.valueOf(100));
        hashtable.putAll(this.dstStore.getDebugState());
        hashtable.putAll(this.msgStore.getDebugState());
        hashtable.putAll(this.intStore.getDebugState());
        hashtable.putAll(this.txnStore.getDebugState());
        hashtable.putAll(this.propStore.getDebugState());
        hashtable.putAll(this.configStoreStore.getDebugState());
        return hashtable;
    }

    @Override
    public void compactDestination(Destination destination) throws BrokerException {
    }

    MsgStore getMsgStore() {
        return this.msgStore;
    }

    DestinationStore getDstStore() {
        return this.dstStore;
    }

    @Override
    protected void setClosedAndWait() {
        this.isClosed.set(true);
    }

    @Override
    protected void checkClosedAndSetInProgress() throws BrokerException {
        if (this.isClosed.get()) {
            logger.log(32, "B3102");
            throw new BrokerException(br.getString("B3102"));
        }
    }

    @Override
    protected void setInProgress(boolean bl) {
    }
}

