/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.AbstractPool;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Deadlock;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.impl.services.locks.SinglePool;
import org.apache.derby.impl.services.locks.Timeout;

final class LockSet
implements LockTable {
    private final SinglePool factory;
    private final HashMap locks;
    private int deadlockTimeout = 20000;
    private int waitTimeout = 60000;
    private boolean deadlockTrace;
    private int blockCount;

    protected LockSet(SinglePool singlePool) {
        this.factory = singlePool;
        this.locks = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Lock lockObject(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, int n) throws StandardException {
        int n2;
        Lock lock;
        Object var8_5 = null;
        LockSet lockSet = this;
        // MONITORENTER : lockSet
        Control control = this.getControl(lockable);
        if (control == null) {
            Lock lock2 = new Lock(compatibilitySpace, lockable, object);
            lock2.grant();
            this.locks.put(lockable, lock2);
            // MONITOREXIT : lockSet
            return lock2;
        }
        LockControl lockControl = control.getLockControl();
        if (lockControl != control) {
            this.locks.put(lockable, lockControl);
        }
        if ((lock = lockControl.addLock(this, compatibilitySpace, object)).getCount() != 0) {
            // MONITOREXIT : lockSet
            return lock;
        }
        if (AbstractPool.noLockWait(n, compatibilitySpace)) {
            lockControl.giveUpWait(lock, this);
            // MONITOREXIT : lockSet
            return null;
        }
        // MONITOREXIT : lockSet
        boolean bl = false;
        if (n == -1) {
            bl = true;
            n2 = this.deadlockTimeout;
            if (n2 == -1) {
                n2 = 20000;
            }
        } else {
            if (n == -2) {
                n = n2 = this.waitTimeout;
            } else {
                n2 = n;
            }
            if (this.deadlockTimeout >= 0) {
                if (n2 < 0) {
                    bl = true;
                    n2 = this.deadlockTimeout;
                } else if (this.deadlockTimeout < n2) {
                    bl = true;
                    n2 = this.deadlockTimeout;
                    n -= this.deadlockTimeout;
                }
            }
        }
        ActiveLock activeLock = (ActiveLock)lock;
        lock = null;
        int n3 = 0;
        long l = 0L;
        while (true) {
            Object var26_24;
            long l2;
            byte by = activeLock.waitForGrant(n2);
            ActiveLock activeLock2 = null;
            Object[] objectArray = null;
            try {
                boolean bl2;
                Enumeration enumeration = null;
                l2 = 0L;
                Object object2 = this;
                // MONITORENTER : object2
                if (lockControl.isGrantable(lockControl.firstWaiter() == activeLock, compatibilitySpace, object)) {
                    lockControl.grant(activeLock);
                    activeLock2 = lockControl.getNextWaiter(activeLock, true, this);
                    ActiveLock activeLock3 = activeLock;
                    // MONITOREXIT : object2
                    var26_24 = null;
                    if (activeLock2 == null) return activeLock3;
                    activeLock2.wakeUp((byte)1);
                    return activeLock3;
                }
                activeLock.clearPotentiallyGranted();
                boolean bl3 = bl2 = by != 1;
                if (by == 0 && bl || by == 2) {
                    objectArray = Deadlock.look(this.factory, this, lockControl, activeLock, by);
                    if (objectArray == null) {
                        bl = false;
                        n2 = n;
                        l = 0L;
                        bl2 = false;
                    } else {
                        bl2 = true;
                    }
                }
                activeLock2 = lockControl.getNextWaiter(activeLock, bl2, this);
                if (bl2 && this.deadlockTrace && objectArray == null) {
                    l2 = System.currentTimeMillis();
                    enumeration = this.factory.makeVirtualLockTable();
                }
                // MONITOREXIT : object2
                if (bl2) {
                    if (objectArray != null) throw Deadlock.buildException(this.factory, objectArray);
                    if (this.deadlockTrace) {
                        throw Timeout.buildException(activeLock, enumeration, l2);
                    }
                    object2 = StandardException.newException("40XL1");
                    throw object2;
                }
                var26_24 = null;
                if (activeLock2 != null) {
                    activeLock2.wakeUp((byte)1);
                    activeLock2 = null;
                }
            }
            catch (Throwable throwable) {
                var26_24 = null;
                if (activeLock2 == null) throw throwable;
                activeLock2.wakeUp((byte)1);
                activeLock2 = null;
                throw throwable;
            }
            if (n2 == -1) continue;
            if (by != 0) {
                ++n3;
            }
            if (n3 <= 5) continue;
            long l3 = System.currentTimeMillis();
            if (l != 0L) {
                l2 = l3 - l;
                n2 = (int)((long)n2 - l2);
            }
            l = l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Latch latch, int n) {
        boolean bl = false;
        ActiveLock activeLock = null;
        LockSet lockSet = this;
        synchronized (lockSet) {
            Control control = this.getControl(latch.getLockable());
            bl = control.unlock(latch, n);
            latch = null;
            boolean bl2 = true;
            if (bl && (activeLock = control.firstWaiter()) != null) {
                bl2 = false;
                if (!activeLock.setPotentiallyGranted()) {
                    activeLock = null;
                }
            }
            if (bl2) {
                if (control.isEmpty()) {
                    this.locks.remove(control.getLockable());
                }
                return;
            }
        }
        if (bl && activeLock != null) {
            activeLock.wakeUp((byte)1);
        }
    }

    public synchronized Lock unlockReference(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, Map map) {
        Control control = this.getControl(lockable);
        if (control == null) {
            return null;
        }
        Lock lock = control.getLock(compatibilitySpace, object);
        if (lock == null) {
            return null;
        }
        Lock lock2 = (Lock)map.remove(lock);
        if (lock2 != null) {
            this.unlock(lock2, 1);
        }
        return lock2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zeroDurationLockObject(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object, int n) throws StandardException {
        Object object2 = this;
        synchronized (object2) {
            Control control = this.getControl(lockable);
            if (control == null) {
                return true;
            }
            if (control.isGrantable(true, compatibilitySpace, object)) {
                return true;
            }
            if (AbstractPool.noLockWait(n, compatibilitySpace)) {
                return false;
            }
        }
        object2 = this.lockObject(compatibilitySpace, lockable, object, n);
        this.unlock((Latch)object2, 1);
        return true;
    }

    public void setDeadlockTimeout(int n) {
        this.deadlockTimeout = n;
    }

    public void setWaitTimeout(int n) {
        this.waitTimeout = n;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setDeadlockTrace(boolean bl) {
        this.deadlockTrace = bl;
    }

    public String toDebugString() {
        return null;
    }

    public void addWaiters(Map map) {
        Iterator iterator = this.locks.values().iterator();
        while (iterator.hasNext()) {
            Control control = (Control)iterator.next();
            control.addWaiters(map);
        }
    }

    public synchronized Map shallowClone() {
        HashMap<Lockable, Control> hashMap = new HashMap<Lockable, Control>();
        Iterator iterator = this.locks.keySet().iterator();
        while (iterator.hasNext()) {
            Lockable lockable = (Lockable)iterator.next();
            Control control = this.getControl(lockable);
            hashMap.put(lockable, control.shallowClone());
        }
        return hashMap;
    }

    public void oneMoreWaiter() {
        ++this.blockCount;
    }

    public void oneLessWaiter() {
        --this.blockCount;
    }

    public synchronized boolean anyoneBlocked() {
        return this.blockCount != 0;
    }

    private final Control getControl(Lockable lockable) {
        return (Control)this.locks.get(lockable);
    }
}

