/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.generic;

import com.sun.corba.ee.spi.orbutil.generic.BinaryFunction;
import com.sun.corba.ee.spi.orbutil.generic.UnaryBooleanFunction;
import com.sun.corba.ee.spi.orbutil.generic.UnaryFunction;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class Algorithms {
    public static String convertToString(Object arg) {
        if (arg == null) {
            return "<NULL>";
        }
        Class<?> cls = arg.getClass();
        if (cls.isArray()) {
            Class<?> cclass = cls.getComponentType();
            if (cclass.equals(Integer.TYPE)) {
                return Arrays.toString((int[])arg);
            }
            if (cclass.equals(Byte.TYPE)) {
                return Arrays.toString((byte[])arg);
            }
            if (cclass.equals(Boolean.TYPE)) {
                return Arrays.toString((boolean[])arg);
            }
            if (cclass.equals(Character.TYPE)) {
                return Arrays.toString((char[])arg);
            }
            if (cclass.equals(Short.TYPE)) {
                return Arrays.toString((short[])arg);
            }
            if (cclass.equals(Long.TYPE)) {
                return Arrays.toString((long[])arg);
            }
            if (cclass.equals(Float.TYPE)) {
                return Arrays.toString((float[])arg);
            }
            if (cclass.equals(Double.TYPE)) {
                return Arrays.toString((double[])arg);
            }
            return Arrays.toString((Object[])arg);
        }
        return arg.toString();
    }

    public static <A, R> UnaryFunction<A, R> mapToFunction(final Map<A, R> map) {
        return new UnaryFunction<A, R>(){

            @Override
            public R evaluate(A arg) {
                return map.get(arg);
            }
        };
    }

    public static <A, R> void map(List<A> arg, List<R> result, UnaryFunction<A, R> func) {
        for (A a : arg) {
            R newArg = func.evaluate(a);
            if (newArg == null) continue;
            result.add(newArg);
        }
    }

    public static <A, R> List<R> map(List<A> arg, UnaryFunction<A, R> func) {
        ArrayList result = new ArrayList();
        Algorithms.map(arg, result, func);
        return result;
    }

    public static <A> void filter(List<A> arg, List<A> result, final UnaryBooleanFunction<A> predicate) {
        UnaryFunction filter = new UnaryFunction<A, A>(){

            @Override
            public A evaluate(A arg) {
                return predicate.evaluate(arg) ? arg : null;
            }
        };
        Algorithms.map(arg, result, filter);
    }

    public static <A> List<A> filter(List<A> arg, UnaryBooleanFunction<A> predicate) {
        ArrayList result = new ArrayList();
        Algorithms.filter(arg, result, predicate);
        return result;
    }

    public static <A> A find(List<A> arg, UnaryBooleanFunction<A> predicate) {
        for (A a : arg) {
            if (!predicate.evaluate(a)) continue;
            return a;
        }
        return null;
    }

    public static <A, R> R fold(List<A> list, R initial, BinaryFunction<R, A, R> func) {
        R result = initial;
        for (A elem : list) {
            result = func.evaluate(result, elem);
        }
        return result;
    }

    public static <T> T getOne(List<T> list, String zeroMsg, String manyMsg) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException(zeroMsg);
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException(manyMsg);
        }
        return list.get(0);
    }

    public static <T> T getFirst(List<T> list, String zeroMsg) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException(zeroMsg);
        }
        return list.get(0);
    }

    private static <T> PrivilegedAction<T> makePrivilegedAction(final Action<T> act) {
        return new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return act.run();
                }
                catch (RuntimeException exc) {
                    throw exc;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    public static <T> T doPrivileged(Action<T> func) {
        SecurityManager sman = System.getSecurityManager();
        try {
            if (sman == null) {
                return func.run();
            }
            return AccessController.doPrivileged(Algorithms.makePrivilegedAction(func));
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static interface Action<T> {
        public T run() throws Exception;
    }
}

