/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletContext;
import jmaki.runtime.CombinedResource;
import jmaki.runtime.IOUtil;
import jmaki.runtime.LocalizedMessage;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.WidgetResourceException;

public class CombinedResourceManager {
    private ServletContext context;
    private String resourceService;
    ArrayList dependentStyles = null;
    ArrayList styleResources = null;
    ArrayList scriptResources = null;
    HashSet scriptWidgets = null;
    HashSet styleWidgets = null;
    private long maxTimeout;
    ResourceManager resourceManager = null;

    public CombinedResourceManager(ResourceManager resourceManager, ServletContext ctx, String resourceService, long maxTimeout) {
        this.context = ctx;
        this.resourceService = resourceService;
        this.maxTimeout = maxTimeout;
        this.resourceManager = resourceManager;
    }

    public String getResourceService() {
        return this.resourceService;
    }

    public void addStyleLink(String style) {
        if (this.dependentStyles == null) {
            this.dependentStyles = new ArrayList();
        }
        this.dependentStyles.add(style);
    }

    public ArrayList getStyleLinks() {
        return this.dependentStyles;
    }

    public void addScriptResource(String resource, String widgetName, String widgetDir, boolean isWebAppResource) {
        if (this.scriptResources == null) {
            this.scriptResources = new ArrayList();
            this.scriptWidgets = new HashSet();
        }
        this.scriptWidgets.add(widgetName);
        this.scriptResources.add(new Resource(resource, widgetName, widgetDir, isWebAppResource));
    }

    public void addStyleResource(String resource, String widgetName, String widgetDir, boolean isWebAppResource) {
        if (this.styleResources == null) {
            this.styleResources = new ArrayList();
            this.styleWidgets = new HashSet();
        }
        this.styleWidgets.add(widgetName);
        this.styleResources.add(new Resource(resource, widgetName, widgetDir, isWebAppResource));
    }

    private StringBuffer replaceRelativeLinks(StringBuffer buffer, String widgetDir) {
        int end;
        int start;
        int index = 0;
        while ((start = buffer.indexOf("url(", index)) != -1 && (start += 4) <= buffer.length() && (end = buffer.indexOf(")", start)) != -1) {
            String url = buffer.substring(start, end);
            if (!url.startsWith("http")) {
                url = widgetDir + "/" + url;
            }
            buffer.replace(start, end, url);
            index = start + url.length() + 1;
        }
        return buffer;
    }

    public String getStylesHash() {
        return this.getHash(this.styleWidgets);
    }

    public String getScriptsHash() {
        return this.getHash(this.scriptWidgets);
    }

    public String getHash(HashSet widgets) {
        if (widgets != null) {
            Object[] wnames = widgets.toArray();
            Arrays.sort(wnames);
            String namesString = "";
            for (int i = 0; i < wnames.length; ++i) {
                namesString = namesString + "" + wnames[i];
            }
            return CombinedResourceManager.generateHash(namesString);
        }
        return null;
    }

    public static String generateHash(String target) {
        if (target != null) {
            String hash = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] bytes = md.digest(target.getBytes());
                StringBuffer buff = new StringBuffer();
                for (int l = 0; l < bytes.length; ++l) {
                    String hx = Integer.toHexString(0xFF & bytes[l]);
                    if (hx.length() == 1) {
                        buff.append("0");
                    }
                    buff.append(hx);
                }
                hash = buff.toString().trim();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            return hash;
        }
        return null;
    }

    public CombinedResource getScripts() throws IOException {
        CombinedResource scripts = new CombinedResource("text/javascript", this.maxTimeout, this.getScriptsHash());
        Iterator it = this.scriptResources.iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            URL scriptURL = r.isWidgetWebAppResource ? this.resourceManager.locateWebAppResource(r.getResource()) : this.resourceManager.locateClassPathResource(r.getResource());
            StringBuffer scriptBuffer = null;
            try {
                scriptBuffer = IOUtil.loadResource(scriptURL.openStream(), "UTF-8");
                scripts.appendContent(scriptBuffer.toString());
            }
            catch (Exception ioe) {
                String[] parameter = new String[]{r.getResource(), r.getWidgetName()};
                throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_FOR_WIDGET", parameter), (Throwable)ioe);
            }
        }
        return scripts;
    }

    public CombinedResource getStyles() throws IOException {
        CombinedResource styles = new CombinedResource("text/css", this.maxTimeout, this.getStylesHash());
        Iterator it = this.styleResources.iterator();
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            URL styleURL = r.isWidgetWebAppResource ? this.resourceManager.locateWebAppResource(r.getResource()) : this.resourceManager.locateClassPathResource(r.getResource());
            StringBuffer stylesBuffer = null;
            try {
                stylesBuffer = IOUtil.loadResource(styleURL.openStream(), "UTF-8");
                stylesBuffer = this.replaceRelativeLinks(stylesBuffer, r.getWidgetDir());
                styles.appendContent(stylesBuffer.toString());
            }
            catch (Exception ioe) {
                String[] parameter = new String[]{r.getResource(), r.getWidgetName()};
                throw new WidgetResourceException(new LocalizedMessage("ERROR_LOCATE_RESOURCE_FOR_WIDGET", parameter), (Throwable)ioe);
            }
        }
        return styles;
    }

    public void processStyles(Writer out) throws IOException {
        Hashtable styles = null;
        String hash = this.getStylesHash();
        if (hash != null) {
            CombinedResource csr;
            styles = this.context.getAttribute("JMAKI_CSS_RESOURCES") != null ? (Hashtable)this.context.getAttribute("JMAKI_CSS_RESOURCES") : new Hashtable();
            if (styles.get(hash) != null) {
                csr = (CombinedResource)styles.get(hash);
                if (csr.isExpired()) {
                    csr.reset();
                    csr = this.getStyles();
                }
            } else {
                csr = this.getStyles();
            }
            styles.put(hash, csr);
            this.context.setAttribute("JMAKI_CSS_RESOURCES", (Object)styles);
            if (this.getStyleLinks() != null) {
                ArrayList links = this.getStyleLinks();
                Iterator it = links.iterator();
                while (it.hasNext()) {
                    out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + it.next() + "\" media=\"screen,projection\" />");
                }
            }
            out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.getResourceService() + "?id=" + hash + ".css\" media=\"screen,projection\" />");
        }
    }

    public void processScripts(Writer out) throws IOException {
        Hashtable scripts = null;
        String hash = this.getScriptsHash();
        if (hash != null) {
            CombinedResource csr;
            scripts = this.context.getAttribute("JMAKI_JS_RESOURCES") != null ? (Hashtable)this.context.getAttribute("JMAKI_JS_RESOURCES") : new Hashtable();
            if (scripts.get(hash) != null) {
                csr = (CombinedResource)scripts.get(hash);
                if (csr.isExpired()) {
                    csr.reset();
                    csr = this.getScripts();
                }
            } else {
                csr = this.getScripts();
            }
            scripts.put(hash, csr);
            this.context.setAttribute("JMAKI_JS_RESOURCES", (Object)scripts);
            out.write("<script src=\"" + this.getResourceService() + "?id=" + hash + ".js\"></script>");
        }
    }

    public void clear() {
        this.scriptResources = null;
        this.scriptWidgets = null;
        this.styleWidgets = null;
        this.styleResources = null;
        this.dependentStyles = null;
    }

    class Resource {
        String widgetName;
        String widgetDir;
        String resource;
        boolean isWidgetWebAppResource;

        public Resource(String resource, String widgetName, String widgetDir, boolean isWidgetWebAppResource) {
            this.widgetName = widgetName;
            this.widgetDir = widgetDir;
            this.resource = resource;
            this.isWidgetWebAppResource = isWidgetWebAppResource;
        }

        public String getWidgetName() {
            return this.widgetName;
        }

        public String getWidgetDir() {
            return this.widgetDir;
        }

        public String getResource() {
            return this.resource;
        }
    }
}

