/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.BufferQueue;
import com.sun.corba.ee.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.ee.impl.encoding.CDROutputObject;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import java.util.Iterator;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.OutputStream;

public class BufferManagerWriteCollect
extends BufferManagerWrite {
    private BufferQueue queue = new BufferQueue();
    private boolean sentFragment = false;

    BufferManagerWriteCollect(com.sun.corba.ee.spi.orb.ORB orb) {
        super(orb);
    }

    @Override
    public boolean sentFragment() {
        return this.sentFragment;
    }

    @Override
    public int getBufferSize() {
        return this.orb.getORBData().getGIOPFragmentSize();
    }

    @Override
    public void overflow(ByteBufferWithInfo bbwi) {
        MessageBase.setFlag(bbwi.getByteBuffer(), 2);
        this.queue.enqueue(bbwi);
        ByteBufferWithInfo newBbwi = new ByteBufferWithInfo((ORB)this.orb, this);
        newBbwi.setFragmented(true);
        ((CDROutputObject)this.outputObject).setByteBufferWithInfo(newBbwi);
        FragmentMessage header = ((CDROutputObject)this.outputObject).getMessageHeader().createFragmentMessage();
        header.write((OutputStream)((CDROutputObject)this.outputObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage() {
        this.queue.enqueue(((CDROutputObject)this.outputObject).getByteBufferWithInfo());
        Iterator bufs = this.iterator();
        CorbaConnection conn = ((CDROutputObject)this.outputObject).getMessageMediator().getConnection();
        conn.writeLock();
        try {
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            while (bufs.hasNext()) {
                ByteBufferWithInfo bbwi = (ByteBufferWithInfo)bufs.next();
                ((CDROutputObject)this.outputObject).setByteBufferWithInfo(bbwi);
                conn.sendWithoutLock((CDROutputObject)this.outputObject);
                this.sentFragment = true;
                byteBufferPool.releaseByteBuffer(bbwi.getByteBuffer());
                bbwi.setByteBuffer(null);
                bbwi = null;
            }
            this.sentFullMessage = true;
        }
        finally {
            conn.writeUnlock();
        }
    }

    @Override
    public void close() {
        Iterator bufs = this.iterator();
        ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
        while (bufs.hasNext()) {
            ByteBufferWithInfo bbwi = (ByteBufferWithInfo)bufs.next();
            if (bbwi == null || bbwi.getByteBuffer() == null) continue;
            byteBufferPool.releaseByteBuffer(bbwi.getByteBuffer());
            bbwi.setByteBuffer(null);
            Object var3_3 = null;
        }
    }

    private void dprint(String msg) {
        ORBUtility.dprint("BufferManagerWriteCollect", msg);
    }

    private Iterator iterator() {
        return new BufferManagerWriteCollectIterator();
    }

    private class BufferManagerWriteCollectIterator
    implements Iterator {
        private BufferManagerWriteCollectIterator() {
        }

        @Override
        public boolean hasNext() {
            return BufferManagerWriteCollect.this.queue.size() != 0;
        }

        public Object next() {
            return BufferManagerWriteCollect.this.queue.dequeue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

