/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq;

import com.sun.messaging.jmq.resources.SharedResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class Version {
    private static String[] patchTermsList = new String[]{"SP", "UR", "_", "U", "PATCH", "UPDATE"};
    private static HashSet patchTerms = new HashSet();
    private String propname = "/com/sun/messaging/jmq/version.properties";
    private String comm_propname = "/com/sun/messaging/jmq/brand_version.properties";
    private static String imqhome_propname;
    private static final String IMQ_HOME;
    private static final String PATCHIDFILE;
    private Properties props = null;
    private String miniCopyright = "Copyright (c) 2011, Oracle and/or its affiliates.  All rights reserved.";
    private String shortCopyright = "Copyright (c) 2011, Oracle and/or its affiliates.  All rights reserved.";
    private String longCopyright = "Copyright (c) 2011, Oracle and/or its affiliates.  All rights reserved.";
    public static final int MINI_COPYRIGHT = 0;
    public static final int SHORT_COPYRIGHT = 1;
    public static final int LONG_COPYRIGHT = 2;
    private static String thisPackage;
    private static SharedResources rb;
    private boolean isJar = false;

    public Version() {
        this(true);
    }

    public Version(boolean bl) {
        this.isJar = bl;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.propname);
            if (inputStream == null) {
                System.err.println(rb.getString("S3006"));
            }
            this.props = new Properties();
            this.props.load(inputStream);
            inputStream = this.getClass().getResourceAsStream(this.comm_propname);
            if (inputStream != null) {
                this.props.load(inputStream);
            }
        }
        catch (Exception exception) {
            System.err.println(rb.getString("S3007"));
            exception.printStackTrace();
        }
    }

    public Properties getProps() {
        return this.props;
    }

    public String getProductVersion() {
        return this.props.getProperty("imq.product.version");
    }

    public int getMajorVersion() {
        try {
            return Integer.parseInt(this.props.getProperty("imq.product.major"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getMinorVersion() {
        try {
            return Integer.parseInt(this.props.getProperty("imq.product.minor"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getVersionProperty(String string) {
        return this.props.getProperty(string);
    }

    public String getBuildMilestone() {
        String string = this.props.getProperty("imq.build.milestone");
        if ("FCS".equals(string)) {
            return "";
        }
        return string;
    }

    public String getBuildDate() {
        return this.props.getProperty("imq.build.date");
    }

    public String getBuildVersion() {
        return this.props.getProperty("imq.product.version") + " " + this.getBuildMilestone() + " (Build " + this.props.getProperty("imq.build.number") + "-" + this.props.getProperty("imq.build.letter") + ")";
    }

    public String getProductName() {
        if (this.isJar) {
            return this.props.getProperty("imq.product.jarname");
        }
        return this.props.getProperty("imq.product.name");
    }

    public String getReleaseQID() {
        return this.props.getProperty("imq.product.releaseqid");
    }

    public String getAbbreviatedProductName() {
        return this.props.getProperty("imq.product.name.abbrev");
    }

    public String getLowerCaseAbbreviatedProductName() {
        return this.props.getProperty("imq.product.name.abbrev.lowercase");
    }

    public String getShortProductName() {
        return this.props.getProperty("imq.product.name.short");
    }

    public String getProductCopyrightDate() {
        return this.props.getProperty("imq.product.copyright.date");
    }

    public String getProductCompanyName() {
        return this.props.getProperty("imq.product.companyname");
    }

    public String getVersionPackageName() {
        return this.props.getProperty("imq.version.package");
    }

    public String getImplementationVersion() {
        return this.props.getProperty("imq.api.version");
    }

    public String getProtocolVersion() {
        return this.props.getProperty("imq.protocol.version");
    }

    public String getTargetJMSVersion() {
        return this.props.getProperty("imq.jms.api.version");
    }

    public boolean isCommercialProduct() {
        boolean bl = false;
        String string = this.props.getProperty("imq.product.brand");
        return Boolean.parseBoolean(string);
    }

    public boolean isProductValid() {
        if (!this.isCommercialProduct()) {
            return true;
        }
        int n = this.getMajorVersion();
        int n2 = this.getMinorVersion();
        int n3 = -1;
        int n4 = -1;
        try {
            n3 = Integer.parseInt(this.props.getProperty("imq.product.brand.major"));
            n4 = Integer.parseInt(this.props.getProperty("imq.product.brand.minor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3 == n && n4 == n2;
    }

    public String getUserAgent() {
        return this.getShortProductName() + "/" + this.getProductVersion() + " " + "(JMS; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")";
    }

    public String toString() {
        return this.getBanner(false);
    }

    public String getHeader() {
        return this.getHeader(2);
    }

    public String getHeader(int n) {
        return rb.getString("S1000") + this.getProductName() + " " + this.getReleaseQID() + SharedResources.NL + this.getProductCompanyName() + SharedResources.NL + rb.getString("S1001") + this.getBuildVersion() + SharedResources.NL + rb.getString("S1002") + this.getBuildDate() + SharedResources.NL + SharedResources.NL + this.getCopyright(n) + SharedResources.NL + rb.getString("S1000");
    }

    public String getRAVersion() {
        return rb.getString("S1001") + this.getBuildVersion() + " " + rb.getString("S1002") + this.getBuildDate();
    }

    public String getCopyright(int n) {
        switch (n) {
            case 0: {
                return this.miniCopyright;
            }
            case 1: {
                return this.shortCopyright;
            }
            case 2: {
                return this.longCopyright;
            }
        }
        return this.shortCopyright;
    }

    public String[] getPatchIds() {
        String string;
        File file = new File(PATCHIDFILE);
        if (!file.exists()) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(PATCHIDFILE);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            return null;
        }
        String string2 = this.getMajorVersion() + "." + this.getMinorVersion();
        String[] stringArray = new String[1000];
        int n = 0;
        for (int i = 1; i < stringArray.length && (string = properties.getProperty(string2 + "_" + i)) != null; ++i) {
            stringArray[n++] = string;
        }
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public String getPatchString() {
        String[] stringArray = this.getPatchIds();
        String string = "";
        if (stringArray == null) {
            string = "";
        } else if (stringArray.length == 0) {
            string = "";
        } else if (stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
                if (string.equals("")) {
                    string = string + rb.getString("S1009") + stringArray[i] + SharedResources.NL;
                    continue;
                }
                if (stringArray[i] == null) continue;
                string = string + rb.getString("S1010") + stringArray[i] + SharedResources.NL;
            }
        }
        return string;
    }

    public String getJMSAdminSpiVersion() {
        return this.props.getProperty("imq.jmsadmin.spi.version");
    }

    public String getVersion() {
        return this.getVersionPackageName() + rb.getString("S1004") + rb.getString("S1005") + this.getImplementationVersion() + SharedResources.NL + rb.getString("S1006") + this.getProtocolVersion() + SharedResources.NL + rb.getString("S1007") + this.getTargetJMSVersion() + SharedResources.NL + this.getPatchString();
    }

    public String getBanner(boolean bl) {
        return this.getBanner(bl, 1);
    }

    public String getBanner(boolean bl, int n) {
        if (this.props == null) {
            return rb.getString("S3008") + thisPackage;
        }
        if (bl) {
            return this.getHeader(n) + this.getVersion();
        }
        return this.getHeader(n);
    }

    public static int[] getIntVersion(String string) throws NumberFormatException {
        int[] nArray = new int[4];
        String string2 = Version.stripTrailingLetters(string.toUpperCase().trim());
        Object var3_3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String string3 = "";
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < 4; ++i) {
            string3 = stringTokenizer.nextToken();
            try {
                nArray[i] = Integer.parseInt(string3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                String string4;
                int n = 0;
                if (Character.isDigit(string3.charAt(n))) {
                    string4 = Version.getNumber(string3);
                    try {
                        nArray[i] = Integer.parseInt(string4);
                        ++i;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        System.out.println("Can't parse " + string3 + ": " + numberFormatException);
                    }
                    string3 = string3.substring(n += string4.length());
                }
                for (n = 0; n < string3.length() && !Character.isDigit(string3.charAt(n)); ++n) {
                }
                string4 = string3.substring(0, n).trim();
                if (!patchTerms.contains(string4)) break;
                String string5 = string3.substring(n);
                string5 = Version.getNumber(string5);
                try {
                    nArray[3] = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException3) {}
                break;
            }
        }
        return nArray;
    }

    static String getNumber(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        return string.substring(0, n);
    }

    private static String stripTrailingLetters(String string) {
        boolean bl = false;
        int n = string.length() - 1;
        while (!Character.isDigit(string.charAt(n))) {
            --n;
        }
        if (n == string.length() - 1) {
            return string;
        }
        return string.substring(0, n + 1);
    }

    public static int compareVersions(String string, String string2) {
        return Version.compareVersions(string, string2, true);
    }

    public static int compareVersions(String string, String string2, boolean bl) throws NumberFormatException {
        int[] nArray = Version.getIntVersion(string);
        int[] nArray2 = Version.getIntVersion(string2);
        if (bl) {
            nArray[3] = 0;
            nArray2[3] = 0;
        }
        return Version.compareVersions(nArray, nArray2);
    }

    public static int compareVersions(int[] nArray, int[] nArray2) {
        int n = nArray.length > nArray2.length ? nArray.length : nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = nArray.length > i ? nArray[i] : 0;
            int n4 = n2 = nArray2.length > i ? nArray2[i] : 0;
            if (n3 > n2) {
                return 1;
            }
            if (n3 >= n2) continue;
            return -1;
        }
        return 0;
    }

    public static String toVersionString(int[] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + nArray[i];
            if (i + 1 >= nArray.length) continue;
            string = string + ".";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Version version = new Version();
        System.out.println(version);
    }

    static {
        for (int i = 0; i < patchTermsList.length; ++i) {
            try {
                patchTerms.add(patchTermsList[i]);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Version: Could not add patch term " + patchTermsList[i] + ": " + exception);
            }
        }
        imqhome_propname = "imq.home";
        IMQ_HOME = System.getProperty(imqhome_propname, ".");
        PATCHIDFILE = IMQ_HOME + File.separator + "patches" + File.separator + "VERSION";
        thisPackage = "com.sun.messaging";
        rb = SharedResources.getResources();
    }
}

