/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl;
import com.sun.enterprise.security.provider.PolicyConfigurationImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import sun.net.www.ParseUtil;
import sun.security.provider.PolicyFile;
import sun.security.util.PropertyExpander;

public class BasePolicyWrapper
extends Policy {
    private static final String FACTORY_NAME = "javax.security.jacc.PolicyConfigurationFactory.provider";
    private static final String myFactoryName = "com.sun.enterprise.security.provider.PolicyConfigurationFactoryImpl";
    private Policy policy = this.getNewPolicy();
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BasePolicyWrapper.class);
    private static final String REUSE = "java.security.Policy.supportsReuse";
    private static final String IGNORE_REENTRANCY_PROP_NAME = "com.sun.enterprise.security.provider.PolicyWrapper.ignoreReentrancy";
    private static final boolean avoidReentrancy;
    private static ThreadLocal reentrancyStatus;
    private static final String POLICY = "java.security.policy";
    private static final String POLICY_URL = "policy.url.";
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private static final String FORCE_APP_REFRESH_PROP_NAME = "com.sun.enterprise.security.provider.PolicyWrapper.force_app_refresh";
    private static final boolean forceAppRefresh;
    private long refreshTime = 0L;

    static String logMsg(Level level, String key, Object[] params, String defMsg) {
        String msg = key == null ? defMsg : localStrings.getLocalString(key, defMsg == null ? key : defMsg, params);
        logger.log(level, msg);
        return msg;
    }

    public BasePolicyWrapper() {
        this.defaultContextChanged();
    }

    protected Policy getNewPolicy() {
        return new PolicyFile();
    }

    public PermissionCollection getPermissions(CodeSource codesource) {
        String contextId = PolicyContext.getContextID();
        PolicyConfigurationImpl pci = this.getPolicyConfigForContext(contextId);
        Policy appPolicy = this.getPolicy(pci);
        PermissionCollection perms = appPolicy.getPermissions(codesource);
        if (perms != null) {
            perms = BasePolicyWrapper.removeExcludedPermissions(pci, perms);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JACC Policy Provider: PolicyWrapper.getPermissions(cs), context (" + contextId + ") codesource (" + codesource + ") permissions: " + perms);
        }
        return perms;
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        String contextId = PolicyContext.getContextID();
        PolicyConfigurationImpl pci = this.getPolicyConfigForContext(contextId);
        Policy appPolicy = this.getPolicy(pci);
        PermissionCollection perms = appPolicy.getPermissions(domain);
        if (perms != null) {
            perms = BasePolicyWrapper.removeExcludedPermissions(pci, perms);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("JACC Policy Provider: PolicyWrapper.getPermissions(d), context (" + contextId + ") permissions: " + perms);
        }
        return perms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain domain, Permission permission) {
        if (avoidReentrancy) {
            byte[] alreadyCalled = (byte[])reentrancyStatus.get();
            if (alreadyCalled[0] == 1) {
                return true;
            }
            alreadyCalled[0] = 1;
            try {
                boolean bl = this.doImplies(domain, permission);
                return bl;
            }
            finally {
                alreadyCalled[0] = 0;
            }
        }
        return this.doImplies(domain, permission);
    }

    public void refresh() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: Refreshing Policy files!");
        }
        this.policy.refresh();
        boolean force = this.defaultContextChanged();
        PolicyConfigurationImpl[] pciArray = null;
        PolicyConfigurationFactoryImpl pcf = this.getPolicyFactory();
        if (pcf != null) {
            pciArray = pcf.getPolicyConfigurationImpls();
        }
        if (pciArray != null) {
            for (PolicyConfigurationImpl pci : pciArray) {
                if (pci == null) continue;
                pci.refresh(force);
            }
        }
        try {
            if (PolicyContext.getHandlerKeys().contains(REUSE)) {
                PolicyContext.getContext((String)REUSE);
            }
        }
        catch (PolicyContextException pe) {
            throw new IllegalStateException(pe.toString());
        }
    }

    private PolicyConfigurationImpl getPolicyConfigForContext(String contextId) {
        PolicyConfigurationImpl pci = null;
        PolicyConfigurationFactoryImpl pcf = this.getPolicyFactory();
        if (contextId != null && pcf != null) {
            pci = pcf.getPolicyConfigurationImpl(contextId);
        }
        return pci;
    }

    private Policy getPolicy(PolicyConfigurationImpl pci) {
        Policy result = null;
        if (pci == null) {
            result = this.policy;
        } else {
            result = pci.getPolicy();
            if (result == null) {
                result = this.policy;
            }
        }
        return result;
    }

    private static Permissions getExcludedPolicy(PolicyConfigurationImpl pci) {
        Permissions result = null;
        if (pci != null) {
            result = pci.getExcludedPolicy();
        }
        return result;
    }

    private static PermissionCollection removeExcludedPermissions(PolicyConfigurationImpl pci, PermissionCollection perms) {
        PermissionCollection result = perms;
        boolean noneRemoved = true;
        Permissions excluded = BasePolicyWrapper.getExcludedPolicy(pci);
        if (excluded != null && excluded.elements().hasMoreElements()) {
            result = null;
            Enumeration<Permission> e = perms.elements();
            while (e.hasMoreElements()) {
                Permission granted = e.nextElement();
                if (!BasePolicyWrapper.grantedIsExcluded(granted, excluded)) {
                    if (result == null) {
                        result = new Permissions();
                    }
                    result.add(granted);
                    continue;
                }
                noneRemoved = false;
            }
            if (noneRemoved) {
                result = perms;
            }
        }
        return result;
    }

    private static boolean grantedIsExcluded(Permission granted, Permissions excluded) {
        boolean isExcluded = false;
        if (excluded != null) {
            if (!excluded.implies(granted)) {
                Enumeration<Permission> e = excluded.elements();
                while (!isExcluded && e.hasMoreElements()) {
                    Permission excludedPerm = e.nextElement();
                    if (!granted.implies(excludedPerm)) continue;
                    isExcluded = true;
                }
            } else {
                isExcluded = true;
            }
        }
        if (logger.isLoggable(Level.FINEST) && isExcluded) {
            logger.finest("JACC Policy Provider: permission is excluded: " + granted);
        }
        return isExcluded;
    }

    private boolean doImplies(ProtectionDomain domain, Permission permission) {
        String contextId = PolicyContext.getContextID();
        PolicyConfigurationImpl pci = this.getPolicyConfigForContext(contextId);
        Policy appPolicy = this.getPolicy(pci);
        boolean result = appPolicy.implies(domain, permission);
        if (!result) {
            if (!(permission instanceof WebResourcePermission || permission instanceof MBeanPermission || permission instanceof WebRoleRefPermission || permission instanceof EJBRoleRefPermission)) {
                final String contextId2 = contextId;
                final Permission permission2 = permission;
                final ProtectionDomain domain2 = domain;
                if (logger.isLoggable(Level.FINE)) {
                    Exception ex = new Exception();
                    ex.fillInStackTrace();
                    logger.log(Level.FINE, "JACC Policy Provider, failed Permission Check at :", ex);
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        BasePolicyWrapper.logMsg(Level.INFO, "pc.failed.permission.check", new Object[]{contextId2, permission2}, null);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Domain that failed(" + domain2 + ")");
                        }
                        return null;
                    }
                });
            }
        } else {
            Permissions excluded = BasePolicyWrapper.getExcludedPolicy(pci);
            if (excluded != null) {
                boolean bl = result = !BasePolicyWrapper.grantedIsExcluded(permission, excluded);
            }
        }
        if (!result && logger.isLoggable(Level.FINEST)) {
            logger.finest("JACC Policy Provider: PolicyWrapper.implies, context (" + contextId + ")- result was(" + result + ") permission (" + permission + ")");
        }
        return result;
    }

    synchronized boolean defaultContextChanged() {
        if (forceAppRefresh) {
            return true;
        }
        long newTime = BasePolicyWrapper.getTimeStamp(POLICY, POLICY_URL);
        boolean rvalue = this.refreshTime != (newTime += BasePolicyWrapper.getTimeStamp(AUTH_POLICY, AUTH_POLICY_URL));
        this.refreshTime = newTime;
        return rvalue;
    }

    private static long getTimeStamp(final String propname, final String urlname) {
        Long l = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Long run() {
                String policy_uri;
                String extra_policy;
                long sum = 0L;
                boolean allowSystemProperties = "true".equalsIgnoreCase(Security.getProperty("policy.allowSystemProperty"));
                if (allowSystemProperties && (extra_policy = System.getProperty(propname)) != null) {
                    boolean overrideAll = false;
                    if (extra_policy.startsWith("=")) {
                        overrideAll = true;
                        extra_policy = extra_policy.substring(1);
                    }
                    try {
                        URL policy_url;
                        String path = PropertyExpander.expand(extra_policy);
                        File policyFile = new File(path);
                        boolean found = policyFile.exists();
                        if (!found && "file".equals((policy_url = new URL(path)).getProtocol())) {
                            path = policy_url.getFile().replace('/', File.separatorChar);
                            path = ParseUtil.decode(path);
                            policyFile = new File(path);
                            found = policyFile.exists();
                        }
                        if (found) {
                            sum += policyFile.lastModified();
                            if (logger.isLoggable(Level.FINE)) {
                                BasePolicyWrapper.logMsg(Level.FINE, "pc.file_refreshed", new Object[]{path}, null);
                            }
                        } else if (logger.isLoggable(Level.FINE)) {
                            BasePolicyWrapper.logMsg(Level.FINE, "pc.file_not_refreshed", new Object[]{path}, null);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (overrideAll) {
                        return sum;
                    }
                }
                int n = 1;
                while ((policy_uri = Security.getProperty(urlname + n)) != null) {
                    try {
                        URL policy_url = null;
                        String expanded_uri = PropertyExpander.expand(policy_uri).replace(File.separatorChar, '/');
                        policy_url = policy_uri.startsWith("file:${java.home}/") || policy_uri.startsWith("file:${user.home}/") ? new File(expanded_uri.substring(5)).toURI().toURL() : new URI(expanded_uri).toURL();
                        if ("file".equals(policy_url.getProtocol())) {
                            String path = policy_url.getFile().replace('/', File.separatorChar);
                            File policyFile = new File(path = ParseUtil.decode(path));
                            if (policyFile.exists()) {
                                sum += policyFile.lastModified();
                                if (logger.isLoggable(Level.FINE)) {
                                    BasePolicyWrapper.logMsg(Level.FINE, "pc.file_refreshed", new Object[]{path}, null);
                                }
                            } else if (logger.isLoggable(Level.FINE)) {
                                BasePolicyWrapper.logMsg(Level.FINE, "pc.file_not_refreshed", new Object[]{path}, null);
                            }
                        } else if (logger.isLoggable(Level.FINE)) {
                            BasePolicyWrapper.logMsg(Level.FINE, "pc.file_not_refreshed", new Object[]{policy_url}, null);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++n;
                }
                return sum;
            }
        });
        return l;
    }

    private PolicyConfigurationFactoryImpl getPolicyFactory() {
        return PolicyConfigurationFactoryImpl.getInstance();
    }

    static {
        boolean bl = avoidReentrancy = !Boolean.getBoolean(IGNORE_REENTRANCY_PROP_NAME) && System.getSecurityManager() != null;
        if (avoidReentrancy) {
            reentrancyStatus = new ThreadLocal(){

                protected synchronized Object initialValue() {
                    return new byte[]{0};
                }
            };
        }
        forceAppRefresh = Boolean.getBoolean(FORCE_APP_REFRESH_PROP_NAME);
    }
}

