/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Addressing;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.RespectBinding;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.ws.ReliabilityConfig;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.developer.SchemaValidationFeature;
import com.sun.xml.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeature;
import com.sun.xml.ws.rx.rm.api.ReliableMessagingFeatureBuilder;
import com.sun.xml.ws.rx.rm.api.RmProtocolVersion;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.glassfish.webservices.InstanceResolverImpl;
import org.glassfish.webservices.JAXWSAdapterRegistry;
import org.glassfish.webservices.JAXWSContainer;
import org.glassfish.webservices.JAXWSServlet;
import org.glassfish.webservices.WebServiceContractImpl;
import org.glassfish.webservices.WsUtil;

public class WSServletContextListener
implements ServletContextListener {
    private static Logger logger = LogDomains.getLogger(JAXWSServlet.class, (String)"javax.enterprise.webservices");
    private String contextRoot;

    public void contextInitialized(ServletContextEvent sce) {
        WebServiceContractImpl wscImpl = WebServiceContractImpl.getInstance();
        ComponentEnvManager compEnvManager = wscImpl.getComponentEnvManager();
        JndiNameEnvironment jndiNameEnv = compEnvManager.getCurrentJndiNameEnvironment();
        WebBundleDescriptor webBundle = null;
        if (jndiNameEnv == null || !(jndiNameEnv instanceof WebBundleDescriptor)) {
            throw new WebServiceException("Cannot intialize the JAXWSServlet for " + jndiNameEnv);
        }
        webBundle = (WebBundleDescriptor)jndiNameEnv;
        this.contextRoot = webBundle.getContextRoot();
        WebServicesDescriptor webServices = webBundle.getWebServices();
        try {
            for (WebServiceEndpoint endpoint : webServices.getEndpoints()) {
                this.registerEndpoint(endpoint, sce.getServletContext());
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Deployment failed", t);
            sce.getServletContext().removeAttribute("ADAPTER_LIST");
            throw new RuntimeException("Servlet web service endpoint '' failure", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEndpoint(WebServiceEndpoint endpoint, ServletContext servletContext) throws Exception {
        ServletAdapter adapter;
        RespectBinding rb;
        Addressing addressing;
        ClassLoader classLoader = servletContext.getClassLoader();
        WsUtil wsu = new WsUtil();
        Class<?> serviceEndpointClass = Class.forName(endpoint.getServletImplClass(), true, classLoader);
        String givenBinding = endpoint.getProtocolBinding();
        SDDocumentSource primaryWsdl = null;
        Collection docs = null;
        if (endpoint.getWebService().hasWsdlFile()) {
            URL pkgedWsdl = null;
            try {
                pkgedWsdl = servletContext.getResource('/' + endpoint.getWebService().getWsdlFileUri());
            }
            catch (MalformedURLException e) {
                logger.severe("Cannot load the wsdl from the aplication : " + e.getMessage());
            }
            if (pkgedWsdl == null) {
                pkgedWsdl = endpoint.getWebService().getWsdlFileUrl();
            }
            if (pkgedWsdl != null) {
                primaryWsdl = SDDocumentSource.create((URL)pkgedWsdl);
                docs = wsu.getWsdlsAndSchemas(pkgedWsdl);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.INFO, "Creating endpoint with packaged WSDL " + primaryWsdl.getSystemId().toString());
                    logger.log(Level.FINE, "Metadata documents:");
                    for (Object source : docs) {
                        logger.log(Level.FINE, ((SDDocumentSource)source).getSystemId().toString());
                    }
                }
            }
        }
        JAXWSContainer container = new JAXWSContainer(servletContext, endpoint);
        URL catalogURL = servletContext.getResource('/' + endpoint.getBundleDescriptor().getDeploymentDescriptorDir() + File.separator + "jax-ws-catalog.xml");
        boolean mtomEnabled = wsu.getMtom(endpoint);
        WSBinding binding = null;
        ArrayList<Object> wsFeatures = new ArrayList<Object>();
        if (mtomEnabled) {
            int mtomThreshold = endpoint.getMtomThreshold() != null ? new Integer(endpoint.getMtomThreshold()) : 0;
            MTOMFeature mtom = new MTOMFeature(true, mtomThreshold);
            wsFeatures.add(mtom);
        }
        if ((addressing = endpoint.getAddressing()) != null) {
            AddressingFeature addressingFeature = new AddressingFeature(addressing.isEnabled(), addressing.isRequired(), this.getResponse(addressing.getResponses()));
            wsFeatures.add(addressingFeature);
        }
        if ((rb = endpoint.getRespectBinding()) != null) {
            RespectBindingFeature rbFeature = new RespectBindingFeature(rb.isEnabled());
            wsFeatures.add(rbFeature);
        }
        if (endpoint.getValidateRequest() != null && Boolean.parseBoolean(endpoint.getValidateRequest())) {
            wsFeatures.add(new SchemaValidationFeature());
        }
        if (endpoint.getStreamAttachments() != null && Boolean.parseBoolean(endpoint.getStreamAttachments())) {
            wsFeatures.add(new StreamingAttachmentFeature());
        }
        if (endpoint.getReliabilityConfig() != null) {
            ReliabilityConfig rxConfig = endpoint.getReliabilityConfig();
            ReliableMessagingFeatureBuilder rmbuilder = new ReliableMessagingFeatureBuilder(RmProtocolVersion.getDefault());
            if (rxConfig.getInactivityTimeout() != null) {
                rmbuilder.sequenceInactivityTimeout(Long.parseLong(rxConfig.getInactivityTimeout().trim()));
            }
            if (endpoint.getHttpResponseBufferSize() != null) {
                rmbuilder.destinationBufferQuota(Long.parseLong(endpoint.getHttpResponseBufferSize().trim()));
            }
            if (rxConfig.getBaseRetransmissionInterval() != null) {
                rmbuilder.messageRetransmissionInterval(Long.parseLong(rxConfig.getBaseRetransmissionInterval().trim()));
            }
            if (rxConfig.getRetransmissionExponentialBackoff() != null) {
                rmbuilder.retransmissionBackoffAlgorithm(Boolean.parseBoolean(rxConfig.getRetransmissionExponentialBackoff()) ? ReliableMessagingFeature.BackoffAlgorithm.EXPONENTIAL : ReliableMessagingFeature.BackoffAlgorithm.getDefault());
            }
            if (rxConfig.getAcknowledgementInterval() != null) {
                rmbuilder.acknowledgementTransmissionInterval(Long.parseLong(rxConfig.getAcknowledgementInterval().trim()));
            }
            if (rxConfig.getSequenceExpiration() != null) {
                logger.info("For endpoint" + endpoint.getEndpointName() + ", Ignoring configuration <sequence-expiration> in weblogic-webservices.xml");
            }
            if (rxConfig.getBufferRetryCount() != null) {
                rmbuilder.maxMessageRetransmissionCount(Long.parseLong(rxConfig.getBufferRetryCount().trim()));
            }
            if (rxConfig.getBufferRetryDelay() != null) {
                logger.info("For endpoint" + endpoint.getEndpointName() + ", Ignoring configuration <buffer-retry-delay> in weblogic-webservices.xml");
            }
            wsFeatures.add(rmbuilder.build());
        } else if (endpoint.getHttpResponseBufferSize() != null) {
            logger.warning("For endpoint" + endpoint.getEndpointName() + ", Unsupported configuration <http-response-buffersize> in weblogic-webservices.xml");
        }
        binding = wsFeatures.size() > 0 ? BindingID.parse((String)givenBinding).createBinding(wsFeatures.toArray(new WebServiceFeature[0])) : BindingID.parse((String)givenBinding).createBinding();
        wsu.configureJAXWSServiceHandlers(endpoint, givenBinding, binding);
        InstanceResolverImpl ir = InstanceResolver.createFromInstanceResolverAnnotation(serviceEndpointClass);
        if (ir == null) {
            ir = new InstanceResolverImpl(serviceEndpointClass);
        }
        Invoker inv = ir.createInvoker();
        WSEndpoint wsep = WSEndpoint.create(serviceEndpointClass, (boolean)false, (Invoker)inv, (QName)endpoint.getServiceName(), (QName)endpoint.getWsdlPort(), (Container)container, (WSBinding)binding, (SDDocumentSource)primaryWsdl, (Collection)docs, (URL)catalogURL);
        String uri = endpoint.getEndpointAddressUri();
        String urlPattern = uri.startsWith("/") ? uri : "/" + uri;
        WSServletContextListener wSServletContextListener = this;
        synchronized (wSServletContextListener) {
            ServletAdapterList list = (ServletAdapterList)servletContext.getAttribute("ADAPTER_LIST");
            if (list == null) {
                list = new ServletAdapterList();
                servletContext.setAttribute("ADAPTER_LIST", (Object)list);
            }
            adapter = (ServletAdapter)list.createAdapter(endpoint.getName(), urlPattern, wsep);
            container.addEndpoint(adapter);
        }
        this.registerEndpointUrlPattern(urlPattern, (Adapter)adapter);
    }

    private AddressingFeature.Responses getResponse(String s) {
        if (s != null) {
            return (AddressingFeature.Responses)AddressingFeature.Responses.valueOf(AddressingFeature.Responses.class, (String)s);
        }
        return AddressingFeature.Responses.ALL;
    }

    private void registerEndpointUrlPattern(String urlPattern, Adapter info) {
        JAXWSAdapterRegistry.getInstance().addAdapter(this.contextRoot, urlPattern, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        WSServletContextListener wSServletContextListener = this;
        synchronized (wSServletContextListener) {
            ServletAdapterList list = (ServletAdapterList)servletContext.getAttribute("ADAPTER_LIST");
            if (list != null) {
                for (ServletAdapter x : list) {
                    x.getEndpoint().dispose();
                }
                servletContext.removeAttribute("ADAPTER_LIST");
            }
            JAXWSAdapterRegistry.getInstance().removeAdapter(this.contextRoot);
        }
    }
}

