/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.annotation.handlers;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.annotation.context.HandlerContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContextImpl;
import com.sun.enterprise.deployment.annotation.handlers.AbstractHandler;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.util.XModuleType;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.WebServiceRef;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ProcessingContext;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class HandlerChainHandler
extends AbstractHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return HandlerChain.class;
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        Class[] dependencies = new Class[]{WebService.class, WebServiceRef.class, WebServiceProvider.class};
        return dependencies;
    }

    public HandlerProcessingResult processAnnotation(AnnotationInfo annInfo) throws AnnotationProcessorException {
        Class declaringClass;
        boolean serviceSideChain;
        AnnotatedElementHandler annCtx = annInfo.getProcessingContext().getHandler();
        AnnotatedElement annElem = annInfo.getAnnotatedElement();
        boolean bl = serviceSideChain = annElem.getAnnotation(WebService.class) != null || annElem.getAnnotation(WebServiceProvider.class) != null;
        if (serviceSideChain) {
            declaringClass = (Class)annElem;
        } else if (annInfo.getElementType().equals((Object)ElementType.FIELD)) {
            declaringClass = ((Field)annElem).getDeclaringClass();
        } else if (annInfo.getElementType().equals((Object)ElementType.METHOD)) {
            declaringClass = ((Method)annElem).getDeclaringClass();
        } else if (annInfo.getElementType().equals((Object)ElementType.TYPE)) {
            declaringClass = (Class)annElem;
        } else {
            throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.invalidtype", "annotation not allowed on this element."), annInfo);
        }
        return this.processHandlerChainAnnotation(annInfo, annCtx, annElem, declaringClass, serviceSideChain);
    }

    public HandlerProcessingResult processHandlerChainAnnotation(AnnotationInfo annInfo, AnnotatedElementHandler annCtx, AnnotatedElement annElem, Class declaringClass, boolean serviceSideChain) throws AnnotationProcessorException {
        HandlerChain hChain = null;
        boolean clientSideHandlerChain = false;
        if (serviceSideChain) {
            WebService webService;
            if (declaringClass.isInterface()) {
                return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
            }
            hChain = annElem.getAnnotation(HandlerChain.class);
            if (hChain == null && (webService = declaringClass.getAnnotation(WebService.class)) != null && webService.endpointInterface() != null && webService.endpointInterface().length() > 0) {
                Class<?> endpointIntf;
                try {
                    endpointIntf = declaringClass.getClassLoader().loadClass(webService.endpointInterface());
                }
                catch (ClassNotFoundException cfne) {
                    throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.classnotfound", "class {0} referenced from annotation symbol cannot be loaded", new Object[]{webService.endpointInterface()}), annInfo);
                }
                if (endpointIntf.getAnnotation(HandlerChain.class) != null) {
                    hChain = endpointIntf.getAnnotation(HandlerChain.class);
                }
            }
        } else {
            hChain = annElem.getAnnotation(HandlerChain.class);
            clientSideHandlerChain = true;
        }
        if (hChain == null) {
            return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
        }
        String handlerFile = hChain.file();
        HandlerChainContainer[] containers = null;
        if (annCtx instanceof HandlerContext) {
            containers = ((HandlerContext)annCtx).getHandlerChainContainers(serviceSideChain, declaringClass);
        }
        if (!(clientSideHandlerChain || containers != null && containers.length != 0)) {
            throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.componentnotfound", "component referenced from annotation symbol cannot be found"), annInfo);
        }
        try {
            Document document;
            InputStream handlerFileStream;
            URL handlerFileURL = null;
            try {
                handlerFileURL = new URL(handlerFile);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (handlerFileURL == null) {
                String y;
                ClassLoader clo = annInfo.getProcessingContext().getProcessingInput().getClassLoader();
                handlerFileStream = clo.getResourceAsStream(handlerFile);
                if (handlerFileStream == null) {
                    y = declaringClass.getPackage().getName().replaceAll("\\.", "/");
                    handlerFileStream = clo.getResourceAsStream(declaringClass.getPackage().getName().replaceAll("\\.", "/") + "/" + handlerFile);
                }
                if (handlerFileStream == null && annElem instanceof Class) {
                    y = ((Class)annElem).getPackage().getName().replaceAll("\\.", "/");
                    handlerFileStream = clo.getResourceAsStream(((Class)annElem).getPackage().getName().replaceAll("\\.", "/") + "/" + handlerFile);
                }
            } else {
                handlerFileStream = handlerFileURL.openConnection().getInputStream();
            }
            if (handlerFileStream == null) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.handlerfilenotfound", "handler file {0} not found", new Object[]{handlerFile}), annInfo);
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setExpandEntityReferences(false);
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.parse(handlerFileStream);
            }
            catch (SAXParseException spe) {
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.annotation.handlers.parserexception", "{0} XML Parsing error : line  {1} ; Error = {2}", new Object[]{handlerFile, spe.getLineNumber(), spe.getMessage()}));
            }
            finally {
                if (handlerFileStream != null) {
                    handlerFileStream.close();
                }
            }
            for (HandlerChainContainer container : containers) {
                boolean fromDD = true;
                if (!container.hasHandlerChain()) {
                    fromDD = false;
                    this.processHandlerFile(document, container);
                }
                List chains = container.getHandlerChain();
                ArrayList handlerClasses = new ArrayList();
                ClassLoader clo = annInfo.getProcessingContext().getProcessingInput().getClassLoader();
                for (WebServiceHandlerChain chain : chains) {
                    for (WebServiceHandler handler : chain.getHandlers()) {
                        String className = handler.getHandlerClass();
                        try {
                            handlerClasses.add(clo.loadClass(className));
                        }
                        catch (ClassNotFoundException e) {
                            if (fromDD) {
                                this.logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.annotation.handlers.ddhandlernotfound", "handler class {0} specified in deployment descriptors", new Object[]{className}));
                                continue;
                            }
                            this.logger.log(Level.WARNING, localStrings.getLocalString("enterprise.deployment.annotation.handlers.handlerfilehandlernotfound", "handler class {0} specified in handler file {1} cannot be loaded", new Object[]{className, handlerFile}));
                        }
                    }
                }
                Object jndiContainer = null;
                if (serviceSideChain) {
                    WebServiceEndpoint endpoint = (WebServiceEndpoint)container;
                    jndiContainer = XModuleType.WAR.equals((Object)endpoint.getBundleDescriptor().getModuleType()) ? endpoint.getBundleDescriptor() : endpoint.getEjbComponentImpl();
                } else {
                    ServiceReferenceDescriptor ref = (ServiceReferenceDescriptor)container;
                    if (XModuleType.EJB.equals((Object)ref.getBundleDescriptor().getModuleType())) {
                        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)ref.getBundleDescriptor();
                        for (EjbDescriptor ejb : ejbBundle.getEjbs()) {
                            try {
                                if (ejb.getServiceReferenceByName(ref.getName()) == null) continue;
                                jndiContainer = ejb;
                                break;
                            }
                            catch (IllegalArgumentException illex) {
                            }
                        }
                    } else {
                        jndiContainer = ref.getBundleDescriptor();
                    }
                }
                ResourceContainerContextImpl newContext = new ResourceContainerContextImpl((Descriptor)jndiContainer);
                ProcessingContext ctx = annInfo.getProcessingContext();
                ctx.pushHandler((AnnotatedElementHandler)newContext);
                annInfo.getProcessingContext().getProcessor().process(annInfo.getProcessingContext(), handlerClasses.toArray(new Class[0]));
                ctx.popHandler();
            }
        }
        catch (Throwable t) {
            throw new AnnotationProcessorException(t.getMessage(), annInfo);
        }
        return HandlerProcessingResultImpl.getDefaultResult(this.getAnnotationType(), (ResultType)ResultType.PROCESSED);
    }

    private void processHandlerFile(Document document, HandlerChainContainer ep) throws SAXException {
        NodeList handlerChainList = document.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chain");
        if (handlerChainList.getLength() != 0) {
            this.processHandlerChains(handlerChainList, ep);
            return;
        }
        handlerChainList = document.getElementsByTagName("handler-chain");
        this.processHandlerChains(handlerChainList, ep);
    }

    private String getAsQName(Node n) {
        String nodeValue = n.getTextContent();
        int index = nodeValue.indexOf(":");
        if (index <= 0) {
            return nodeValue;
        }
        String prefix = nodeValue.substring(0, index);
        String ns = n.lookupNamespaceURI(prefix);
        return "{" + ns + "}" + nodeValue.substring(index + 1);
    }

    private void processHandlerChains(NodeList handlerChainList, HandlerChainContainer ep) throws SAXException {
        for (int i = 0; i < handlerChainList.getLength(); ++i) {
            WebServiceHandlerChain hc = new WebServiceHandlerChain();
            Node handlerChain = handlerChainList.item(i);
            for (Node child = handlerChain.getFirstChild(); child != null; child = child.getNextSibling()) {
                if ("service-name-pattern".equals(child.getLocalName())) {
                    hc.setServiceNamePattern(this.getAsQName(child));
                }
                if ("port-name-pattern".equals(child.getLocalName())) {
                    hc.setPortNamePattern(this.getAsQName(child));
                }
                if ("protocol-bindings".equals(child.getLocalName())) {
                    hc.setProtocolBindings(child.getTextContent());
                }
                if (!"handler".equals(child.getLocalName())) continue;
                this.processHandlers(child, hc);
            }
            ep.addHandlerChain(hc);
        }
    }

    private void processHandlers(Node handler, WebServiceHandlerChain hc) throws SAXException {
        WebServiceHandler h = new WebServiceHandler();
        for (Node child = handler.getFirstChild(); child != null; child = child.getNextSibling()) {
            if ("handler-name".equals(child.getLocalName())) {
                h.setHandlerName(child.getTextContent());
            }
            if ("handler-class".equals(child.getLocalName())) {
                h.setHandlerClass(child.getTextContent());
            }
            if ("port-name".equals(child.getLocalName())) {
                h.addPortName(this.getAsQName(child));
            }
            if (!"soap-role".equals(child.getLocalName())) continue;
            h.addSoapRole(child.getTextContent());
        }
        hc.addHandler(h);
    }
}

