/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.codegen;

import com.sun.corba.ee.impl.orbutil.codegen.ASMByteCodeVisitor;
import com.sun.corba.ee.impl.orbutil.codegen.ASMUtil;
import com.sun.corba.ee.impl.orbutil.codegen.Attribute;
import com.sun.corba.ee.impl.orbutil.codegen.BlockStatement;
import com.sun.corba.ee.impl.orbutil.codegen.ClassGeneratorImpl;
import com.sun.corba.ee.impl.orbutil.codegen.CodegenPrinter;
import com.sun.corba.ee.impl.orbutil.codegen.EmitterFactory;
import com.sun.corba.ee.impl.orbutil.codegen.ExpressionFactory;
import com.sun.corba.ee.impl.orbutil.codegen.ExpressionInternal;
import com.sun.corba.ee.impl.orbutil.codegen.FieldGenerator;
import com.sun.corba.ee.impl.orbutil.codegen.MethodGenerator;
import com.sun.corba.ee.impl.orbutil.codegen.MyLabel;
import com.sun.corba.ee.impl.orbutil.codegen.Node;
import com.sun.corba.ee.impl.orbutil.codegen.Statement;
import com.sun.corba.ee.impl.orbutil.codegen.VariableInternal;
import com.sun.corba.ee.org.objectweb.asm.ClassWriter;
import com.sun.corba.ee.org.objectweb.asm.Label;
import com.sun.corba.ee.org.objectweb.asm.MethodVisitor;
import com.sun.corba.ee.org.objectweb.asm.util.TraceMethodVisitor;
import com.sun.corba.ee.spi.orbutil.codegen.ClassInfo;
import com.sun.corba.ee.spi.orbutil.codegen.MethodInfo;
import com.sun.corba.ee.spi.orbutil.codegen.Signature;
import com.sun.corba.ee.spi.orbutil.codegen.Type;
import com.sun.corba.ee.spi.orbutil.codegen.Variable;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ByteCodeUtility {
    private ClassWriter cw;
    private MethodVisitor mv;
    private boolean debug;
    private PrintStream ps;
    private String methodName;
    private String methodSignature;
    private static Map<Type, Integer> typeIndex = new HashMap<Type, Integer>();
    private static final EmitterFactory.Emitter E_NOP;
    private static final EmitterFactory.Emitter E_I2B;
    private static final EmitterFactory.Emitter E_I2C;
    private static final EmitterFactory.Emitter E_I2S;
    private static final EmitterFactory.Emitter E_I2L;
    private static final EmitterFactory.Emitter E_I2F;
    private static final EmitterFactory.Emitter E_I2D;
    private static final EmitterFactory.Emitter E_L2I;
    private static final EmitterFactory.Emitter E_F2I;
    private static final EmitterFactory.Emitter E_D2I;
    private static final EmitterFactory.Emitter E_L2F;
    private static final EmitterFactory.Emitter E_L2D;
    private static final EmitterFactory.Emitter E_F2L;
    private static final EmitterFactory.Emitter E_D2L;
    private static final EmitterFactory.Emitter E_F2D;
    private static final EmitterFactory.Emitter E_D2F;
    private static final EmitterFactory.Emitter E_L2B;
    private static final EmitterFactory.Emitter E_F2B;
    private static final EmitterFactory.Emitter E_D2B;
    private static final EmitterFactory.Emitter E_L2S;
    private static final EmitterFactory.Emitter E_F2S;
    private static final EmitterFactory.Emitter E_D2S;
    private static final EmitterFactory.Emitter E_L2C;
    private static final EmitterFactory.Emitter E_F2C;
    private static final EmitterFactory.Emitter E_D2C;
    EmitterFactory.Emitter[][] numericConversions = new EmitterFactory.Emitter[][]{{E_I2B, E_I2S, E_I2C, E_NOP, E_I2L, E_I2F, E_I2D}, {E_I2B, E_I2S, E_I2C, E_NOP, E_I2L, E_I2F, E_I2D}, {E_I2B, E_I2S, E_I2C, E_NOP, E_I2L, E_I2F, E_I2D}, {E_I2B, E_I2S, E_I2C, E_NOP, E_I2L, E_I2F, E_I2D}, {E_L2B, E_L2S, E_L2C, E_L2I, E_NOP, E_L2F, E_L2D}, {E_F2B, E_F2S, E_F2C, E_F2I, E_F2L, E_NOP, E_F2D}, {E_D2B, E_D2S, E_D2C, E_D2I, E_D2L, E_D2F, E_NOP}};
    private static Map<ExpressionFactory.BinaryOperator, Map<Type, Integer>> opInstructions;
    private static Map<ExpressionFactory.BinaryOperator, Integer> ifOpInstructions;

    public ByteCodeUtility(ClassWriter cw, ClassGeneratorImpl cg, boolean debug, PrintStream ps) {
        this.cw = cw;
        this.mv = null;
        this.debug = debug;
        this.ps = ps;
        String[] interfaces = new String[cg.impls().size()];
        int ctr = 0;
        for (Type impl : cg.impls()) {
            interfaces[ctr++] = ASMUtil.bcName(impl);
        }
        int modifiers = cg.modifiers();
        if (cg.isInterface()) {
            modifiers += 512;
        }
        String superType = cg.superType() == null ? ASMUtil.bcName(Type._Object()) : ASMUtil.bcName(cg.superType());
        cw.visit(49, cg.modifiers(), ASMUtil.bcName(cg.thisType()), null, superType, interfaces);
        cw.visitSource(cg.name().replace('.', '/') + ".java", null);
    }

    public void addField(FieldGenerator arg) {
        String descriptor = arg.type().signature();
        this.cw.visitField(arg.modifiers(), arg.name(), descriptor, null, null);
    }

    public ByteCodeUtility(ClassWriter cw, ClassGeneratorImpl cg) {
        this(cw, cg, false, System.out);
    }

    private void dump() {
        if (this.debug) {
            List data = ((TraceMethodVisitor)TraceMethodVisitor.class.cast(this.mv)).getText();
            this.ps.printf("MethodVisitor calls for method %s%s\n", this.methodName, this.methodSignature);
            for (String str : data) {
                this.ps.print(str);
            }
        }
    }

    public void emitMethodStart(MethodGenerator mg) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Variable var : mg.arguments()) {
            types.add(((VariableInternal)var).type());
        }
        this.methodName = mg.name();
        this.methodSignature = Signature.make(mg.returnType(), types).signature();
        String[] strs = new String[mg.exceptions().size()];
        int ctr = 0;
        for (Type exception : mg.exceptions()) {
            strs[ctr++] = ASMUtil.bcName(exception);
        }
        this.mv = this.cw.visitMethod(mg.modifiers(), this.methodName, this.methodSignature, null, strs);
        if (this.debug) {
            this.mv = new TraceMethodVisitor(this.mv);
        }
        this.mv.visitCode();
    }

    private void emitLineNumberTable(MethodGenerator mg) {
        ASMUtil.LineNumberTable lnt = ASMUtil.lineNumberTable.get(mg);
        if (lnt != null) {
            ArrayList labels = new ArrayList(lnt.keySet());
            Collections.sort(labels, new Comparator<MyLabel>(){

                @Override
                public int compare(MyLabel l1, MyLabel l2) {
                    return l1.getOffset() - l2.getOffset();
                }
            });
            int currentLineNum = -1;
            for (MyLabel label : labels) {
                int lineNum = (Integer)lnt.get((Object)label);
                if (lineNum == currentLineNum) continue;
                currentLineNum = lineNum;
                this.mv.visitLineNumber(lineNum, (Label)label);
            }
        }
    }

    private void emitLocalVariableTable(MethodGenerator mg) {
        ASMUtil.VariablesInMethod vm = ASMUtil.variablesInMethod.get(mg);
        for (Variable var : vm) {
            Label start;
            Label end;
            Statement stmt = ((VariableInternal)var).getAncestor(Statement.class);
            if (stmt == null) {
                end = ASMUtil.returnLabel.get(mg);
                BlockStatement bs = mg.body();
                if (bs.isEmpty()) {
                    start = end;
                } else {
                    List<Statement> stmts = bs.body();
                    Statement first = stmts.iterator().next();
                    start = ASMUtil.statementStartLabel.get(first);
                }
            } else {
                start = ASMUtil.statementStartLabel.get(stmt);
                end = ASMUtil.statementEndLabel.get(stmt);
            }
            VariableInternal ivar = (VariableInternal)var;
            int index = ASMUtil.stackFrameSlot.get(ivar);
            this.mv.visitLocalVariable(ivar.ident(), ivar.type().signature(), null, start, end, index);
        }
    }

    public void emitMethodEnd(MethodGenerator mg, Label returnLabel, Variable returnVariable, boolean dump) {
        if ((mg.modifiers() & 0x400) == 0) {
            this.mv.visitLabel(returnLabel);
            if (returnVariable != null) {
                EmitterFactory.Emitter emitter = ASMUtil.getEmitter.get((VariableInternal)returnVariable);
                assert (emitter != null);
                emitter.evaluate(this.mv);
            }
            this.emitReturn(returnVariable == null ? Type._void() : ((VariableInternal)returnVariable).type());
            this.emitLineNumberTable(mg);
            this.emitLocalVariableTable(mg);
        }
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
        if (dump) {
            this.dump();
        }
        this.mv = null;
    }

    private void emitReturn(Type returnType) {
        if (returnType.equals(Type._void())) {
            this.mv.visitInsn(177);
        } else if (returnType.isPrimitive()) {
            if (returnType.equals(Type._long())) {
                this.mv.visitInsn(173);
            } else if (returnType.equals(Type._float())) {
                this.mv.visitInsn(174);
            } else if (returnType.equals(Type._double())) {
                this.mv.visitInsn(175);
            } else {
                this.mv.visitInsn(172);
            }
        } else {
            this.mv.visitInsn(176);
        }
    }

    public void emitRet(Variable var) {
        VariableInternal ivar = (VariableInternal)var;
        assert (ivar.type().equals(Type._Object()));
        Integer slot = ASMUtil.stackFrameSlot.get(ivar);
        assert (slot != null);
        this.mv.visitVarInsn(169, slot.intValue());
    }

    public void emitConstantExpression(Type type, Object value) {
        if (type.equals(Type._null())) {
            this.mv.visitInsn(1);
        } else if (type.equals(Type._Class())) {
            Type vtype = (Type)Type.class.cast(value);
            com.sun.corba.ee.org.objectweb.asm.Type atype = com.sun.corba.ee.org.objectweb.asm.Type.getType((String)vtype.signature());
            this.mv.visitLdcInsn((Object)atype);
        } else if (type.equals(Type._String())) {
            this.mv.visitLdcInsn(value);
        } else if (type.equals(Type._float())) {
            float val = ((Float)Float.class.cast(value)).floatValue();
            if ((double)val == 0.0) {
                this.mv.visitInsn(11);
            } else if ((double)val == 1.0) {
                this.mv.visitInsn(12);
            } else if ((double)val == 2.0) {
                this.mv.visitInsn(13);
            } else {
                this.mv.visitLdcInsn(value);
            }
        } else if (type.equals(Type._double())) {
            double val = (Double)Double.class.cast(value);
            if (val == 0.0) {
                this.mv.visitInsn(14);
            } else if (val == 1.0) {
                this.mv.visitInsn(15);
            } else {
                this.mv.visitLdcInsn(value);
            }
        } else if (type.equals(Type._long())) {
            long val = (Long)Long.class.cast(value);
            if (val == 0L) {
                this.mv.visitInsn(9);
            } else if (val == 1L) {
                this.mv.visitInsn(10);
            } else {
                this.mv.visitLdcInsn(value);
            }
        } else if (type.equals(Type._boolean())) {
            this.mv.visitInsn((Boolean)Boolean.class.cast(value) != false ? 4 : 3);
        } else {
            int val = (Integer)Integer.class.cast(value);
            if (val == -1) {
                this.mv.visitInsn(2);
            } else if (val == 0) {
                this.mv.visitInsn(3);
            } else if (val == 1) {
                this.mv.visitInsn(4);
            } else if (val == 2) {
                this.mv.visitInsn(5);
            } else if (val == 3) {
                this.mv.visitInsn(6);
            } else if (val == 4) {
                this.mv.visitInsn(7);
            } else if (val == 5) {
                this.mv.visitInsn(8);
            } else if (val >= -128 && val <= 127) {
                this.mv.visitIntInsn(16, val);
            } else if (val >= Short.MIN_VALUE && val <= Short.MAX_VALUE) {
                this.mv.visitIntInsn(17, val);
            } else {
                this.mv.visitLdcInsn(value);
            }
        }
    }

    public void emitThisExpression() {
        this.mv.visitIntInsn(25, 0);
    }

    public void emitConditionalBranch(MyLabel falseBranch) {
        this.mv.visitJumpInsn(153, (Label)falseBranch);
    }

    public void emitBranch(MyLabel target) {
        this.mv.visitJumpInsn(167, (Label)target);
    }

    public void emitLabel(Attribute<MyLabel> attr, Node node) {
        if (attr.isSet(node)) {
            MyLabel label = attr.get(node);
            if (label.emitted()) {
                if (this.debug) {
                    ((TraceMethodVisitor)TraceMethodVisitor.class.cast(this.mv)).getText().add("    Already emitted label " + (Object)((Object)label));
                }
            } else {
                int lineNumber = CodegenPrinter.lineNumberAttribute.get(node);
                if (lineNumber > 0) {
                    MethodGenerator mg = node.getAncestor(MethodGenerator.class);
                    ASMUtil.LineNumberTable lnt = ASMUtil.lineNumberTable.get(mg);
                    lnt.put(label, lineNumber);
                }
                label.emitted(true);
                this.mv.visitLabel((Label)label);
            }
        }
    }

    public void emitNewCall(Type type) {
        String typeName = ASMUtil.bcName(type);
        this.mv.visitTypeInsn(187, typeName);
        this.mv.visitInsn(89);
    }

    public void emitInstanceof(Type type) {
        String typeName = ASMUtil.bcName(type);
        this.mv.visitTypeInsn(193, typeName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void emitCast(Type from, Type to) {
        if (from.isPrimitive()) {
            if (!to.isPrimitive()) throw new IllegalArgumentException("Type " + from.name() + " is a primitive type, but type " + to.name() + " is a reference type: no conversion is possible");
            if (!from.isNumber() || !to.isNumber()) throw new IllegalArgumentException("No conversion is possible from " + from.name() + " to " + to.name());
            this.emitConversion(from, to);
            return;
        } else {
            if (to.isPrimitive()) {
                throw new IllegalArgumentException("Type " + from.name() + " is a reference type, but type " + to.name() + " is a primitive type: no conversion is possible");
            }
            String sig = to.isArray() ? to.signature() : ASMUtil.bcName(to);
            this.mv.visitTypeInsn(192, sig);
        }
    }

    public void emitDup() {
        this.mv.visitInsn(89);
    }

    public void emitArrayStore() {
        this.mv.visitInsn(83);
    }

    public int typeCode(Type type) {
        if (type.equals(Type._boolean())) {
            return 4;
        }
        if (type.equals(Type._byte())) {
            return 8;
        }
        if (type.equals(Type._char())) {
            return 5;
        }
        if (type.equals(Type._short())) {
            return 9;
        }
        if (type.equals(Type._int())) {
            return 10;
        }
        if (type.equals(Type._long())) {
            return 11;
        }
        if (type.equals(Type._float())) {
            return 6;
        }
        if (type.equals(Type._double())) {
            return 7;
        }
        throw new IllegalArgumentException("Can only get a NEWARRAY typecode for a primitive type");
    }

    public void emitNewArrayCall(Type type) {
        if (type.isPrimitive()) {
            this.mv.visitIntInsn(188, this.typeCode(type));
        } else {
            this.mv.visitTypeInsn(189, ASMUtil.bcName(type));
        }
    }

    public void emitStaticInvoke(Type type, String name, Signature sig) {
        this.mv.visitMethodInsn(184, ASMUtil.bcName(type), name, sig.signature());
    }

    public void emitInvoke(Type type, String name, Signature sig) {
        String sigString = sig.signature();
        ClassInfo targetInfo = type.classInfo();
        MethodInfo minfo = targetInfo.findMethodInfo(name, sig);
        if (minfo == null) {
            throw new IllegalArgumentException("Could not find a method " + name + " with signature " + sig + " in class " + targetInfo.name());
        }
        ClassInfo mcinfo = minfo.myClassInfo();
        boolean privateMethod = Modifier.isPrivate(minfo.modifiers());
        int opcode = mcinfo.isInterface() ? 185 : (privateMethod ? 183 : 182);
        String typeName = ASMUtil.bcName(mcinfo.thisType());
        this.mv.visitMethodInsn(opcode, typeName, name, sigString);
    }

    public void emitNewInvoke(Type type, Signature sig) {
        String typeName = ASMUtil.bcName(type);
        this.mv.visitMethodInsn(183, typeName, "<init>", sig.signature());
    }

    public void emitSpecialInvoke(Type type, String name, Signature sig) {
        String typeName = ASMUtil.bcName(type);
        this.mv.visitMethodInsn(183, typeName, name, sig.signature());
    }

    public void emitThrow() {
        this.mv.visitInsn(191);
    }

    public void emitExceptionTableEntry(Label start, Label end, Label handler, Type exceptionType) {
        String exceptionTypeName = exceptionType == null ? null : ASMUtil.bcName(exceptionType);
        this.mv.visitTryCatchBlock(start, end, handler, exceptionTypeName);
    }

    public void emitJsr(Label label) {
        this.mv.visitJumpInsn(168, label);
    }

    public void callEmitter(EmitterFactory.Emitter emitter) {
        emitter.evaluate(this.mv);
    }

    public void emitPop() {
        this.mv.visitInsn(87);
    }

    public void emitConversion(Type from, Type to) {
        if (!from.isNumber()) {
            throw new IllegalArgumentException("From type " + from.name() + " is not a numeric type");
        }
        if (!to.isNumber()) {
            throw new IllegalArgumentException("To type " + to.name() + " is not a numeric type");
        }
        int fromIndex = typeIndex.get(from);
        int toIndex = typeIndex.get(to);
        EmitterFactory.Emitter emitter = this.numericConversions[fromIndex][toIndex];
        emitter.evaluate(this.mv);
    }

    private void emitBooleanCodeForPrimitive(ExpressionFactory.BinaryOperatorExpression arg) {
        MyLabel internalLabel = new MyLabel();
        MyLabel exitLabel = ASMByteCodeVisitor.nextLabel(arg);
        if (!ifOpInstructions.containsKey((Object)arg.operator())) {
            throw new IllegalStateException("emitBooleanCode called with operator " + arg + ", which is not a relational operator");
        }
        this.mv.visitJumpInsn(ifOpInstructions.get((Object)arg.operator()).intValue(), (Label)internalLabel);
        this.mv.visitInsn(3);
        this.mv.visitJumpInsn(167, (Label)exitLabel);
        this.mv.visitLabel((Label)internalLabel);
        this.mv.visitInsn(4);
    }

    private void emitBooleanCodeForReference(ExpressionFactory.BinaryOperatorExpression arg) {
        MyLabel internalLabel = new MyLabel();
        MyLabel exitLabel = new MyLabel();
        if (arg.operator() == ExpressionFactory.BinaryOperator.EQ) {
            this.mv.visitJumpInsn(165, (Label)internalLabel);
        } else if (arg.operator() == ExpressionFactory.BinaryOperator.NE) {
            this.mv.visitJumpInsn(166, (Label)internalLabel);
        }
        this.mv.visitInsn(3);
        this.mv.visitJumpInsn(167, (Label)exitLabel);
        this.mv.visitLabel((Label)internalLabel);
        this.mv.visitInsn(4);
        this.mv.visitLabel((Label)exitLabel);
    }

    public void emitBinaryOperator(ExpressionFactory.BinaryOperatorExpression arg) {
        Type type = ((ExpressionInternal)arg.left()).type();
        ExpressionFactory.BinaryOperator op = arg.operator();
        if (type.isPrimitive()) {
            this.mv.visitInsn(opInstructions.get((Object)op).get(type).intValue());
            if (op.kind() == ExpressionFactory.BinaryOperatorKind.RELATIONAL) {
                this.emitBooleanCodeForPrimitive(arg);
            }
        } else if (op == ExpressionFactory.BinaryOperator.EQ || op == ExpressionFactory.BinaryOperator.NE) {
            this.emitBooleanCodeForReference(arg);
        } else {
            throw new IllegalStateException("Binary operator argument types are " + type.name() + " but operator is not EQ or NE");
        }
    }

    static {
        typeIndex.put(Type._byte(), 0);
        typeIndex.put(Type._short(), 1);
        typeIndex.put(Type._char(), 2);
        typeIndex.put(Type._int(), 3);
        typeIndex.put(Type._long(), 4);
        typeIndex.put(Type._float(), 5);
        typeIndex.put(Type._double(), 6);
        E_NOP = new EmitterFactory.NullEmitter();
        E_I2B = new EmitterFactory.SimpleEmitter(145);
        E_I2C = new EmitterFactory.SimpleEmitter(146);
        E_I2S = new EmitterFactory.SimpleEmitter(147);
        E_I2L = new EmitterFactory.SimpleEmitter(133);
        E_I2F = new EmitterFactory.SimpleEmitter(134);
        E_I2D = new EmitterFactory.SimpleEmitter(135);
        E_L2I = new EmitterFactory.SimpleEmitter(136);
        E_F2I = new EmitterFactory.SimpleEmitter(139);
        E_D2I = new EmitterFactory.SimpleEmitter(142);
        E_L2F = new EmitterFactory.SimpleEmitter(137);
        E_L2D = new EmitterFactory.SimpleEmitter(138);
        E_F2L = new EmitterFactory.SimpleEmitter(140);
        E_D2L = new EmitterFactory.SimpleEmitter(143);
        E_F2D = new EmitterFactory.SimpleEmitter(141);
        E_D2F = new EmitterFactory.SimpleEmitter(144);
        E_L2B = new EmitterFactory.CompoundEmitter(E_L2I, E_I2B);
        E_F2B = new EmitterFactory.CompoundEmitter(E_F2I, E_I2B);
        E_D2B = new EmitterFactory.CompoundEmitter(E_D2I, E_I2B);
        E_L2S = new EmitterFactory.CompoundEmitter(E_L2I, E_I2S);
        E_F2S = new EmitterFactory.CompoundEmitter(E_F2I, E_I2S);
        E_D2S = new EmitterFactory.CompoundEmitter(E_D2I, E_I2S);
        E_L2C = new EmitterFactory.CompoundEmitter(E_L2I, E_I2C);
        E_F2C = new EmitterFactory.CompoundEmitter(E_F2I, E_I2C);
        E_D2C = new EmitterFactory.CompoundEmitter(E_D2I, E_I2C);
        opInstructions = new HashMap<ExpressionFactory.BinaryOperator, Map<Type, Integer>>();
        ifOpInstructions = new HashMap<ExpressionFactory.BinaryOperator, Integer>();
        HashMap<Type, Integer> map = new HashMap<Type, Integer>();
        map.put(Type._boolean(), 100);
        map.put(Type._byte(), 100);
        map.put(Type._char(), 100);
        map.put(Type._short(), 100);
        map.put(Type._int(), 100);
        map.put(Type._long(), 148);
        map.put(Type._float(), 150);
        map.put(Type._double(), 152);
        opInstructions.put(ExpressionFactory.BinaryOperator.EQ, map);
        opInstructions.put(ExpressionFactory.BinaryOperator.NE, map);
        opInstructions.put(ExpressionFactory.BinaryOperator.GT, map);
        opInstructions.put(ExpressionFactory.BinaryOperator.GE, map);
        opInstructions.put(ExpressionFactory.BinaryOperator.LT, map);
        opInstructions.put(ExpressionFactory.BinaryOperator.LE, map);
        map.clear();
        map.put(Type._int(), 96);
        map.put(Type._long(), 97);
        map.put(Type._float(), 98);
        map.put(Type._double(), 99);
        opInstructions.put(ExpressionFactory.BinaryOperator.PLUS, map);
        map.clear();
        map.put(Type._int(), 100);
        map.put(Type._long(), 101);
        map.put(Type._float(), 102);
        map.put(Type._double(), 103);
        opInstructions.put(ExpressionFactory.BinaryOperator.MINUS, map);
        map.clear();
        map.put(Type._int(), 104);
        map.put(Type._long(), 105);
        map.put(Type._float(), 106);
        map.put(Type._double(), 107);
        opInstructions.put(ExpressionFactory.BinaryOperator.TIMES, map);
        map.clear();
        map.put(Type._int(), 108);
        map.put(Type._long(), 109);
        map.put(Type._float(), 110);
        map.put(Type._double(), 111);
        opInstructions.put(ExpressionFactory.BinaryOperator.DIV, map);
        map.clear();
        map.put(Type._int(), 112);
        map.put(Type._long(), 113);
        map.put(Type._float(), 114);
        map.put(Type._double(), 115);
        opInstructions.put(ExpressionFactory.BinaryOperator.REM, map);
        ifOpInstructions.put(ExpressionFactory.BinaryOperator.EQ, 153);
        ifOpInstructions.put(ExpressionFactory.BinaryOperator.NE, 154);
        ifOpInstructions.put(ExpressionFactory.BinaryOperator.GT, 157);
        ifOpInstructions.put(ExpressionFactory.BinaryOperator.GE, 156);
        ifOpInstructions.put(ExpressionFactory.BinaryOperator.LT, 155);
        ifOpInstructions.put(ExpressionFactory.BinaryOperator.LE, 158);
    }
}

