/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.MessageAndPath;
import org.hibernate.validator.internal.engine.PathImpl;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstraintValidatorContextImpl
implements ConstraintValidatorContext {
    private static final Log log = LoggerFactory.make();
    private final List<MessageAndPath> messageAndPaths = new ArrayList<MessageAndPath>(3);
    private final PathImpl basePath;
    private final ConstraintDescriptor<?> constraintDescriptor;
    private boolean defaultDisabled;

    public ConstraintValidatorContextImpl(PathImpl propertyPath, ConstraintDescriptor<?> constraintDescriptor) {
        this.basePath = PathImpl.createCopy(propertyPath);
        this.constraintDescriptor = constraintDescriptor;
    }

    @Override
    public final void disableDefaultConstraintViolation() {
        this.defaultDisabled = true;
    }

    @Override
    public final String getDefaultConstraintMessageTemplate() {
        return (String)this.constraintDescriptor.getAttributes().get("message");
    }

    @Override
    public final ConstraintValidatorContext.ConstraintViolationBuilder buildConstraintViolationWithTemplate(String messageTemplate) {
        return new ErrorBuilderImpl(messageTemplate, PathImpl.createCopy(this.basePath));
    }

    public final ConstraintDescriptor<?> getConstraintDescriptor() {
        return this.constraintDescriptor;
    }

    public final List<MessageAndPath> getMessageAndPathList() {
        if (this.defaultDisabled && this.messageAndPaths.size() == 0) {
            throw log.getAtLeastOneCustomMessageMustBeCreatedException();
        }
        ArrayList<MessageAndPath> returnedMessageAndPaths = new ArrayList<MessageAndPath>(this.messageAndPaths);
        if (!this.defaultDisabled) {
            returnedMessageAndPaths.add(new MessageAndPath(this.getDefaultConstraintMessageTemplate(), this.basePath));
        }
        return returnedMessageAndPaths;
    }

    class ErrorBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder {
        private String messageTemplate;
        private PathImpl propertyPath;

        ErrorBuilderImpl(String template, PathImpl path) {
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext addNode(String name) {
            this.propertyPath.addNode(name);
            return new NodeBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        @Override
        public ConstraintValidatorContext addConstraintViolation() {
            ConstraintValidatorContextImpl.this.messageAndPaths.add(new MessageAndPath(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }

    class InIterableNodeBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext {
        private final String messageTemplate;
        private final PathImpl propertyPath;
        private final String leafNodeName;

        InIterableNodeBuilderImpl(String template, PathImpl path, String nodeName) {
            this.messageTemplate = template;
            this.propertyPath = path;
            this.leafNodeName = nodeName;
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder inIterable() {
            this.propertyPath.makeLeafNodeIterable();
            return new InIterablePropertiesBuilderImpl(this.messageTemplate, this.propertyPath, this.leafNodeName);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            this.propertyPath.addNode(this.leafNodeName);
            return new InIterableNodeBuilderImpl(this.messageTemplate, this.propertyPath, name);
        }

        @Override
        public ConstraintValidatorContext addConstraintViolation() {
            this.propertyPath.addNode(this.leafNodeName);
            ConstraintValidatorContextImpl.this.messageAndPaths.add(new MessageAndPath(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }

    class InIterablePropertiesBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeContextBuilder {
        private final String messageTemplate;
        private final PathImpl propertyPath;
        private final String leafNodeName;

        InIterablePropertiesBuilderImpl(String template, PathImpl path, String nodeName) {
            this.messageTemplate = template;
            this.propertyPath = path;
            this.leafNodeName = nodeName;
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext atKey(Object key) {
            this.propertyPath.setLeafNodeMapKey(key);
            this.propertyPath.addNode(this.leafNodeName);
            return new NodeBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext atIndex(Integer index) {
            this.propertyPath.setLeafNodeIndex(index);
            this.propertyPath.addNode(this.leafNodeName);
            return new NodeBuilderImpl(this.messageTemplate, this.propertyPath);
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            this.propertyPath.addNode(this.leafNodeName);
            return new InIterableNodeBuilderImpl(this.messageTemplate, this.propertyPath, name);
        }

        @Override
        public ConstraintValidatorContext addConstraintViolation() {
            this.propertyPath.addNode(this.leafNodeName);
            ConstraintValidatorContextImpl.this.messageAndPaths.add(new MessageAndPath(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }

    class NodeBuilderImpl
    implements ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderDefinedContext {
        private final String messageTemplate;
        private final PathImpl propertyPath;

        NodeBuilderImpl(String template, PathImpl path) {
            this.messageTemplate = template;
            this.propertyPath = path;
        }

        @Override
        public ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addNode(String name) {
            return new InIterableNodeBuilderImpl(this.messageTemplate, this.propertyPath, name);
        }

        @Override
        public ConstraintValidatorContext addConstraintViolation() {
            ConstraintValidatorContextImpl.this.messageAndPaths.add(new MessageAndPath(this.messageTemplate, this.propertyPath));
            return ConstraintValidatorContextImpl.this;
        }
    }
}

