/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.ctl;

import com.sun.jndi.ldap.BasicControl;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.LdapCtx;
import java.io.IOException;
import javax.naming.NamingException;

public final class VirtualListViewResponseControl
extends BasicControl {
    public static final String OID = "2.16.840.1.113730.3.4.10";
    private int targetOffset;
    private int listSize;
    private int resultCode;
    private byte[] cookie = null;
    private static final long serialVersionUID = 7199084985976520165L;

    public VirtualListViewResponseControl(String string, boolean bl, byte[] byArray) throws IOException {
        super(string, bl, byArray);
        if (byArray != null && byArray.length > 0) {
            BerDecoder berDecoder = new BerDecoder(byArray, 0, byArray.length);
            berDecoder.parseSeq(null);
            this.targetOffset = berDecoder.parseInt();
            this.listSize = berDecoder.parseInt();
            this.resultCode = berDecoder.parseEnumeration();
            if (berDecoder.bytesLeft() > 0 && berDecoder.peekByte() == 4) {
                this.cookie = berDecoder.parseOctetString(4, null);
            }
        }
    }

    public byte[] getContextID() {
        return this.cookie;
    }

    public NamingException getException() {
        return LdapCtx.mapErrorCode(this.resultCode, null);
    }

    public int getListSize() {
        return this.listSize;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public int getTargetOffset() {
        return this.targetOffset;
    }
}

