/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LifecycleSupport {
    private Lifecycle lifecycle = null;
    private List<LifecycleListener> listeners = new ArrayList<LifecycleListener>();

    public LifecycleSupport(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    public List<LifecycleListener> findLifecycleListeners() {
        return this.listeners;
    }

    public void fireLifecycleEvent(String type, Object data) throws LifecycleException {
        LifecycleEvent event = new LifecycleEvent(this.lifecycle, type, data);
        Iterator<LifecycleListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            i.next().lifecycleEvent(event);
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.listeners.remove(listener);
    }

    public void removeLifecycleListeners() {
        this.listeners.clear();
    }
}

