/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.SlotTable;
import com.sun.corba.ee.impl.interceptors.SlotTableStack;
import com.sun.corba.ee.spi.logging.OMGSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;

public class PICurrent
extends LocalObject
implements Current {
    private static final OMGSystemException wrapper = OMGSystemException.self;
    private int slotCounter;
    private transient ORB myORB;
    private boolean orbInitializing;
    private transient ThreadLocal<SlotTableStack> threadLocalSlotTable = new ThreadLocal<SlotTableStack>(){

        @Override
        protected SlotTableStack initialValue() {
            return new SlotTableStack(PICurrent.this.myORB, PICurrent.this);
        }
    };

    PICurrent(ORB myORB) {
        this.myORB = myORB;
        this.orbInitializing = true;
        this.slotCounter = 0;
    }

    synchronized int getTableSize() {
        return this.slotCounter;
    }

    synchronized int allocateSlotId() {
        int slotId = this.slotCounter++;
        return slotId;
    }

    SlotTable getSlotTable() {
        SlotTable table = this.threadLocalSlotTable.get().peekSlotTable();
        return table;
    }

    void pushSlotTable() {
        SlotTableStack st = this.threadLocalSlotTable.get();
        st.pushSlotTable();
    }

    void popSlotTable() {
        SlotTableStack st = this.threadLocalSlotTable.get();
        st.popSlotTable();
    }

    public void set_slot(int id, Any data) throws InvalidSlot {
        if (this.orbInitializing) {
            throw wrapper.invalidPiCall3();
        }
        this.getSlotTable().set_slot(id, data);
    }

    public Any get_slot(int id) throws InvalidSlot {
        if (this.orbInitializing) {
            throw wrapper.invalidPiCall4();
        }
        return this.getSlotTable().get_slot(id);
    }

    void resetSlotTable() {
        this.getSlotTable().resetSlots();
    }

    void setORBInitializing(boolean init) {
        this.orbInitializing = init;
    }
}

