/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.PersistentManagerBase;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.web.ha.session.management.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplicationManagerBase
extends PersistentManagerBase {
    protected BackingStore backingStore;
    protected SessionFactory sessionFactory;
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock(true);
    private AtomicBoolean alreadyClosed = new AtomicBoolean(false);
    protected static final String name = "ReplicationManagerBase";
    protected Logger logger = LogDomains.getLogger(ReplicationManagerBase.class, (String)"javax.enterprise.system.container.web");
    protected boolean relaxCacheVersionSemantics = false;
    protected boolean disableJreplica = false;

    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    public abstract <T extends Serializable> void createBackingStore(String var1, String var2, Class<T> var3, HashMap var4);

    public Session createNewSession() {
        return this.sessionFactory.createSession((Manager)this);
    }

    public Session createEmptySession() {
        Session sess = this.sessionFactory.createSession((Manager)this);
        return sess;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setBackingStore(BackingStore backingStore) {
        this.backingStore = backingStore;
    }

    public void doRemove(String id) {
        try {
            this.backingStore.remove((Serializable)((Object)id));
        }
        catch (BackingStoreException e) {
            this.logger.warning("Failed to remove session from backing store");
        }
    }

    public boolean isSessionVersioningSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session findSession(String id, String version) throws IOException {
        try {
            long requiredVersion;
            Session loadedSession;
            block21: {
                Session cachedSession;
                long cachedVersion;
                block20: {
                    this.acquireReadLock();
                    if (this.alreadyClosed.get()) {
                        throw new IOException("Store already closed");
                    }
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("in findSession: version=" + version);
                    }
                    if (!this.isSessionIdValid(id) || version == null) {
                        Session session = null;
                        this.releaseReadLock();
                        return session;
                    }
                    loadedSession = null;
                    requiredVersion = 0L;
                    cachedVersion = -1L;
                    requiredVersion = Long.valueOf(version);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Required version " + requiredVersion);
                    }
                    if ((cachedSession = (Session)this.sessions.get(id)) != null) {
                        cachedVersion = cachedSession.getVersion();
                    }
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("findSession:cachedVersion=" + cachedVersion);
                    }
                    if (cachedVersion != requiredVersion && (!this.isRelaxCacheVersionSemantics() || cachedVersion <= requiredVersion)) break block20;
                    Session session = cachedSession;
                    this.releaseReadLock();
                    return session;
                }
                if (cachedVersion < requiredVersion && !this.isRelaxCacheVersionSemantics()) {
                    this.removeSessionFromManagerCache(cachedSession);
                    cachedSession = null;
                    cachedVersion = -1L;
                }
                loadedSession = requiredVersion != -1L ? this.swapIn(id, version) : this.swapIn(id);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("findSession:swappedInSession=" + loadedSession);
                }
                if (loadedSession != null && loadedSession.getVersion() >= cachedVersion) break block21;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("ReplicationManagerBase>>findSession:returning cached version:" + cachedVersion);
                }
                Session session = cachedSession;
                this.releaseReadLock();
                return session;
            }
            try {
                if (loadedSession.getVersion() < requiredVersion && !this.isRelaxCacheVersionSemantics()) {
                    loadedSession = null;
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("ReplicationManagerBase>>findSession:returning:" + loadedSession);
                }
            }
            catch (NumberFormatException ex) {
                this.logger.log(Level.INFO, "required version nfe ", ex);
            }
            Session session = loadedSession;
            return session;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public boolean isRelaxCacheVersionSemantics() {
        return this.relaxCacheVersionSemantics;
    }

    public void setRelaxCacheVersionSemantics(boolean value) {
        this.relaxCacheVersionSemantics = value;
    }

    public void removeSessionFromManagerCache(Session session) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>removeSessionFromManagerCache:session = " + session);
        }
        if (session == null) {
            return;
        }
        Session removed = (Session)this.sessions.remove(session.getIdInternal());
        if (removed != null && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Remove from manager cache id=" + session.getId());
        }
    }

    public void setDisableJreplica(boolean disableJreplica) {
        this.disableJreplica = disableJreplica;
    }

    public boolean isDisableJreplica() {
        return this.disableJreplica;
    }

    public void acquireReadLock() throws IOException {
        this.rwl.readLock().lock();
    }

    public void releaseReadLock() {
        this.rwl.readLock().unlock();
    }

    public void acquireWriteLock() {
        this.rwl.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.rwl.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        try {
            this.acquireWriteLock();
            if (this.alreadyClosed.compareAndSet(false, true)) {
                super.stop();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public abstract void doValveSave(Session var1);

    public abstract String getReplicaFromPredictor(String var1, String var2);
}

