/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.SSMessage;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsspi.ServerSession;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

class ServerSessionRunner {
    private final int SERVERSESSION_RUN = 0;
    private final int SERVERSESSION_STOP = 1;
    private final int SERVERSESSION_CLOSE = 2;
    private final int SERVERSESSION_RESET = 3;
    private SessionImpl session;
    private Vector serverSessionMessageQ = new Vector();
    private Object serverSessionSyncObj = new Object();
    private int serverSessionInProcess = 0;
    private Thread serverSessionThread = null;
    private boolean serverSessionInWait = false;
    private int serverSessionState = 0;
    private boolean reset = false;
    private MessageListener messageListener = null;
    protected MessageImpl currentMessage = null;

    public ServerSessionRunner(SessionImpl sessionImpl, MessageListener messageListener) {
        this.session = sessionImpl;
        this.messageListener = messageListener;
    }

    protected MessageListener getMessageListener() throws JMSException {
        return this.messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessageListener(MessageListener messageListener) throws JMSException {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.serverSessionInProcess > 0) {
                String string = AdministeredObject.cr.getKString("C4048");
                throw new IllegalStateException(string, "C4048");
            }
            this.messageListener = messageListener;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void run() {
        this.serverSessionProcessStart();
        this.currentMessage = null;
        int n = this.serverSessionMessageQ.size();
        this.serverSessionProcess(n);
        int i = 0;
        while (i < n) {
            block13: {
                try {
                    Object var7_8;
                    MessageImpl messageImpl;
                    this.checkState();
                    this.serverSessionPreOnMessage();
                    if (this.serverSessionState == 2 || this.reset) {
                        this.serverSessionProcess(i - n);
                        this.serverSessionMessageQ.clear();
                        return;
                    }
                    SSMessage sSMessage = (SSMessage)this.serverSessionMessageQ.elementAt(0);
                    this.currentMessage = messageImpl = sSMessage.message;
                    if (!sSMessage.isDMQMessage && messageImpl._isExpired()) {
                        this.serverSessionMessageQ.removeElementAt(0);
                        this.currentMessage = null;
                        this.session.acknowledgeExpired(messageImpl);
                        break block13;
                    }
                    if (sSMessage.serversession instanceof ServerSession) {
                        ((ServerSession)sSMessage.serversession).beforeMessageDelivery(messageImpl);
                    }
                    try {
                        try {
                            boolean bl = this.onMessage(messageImpl);
                            this.currentMessage = null;
                            this.serverSessionMessageQ.removeElementAt(0);
                            if (bl) {
                                this.session.acknowledge(messageImpl);
                            }
                        }
                        catch (JMSException jMSException) {
                            this.session.isRollbackOnly = true;
                            this.session.rollbackCause = jMSException;
                            throw new RuntimeException(jMSException.getMessage());
                        }
                        var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        var7_8 = null;
                        if (!(sSMessage.serversession instanceof ServerSession)) throw throwable;
                        ((ServerSession)sSMessage.serversession).afterMessageDelivery(messageImpl);
                        throw throwable;
                    }
                    if (sSMessage.serversession instanceof ServerSession) {
                        ((ServerSession)sSMessage.serversession).afterMessageDelivery(messageImpl);
                    }
                }
                catch (Throwable throwable) {
                    this.session.isRollbackOnly = true;
                    this.session.rollbackCause = throwable;
                    this.serverSessionProcess(i - n);
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    if (!(throwable instanceof RuntimeException)) throw new RuntimeException(throwable.getMessage());
                    throw (RuntimeException)throwable;
                }
            }
            this.serverSessionProcess(-1);
            ++i;
        }
    }

    private boolean onMessage(Message message) throws JMSException {
        boolean bl = true;
        try {
            this.messageListener.onMessage(message);
        }
        catch (RuntimeException runtimeException) {
            ExceptionHandler.rootLogger.log(Level.WARNING, runtimeException.getMessage(), runtimeException);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionProcessStart() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.serverSessionInProcess > 0) {
                String string = AdministeredObject.cr.getKString("C4048");
                throw new java.lang.IllegalStateException(string);
            }
            this.serverSessionInProcess = 1;
            this.serverSessionThread = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionProcess(int n) {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (n < 0) {
                this.serverSessionInProcess += n;
            } else {
                this.serverSessionInProcess = n;
                if (this.messageListener == null) {
                    this.serverSessionInProcess = 0;
                }
            }
            if (this.serverSessionInProcess <= 0) {
                this.serverSessionInProcess = 0;
                this.serverSessionThread = null;
                this.currentMessage = null;
                this.serverSessionSyncObj.notifyAll();
            }
            if (this.messageListener == null) {
                String string = AdministeredObject.cr.getKString("C4029");
                throw new java.lang.IllegalStateException(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionPreOnMessage() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            while (this.serverSessionState == 1 && !this.reset) {
                Object var5_2;
                try {
                    try {
                        this.serverSessionInWait = true;
                        this.serverSessionSyncObj.notifyAll();
                        this.serverSessionSyncObj.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        String string = AdministeredObject.cr.getKString("C4047");
                        throw new RuntimeException(string);
                    }
                    var5_2 = null;
                    this.serverSessionInWait = false;
                }
                catch (Throwable throwable) {
                    var5_2 = null;
                    this.serverSessionInWait = false;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverSessionRun() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            this.serverSessionState = 0;
            this.serverSessionSyncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serverSessionStop() throws JMSException {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.messageListener == null) {
                this.serverSessionState = 1;
                return;
            }
            if (this.serverSessionThread != Thread.currentThread()) {
                this.serverSessionState = 1;
                try {
                    long l = 0L;
                    while (this.serverSessionInProcess > 0 && !this.serverSessionInWait && this.serverSessionState == 1) {
                        if (l % 15000L == 0L) {
                            l = 0L;
                            SessionImpl.sessionLogger.log(Level.INFO, "Waiting for ServerSession runner" + this + " to stop ...");
                        }
                        this.serverSessionSyncObj.wait(1000L);
                        l += 1000L;
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (this.serverSessionInProcess <= 0 || this.serverSessionInWait || this.serverSessionState != 1) return;
                    ExceptionHandler.handleException((Exception)interruptedException, "C4047");
                }
            } else {
                String string = AdministeredObject.cr.getKString("C4048");
                throw new IllegalStateException(string, "C4048");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverSessionClose() throws JMSException {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.messageListener == null) {
                this.serverSessionState = 2;
                return;
            }
            this.serverSessionStop();
            this.serverSessionState = 2;
            this.serverSessionSyncObj.notifyAll();
        }
    }

    protected void loadMessage(MessageImpl messageImpl, javax.jms.ServerSession serverSession, boolean bl) {
        if (this.isReset()) {
            this.clear();
        }
        this.serverSessionMessageQ.addElement(new SSMessage(messageImpl, serverSession, bl));
    }

    protected Thread getCurrentThread() {
        return this.serverSessionThread;
    }

    protected void dump(PrintStream printStream) {
        printStream.println("------ ServerSessionRunner dump ------");
        printStream.println("session ID: " + this.session.sessionId);
        printStream.println("messageListener: " + this.messageListener);
        printStream.println("serverSessionInProcess: " + this.serverSessionInProcess);
        printStream.println("serverSessionThread: " + this.serverSessionThread);
        printStream.println("serverSessionState: " + this.serverSessionState);
        printStream.println("serverSessionInWait: " + this.serverSessionInWait);
        printStream.println("message queue size: " + this.serverSessionMessageQ.size());
        Enumeration enumeration = this.serverSessionMessageQ.elements();
        while (enumeration.hasMoreElements()) {
            ((Traceable)enumeration.nextElement()).dump(printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            this.serverSessionMessageQ.clear();
            if (this.serverSessionState == 3) {
                this.serverSessionState = this.SERVERSESSION_RUN;
            }
            this.reset = false;
        }
    }

    protected void reset() {
        this.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(boolean bl) {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (bl) {
                this.serverSessionState = 3;
                this.serverSessionSyncObj.notifyAll();
                return;
            }
            if (this.serverSessionState == 2) {
                return;
            }
            this.reset = true;
            if (this.serverSessionState == 3 || this.serverSessionState == 1) {
                this.serverSessionSyncObj.notifyAll();
                return;
            }
            try {
                this.serverSessionStop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.serverSessionState == 2) {
                return;
            }
            this.serverSessionRun();
        }
    }

    private void checkState() throws Exception {
        if (this.isReset()) {
            if (this.reset) {
                return;
            }
            throw new RuntimeException("Fail-over occurred, server session must be reset.");
        }
    }

    private boolean isReset() {
        return this.serverSessionState == 3 || this.reset;
    }

    public Hashtable getDebugState(boolean bl) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("serverSessionState", String.valueOf(this.serverSessionState));
        hashtable.put("serverSessionInProcess", String.valueOf(this.serverSessionInProcess));
        hashtable.put("serverSessionInWait", String.valueOf(this.serverSessionInWait));
        hashtable.put("reset", String.valueOf(this.reset));
        try {
            Thread thread = this.serverSessionThread;
            hashtable.put("serverSessionThread", thread == null ? "null" : thread.toString());
            Object object = null;
            hashtable.put("messageListener", object == null ? "null" : object.toString());
            MessageImpl messageImpl = this.currentMessage;
            hashtable.put("currentMessage", messageImpl == null ? "null" : messageImpl.getJMSMessageID());
        }
        catch (Throwable throwable) {
            ExceptionHandler.logCaughtException(throwable);
            throwable.printStackTrace();
        }
        return hashtable;
    }
}

