/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9;

import com.sun.enterprise.mgmt.transport.NetworkUtility;
import com.sun.enterprise.mgmt.transport.grizzly.grizzly1_9.MulticastConnectorHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.CallbackHandlerSelectionKeyAttachment;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorInstanceHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.ReusableUDPSelectorHandler;
import com.sun.grizzly.Role;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.async.UDPAsyncQueueReader;
import com.sun.grizzly.async.UDPAsyncQueueWriter;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Callable;
import java.util.logging.Level;

public class MulticastSelectorHandler
extends ReusableUDPSelectorHandler {
    private volatile InetAddress multicastAddress;
    private volatile NetworkInterface anInterface;
    private Object membershipKey;
    private final Method joinMethod;

    public MulticastSelectorHandler() {
        Method method;
        block4: {
            try {
                this.anInterface = NetworkUtility.getFirstNetworkInterface();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            method = null;
            try {
                method = DatagramChannel.class.getMethod("join", InetAddress.class, NetworkInterface.class);
            }
            catch (Throwable t) {
                method = null;
                if (!this.logger.isLoggable(Level.FINER)) break block4;
                this.logger.log(Level.FINER, "this JDK doesn't support DatagramChannel#join()", t);
            }
        }
        this.joinMethod = method;
    }

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        MulticastSelectorHandler copyHandler = (MulticastSelectorHandler)copy;
        copyHandler.anInterface = this.anInterface;
        copyHandler.membershipKey = this.membershipKey;
    }

    public void preSelect(Context ctx) throws IOException {
        if (this.asyncQueueReader == null) {
            this.asyncQueueReader = new UDPAsyncQueueReader((SelectorHandler)this);
        }
        if (this.asyncQueueWriter == null) {
            this.asyncQueueWriter = new UDPAsyncQueueWriter((SelectorHandler)this);
        }
        if (this.selector == null) {
            this.initSelector(ctx);
        } else {
            this.processPendingOperations(ctx);
        }
    }

    private void initSelector(Context ctx) throws IOException {
        try {
            block8: {
                this.isShutDown.set(false);
                this.connectorInstanceHandler = new ConnectorInstanceHandler.ConcurrentQueueDelegateCIH(this.getConnectorInstanceHandlerDelegate());
                this.datagramChannel = DatagramChannel.open();
                this.selector = Selector.open();
                if (this.role != Role.CLIENT) {
                    this.datagramSocket = this.datagramChannel.socket();
                    this.datagramSocket.setReuseAddress(this.reuseAddress);
                    if (this.inet == null) {
                        this.datagramSocket.bind(new InetSocketAddress(this.getPort()));
                    } else {
                        this.datagramSocket.bind(new InetSocketAddress(this.inet, this.getPort()));
                    }
                    this.datagramChannel.configureBlocking(false);
                    this.datagramChannel.register(this.selector, 1);
                    this.datagramSocket.setSoTimeout(this.serverTimeout);
                    if (this.multicastAddress != null && this.joinMethod != null) {
                        try {
                            this.membershipKey = this.joinMethod.invoke((Object)this.datagramChannel, this.multicastAddress, this.anInterface);
                        }
                        catch (Throwable t) {
                            if (!this.logger.isLoggable(Level.FINE)) break block8;
                            this.logger.log(Level.FINE, "Exception occured when tried to join datagram channel", t);
                        }
                    }
                }
            }
            ctx.getController().notifyReady();
        }
        catch (SocketException ex) {
            throw new BindException(ex.getMessage() + ": " + this.getPort());
        }
    }

    public void setMulticastAddress(String multicastAddress) throws UnknownHostException {
        if (multicastAddress != null) {
            this.multicastAddress = InetAddress.getByName(multicastAddress);
        }
    }

    public void setNetworkInterface(String networkInterfaceName) throws SocketException {
        NetworkInterface anInterface;
        if (networkInterfaceName != null && NetworkUtility.supportsMulticast(anInterface = NetworkInterface.getByName(networkInterfaceName))) {
            this.anInterface = anInterface;
        }
    }

    protected void onConnectOp(Context ctx, TCPSelectorHandler.ConnectChannelOperation connectChannelOp) throws IOException {
        SelectionKey key;
        block5: {
            DatagramChannel newDatagramChannel = (DatagramChannel)connectChannelOp.getChannel();
            SocketAddress remoteAddress = connectChannelOp.getRemoteAddress();
            CallbackHandler callbackHandler = connectChannelOp.getCallbackHandler();
            CallbackHandlerSelectionKeyAttachment attachment = new CallbackHandlerSelectionKeyAttachment(callbackHandler);
            key = newDatagramChannel.register(this.selector, 5, attachment);
            attachment.associateKey(key);
            try {
                InetAddress remoteInetAddress = InetAddress.getByName(((InetSocketAddress)remoteAddress).getHostName());
                if (remoteInetAddress.isMulticastAddress()) {
                    if (this.role == Role.CLIENT && this.joinMethod != null) {
                        this.joinMethod.invoke((Object)newDatagramChannel, remoteInetAddress, this.anInterface);
                    }
                } else {
                    newDatagramChannel.connect(remoteAddress);
                }
            }
            catch (Throwable t) {
                if (!this.logger.isLoggable(Level.FINE)) break block5;
                this.logger.log(Level.FINE, "Exception occured when tried to join or connect datagram channel", t);
            }
        }
        this.onConnectInterest(key, ctx);
    }

    protected Callable<ConnectorHandler> getConnectorInstanceHandlerDelegate() {
        return new Callable<ConnectorHandler>(){

            @Override
            public ConnectorHandler call() throws Exception {
                return new MulticastConnectorHandler();
            }
        };
    }
}

