/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.admin.cli;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MQJMXConnectorInfo {
    private String jmxServiceURL = null;
    private Map<String, ?> jmxConnectorEnv = null;
    private String asInstanceName = null;
    private String brokerInstanceName = null;
    private String brokerType = null;
    static Logger _logger = LogDomains.getLogger(MQJMXConnectorInfo.class, (String)"javax.enterprise.resource.jms");
    private JMXConnector connector = null;

    public MQJMXConnectorInfo(String asInstanceName, String brokerInstanceName, String brokerType, String jmxServiceURL, Map<String, ?> jmxConnectorEnv) {
        this.brokerInstanceName = brokerInstanceName;
        this.asInstanceName = asInstanceName;
        this.jmxServiceURL = jmxServiceURL;
        this.brokerType = brokerType;
        this.jmxConnectorEnv = jmxConnectorEnv;
        _logger.log(Level.FINE, "MQJMXConnectorInfo : brokerInstanceName " + brokerInstanceName + " ASInstanceName " + asInstanceName + " jmxServiceURL " + jmxServiceURL + " BrokerType " + brokerType + " jmxConnectorEnv " + jmxConnectorEnv);
    }

    public String getBrokerInstanceName() {
        return this.brokerInstanceName;
    }

    public String getBrokerType() {
        return this.brokerType;
    }

    public String getASInstanceName() {
        return this.asInstanceName;
    }

    public String getJMXServiceURL() {
        _logger.log(Level.FINE, "MQJMXConnectorInfo :: JMXServiceURL is " + this.jmxServiceURL);
        return this.jmxServiceURL;
    }

    public Map<String, ?> getJMXConnectorEnv() {
        return this.jmxConnectorEnv;
    }

    public MBeanServerConnection getMQMBeanServerConnection() throws ConnectorRuntimeException {
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "creating MBeanServerConnection to MQ JMXServer with " + this.getJMXServiceURL());
            }
            JMXServiceURL jmxServiceURL = new JMXServiceURL(this.getJMXServiceURL());
            this.connector = JMXConnectorFactory.connect(jmxServiceURL, this.jmxConnectorEnv);
            MBeanServerConnection mbsc = this.connector.getMBeanServerConnection();
            return mbsc;
        }
        catch (Exception e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
    }

    public void closeMQMBeanServerConnection() throws ConnectorRuntimeException {
        try {
            if (this.connector != null) {
                this.connector.close();
            }
        }
        catch (IOException e) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause((Throwable)e);
            throw cre;
        }
    }
}

