/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.selector;

import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import com.sun.messaging.jmq.util.selector.RegularExpression;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.selector.SelectorToken;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

public class Selector {
    public static boolean DEBUG = false;
    public static boolean VERBOSE_DEBUG = false;
    static final int INVALID = 500;
    static final int STARTING = 0;
    static final int OR = 1;
    static final int AND = 2;
    static final int NOT = 3;
    static final int NOT_EQUALS = 4;
    static final int LTE = 5;
    static final int LT = 6;
    static final int GTE = 7;
    static final int GT = 8;
    static final int EQUALS = 9;
    static final int UNARY_PLUS = 10;
    static final int UNARY_MINUS = 11;
    static final int MULTIPLY = 12;
    static final int DIVIDE = 13;
    static final int PLUS = 14;
    static final int MINUS = 15;
    static final int BETWEEN = 16;
    static final int NOT_BETWEEN = 17;
    static final int IN = 18;
    static final int NOT_IN = 19;
    static final int LIKE = 20;
    static final int ESCAPE = 21;
    static final int NOT_LIKE = 22;
    static final int IS_NULL = 23;
    static final int IS_NOT_NULL = 24;
    static final int IS = 25;
    static final int IS_NOT = 26;
    static final int LEFT_PAREN = 27;
    static final int RIGHT_PAREN = 28;
    static final int COMMA = 29;
    static final int IDENTIFIER = 101;
    static final int STRING = 102;
    static final int DOUBLE = 103;
    static final int LONG = 104;
    static final int TRUE = 105;
    static final int FALSE = 106;
    static final int JMS_FIELD = 107;
    static final int RANGE = 108;
    static final int LIST = 109;
    static final int WHITESPACE = 110;
    static final int NULL = 111;
    static final int UNKNOWN = 112;
    static final int RE = 113;
    static final int AND_MARKER = 200;
    static final int OR_MARKER = 201;
    private static boolean convertTypes = false;
    private static boolean shortCircuit = true;
    private boolean usesProperties = false;
    private boolean usesFields = false;
    private static HashMap keywords = null;
    private static HashSet headers = null;
    private String selector = null;
    private Object[] compiledSelector = null;
    private Stack stack = new Stack();
    private static WeakValueHashMap selectorCache = null;

    public static void setConvertTypes(boolean bl) {
        convertTypes = bl;
    }

    public static boolean getConvertTypes() {
        return convertTypes;
    }

    public static void setShortCircuit(boolean bl) {
        shortCircuit = bl;
    }

    public static boolean getShortCircuit() {
        return shortCircuit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selector compile(String string) throws SelectorFormatException {
        if (string == null || string.length() == 0) {
            return null;
        }
        Selector selector = null;
        WeakValueHashMap weakValueHashMap = selectorCache;
        synchronized (weakValueHashMap) {
            selector = (Selector)selectorCache.get(string);
            if (selector == null) {
                selector = new Selector(string);
                selector.compile();
                selectorCache.put(string, selector);
            }
        }
        return selector;
    }

    private Selector(String string) {
        this.selector = string;
    }

    public synchronized void compile() throws SelectorFormatException {
        LinkedList linkedList = this.tokenize(this.selector + " ");
        if (VERBOSE_DEBUG) {
            Selector.dumpTokens(linkedList);
        }
        linkedList = this.aggregate(linkedList);
        if (VERBOSE_DEBUG) {
            Selector.dumpTokens(linkedList);
            System.out.println();
        }
        linkedList = this.prepare(linkedList);
        if (VERBOSE_DEBUG) {
            Selector.dumpTokens(linkedList);
            System.out.println();
        }
        this.validate(linkedList);
        this.compiledSelector = this.convertToRPN(linkedList);
        if (DEBUG) {
            System.out.println(this.toDebugString());
        }
        this.match(new HashMap(0), new HashMap(0));
    }

    private LinkedList tokenize(String string) throws SelectorFormatException {
        LinkedList<SelectorToken> linkedList = new LinkedList<SelectorToken>();
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(80);
        int n3 = 0;
        int n4 = 0;
        int n5 = 10;
        int n6 = 0;
        for (n6 = 0; n6 < n; ++n6) {
            char c = string.charAt(n6);
            Object object = null;
            block4 : switch (n2) {
                case 0: {
                    stringBuffer.delete(0, stringBuffer.length());
                    switch (c) {
                        case ',': {
                            n3 = 29;
                            stringBuffer.append(c);
                            object = stringBuffer.toString();
                            break block4;
                        }
                        case '=': {
                            if (n4 == 9) {
                                throw new SelectorFormatException("Invalid operator ==, use =", string, n6);
                            }
                            n3 = 9;
                            stringBuffer.append(c);
                            object = stringBuffer.toString();
                            break block4;
                        }
                        case '/': {
                            n3 = 13;
                            stringBuffer.append(c);
                            object = stringBuffer.toString();
                            break block4;
                        }
                        case '*': {
                            n3 = 12;
                            stringBuffer.append(c);
                            object = stringBuffer.toString();
                            break block4;
                        }
                        case '(': {
                            n3 = 27;
                            stringBuffer.append(c);
                            object = stringBuffer.toString();
                            break block4;
                        }
                        case ')': {
                            n3 = 28;
                            stringBuffer.append(c);
                            object = stringBuffer.toString();
                            break block4;
                        }
                        case '-': {
                            if (n4 == 0 || Selector.isOperator(n4) && n4 != 28) {
                                n3 = 11;
                                stringBuffer.append(c);
                                object = stringBuffer.toString();
                                break block4;
                            }
                            n3 = 15;
                            stringBuffer.append(c);
                            object = stringBuffer.toString();
                            break block4;
                        }
                        case '+': {
                            if (n4 == 0 || Selector.isOperator(n4) && n4 != 28) {
                                n3 = 10;
                                stringBuffer.append(c);
                                object = stringBuffer.toString();
                                break block4;
                            }
                            n3 = 14;
                            stringBuffer.append(c);
                            object = stringBuffer.toString();
                            break block4;
                        }
                        case '>': {
                            stringBuffer.append(c);
                            n2 = 1;
                            break block4;
                        }
                        case '<': {
                            stringBuffer.append(c);
                            n2 = 2;
                            break block4;
                        }
                        case '\'': {
                            n2 = 9;
                            break block4;
                        }
                        case '.': {
                            stringBuffer.append(c);
                            n2 = 6;
                            break block4;
                        }
                        case '0': {
                            stringBuffer.append(c);
                            n2 = 3;
                            break block4;
                        }
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        stringBuffer.append(c);
                        n2 = 11;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        stringBuffer.append(c);
                        n2 = 5;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        n3 = 110;
                        break;
                    }
                    throw new SelectorFormatException("Invalid character " + c, string, n6);
                }
                case 1: {
                    switch (c) {
                        case '=': {
                            stringBuffer.append(c);
                            n3 = 7;
                            object = stringBuffer.toString();
                            n2 = 0;
                            break block4;
                        }
                    }
                    n3 = 8;
                    object = stringBuffer.toString();
                    n2 = 0;
                    --n6;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '=': {
                            stringBuffer.append(c);
                            n3 = 5;
                            object = stringBuffer.toString();
                            n2 = 0;
                            break block4;
                        }
                        case '>': {
                            stringBuffer.append(c);
                            n3 = 4;
                            object = stringBuffer.toString();
                            n2 = 0;
                            break block4;
                        }
                    }
                    n3 = 6;
                    object = stringBuffer.toString();
                    n2 = 0;
                    --n6;
                    break;
                }
                case 3: {
                    if (c == 'x' || c == 'X') {
                        n5 = 16;
                        n2 = 5;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        n5 = 8;
                        stringBuffer.append(c);
                        n2 = 5;
                        break;
                    }
                    --n6;
                    n2 = 5;
                    break;
                }
                case 5: {
                    if (n5 == 16 && this.isHexDigit(c) || Character.isDigit(c)) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (c == '.') {
                        stringBuffer.append(c);
                        n2 = 6;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        stringBuffer.append(c);
                        n2 = 7;
                        break;
                    }
                    n3 = 104;
                    if (n4 == 11) {
                        stringBuffer.insert(0, '-');
                        linkedList.removeLast();
                    }
                    try {
                        object = Long.valueOf(stringBuffer.toString(), n5);
                        n5 = 10;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SelectorFormatException("Invalid numeric constant: " + numberFormatException.getMessage(), string, n6);
                    }
                    n2 = 0;
                    if (c == 'l' || c == 'L') break;
                    --n6;
                    break;
                }
                case 6: {
                    if (Character.isDigit(c)) {
                        stringBuffer.append(c);
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        stringBuffer.append(c);
                        n2 = 7;
                        break;
                    }
                    n3 = 103;
                    try {
                        object = Double.valueOf(stringBuffer.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SelectorFormatException("Invalid numeric constant: " + numberFormatException.getMessage(), string, n6);
                    }
                    n2 = 0;
                    if (c == 'd' || c == 'D' || c == 'f' || c == 'F') break;
                    --n6;
                    break;
                }
                case 7: {
                    if (Character.isDigit(c)) {
                        stringBuffer.append(c);
                        n2 = 8;
                        break;
                    }
                    if (c == '-') {
                        stringBuffer.append(c);
                        n2 = 8;
                        break;
                    }
                    n3 = 103;
                    try {
                        object = Double.valueOf(stringBuffer.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SelectorFormatException("Invalid numeric constant: " + numberFormatException.getMessage(), string, n6);
                    }
                    n2 = 0;
                    if (c == 'd' || c == 'D' || c == 'f' || c == 'F') break;
                    --n6;
                    break;
                }
                case 8: {
                    if (Character.isDigit(c)) {
                        stringBuffer.append(c);
                        break;
                    }
                    n3 = 103;
                    try {
                        object = Double.valueOf(stringBuffer.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SelectorFormatException("Invalid numeric constant: " + numberFormatException.getMessage(), string, n6);
                    }
                    n2 = 0;
                    if (c == 'd' || c == 'D' || c == 'f' || c == 'F') break;
                    --n6;
                    break;
                }
                case 9: {
                    if (c == '\'') {
                        n2 = 10;
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 10: {
                    if (c == '\'') {
                        n2 = 9;
                        stringBuffer.append(c);
                        break;
                    }
                    n3 = 102;
                    object = stringBuffer.toString();
                    n2 = 0;
                    --n6;
                    break;
                }
                case 11: {
                    if (Character.isJavaIdentifierPart(c)) {
                        stringBuffer.append(c);
                        break;
                    }
                    object = stringBuffer.toString();
                    n3 = this.identifierToKeyWord((String)object);
                    n2 = 0;
                    --n6;
                    break;
                }
                default: {
                    throw new SelectorFormatException("Selector tokenizer in bad state: " + n2 + " tokenBuf=" + stringBuffer + " char=" + c, string, n6);
                }
            }
            if (n3 == 101) {
                this.usesProperties = true;
            } else if (n3 == 107) {
                this.usesFields = true;
            }
            if (n2 == 0 && n3 == 500) {
                throw new SelectorFormatException("Unknown token: " + n3 + " tokenBuf=" + stringBuffer, string, n6);
            }
            if (n2 != 0 || n3 == 110) continue;
            linkedList.add(SelectorToken.getInstance(n3, object));
            n4 = n3;
            n5 = 10;
        }
        if (n2 == 9) {
            throw new SelectorFormatException("Missing closing quote", string, n6);
        }
        if (n2 != 0) {
            throw new SelectorFormatException("Invalid Expression", string, n6);
        }
        return linkedList;
    }

    private int identifierToKeyWord(String string) {
        Integer n = (Integer)keywords.get(string.toUpperCase());
        if (n != null) {
            return n;
        }
        if (string.startsWith("JMS")) {
            if (headers.contains(string)) {
                return 107;
            }
            return 101;
        }
        return 101;
    }

    private boolean isHexDigit(char c) {
        return Character.isDigit(c) || c == 'a' || c == 'A' || c == 'b' || c == 'B' || c == 'c' || c == 'C' || c == 'd' || c == 'D' || c == 'e' || c == 'E' || c == 'f' || c == 'F';
    }

    private LinkedList aggregate(LinkedList linkedList) throws SelectorFormatException {
        LinkedList<SelectorToken> linkedList2 = new LinkedList<SelectorToken>();
        int n = linkedList.size();
        block4: for (int i = 0; i < n; ++i) {
            SelectorToken selectorToken = (SelectorToken)linkedList.get(i);
            SelectorToken selectorToken2 = null;
            SelectorToken selectorToken3 = null;
            if (i + 1 < n) {
                selectorToken2 = (SelectorToken)linkedList.get(i + 1);
            }
            if (i + 2 < n) {
                selectorToken3 = (SelectorToken)linkedList.get(i + 2);
            }
            switch (selectorToken.getToken()) {
                case 3: {
                    if (selectorToken2 == null) {
                        linkedList2.add(selectorToken);
                        continue block4;
                    }
                    if (selectorToken2.getToken() == 16) {
                        linkedList2.add(SelectorToken.getInstance(17, (String)selectorToken.getValue() + " " + (String)selectorToken2.getValue()));
                        ++i;
                        continue block4;
                    }
                    if (selectorToken2.getToken() == 18) {
                        linkedList2.add(SelectorToken.getInstance(19, (String)selectorToken.getValue() + " " + (String)selectorToken2.getValue()));
                        ++i;
                        continue block4;
                    }
                    if (selectorToken2.getToken() == 20) {
                        linkedList2.add(SelectorToken.getInstance(22, (String)selectorToken.getValue() + " " + (String)selectorToken2.getValue()));
                        ++i;
                        continue block4;
                    }
                    linkedList2.add(selectorToken);
                    continue block4;
                }
                case 25: {
                    if (selectorToken2 == null) {
                        linkedList2.add(selectorToken);
                        continue block4;
                    }
                    if (selectorToken2.getToken() == 111) {
                        linkedList2.add(SelectorToken.getInstance(23, (String)selectorToken.getValue() + " " + (String)selectorToken2.getValue()));
                        ++i;
                        continue block4;
                    }
                    if (selectorToken2.getToken() == 3) {
                        if (selectorToken3 == null) {
                            linkedList2.add(SelectorToken.getInstance(26, (String)selectorToken.getValue() + " " + (String)selectorToken2.getValue()));
                            ++i;
                            continue block4;
                        }
                        if (selectorToken3.getToken() == 111) {
                            linkedList2.add(SelectorToken.getInstance(24, (String)selectorToken.getValue() + " " + (String)selectorToken2.getValue() + " " + (String)selectorToken3.getValue()));
                            ++i;
                            ++i;
                            continue block4;
                        }
                        linkedList2.add(SelectorToken.getInstance(26, (String)selectorToken.getValue() + " " + (String)selectorToken2.getValue()));
                        ++i;
                        continue block4;
                    }
                    linkedList2.add(selectorToken);
                    continue block4;
                }
                default: {
                    linkedList2.add(selectorToken);
                }
            }
        }
        return linkedList2;
    }

    private LinkedList prepare(LinkedList linkedList) throws SelectorFormatException {
        LinkedList<SelectorToken> linkedList2 = new LinkedList<SelectorToken>();
        int n = linkedList.size();
        block5: for (int i = 0; i < n; ++i) {
            SelectorToken selectorToken = (SelectorToken)linkedList.get(i);
            switch (selectorToken.getToken()) {
                case 16: 
                case 17: {
                    linkedList2.add(selectorToken);
                    ++i;
                    while (i < n) {
                        selectorToken = (SelectorToken)linkedList.get(i);
                        if (selectorToken.getToken() == 2) {
                            linkedList2.add(SelectorToken.getInstance(29, ","));
                            continue block5;
                        }
                        linkedList2.add(selectorToken);
                        ++i;
                    }
                    continue block5;
                }
                case 18: 
                case 19: {
                    linkedList2.add(selectorToken);
                    selectorToken = (SelectorToken)linkedList.get(++i);
                    if (selectorToken.getToken() != 27) {
                        throw new SelectorFormatException("Missing ( in IN statement", this.selector);
                    }
                    ++i;
                    HashSet<Object> hashSet = new HashSet<Object>();
                    while (i < n && (selectorToken = (SelectorToken)linkedList.get(i)).getToken() != 28) {
                        if (selectorToken.getToken() == 29) {
                            ++i;
                            continue;
                        }
                        if (selectorToken.getToken() != 102) {
                            throw new SelectorFormatException("IN requires string literal: " + selectorToken.getValue(), this.selector);
                        }
                        hashSet.add(selectorToken.getValue());
                        ++i;
                    }
                    linkedList2.add(SelectorToken.getInstance(109, hashSet));
                    continue block5;
                }
                case 20: 
                case 22: {
                    linkedList2.add(selectorToken);
                    selectorToken = (SelectorToken)linkedList.get(++i);
                    if (selectorToken.getToken() != 102) {
                        throw new SelectorFormatException("LIKE requires string literal: " + selectorToken.getValue(), this.selector);
                    }
                    String string = (String)selectorToken.getValue();
                    String string2 = null;
                    if (++i < n) {
                        selectorToken = (SelectorToken)linkedList.get(i);
                        if (selectorToken.getToken() == 21) {
                            if ((selectorToken = (SelectorToken)linkedList.get(++i)).getToken() != 102) {
                                throw new SelectorFormatException("ESCAPE requires string literal: " + selectorToken.getValue(), this.selector);
                            }
                            string2 = (String)selectorToken.getValue();
                        } else {
                            --i;
                        }
                    }
                    linkedList2.add(SelectorToken.getInstance(113, new RegularExpression(string, string2)));
                    continue block5;
                }
                default: {
                    linkedList2.add(selectorToken);
                }
            }
        }
        return linkedList2;
    }

    private void validate(LinkedList linkedList) throws SelectorFormatException {
        int n = linkedList.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            SelectorToken selectorToken = (SelectorToken)linkedList.get(i);
            if (!Selector.isOperator(selectorToken)) {
                if (n2 != 0 && !Selector.isOperator(n2)) {
                    throw new SelectorFormatException("Missing operator", this.selector);
                }
            } else if (n2 == selectorToken.getToken() && n2 != 27 && n2 != 28) {
                throw new SelectorFormatException("Missing operand", this.selector);
            }
            n2 = selectorToken.getToken();
        }
    }

    private Object[] convertToRPN(LinkedList linkedList) throws SelectorFormatException {
        Stack<SelectorToken> stack = new Stack<SelectorToken>();
        Object[] objectArray = new Object[(int)((double)linkedList.size() * 1.5)];
        int n = 0;
        for (SelectorToken selectorToken : linkedList) {
            if (!Selector.isOperator(selectorToken)) {
                objectArray[n++] = selectorToken;
                continue;
            }
            if (selectorToken.getToken() == 27) {
                stack.push(selectorToken);
                continue;
            }
            SelectorToken selectorToken2 = null;
            if (selectorToken.getToken() == 28) {
                do {
                    if (stack.empty()) {
                        throw new SelectorFormatException("Missing (", this.selector);
                    }
                    selectorToken2 = (SelectorToken)stack.pop();
                    if (selectorToken2.getToken() == 27) continue;
                    objectArray[n++] = selectorToken2;
                } while (selectorToken2.getToken() != 27);
                continue;
            }
            while (!stack.empty() && (selectorToken2 = (SelectorToken)stack.peek()).getToken() != 27 && Selector.getPrecedence(selectorToken2) >= Selector.getPrecedence(selectorToken)) {
                objectArray[n++] = (SelectorToken)stack.pop();
            }
            stack.push(selectorToken);
            if (!shortCircuit) continue;
            if (selectorToken.getToken() == 2) {
                objectArray[n++] = SelectorToken.getInstance(200);
                continue;
            }
            if (selectorToken.getToken() != 1) continue;
            objectArray[n++] = SelectorToken.getInstance(201);
        }
        while (!stack.empty()) {
            objectArray[n] = (SelectorToken)stack.pop();
            if (((SelectorToken)objectArray[n]).getToken() == 27) {
                throw new SelectorFormatException("Missing )", this.selector);
            }
            ++n;
        }
        return objectArray;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean match(Map var1_1, Map var2_2) throws SelectorFormatException {
        this.stack.clear();
        var7_3 = 0;
lbl3:
        // 3 sources

        try {
            block19: for (var8_4 = 0; var8_4 < this.compiledSelector.length && (var3_7 = (SelectorToken)this.compiledSelector[var8_4]) != null; ++var8_4) {
                block59: {
                    block60: {
                        if (!Selector.shortCircuit) break block59;
                        if (var3_7.getToken() != 200) break block60;
                        var9_10 = ((SelectorToken)this.stack.peek()).getToken();
                        if (var9_10 != 106) continue;
                        var7_3 = 1;
                        while (var7_3 > 0) {
                            if ((var3_7 = (SelectorToken)this.compiledSelector[++var8_4]).getToken() == 200) {
                                ++var7_3;
                                continue;
                            }
                            if (var3_7.getToken() != 2) continue;
                            --var7_3;
                        }
                        ** GOTO lbl3
                    }
                    if (var3_7.getToken() != 201) break block59;
                    var9_11 = ((SelectorToken)this.stack.peek()).getToken();
                    if (var9_11 != 105) continue;
                    var7_3 = 1;
                    while (var7_3 > 0) {
                        if ((var3_7 = (SelectorToken)this.compiledSelector[++var8_4]).getToken() == 201) {
                            ++var7_3;
                            continue;
                        }
                        if (var3_7.getToken() != 1) continue;
                        --var7_3;
                    }
                    ** GOTO lbl3
                }
                if (!Selector.isOperator(var3_7)) {
                    if (var3_7.getToken() == 101) {
                        var9_12 = var1_1 == null ? null : var1_1.get((String)var3_7.getValue());
                        if (var9_12 == null) {
                            this.stack.push(SelectorToken.getInstance(112, null));
                            continue;
                        }
                        this.stack.push(this.propertyToToken(var9_12));
                        continue;
                    }
                    if (var3_7.getToken() == 107) {
                        var9_13 = var2_2 == null ? null : var2_2.get((String)var3_7.getValue());
                        if (var9_13 == null) {
                            this.stack.push(SelectorToken.getInstance(112, null));
                            continue;
                        }
                        this.stack.push(this.propertyToToken(var9_13));
                        continue;
                    }
                    this.stack.push(var3_7);
                    continue;
                }
                if (var3_7.getToken() == 29) continue;
                var4_8 = (SelectorToken)this.stack.pop();
                switch (var3_7.getToken()) {
                    case 1: {
                        var5_9 = (SelectorToken)this.stack.pop();
                        if (var4_8.getToken() == 105 || var5_9.getToken() == 105) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        if (var4_8.getToken() == 106 && var5_9.getToken() == 106) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(112));
                        continue block19;
                    }
                    case 2: {
                        var5_9 = (SelectorToken)this.stack.pop();
                        if (var4_8.getToken() == 105 && var5_9.getToken() == 105) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        if (var4_8.getToken() == 106 || var5_9.getToken() == 106) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(112));
                        continue block19;
                    }
                    case 3: {
                        if (var4_8.getToken() == 105) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (var4_8.getToken() == 106) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(112));
                        continue block19;
                    }
                    case 9: {
                        var5_9 = (SelectorToken)this.stack.pop();
                        if (Selector.isNumeric(var4_8) || Selector.isNumeric(var5_9)) {
                            this.stack.push(this.doNumericOperation(var3_7, var5_9, var4_8));
                            continue block19;
                        }
                        if (var4_8.equals(var5_9)) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(106));
                        continue block19;
                    }
                    case 4: {
                        var5_9 = (SelectorToken)this.stack.pop();
                        if (Selector.isNumeric(var4_8) || Selector.isNumeric(var5_9)) {
                            this.stack.push(this.doNumericOperation(var3_7, var5_9, var4_8));
                            continue block19;
                        }
                        if (var4_8.equals(var5_9)) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(105));
                        continue block19;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        var5_9 = (SelectorToken)this.stack.pop();
                        this.stack.push(this.doNumericOperation(var3_7, var5_9, var4_8));
                        continue block19;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        var5_9 = (SelectorToken)this.stack.pop();
                        this.stack.push(this.doNumericOperation(var3_7, var5_9, var4_8));
                        continue block19;
                    }
                    case 11: {
                        this.stack.push(this.doNumericOperation(var3_7, var4_8, null));
                        continue block19;
                    }
                    case 10: {
                        this.stack.push(this.doNumericOperation(var3_7, var4_8, null));
                        continue block19;
                    }
                    case 16: 
                    case 17: {
                        var9_14 = var4_8;
                        var10_15 = (SelectorToken)this.stack.pop();
                        var11_16 = (SelectorToken)this.stack.pop();
                        var12_17 = false;
                        if (this.doNumericOperation(SelectorToken.getInstance(7), var11_16, var10_15).getToken() == 105 && this.doNumericOperation(SelectorToken.getInstance(5), var11_16, var9_14).getToken() == 105) {
                            var12_17 = true;
                        }
                        if (var3_7.getToken() == 16) {
                            if (var12_17) {
                                this.stack.push(SelectorToken.getInstance(105));
                                continue block19;
                            }
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (var12_17) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(105));
                        continue block19;
                    }
                    case 18: 
                    case 19: {
                        var5_9 = (SelectorToken)this.stack.pop();
                        if (!(var5_9.getValue() instanceof String)) {
                            throw new SelectorFormatException("IN requires string operand: " + var5_9.getValue(), this.selector);
                        }
                        var13_18 = (HashSet)var4_8.getValue();
                        if (var5_9.getToken() == 112) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (var13_18.contains((String)var5_9.getValue())) {
                            if (var3_7.getToken() == 18) {
                                this.stack.push(SelectorToken.getInstance(105));
                                continue block19;
                            }
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (var3_7.getToken() == 18) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(105));
                        continue block19;
                    }
                    case 20: 
                    case 22: {
                        var5_9 = (SelectorToken)this.stack.pop();
                        if (!(var5_9.getValue() instanceof String)) {
                            throw new SelectorFormatException("LIKE requires string operand: " + var5_9.getValue(), this.selector);
                        }
                        var14_19 = (RegularExpression)var4_8.getValue();
                        if (var5_9.getToken() == 112) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (var14_19.match((String)var5_9.getValue())) {
                            if (var3_7.getToken() == 20) {
                                this.stack.push(SelectorToken.getInstance(105));
                                continue block19;
                            }
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (var3_7.getToken() == 20) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(105));
                        continue block19;
                    }
                    case 23: {
                        if (var4_8.getToken() == 112) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(106));
                        continue block19;
                    }
                    case 24: {
                        if (var4_8.getToken() != 112) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(106));
                        continue block19;
                    }
                    default: {
                        throw new SelectorFormatException("Unknown operator: " + var3_7, this.selector);
                    }
                }
            }
            var3_7 = (SelectorToken)this.stack.pop();
        }
        catch (EmptyStackException var8_5) {
            throw new SelectorFormatException("Missing operand", this.selector);
        }
        catch (ArithmeticException var8_6) {
            throw new SelectorFormatException(var8_6.toString(), this.selector);
        }
        if (!this.stack.empty()) {
            throw new SelectorFormatException("Missing operator", this.selector);
        }
        if (var3_7.getToken() == 105) {
            return true;
        }
        if (var3_7.getToken() == 106) {
            return false;
        }
        if (var3_7.getToken() == 112) {
            return false;
        }
        throw new SelectorFormatException("Non-boolean expression", this.selector);
    }

    private SelectorToken propertyToToken(Object object) {
        if (object instanceof String) {
            return SelectorToken.getInstance(102, object);
        }
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (bl) {
                return SelectorToken.getInstance(105);
            }
            return SelectorToken.getInstance(106);
        }
        if (object instanceof Double) {
            return SelectorToken.getInstance(103, object);
        }
        if (object instanceof Float) {
            double d = ((Float)object).floatValue();
            return SelectorToken.getInstance(103, new Double(d));
        }
        if (object instanceof Long) {
            return SelectorToken.getInstance(104, object);
        }
        if (object instanceof Integer) {
            long l = ((Integer)object).intValue();
            return SelectorToken.getInstance(104, new Long(l));
        }
        if (object instanceof Short) {
            long l = ((Short)object).shortValue();
            return SelectorToken.getInstance(104, new Long(l));
        }
        if (object instanceof Byte) {
            long l = ((Byte)object).byteValue();
            return SelectorToken.getInstance(104, new Long(l));
        }
        return null;
    }

    private SelectorToken convertStringToNumber(String string) throws SelectorFormatException {
        try {
            Long l = Long.valueOf(string);
            return SelectorToken.getInstance(104, l);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double d = Double.valueOf(string);
                return SelectorToken.getInstance(103, d);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new SelectorFormatException("Cannot convert string to number '" + string + "'", this.selector);
            }
        }
    }

    private SelectorToken doNumericOperation(SelectorToken selectorToken, SelectorToken selectorToken2, SelectorToken selectorToken3) throws SelectorFormatException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        long l = 0L;
        long l2 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        if (!Selector.isNumeric(selectorToken2) && selectorToken2.getToken() != 112) {
            if (convertTypes && selectorToken2.getToken() == 102) {
                selectorToken2 = this.convertStringToNumber((String)selectorToken2.getValue());
            } else {
                throw new SelectorFormatException("Non-numeric argument '" + selectorToken2.getValue() + "'", this.selector);
            }
        }
        if (selectorToken3 != null && !Selector.isNumeric(selectorToken3) && selectorToken3.getToken() != 112) {
            if (convertTypes && selectorToken3.getToken() == 102) {
                selectorToken3 = this.convertStringToNumber((String)selectorToken3.getValue());
            } else {
                throw new SelectorFormatException("Non-numeric argument '" + selectorToken3.getValue() + "'", this.selector);
            }
        }
        if (selectorToken2.getToken() == 112 || selectorToken3 != null && selectorToken3.getToken() == 112) {
            return SelectorToken.getInstance(112);
        }
        if (selectorToken2.getValue() instanceof Long) {
            bl2 = true;
            l = (Long)selectorToken2.getValue();
            d = ((Long)selectorToken2.getValue()).doubleValue();
        } else {
            bl2 = false;
            l = ((Double)selectorToken2.getValue()).longValue();
            d = (Double)selectorToken2.getValue();
        }
        if (selectorToken3 != null) {
            if (selectorToken3.getValue() instanceof Long) {
                bl3 = true;
                l2 = (Long)selectorToken3.getValue();
                d2 = ((Long)selectorToken3.getValue()).doubleValue();
            } else {
                bl3 = false;
                l2 = ((Double)selectorToken3.getValue()).longValue();
                d2 = (Double)selectorToken3.getValue();
            }
        }
        switch (selectorToken.getToken()) {
            case 4: 
            case 9: {
                if (bl2 && bl3) {
                    bl = l == l2;
                } else if (bl2) {
                    bl = (double)l == d2;
                } else if (bl3) {
                    bl = d == (double)l2;
                } else {
                    boolean bl4 = bl = d == d2;
                }
                if (selectorToken.getToken() == 9) {
                    return SelectorToken.getInstance(bl ? 105 : 106);
                }
                return SelectorToken.getInstance(bl ? 106 : 105);
            }
            case 6: {
                bl = bl2 && bl3 ? l < l2 : (bl2 ? (double)l < d2 : (bl3 ? d < (double)l2 : d < d2));
                return SelectorToken.getInstance(bl ? 105 : 106);
            }
            case 5: {
                bl = bl2 && bl3 ? l <= l2 : (bl2 ? (double)l <= d2 : (bl3 ? d <= (double)l2 : d <= d2));
                return SelectorToken.getInstance(bl ? 105 : 106);
            }
            case 8: {
                bl = bl2 && bl3 ? l > l2 : (bl2 ? (double)l > d2 : (bl3 ? d > (double)l2 : d > d2));
                return SelectorToken.getInstance(bl ? 105 : 106);
            }
            case 7: {
                bl = bl2 && bl3 ? l >= l2 : (bl2 ? (double)l >= d2 : (bl3 ? d >= (double)l2 : d >= d2));
                return SelectorToken.getInstance(bl ? 105 : 106);
            }
            case 14: {
                if (bl2 && bl3) {
                    long l3 = l + l2;
                    return SelectorToken.getInstance(104, new Long(l3));
                }
                double d3 = d + d2;
                return SelectorToken.getInstance(103, new Double(d3));
            }
            case 10: {
                return selectorToken2;
            }
            case 15: {
                if (bl2 && bl3) {
                    long l4 = l - l2;
                    return SelectorToken.getInstance(104, new Long(l4));
                }
                double d4 = d - d2;
                return SelectorToken.getInstance(103, new Double(d4));
            }
            case 11: {
                if (bl2) {
                    long l5 = -l;
                    return SelectorToken.getInstance(104, new Long(l5));
                }
                double d5 = -d;
                return SelectorToken.getInstance(103, new Double(d5));
            }
            case 12: {
                if (bl2 && bl3) {
                    long l6 = l * l2;
                    return SelectorToken.getInstance(104, new Long(l6));
                }
                double d6 = d * d2;
                return SelectorToken.getInstance(103, new Double(d6));
            }
            case 13: {
                if (bl2 && bl3) {
                    long l7 = l / l2;
                    return SelectorToken.getInstance(104, new Long(l7));
                }
                double d7 = d / d2;
                return SelectorToken.getInstance(103, new Double(d7));
            }
        }
        throw new SelectorFormatException("Unknown numeric operation: " + selectorToken, this.selector);
    }

    private static boolean isNumeric(SelectorToken selectorToken) {
        int n = selectorToken.getToken();
        return n == 103 || n == 104;
    }

    private static boolean isOperator(SelectorToken selectorToken) {
        return selectorToken.getToken() < 100;
    }

    private static boolean isOperator(int n) {
        return n < 100;
    }

    private static int getPrecedence(SelectorToken selectorToken) {
        switch (selectorToken.getToken()) {
            case 1: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 12;
            }
            case 4: 
            case 9: {
                return 20;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 21;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                return 30;
            }
            case 14: 
            case 15: {
                return 40;
            }
            case 12: 
            case 13: {
                return 41;
            }
            case 29: {
                return 42;
            }
            case 10: 
            case 11: {
                return 43;
            }
            case 27: 
            case 28: {
                return 50;
            }
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Selector)) {
            return false;
        }
        Selector selector = (Selector)object;
        return this.selector.equals(selector.selector);
    }

    public int hashCode() {
        return this.selector.hashCode();
    }

    public String toString() {
        return this.selector;
    }

    public boolean usesProperties() {
        return this.usesProperties;
    }

    public boolean usesFields() {
        return this.usesFields;
    }

    private static void dumpTokens(LinkedList linkedList) {
        for (SelectorToken selectorToken : linkedList) {
            System.out.print(selectorToken.toString());
        }
        System.out.println();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.compiledSelector.length; ++i) {
            if (this.compiledSelector[i] == null) continue;
            stringBuffer.append(this.compiledSelector[i].toString());
        }
        return stringBuffer.toString() + " cachesize=" + selectorCache.size();
    }

    public static void main(String[] stringArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        boolean bl = false;
        int n = 0;
        hashMap.put("color", "red");
        hashMap.put("description", "Galvanized hot dipped wing nuts");
        hashMap.put("size", new Integer(1024));
        hashMap.put("msgnum", new Integer(5));
        hashMap.put("msgnumStr", "5");
        hashMap.put("price", new Float(1.5));
        hashMap.put("quantity", new Long(500L));
        hashMap.put("minlong", new Long(Long.MIN_VALUE));
        hashMap.put("maxlong", new Long(Long.MAX_VALUE));
        hashMap.put("trueProp", new Boolean(true));
        hashMap.put("falseProp", new Boolean(false));
        hashMap.put("byteProp", new Byte(4));
        hashMap.put("shortProp", new Short(4));
        hashMap.put("intProp", new Integer(4));
        hashMap.put("negIntProp", new Integer(-4));
        hashMap.put("floatProp", new Float(4.0));
        hashMap.put("stringProp", "4");
        hashMap.put("nullProp", null);
        hashMap.put("Event", "*Service Change*Restart*");
        hashMap.put("Region", "*EA*SO*WE*BC*");
        hashMap.put("Airspace", "*ASSS*ARCC*BVNF*");
        hashMap.put("LIDFAC", "*ZDC/ARTCC*EKN/RCAG*");
        hashMap.put("SVCPDC", "*ECOM/CA*YTR/RCG*");
        hashMap.put("CLASS", "*1*2*3*4*5*");
        hashMap.put("USI", "*USISAMPLEUSI000*");
        hashMap.put("JMSXUserID", "testUser");
        hashMap2.put("JMSDeliveryMode", "PERSISTENT");
        hashMap2.put("JMSPriority", new Integer(7));
        hashMap2.put("JMSTimestamp", new Long(System.currentTimeMillis()));
        hashMap2.put("JMSCorrelationID", "123456789");
        hashMap2.put("JMSType", "order");
        hashMap2.put("JMSMessageID", "messageid_" + System.currentTimeMillis());
        System.out.println("\nProperties=" + hashMap + "\n");
        System.out.println("\nFields=" + hashMap2 + "\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-d")) {
                DEBUG = true;
                continue;
            }
            if (stringArray[i].equals("-D")) {
                DEBUG = true;
                VERBOSE_DEBUG = true;
                continue;
            }
            if (stringArray[i].equals("-l")) {
                n = 500000;
                continue;
            }
            if (stringArray[i].equals("-n")) {
                Selector.setShortCircuit(false);
                continue;
            }
            if (stringArray[i].equals("-c")) {
                bl = true;
                Selector.setConvertTypes(bl);
                continue;
            }
            System.out.println("\nshortCircuit=" + shortCircuit);
            Selector selector = null;
            try {
                selector = Selector.compile(stringArray[i]);
            }
            catch (SelectorFormatException selectorFormatException) {
                System.out.println("Compile Error:\n" + selectorFormatException);
                System.exit(1);
            }
            try {
                System.out.println(selector.match(hashMap, hashMap2));
            }
            catch (SelectorFormatException selectorFormatException) {
                System.out.println("Runtime Error:\n" + selectorFormatException);
                System.exit(1);
            }
            if (n > 0) {
                long l = System.currentTimeMillis();
                for (int j = 0; j < n; ++j) {
                    try {
                        selector.match(hashMap, hashMap2);
                        continue;
                    }
                    catch (SelectorFormatException selectorFormatException) {
                        System.out.println("Runtime Error:\n" + selectorFormatException);
                        System.exit(1);
                    }
                }
                long l2 = System.currentTimeMillis();
                System.out.println("Evaluated " + n + " matches in " + (double)(l2 - l) / 1000.0 + " secs");
                System.out.println((double)n / ((double)(l2 - l) / 1000.0) + " matches/sec");
            }
            System.exit(0);
        }
        String[][] stringArrayArray = new String[][]{{"color = 'red'", "true"}, {"color = 'blue'", "false"}, {"color <> 'red'", "false"}, {"color <> 'blue'", "true"}, {"color in ('red', 'white', 'blue')", "true"}, {"color in ('orange', 'white', 'blue')", "false"}, {"color not in ('orange', 'white', 'blue')", "true"}, {"description like '%hot%'", "true"}, {"description not like '%hot%'", "false"}, {"color like 'r_d'", "true"}, {"color like 'r_d' or color like 'bl_e'", "true"}, {"color like 'r_d' and (color like 'b%' or color like '%d')", "true"}, {"quantity between 400 and 1000.0", "true"}, {"price between 1.10 and 2", "true"}, {"price not between 5 and 10e2", "true"}, {"price not between 5 and 10e2 and price between 1 and 2", "true"}, {"price not between 5 and 10e2 or price between 1 and 2", "true"}, {"nullProp is null and price is not null", "true"}, {"nullProp is null or  price is not null", "true"}, {"price is not null", "true"}, {"price > 0.75", "true"}, {"price < 9.75", "true"}, {"price >= 1.50", "true"}, {"price <= 1.50", "true"}, {"price > 9.75", "false"}, {"price >= 9.75", "false"}, {"msgnum > 1.75", "true"}, {"size > msgnum", "true"}, {"size > price", "true"}, {"size > price + msgnum", "true"}, {"size > price * msgnum", "true"}, {"quantity * price > 3.00", "true"}, {"JMSXUserID = 'testUser'", "true"}, {"JMSMessageID like '%~_%' escape '~'", "true"}, {"JMSTimestamp > 4", "true"}, {"JMSCorrelationID like '1_34__%9'", "true"}, {"JMSType <> 'quote'", "true"}, {"JMSPriority > 5", "true"}, {"JMSPriority < JMSTimestamp", "true"}, {"byteProp = 4", "true"}, {"byteProp <> 5.0", "true"}, {"shortProp <> 5.0", "true"}, {"intProp <> 5.0", "true"}, {"byteProp = shortProp", "true"}, {"byteProp = floatProp", "true"}, {"floatProp = 4.0 ", "true"}, {"floatProp * 2 > byteProp", "true"}, {"stringProp = '4'", "true"}, {"stringProp =  4", "error"}, {"stringProp <> '5'", "true"}, {"stringProp <>  5", "error"}, {"byteProp <> 4", "false"}, {"byteProp = 5.0", "false"}, {"shortProp = 5.0", "false"}, {"intProp = 5.0", "false"}, {"1 + 4 * 5 = 21", "true"}, {"1+4*5=21", "true"}, {"1 + -4 * 5 = -19", "true"}, {"(1 + 4) * +5 = 25", "true"}, {"(1 + 4) * -5 = -25", "true"}, {"(1 + 4) * 5 = (3 + 2) * 5", "true"}, {"1 + (4 * 5) = 21", "true"}, {"1 +  4 * 5  = 21", "true"}, {"(1 +  4) * 5 = 25", "true"}, {"(1 +  4) - 5 = 0 ", "true"}, {"2.0 * 4E2 + 5 = 805.0", "true"}, {"2.0 * 4E2 + 5 = 805", "true"}, {"2.0 = 2.0", "true"}, {"1.0+2.0*3.0-4.0/4.0 = 6", "true"}, {"price > 0.75 OR color <> 'blue'", "true"}, {"(price > 0.75 OR color <> 'blue') AND color <> 'green'", "true"}, {"     2 * quantity between msgnum AND msgnum * size", "true"}, {"NOT (2 * quantity between msgnum AND msgnum * size)", "false"}, {"-price < 0 AND +negIntProp < 0", "true"}, {"negIntProp+4 = 0 AND intProp-1 = 3", "true"}, {"- intProp + intProp = 0", "true"}, {"intProp between -1 and 5", "true"}, {"intProp between 1 and 5 AND intProp between -1 and 5", "true"}, {"minlong=-9223372036854775808 AND maxlong=9223372036854775807", "true"}, {"unknownProp NOT IN ('foo','jms','test')", "false"}, {"nullProp NOT IN ('foo','jms','test')", "false"}, {"unknownProp NOT LIKE '1_3'", "false"}, {"nullProp    NOT LIKE '1_3'", "false"}, {"0x1d = 29", "true"}, {"0x1D = 29", "true"}, {"035 = 29", "true"}, {"29L = 29", "true"}, {"29l = 29", "true"}, {"18. = 1.8e1", "true"}, {"18. = .18e2", "true"}, {"18.0f = .18e2", "true"}, {"18.0F = .18e2", "true"}, {"18.0d = .18e2", "true"}, {"18.0D = .18e2", "true"}, {".7e4 = 7000.0", "true"}, {" is null nullProp", "true"}, {"NOT is null nullProp", "false"}, {" is null unknownProp", "true"}, {" is not null nullProp", "false"}, {"NOT is not null nullProp", "true"}, {" is not null unknownProp", "false"}, {"TRUE", "true"}, {"NOT TRUE", "false"}, {"(NOT (NOT (NOT (NOT TRUE))))", "true"}, {"FALSE", "false"}, {"NOT FALSE", "true"}, {"trueProp", "true"}, {"NOT trueProp", "false"}, {"trueProp = TRUE", "true"}, {"trueProp = FALSE", "false"}, {"trueProp <> FALSE", "true"}, {"falseProp", "false"}, {"falseProp = TRUE", "false"}, {"falseProp = FALSE", "true"}, {"falseProp <> TRUE", "true"}, {"NOT falseProp", "true"}, {"description LIKE '%nuts%' AND color in ('black', 'white') OR color = 'blue'", "false"}, {"description LIKE '%nuts%' OR color in ('black', 'white') OR color = 'blue'", "true"}, {"Event LIKE '%*Service Change*%' OR Event LIKE '%*Restart*%' AND Region LIKE '%*EA*%' AND Airspace LIKE '%*ARCC*%'", "true"}, {"color = 'red' OR color <> 'blue' AND color <> 'green'", "true"}, {"color = 'white' OR color <> 'blue' AND color <> 'green'", "true"}, {"color = 'white' OR color <> 'red' AND color <> 'green'", "false"}, {"color = 'red' OR color <> 'blue' AND color <> 'red'", "true"}, {"(color = 'red' OR color <> 'blue') AND color <> 'red'", "false"}, {"(color = 'red' OR color <> 'blue') AND NOT color <> 'red'", "true"}, {"true OR true OR true OR true", "true"}, {"(true OR true) OR (true OR true)", "true"}, {"true OR false OR true OR false", "true"}, {"false OR false OR false OR true", "true"}, {"true OR false OR false OR false", "true"}, {"false OR false OR false OR false", "false"}, {"false OR false OR false OR true", "true"}, {"true AND true AND true AND true", "true"}, {"(true AND false) AND (true AND false)", "false"}, {"false AND false AND false AND true", "false"}, {"true AND false AND false AND false", "false"}, {"false AND true AND true AND true", "false"}, {"true AND true AND true AND false", "false"}, {"true AND false OR true AND true", "true"}, {"true OR false AND true OR false", "true"}, {"(true OR false) AND (true OR false)", "true"}, {"NOT ((true OR false) AND (true OR false))", "false"}, {"color in ('red', 'white', 'blue'(", "error"}, {"size not between 'red'  and 'green'", "error"}, {"+ + + +", "error"}, {"1 2 3 4", "error"}, {"= = = =", "error"}, {"((1 + 2) * 4 = 3", "error"}, {"red red red", "error"}, {"4 >> 1", "error"}, {"color = 'red", "error"}, {"color == 'red'", "error"}, {"intProp BETWEEN 'foo' and 'test'", "error"}, {"intProp > 'foo'", "error"}, {"color    > 'foo'", "error"}, {"unknownProp > 'foo'", "error"}, {"unknownProp < 'foo'", "error"}, {"unknownProp =< 'foo'", "error"}, {"unknownProp >= 'foo'", "error"}, {"intProp >= 'foo'", "error"}, {"intProp < 'foo'", "error"}, {"intProp <= 'foo'", "error"}, {"intProp between 'foo' and 'bar'", "error"}, {"color    between 1 and 7", "error"}, {"'color'    between 1 and 7", "error"}, {"7 in ('red', 'blue')", "error"}, {"intProp in ('red', 'blue')", "error"}, {"7 not in ('red', 'blue')", "error"}, {"intProp not in ('red', 'blue')", "error"}, {"NULL = 0", "error"}, {"=color 'red'", "error"}, {"size like '7'", "error"}, {"size not like '7'", "error"}, {"4 = 'red'", "error"}, {"4 <> 'red'", "error"}, {"'red' <> 4", "error"}, {"'red' =  4", "error"}, {"intProp = 'red'", "error"}, {"intProp <> 'red'", "error"}, {"'red' = intProp", "error"}, {"'red' <> intProp", "error"}, {"msgnumStr = 5", "error"}, {"msgnum    = '5'", "error"}, {"300 + 150 / 0 = 300", "error"}};
        int n2 = 0;
        for (int i = 0; i < stringArrayArray.length; ++i) {
            String string;
            String string2;
            String string3;
            block21: {
                Selector selector = null;
                string3 = stringArrayArray[i][1];
                string2 = null;
                HashMap<String, Object> hashMap3 = null;
                HashMap<String, Object> hashMap4 = null;
                try {
                    selector = Selector.compile(stringArrayArray[i][0]);
                    hashMap3 = selector.usesProperties() ? hashMap : null;
                    hashMap4 = selector.usesFields() ? hashMap2 : null;
                    string2 = selector.match(hashMap3, hashMap4) ? "true" : "false";
                }
                catch (SelectorFormatException selectorFormatException) {
                    string2 = "error";
                    if (string2.equals(string3)) break block21;
                    System.out.println(selectorFormatException);
                }
            }
            if (string2.equals(string3)) {
                string = "      PASS";
            } else {
                string = "***** FAIL";
                ++n2;
            }
            System.out.println(string + " " + stringArrayArray[i][0] + " : expected=" + string3 + " actual=" + string2);
        }
        System.out.println(stringArrayArray.length + " tests: " + (stringArrayArray.length - n2) + " passed " + n2 + " failed ");
        if (n2 > 0) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    static {
        keywords = new HashMap();
        keywords.put("NOT", new Integer(3));
        keywords.put("AND", new Integer(2));
        keywords.put("OR", new Integer(1));
        keywords.put("BETWEEN", new Integer(16));
        keywords.put("LIKE", new Integer(20));
        keywords.put("IN", new Integer(18));
        keywords.put("IS", new Integer(25));
        keywords.put("ESCAPE", new Integer(21));
        keywords.put("NULL", new Integer(111));
        keywords.put("TRUE", new Integer(105));
        keywords.put("FALSE", new Integer(106));
        headers = new HashSet(6);
        headers.add("JMSDeliveryMode");
        headers.add("JMSPriority");
        headers.add("JMSMessageID");
        headers.add("JMSTimestamp");
        headers.add("JMSCorrelationID");
        headers.add("JMSType");
        selectorCache = new WeakValueHashMap("SelectorCache");
    }
}

