/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class KeyTool {
    private static Logger _logger = null;
    private static final String JSSE_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    private File inputFile = null;
    private File outputFile = null;
    private char[] jksKeyStorePass;
    private char[] pkcsKeyStorePass = null;
    private char[] jksKeyPass = null;
    private char[] pkcsKeyPass = null;
    private String provider = null;
    private KeyStore pkcs12KeyStore = null;
    private KeyStore jksKeyStore = null;
    private static String PKCS12;
    private static String INFILE;
    private static String OUTFILE;
    private static String PKCSKEYSTOREPASS;
    private static String PKCSKEYPASS;
    private static String JKSKEYSTOREPASS;
    private static String JKSKEYPASS;
    private static LocalStringManagerImpl localStrings;

    public KeyTool(String infile, String outfile, String pkcsKeyStorePass, String pkcsKeyPass, String jksKeyStorePass, String jksKeyPass, String provider) throws IOException {
        this.inputFile = new File(infile);
        this.outputFile = new File(outfile);
        this.pkcsKeyStorePass = pkcsKeyStorePass.toCharArray();
        this.pkcsKeyPass = pkcsKeyPass.toCharArray();
        this.jksKeyStorePass = jksKeyStorePass.toCharArray();
        this.jksKeyPass = jksKeyPass.toCharArray();
        this.provider = provider;
        try {
            if (this.outputFile.exists()) {
                throw new IOException("Output file already exists!");
            }
            this.pkcs12KeyStore = KeyStore.getInstance("PKCS12", provider);
            this.jksKeyStore = KeyStore.getInstance("JKS");
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.readKeyStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readKeyStores() throws IOException {
        FileInputStream pkcsFis = null;
        FileInputStream jksFis = null;
        try {
            pkcsFis = new FileInputStream(this.inputFile);
            jksFis = new FileInputStream(this.outputFile);
        }
        catch (Exception e) {
            try {
                this.pkcs12KeyStore.load(pkcsFis, this.pkcsKeyStorePass);
                this.jksKeyStore.load(jksFis, null);
            }
            catch (Exception ce) {
                _logger.log(Level.SEVERE, "java_security.KeyStore_load_exception", ce);
            }
            finally {
                if (pkcsFis != null) {
                    pkcsFis.close();
                }
                if (jksFis != null) {
                    jksFis.close();
                }
            }
        }
        finally {
            try {
                this.pkcs12KeyStore.load(pkcsFis, this.pkcsKeyStorePass);
                this.jksKeyStore.load(jksFis, null);
            }
            catch (Exception ce) {
                _logger.log(Level.SEVERE, "java_security.KeyStore_load_exception", ce);
            }
            finally {
                if (pkcsFis != null) {
                    pkcsFis.close();
                }
                if (jksFis != null) {
                    jksFis.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJksKeyStore() throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.outputFile);
        }
        catch (Exception e) {
        }
        finally {
            try {
                this.jksKeyStore.store(fos, this.jksKeyStorePass);
            }
            catch (Exception ce) {
                _logger.log(Level.SEVERE, "java_security.KeyStore_store_exception", ce);
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void replicatePkcs12ToJks() throws Exception {
        Enumeration<String> e = this.pkcs12KeyStore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (this.pkcs12KeyStore.isKeyEntry(alias)) {
                Key key = this.pkcs12KeyStore.getKey(alias, this.pkcsKeyPass);
                Certificate[] certs = this.pkcs12KeyStore.getCertificateChain(alias);
                this.jksKeyStore.setKeyEntry(alias, key, this.jksKeyPass, certs);
                continue;
            }
            if (!this.pkcs12KeyStore.isCertificateEntry(alias)) continue;
            this.jksKeyStore.setCertificateEntry(alias, this.pkcs12KeyStore.getCertificate(alias));
        }
    }

    public void info() throws Exception {
        _logger.log(Level.FINEST, " Keystore Information");
        _logger.log(Level.FINEST, " Type = " + this.pkcs12KeyStore.getType());
        _logger.log(Level.FINEST, " Provider = " + this.pkcs12KeyStore.getProvider());
        _logger.log(Level.FINEST, " KeyStore size = " + this.pkcs12KeyStore.size());
        Enumeration<String> e = this.pkcs12KeyStore.aliases();
        _logger.log(Level.FINEST, " Kstore Aliases ");
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            _logger.log(Level.FINEST, " Alias = " + alias);
            if (this.pkcs12KeyStore.isKeyEntry(alias)) {
                _logger.log(Level.FINEST, "Alias is a key entry ");
                Key key = this.pkcs12KeyStore.getKey(alias, this.pkcsKeyPass);
                _logger.log(Level.FINEST, " Format = " + key.getFormat());
                continue;
            }
            if (!this.pkcs12KeyStore.isCertificateEntry(alias)) continue;
            _logger.log(Level.FINEST, " Alias is a certificate entry");
        }
        _logger.log(Level.FINEST, " End of Information");
    }

    public static void initProvider() {
        try {
            Provider p = (Provider)Class.forName(JSSE_PROVIDER).newInstance();
            Security.addProvider(p);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "java_security.provider_exception", e);
        }
    }

    public static String getProviderName() {
        try {
            Provider p = (Provider)Class.forName(JSSE_PROVIDER).newInstance();
            return p.getName();
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "java_security.getName_exception", e);
            return null;
        }
    }

    public static void help(boolean exit) {
        System.out.println(localStrings.getLocalString("enterprise.security.keytool", "keytool"));
        System.out.println(localStrings.getLocalString("enterprise.security.keytooloptions", "PKCS Options:"));
        System.out.println(" " + PKCS12 + " " + INFILE + " fileName" + " " + PKCSKEYSTOREPASS + " password" + " " + PKCSKEYPASS + " password" + " " + OUTFILE + " outputFileName" + " " + JKSKEYSTOREPASS + " password");
        if (exit) {
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        boolean pkcs = false;
        KeyTool.initProvider();
        String provider = null;
        String inFile = null;
        String outFile = null;
        String jksKeyPass = null;
        String jksKeyStorePass = null;
        String pkcsKeyPass = null;
        String pkcsKeyStorePass = null;
        try {
            if (args.length == 0) {
                KeyTool.help(false);
            }
            if (args[0].equalsIgnoreCase(PKCS12)) {
                pkcs = true;
                if (args.length != 11) {
                    KeyTool.help(true);
                }
                if (!args[1].equalsIgnoreCase(INFILE)) {
                    KeyTool.help(true);
                }
                inFile = args[2];
                if (!args[3].equalsIgnoreCase(PKCSKEYSTOREPASS)) {
                    KeyTool.help(true);
                }
                pkcsKeyStorePass = args[4];
                if (!args[5].equalsIgnoreCase(PKCSKEYPASS)) {
                    KeyTool.help(true);
                }
                pkcsKeyPass = args[6];
                if (!args[7].equalsIgnoreCase(OUTFILE)) {
                    KeyTool.help(true);
                }
                outFile = args[8];
                if (!args[9].equalsIgnoreCase(JKSKEYSTOREPASS)) {
                    KeyTool.help(true);
                }
                jksKeyPass = jksKeyStorePass = args[10];
            }
            if (pkcs) {
                provider = KeyTool.getProviderName();
                KeyTool kt = new KeyTool(inFile, outFile, pkcsKeyStorePass, pkcsKeyPass, jksKeyStorePass, jksKeyPass, provider);
                kt.replicatePkcs12ToJks();
                kt.writeJksKeyStore();
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "java_security.main_exception", e);
        }
    }

    static {
        _logger = LogDomains.getLogger(KeyTool.class, (String)"javax.enterprise.system.core.security");
        PKCS12 = "-pkcs12";
        INFILE = "-pkcsFile";
        OUTFILE = "-jksFile";
        PKCSKEYSTOREPASS = "-pkcsKeyStorePass";
        PKCSKEYPASS = "-pkcsKeyPass";
        JKSKEYSTOREPASS = "-jksKeyStorePass";
        JKSKEYPASS = "-jksKeyPass";
        localStrings = new LocalStringManagerImpl(KeyTool.class);
    }
}

