/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-password-alias")
@Scoped(value=PerLookup.class)
@I18n(value="delete.password.alias")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN})
public class DeletePasswordAlias
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeletePasswordAlias.class);
    @Param(name="aliasname", primary=true)
    private String aliasName;
    @Inject(name="Security SSL Password Provider Service")
    private MasterPassword masterPasswordHelper;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PasswordAdapter pa = this.masterPasswordHelper.getMasterPasswordAdapter();
            if (pa.getPasswordForAlias(this.aliasName) == null) {
                report.setMessage(localStrings.getLocalString("delete.password.alias.notfound", "Password alias for the alias {0} does not exist.", new Object[]{this.aliasName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            pa.removeAlias(this.aliasName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            report.setMessage(localStrings.getLocalString("delete.password.alias.fail", "Deletion of Password Alias {0} failed", new Object[]{this.aliasName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)ex);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

