/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.newtimer;

import com.sun.corba.ee.impl.orbutil.codegen.ASMUtil;
import com.sun.corba.ee.impl.orbutil.codegen.Identifier;
import com.sun.corba.ee.spi.orbutil.codegen.ClassGenerator;
import com.sun.corba.ee.spi.orbutil.codegen.Expression;
import com.sun.corba.ee.spi.orbutil.codegen.ImportList;
import com.sun.corba.ee.spi.orbutil.codegen.Type;
import com.sun.corba.ee.spi.orbutil.codegen.Wrapper;
import com.sun.corba.ee.spi.orbutil.generic.Pair;
import com.sun.corba.ee.spi.orbutil.newtimer.Controllable;
import com.sun.corba.ee.spi.orbutil.newtimer.Named;
import com.sun.corba.ee.spi.orbutil.newtimer.Timer;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactoryBuilder;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerGroup;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TimerPointSourceGenerator {
    private static final Comparator<Named> COMP = new Comparator<Named>(){

        @Override
        public int compare(Named o1, Named o2) {
            return o1.name().compareTo(o2.name());
        }
    };
    private static Type TimerFactory;
    private static Type Timer;
    private static Type TimerEventController;
    private static Type TimerGroup;
    private static ImportList standardImports;
    private static Type generatedInterfaceType;
    private static Type generatedBaseClassType;

    public static Pair<String, TimerFactory> parseDescription(String fileName) throws IOException {
        return TimerPointSourceGenerator.parseDescription(fileName, false);
    }

    public static Pair<String, TimerFactory> parseDescription(String fileName, boolean debug) throws IOException {
        Handler handler = new Handler(debug);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        File file = null;
        try {
            SAXParser saxParser = factory.newSAXParser();
            file = new File(fileName);
            saxParser.parse(file, (DefaultHandler)handler);
        }
        catch (Exception exc) {
            System.out.println("Exception in processing " + file + ": " + exc);
            exc.printStackTrace();
            return null;
        }
        return handler.getResult();
    }

    public static void generateSingleFile(String dirName, Pair<String, TimerFactory> description) throws IOException {
        String packageName = (String)description.first();
        TimerFactory tf = (TimerFactory)description.second();
        TimerPointSourceGenerator.generateSingleClass(dirName, packageName, tf);
    }

    private static void generateSingleClass(String dirName, String packageName, TimerFactory tf) throws IOException {
        TimerPointSourceGenerator.startFile(packageName);
        Wrapper._class((int)1, (String)tf.name(), (Type)Wrapper._Object(), (Type[])new Type[0]);
        TimerPointSourceGenerator.generateFields(tf, false, true);
        TimerPointSourceGenerator.generateConstructor(tf, false);
        TimerPointSourceGenerator.generateAccessorMethods(tf, true);
        Wrapper._end();
        Type type = Type._classGenerator((ClassGenerator)Wrapper._classGenerator());
        TimerPointSourceGenerator.writeFile(dirName, type);
    }

    public static void generateSourceFiles(String dirName, Pair<String, TimerFactory> description) throws IOException {
        String packageName = (String)description.first();
        TimerFactory tf = (TimerFactory)description.second();
        TimerPointSourceGenerator.generateInterface(dirName, packageName, tf);
        TimerPointSourceGenerator.generateBaseClass(dirName, packageName, tf);
        TimerPointSourceGenerator.generateImpl(false, dirName, packageName, tf);
        TimerPointSourceGenerator.generateImpl(true, dirName, packageName, tf);
    }

    private static void generateInterface(String dirName, String packageName, TimerFactory tf) throws IOException {
        TimerPointSourceGenerator.startFile(packageName);
        Wrapper._interface((int)1, (String)tf.name(), (Type[])new Type[0]);
        TimerPointSourceGenerator.generateAccessorMethods(tf, false);
        TimerPointSourceGenerator.generateEnterExitMethods(tf, GenerationType.METHOD_HEADER);
        Wrapper._end();
        generatedInterfaceType = Type._classGenerator((ClassGenerator)Wrapper._classGenerator());
        TimerPointSourceGenerator.writeFile(dirName, generatedInterfaceType);
    }

    private static void generateBaseClass(String dirName, String packageName, TimerFactory tf) throws IOException {
        TimerPointSourceGenerator.startFile(packageName);
        Wrapper._import((String)generatedInterfaceType.name());
        String baseClassName = tf.name() + "Base";
        Wrapper._class((int)1025, (String)baseClassName, (Type)Wrapper._Object(), (Type[])new Type[]{generatedInterfaceType});
        TimerPointSourceGenerator.generateFields(tf, true, false);
        TimerPointSourceGenerator.generateConstructor(tf, true);
        TimerPointSourceGenerator.generateAccessorMethods(tf, true);
        Wrapper._end();
        generatedBaseClassType = Type._classGenerator((ClassGenerator)Wrapper._classGenerator());
        TimerPointSourceGenerator.writeFile(dirName, generatedBaseClassType);
    }

    private static void generateImpl(boolean isNoop, String dirName, String packageName, TimerFactory tf) throws IOException {
        TimerPointSourceGenerator.startFile(packageName);
        Wrapper._import((String)generatedBaseClassType.name());
        String className = isNoop ? tf.name() + "DisabledImpl" : tf.name() + "EnabledImpl";
        Wrapper._class((int)1, (String)className, (Type)generatedBaseClassType, (Type[])new Type[0]);
        Wrapper._constructor((int)1, (Type[])new Type[0]);
        Expression tfe = Wrapper._arg((Type)TimerFactory, (String)"tf");
        Expression tec = Wrapper._arg((Type)TimerEventController, (String)"tec");
        Wrapper._body();
        Wrapper._expr((Expression)Wrapper._super((Expression[])new Expression[]{tfe, tec}));
        Wrapper._end();
        TimerPointSourceGenerator.generateEnterExitMethods(tf, isNoop ? GenerationType.DISABLED_METHOD : GenerationType.ENABLED_METHOD);
        Wrapper._end();
        Type thisClass = Type._classGenerator((ClassGenerator)Wrapper._classGenerator());
        TimerPointSourceGenerator.writeFile(dirName, thisClass);
    }

    private static void generateAccessorMethods(TimerFactory tf, boolean isImpl) {
        int modifiers = isImpl ? 17 : 1025;
        ArrayList<? extends Timer> timers = new ArrayList<Timer>(tf.timers().values());
        Collections.sort(timers, COMP);
        for (Timer timer : timers) {
            Wrapper._method((int)modifiers, (Type)Timer, (String)timer.name(), (Type[])new Type[0]);
            if (isImpl) {
                Wrapper._body();
                Wrapper._return((Expression)Wrapper._field((Expression)Wrapper._this(), (String)timer.name()));
            }
            Wrapper._end();
        }
        ArrayList<? extends TimerGroup> timerGroups = new ArrayList<TimerGroup>(tf.timerGroups().values());
        Collections.sort(timerGroups, COMP);
        for (TimerGroup timerGroup : timerGroups) {
            Wrapper._method((int)modifiers, (Type)TimerGroup, (String)timerGroup.name(), (Type[])new Type[0]);
            if (isImpl) {
                Wrapper._body();
                Wrapper._return((Expression)Wrapper._field((Expression)Wrapper._this(), (String)timerGroup.name()));
            }
            Wrapper._end();
        }
    }

    private static void startFile(String packageName) {
        Wrapper._clear();
        Wrapper._package((String)packageName);
        Wrapper._import((ImportList)standardImports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String dirName, Type type) throws IOException {
        File file = ASMUtil.getFile((String)dirName, (String)type.name(), (String)".java");
        PrintStream ps = new PrintStream(file);
        try {
            Wrapper._sourceCode((PrintStream)ps, (Properties)new Properties());
        }
        finally {
            ps.close();
        }
    }

    private static void generateFields(TimerFactory tf, boolean generateController, boolean privateTimers) {
        if (generateController) {
            Wrapper._data((int)20, (Type)TimerEventController, (String)"controller");
        }
        int mod = 0x10 | (privateTimers ? 2 : 4);
        ArrayList<? extends Timer> timers = new ArrayList<Timer>(tf.timers().values());
        Collections.sort(timers, COMP);
        for (Timer timer : timers) {
            Wrapper._data((int)mod, (Type)Timer, (String)timer.name());
        }
        ArrayList<? extends TimerGroup> timerGroups = new ArrayList<TimerGroup>(tf.timerGroups().values());
        Collections.sort(timerGroups, COMP);
        for (TimerGroup timerGroup : timerGroups) {
            Wrapper._data((int)18, (Type)TimerGroup, (String)timerGroup.name());
        }
    }

    private static void generateConstructor(TimerFactory tf, boolean generateController) {
        Expression controller = null;
        Wrapper._constructor((int)1, (Type[])new Type[0]);
        Expression tfe = Wrapper._arg((Type)TimerFactory, (String)"tf");
        if (generateController) {
            controller = Wrapper._arg((Type)TimerEventController, (String)"controller");
        }
        Wrapper._body();
        if (generateController) {
            Wrapper._assign((Expression)Wrapper._field((Expression)Wrapper._this(), (String)"controller"), (Expression)controller);
        }
        for (Timer timer : tf.timers().values()) {
            Wrapper._assign((Expression)Wrapper._v((String)timer.name()), (Expression)Wrapper._call((Expression)tfe, (String)"makeTimer", (Expression[])new Expression[]{Wrapper._const((String)timer.name()), Wrapper._const((String)timer.description())}));
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            Wrapper._assign((Expression)Wrapper._v((String)timerGroup.name()), (Expression)Wrapper._call((Expression)tfe, (String)"makeTimerGroup", (Expression[])new Expression[]{Wrapper._const((String)timerGroup.name()), Wrapper._const((String)timerGroup.description())}));
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            for (Controllable controllable : timerGroup.contents()) {
                Wrapper._expr((Expression)Wrapper._call((Expression)Wrapper._v((String)timerGroup.name()), (String)"add", (Expression[])new Expression[]{Wrapper._v((String)controllable.name())}));
            }
        }
        Wrapper._end();
    }

    private static void generateEnterExitMethods(TimerFactory tf, GenerationType gtype) {
        for (Timer timer : tf.timers().values()) {
            TimerPointSourceGenerator.generateMethod("enter", timer.name(), gtype);
            TimerPointSourceGenerator.generateMethod("exit", timer.name(), gtype);
        }
    }

    private static void generateMethod(String op, String timer, GenerationType gtype) {
        int modifiers = gtype == GenerationType.METHOD_HEADER ? 1025 : 1;
        Wrapper._method((int)modifiers, (Type)Wrapper._void(), (String)(op + "_" + timer), (Type[])new Type[0]);
        if (gtype != GenerationType.METHOD_HEADER) {
            Wrapper._body();
            if (gtype == GenerationType.ENABLED_METHOD) {
                Wrapper._expr((Expression)Wrapper._call((Expression)Wrapper._v((String)"controller"), (String)op, (Expression[])new Expression[]{Wrapper._v((String)timer)}));
            }
        }
        Wrapper._end();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Required arguments: input-file output-directory");
            System.exit(1);
        } else {
            try {
                String infile = args[0];
                String outdir = args[1];
                boolean debug = Boolean.parseBoolean(args[2]);
                Pair<String, TimerFactory> result = TimerPointSourceGenerator.parseDescription(infile, debug);
                TimerPointSourceGenerator.generateSourceFiles(outdir, result);
            }
            catch (Exception exc) {
                System.out.println("Failed with exception: " + exc);
                exc.printStackTrace();
                System.exit(1);
            }
        }
    }

    static {
        Wrapper._clear();
        Wrapper._package();
        TimerFactory = Wrapper._import((String)"com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory");
        Timer = Wrapper._import((String)"com.sun.corba.ee.spi.orbutil.newtimer.Timer");
        TimerEventController = Wrapper._import((String)"com.sun.corba.ee.spi.orbutil.newtimer.TimerEventController");
        TimerGroup = Wrapper._import((String)"com.sun.corba.ee.spi.orbutil.newtimer.TimerGroup");
        standardImports = Wrapper._import();
    }

    static enum GenerationType {
        METHOD_HEADER,
        ENABLED_METHOD,
        DISABLED_METHOD;

    }

    private static class Handler
    extends DefaultHandler {
        private static final int WIDTH = 4;
        private static final String TIMER_ELEMENT = "timer";
        private static final String TIMING_ELEMENT = "timing";
        private static final String TIMER_GROUP_ELEMENT = "timerGroup";
        private static final String CONTAINS_ELEMENT = "contains";
        private static final String NAME_ATTR = "name";
        private static final String DESCRIPTION_ATTR = "description";
        private static final String PACKAGE_ATTR = "package";
        private boolean debug;
        private int level;
        private char[] pad;
        private TimingInfoProcessor tip;
        private Pair<String, TimerFactory> result;

        public Handler(boolean debug) {
            this.debug = debug;
            this.level = 0;
            this.setPad();
            this.tip = null;
            this.result = null;
        }

        private void indent() {
            ++this.level;
            this.setPad();
        }

        private void undent() {
            --this.level;
            this.setPad();
        }

        private void setPad() {
            int length = 4 * this.level;
            this.pad = new char[length];
            for (int ctr = 0; ctr < length; ++ctr) {
                this.pad[ctr] = 32;
            }
        }

        private void dprint(String msg) {
            if (this.debug) {
                System.out.print(this.pad);
                System.out.println(msg);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.dprint("startDocument called");
        }

        @Override
        public void endDocument() throws SAXException {
            this.dprint("endDocument called");
            this.result = this.tip.getResult();
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
            this.indent();
            this.dprint("namespaceURI=" + namespaceURI);
            this.dprint("lName=" + lName);
            this.dprint("qName=" + qName);
            this.dprint("Attributes:");
            for (int ctr = 0; ctr < attrs.getLength(); ++ctr) {
                this.dprint("\tlocal name    =" + attrs.getLocalName(ctr));
                this.dprint("\tqualified name=" + attrs.getQName(ctr));
                this.dprint("\tvalue         =" + attrs.getValue(ctr));
            }
            if (qName.equals(TIMING_ELEMENT)) {
                String name = attrs.getValue(NAME_ATTR);
                String pkg = attrs.getValue(PACKAGE_ATTR);
                this.tip = new TimingInfoProcessor(name, pkg);
            } else if (qName.equals(TIMER_ELEMENT)) {
                String name = attrs.getValue(NAME_ATTR);
                String desc = attrs.getValue(DESCRIPTION_ATTR);
                this.tip.addTimer(name, desc);
            } else if (qName.equals(TIMER_GROUP_ELEMENT)) {
                String name = attrs.getValue(NAME_ATTR);
                String desc = attrs.getValue(DESCRIPTION_ATTR);
                this.tip.addTimerGroup(name, desc);
            } else if (qName.equals(CONTAINS_ELEMENT)) {
                String name = attrs.getValue(NAME_ATTR);
                this.tip.contains(name);
            } else {
                throw new IllegalStateException("Unknown XML element: " + qName);
            }
        }

        @Override
        public void endElement(String namespaceURI, String lName, String qName) throws SAXException {
            this.undent();
        }

        public Pair<String, TimerFactory> getResult() {
            return this.result;
        }
    }

    public static class TimingInfoProcessor {
        private boolean done = false;
        private String pkg;
        private TimerFactory tf;
        private Map<String, List<String>> contents;
        private TimerGroup currentTimerGroup;

        private void checkForValidIdentifier(String name) {
            if (!Identifier.isValidIdentifier((String)name)) {
                throw new IllegalArgumentException("name " + name + " is not a valid Java identifier");
            }
        }

        private void checkDone() {
            if (this.done) {
                throw new IllegalStateException("past getResult: no other methods may be called");
            }
        }

        public TimingInfoProcessor(String name, String pkg) {
            this.pkg = pkg;
            this.checkForValidIdentifier(name);
            if (!Identifier.isValidFullIdentifier((String)pkg)) {
                throw new IllegalArgumentException(pkg + " is not a valid package name");
            }
            this.tf = TimerFactoryBuilder.make(name, name);
            this.contents = new LinkedHashMap<String, List<String>>();
            this.currentTimerGroup = null;
        }

        public void addTimer(String name, String desc) {
            this.checkDone();
            this.checkForValidIdentifier(name);
            if (!this.tf.timerAlreadyExists(name)) {
                this.tf.makeTimer(name, desc);
            }
            this.currentTimerGroup = null;
        }

        public void addTimerGroup(String name, String desc) {
            this.checkDone();
            this.checkForValidIdentifier(name);
            this.currentTimerGroup = this.tf.makeTimerGroup(name, desc);
        }

        private void addContained(String timerName, String timerGroupName) {
            List<String> list = this.contents.get(timerGroupName);
            if (list == null) {
                list = new ArrayList<String>();
                this.contents.put(timerGroupName, list);
            }
            list.add(timerName);
        }

        public void containedIn(String timerName, String timerGroupName) {
            this.addContained(timerName, timerGroupName);
        }

        public void contains(String name) {
            this.checkDone();
            if (this.currentTimerGroup == null) {
                throw new IllegalStateException("contains must be called after an addTimerGroup call");
            }
            String cname = this.currentTimerGroup.name();
            this.addContained(name, cname);
        }

        private Controllable getControllable(String name) {
            Controllable result = this.tf.timers().get(name);
            if (result == null) {
                result = this.tf.timerGroups().get(name);
            }
            if (result == null) {
                throw new IllegalArgumentException(name + " is not a valid Timer or TimerGroup name");
            }
            return result;
        }

        private void updateTimerFactoryContents() {
            for (String str : this.contents.keySet()) {
                List<String> list = this.contents.get(str);
                TimerGroup tg = this.tf.timerGroups().get(str);
                for (String content : list) {
                    tg.add(this.getControllable(content));
                }
            }
        }

        public Pair<String, TimerFactory> getResult() {
            this.checkDone();
            this.done = true;
            this.updateTimerFactoryContents();
            Pair result = new Pair((Object)this.pkg, (Object)this.tf);
            return result;
        }
    }
}

