/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.tf;

import com.sun.corba.ee.spi.orbutil.generic.Holder;
import com.sun.corba.ee.spi.orbutil.generic.SynchronizedHolder;
import com.sun.corba.ee.spi.orbutil.newtimer.TimingPointType;
import com.sun.corba.ee.spi.orbutil.tf.EnhancedClassDataReflectiveImpl;
import com.sun.corba.ee.spi.orbutil.tf.Exceptions;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitor;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorFactory;
import com.sun.corba.ee.spi.orbutil.tf.MethodMonitorFactoryDefaults;
import com.sun.corba.ee.spi.orbutil.tf.Util;
import com.sun.corba.ee.spi.orbutil.tf.annotation.MethodMonitorGroup;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class MethodMonitorRegistry {
    public static String USE_SYNC_HOLDER_PROPERTY = "com.sun.corba.ee.tf.UseSynchronizedHolder";
    private static final Exceptions wrapper = Exceptions.self;
    private static final Set<String> mmAnnotations = new HashSet<String>();
    private static final Map<Class<?>, List<TimingPointType>> classToTimerTypes = new HashMap();
    private static final Map<Class<?>, List<String>> classToTimerNames = new HashMap();
    private static final Map<Class<?>, List<String>> classToMNames = new HashMap();
    private static final Map<Class<?>, Map<Class<? extends Annotation>, Holder<MethodMonitor>>> classToAnnoMM = new HashMap();
    private static final Map<Class<? extends Annotation>, Set<Class<? extends Annotation>>> subgroups = new HashMap<Class<? extends Annotation>, Set<Class<? extends Annotation>>>();
    private static final Map<Class<? extends Annotation>, Set<Class<? extends Annotation>>> subgroupsTC = new HashMap<Class<? extends Annotation>, Set<Class<? extends Annotation>>>();
    private static final Map<Class<? extends Annotation>, Set<Class<?>>> annotationToClasses = new HashMap();
    private static final Map<Class<? extends Annotation>, MethodMonitorFactory> annotationToMMF = new HashMap<Class<? extends Annotation>, MethodMonitorFactory>();
    private static final Map<Class<? extends Annotation>, Set<MethodMonitorFactory>> annotationToMMFSets = new HashMap<Class<? extends Annotation>, Set<MethodMonitorFactory>>();
    private static final Map<Class<? extends Annotation>, MethodMonitorFactory> annotationToMMFComposition = new HashMap<Class<? extends Annotation>, MethodMonitorFactory>();

    public static synchronized MethodMonitor merge(MethodMonitor[] mms) {
        return null;
    }

    public static synchronized Set<String> getMMAnnotations() {
        return new HashSet<String>(mmAnnotations);
    }

    public static synchronized void registerAnnotationFile(String fname) {
        try {
            ResourceBundle rb = ResourceBundle.getBundle(fname);
            String obj = rb.getString("com.sun.corba.tf.annotations.size");
            int size = 0;
            if (obj != null) {
                size = Integer.valueOf(obj);
            }
            for (int ctr = 1; ctr <= size; ++ctr) {
                obj = rb.getString("com.sun.corba.tf.annotation." + ctr);
                mmAnnotations.add(obj);
            }
        }
        catch (Exception exc) {
            wrapper.exceptionInRegisterAnnotationFile(exc, fname);
        }
    }

    private static void updateTracedClass(Class<?> cls) {
        Map<Class<? extends Annotation>, Holder<MethodMonitor>> map = classToAnnoMM.get(cls);
        for (Map.Entry<Class<? extends Annotation>, Holder<MethodMonitor>> entry : map.entrySet()) {
            MethodMonitorFactory mmf = annotationToMMFComposition.get(entry.getKey());
            if (mmf == null) {
                entry.getValue().content(null);
                continue;
            }
            entry.getValue().content((Object)mmf.create(cls));
        }
    }

    private static void updateAnnotation(Class<? extends Annotation> annot) {
        HashSet<MethodMonitorFactory> mmfs = new HashSet<MethodMonitorFactory>();
        annotationToMMFSets.put(annot, mmfs);
        Set<Class<? extends Annotation>> relatedAnnos = subgroupsTC.get(annot);
        for (Class<? extends Annotation> key : relatedAnnos) {
            MethodMonitorFactory mmf = annotationToMMF.get(key);
            if (mmf == null) continue;
            mmfs.add(mmf);
        }
        annotationToMMFComposition.put(annot, MethodMonitorFactoryDefaults.compose(mmfs));
        Set<Class<?>> classes = annotationToClasses.get(annot);
        if (classes != null) {
            for (Class<?> cls : classes) {
                MethodMonitorRegistry.updateTracedClass(cls);
            }
        }
    }

    private static void doFullUpdate() {
        for (Class<? extends Annotation> clazz : annotationToMMF.keySet()) {
            MethodMonitorRegistry.updateAnnotation(clazz);
        }
        for (Class<Annotation> clazz : classToAnnoMM.keySet()) {
            MethodMonitorRegistry.updateTracedClass(clazz);
        }
    }

    private static boolean scanClassAnnotations(Class<?> cls) {
        boolean updated = false;
        boolean hasMMAnnotation = false;
        for (Annotation anno : cls.getAnnotations()) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            MethodMonitorGroup mmg = annoClass.getAnnotation(MethodMonitorGroup.class);
            if (mmg == null) continue;
            hasMMAnnotation = true;
            Set<Class<?>> target = annotationToClasses.get(annoClass);
            if (target == null) {
                target = new HashSet();
                annotationToClasses.put(annoClass, target);
            }
            target.add(cls);
            if (!MethodMonitorRegistry.scanAnnotation(annoClass, mmg)) continue;
            updated = true;
        }
        if (!hasMMAnnotation) {
            throw new RuntimeException("Class " + cls + " is not traceable");
        }
        return updated;
    }

    private static boolean scanAnnotation(Class<? extends Annotation> annoClass, MethodMonitorGroup mmg) {
        boolean updated = false;
        if (!subgroups.containsKey(annoClass)) {
            updated = true;
            HashSet<Class<? extends Annotation>> acs = new HashSet<Class<? extends Annotation>>(Arrays.asList(mmg.value()));
            subgroups.put(annoClass, acs);
            MethodMonitorRegistry.computeTransitiveClosure();
        }
        return updated;
    }

    private static void computeTransitiveClosure() {
        subgroupsTC.clear();
        for (Class<? extends Annotation> anno : subgroups.keySet()) {
            HashSet memset = new HashSet();
            subgroupsTC.put(anno, memset);
        }
        for (Class<? extends Annotation> anno : subgroupsTC.keySet()) {
            MethodMonitorRegistry.dfs(anno, anno);
        }
    }

    private static void dfs(Class<? extends Annotation> src, Class<? extends Annotation> dest) {
        Set<Class<? extends Annotation>> images = subgroupsTC.get(src);
        images.add(dest);
        Set<Class<? extends Annotation>> temp = subgroups.get(dest);
        if (temp != null) {
            for (Class<? extends Annotation> anno : temp) {
                if (images.contains(anno)) continue;
                MethodMonitorRegistry.dfs(src, anno);
            }
        }
    }

    private static String getExternalName(String name) {
        return name.replace('/', '.');
    }

    private static final MethodMonitorGroup checkAnnotation(Class<? extends Annotation> annoClass) {
        MethodMonitorGroup mmg = annoClass.getAnnotation(MethodMonitorGroup.class);
        if (mmg == null) {
            throw new RuntimeException("Annotation " + annoClass + " does not have the MethodMonitorGroup annotation");
        }
        return mmg;
    }

    public static synchronized void registerClass(Class<?> cls, List<String> methodNames, Map<Class<? extends Annotation>, Holder<MethodMonitor>> annoMM) {
        boolean fullUpdate = MethodMonitorRegistry.scanClassAnnotations(cls);
        classToMNames.put(cls, methodNames);
        classToAnnoMM.put(cls, annoMM);
        if (fullUpdate) {
            MethodMonitorRegistry.doFullUpdate();
        } else {
            MethodMonitorRegistry.updateTracedClass(cls);
        }
    }

    private static boolean isHolderSynchronized() {
        boolean result = Boolean.getBoolean(USE_SYNC_HOLDER_PROPERTY);
        return result;
    }

    private static void initializeField(Class<?> cls, String fname, Holder<MethodMonitor> sh) throws NoSuchFieldException, IllegalAccessException {
        Field field = cls.getDeclaredField(fname);
        field.setAccessible(true);
        field.set(null, sh);
    }

    public static synchronized void registerClass(final Class<?> cls) {
        Util util = new Util(false, 0);
        EnhancedClassDataReflectiveImpl ecd = new EnhancedClassDataReflectiveImpl(util, cls);
        boolean fullUpdate = MethodMonitorRegistry.scanClassAnnotations(cls);
        classToMNames.put(cls, ecd.getMethodNames());
        classToTimerTypes.put(cls, ecd.getTimingPointTypes());
        classToTimerNames.put(cls, ecd.getTimingPointNames());
        HashMap annoMM = new HashMap();
        for (Map.Entry<String, String> entry : ecd.getAnnotationToHolderName().entrySet()) {
            try {
                SynchronizedHolder sh;
                String aname = entry.getKey();
                final String fname = entry.getValue();
                Object object = sh = MethodMonitorRegistry.isHolderSynchronized() ? new SynchronizedHolder() : new Holder();
                if (System.getSecurityManager() == null) {
                    MethodMonitorRegistry.initializeField(cls, fname, (Holder<MethodMonitor>)sh);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction<Field>((Holder)sh){
                        final /* synthetic */ Holder val$sh;
                        {
                            this.val$sh = holder;
                        }

                        @Override
                        public Field run() {
                            try {
                                MethodMonitorRegistry.initializeField(cls, fname, (Holder<MethodMonitor>)this.val$sh);
                            }
                            catch (Exception exc) {
                                wrapper.fieldSettingError(exc, cls, fname);
                            }
                            return null;
                        }
                    });
                }
                String axname = MethodMonitorRegistry.getExternalName(aname);
                Class<?> aclass = Class.forName(axname, true, cls.getClassLoader());
                annoMM.put(aclass, sh);
            }
            catch (Exception exc) {
                wrapper.exceptionInRegisterClass(exc, cls);
            }
        }
        classToAnnoMM.put(cls, annoMM);
        if (fullUpdate) {
            MethodMonitorRegistry.doFullUpdate();
        } else {
            MethodMonitorRegistry.updateTracedClass(cls);
        }
    }

    public static synchronized List<String> getMethodNames(Class<?> cls) {
        return classToMNames.get(cls);
    }

    public static synchronized String getMethodName(Class<?> cls, int identifier) {
        List<String> names = classToMNames.get(cls);
        if (names == null) {
            throw new RuntimeException("Class " + cls + " not found in map");
        }
        if (identifier < 0 || identifier >= names.size()) {
            throw new RuntimeException("identifier is out of range");
        }
        return names.get(identifier);
    }

    public static synchronized int getMethodIdentifier(Class<?> cls, String mname) {
        List<String> names = classToMNames.get(cls);
        if (names == null) {
            throw new RuntimeException("Class " + cls + " not found in map");
        }
        for (int ctr = 0; ctr < names.size(); ++ctr) {
            String str = names.get(ctr);
            if (!str.equals(mname)) continue;
            return ctr;
        }
        return -1;
    }

    public static synchronized void register(Class<? extends Annotation> annot, MethodMonitorFactory mmf) {
        boolean fullUpdate = MethodMonitorRegistry.scanAnnotation(annot, MethodMonitorRegistry.checkAnnotation(annot));
        annotationToMMF.put(annot, mmf);
        if (fullUpdate) {
            MethodMonitorRegistry.doFullUpdate();
        } else {
            MethodMonitorRegistry.updateAnnotation(annot);
        }
    }

    public static synchronized void clear(Class<? extends Annotation> annot) {
        boolean fullUpdate = MethodMonitorRegistry.scanAnnotation(annot, MethodMonitorRegistry.checkAnnotation(annot));
        annotationToMMF.remove(annot);
        if (fullUpdate) {
            MethodMonitorRegistry.doFullUpdate();
        } else {
            MethodMonitorRegistry.updateAnnotation(annot);
        }
    }

    public static synchronized MethodMonitorFactory registeredFactory(Class<? extends Annotation> annot) {
        boolean fullUpdate = MethodMonitorRegistry.scanAnnotation(annot, MethodMonitorRegistry.checkAnnotation(annot));
        if (fullUpdate) {
            MethodMonitorRegistry.doFullUpdate();
        }
        return annotationToMMF.get(annot);
    }

    public static synchronized MethodMonitor getMethodMonitorForClass(Class<?> cls, Class<? extends Annotation> annot) {
        Map<Class<? extends Annotation>, Holder<MethodMonitor>> map = classToAnnoMM.get(cls);
        if (map == null) {
            throw new RuntimeException("Class " + cls + " is not a traced class.");
        }
        Holder<MethodMonitor> holder = map.get(annot);
        if (holder == null) {
            throw new RuntimeException("Annotation " + annot + " is not a tracing annotation defined on class " + cls);
        }
        return (MethodMonitor)holder.content();
    }

    public static synchronized List<TimingPointType> getTimerTypes(Class<?> cls) {
        return classToTimerTypes.get(cls);
    }

    public static synchronized List<String> getTimerNames(Class<?> cls) {
        return classToTimerNames.get(cls);
    }
}

