/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.TimerTask;

class DetachedTransactionReaper {
    static final int DEFAULT_TIMEOUT = 0;
    List txns = null;
    TimerTask mytimer = null;
    TransactionList translist = null;
    private static MQTimer timer = Globals.getTimer();
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private static final int timeoutsec = Globals.getConfig().getIntProperty("imq.transaction.detachedTimeout", 0);
    boolean destroyed = false;

    public DetachedTransactionReaper(TransactionList transactionList) {
        this.translist = transactionList;
        this.txns = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDetachedTID(TransactionUID transactionUID) {
        if (TransactionList.DEBUG_CLUSTER_TXN) {
            this.logger.log(8, "addDetachedTID: " + transactionUID);
        }
        if (timeoutsec <= 0) {
            return;
        }
        DetachedTransactionReaper detachedTransactionReaper = this;
        synchronized (detachedTransactionReaper) {
            this.txns.add(transactionUID);
            if (this.mytimer == null || this.txns.size() == 1) {
                this.addTimer(timeoutsec);
            }
        }
    }

    public synchronized void removeDetachedTID(TransactionUID transactionUID) {
        boolean bl = this.txns.remove(transactionUID);
        if (bl && this.txns.isEmpty()) {
            this.removeTimer();
        }
    }

    public synchronized TransactionUID[] getDetachedTIDs() {
        return this.txns.toArray(new TransactionUID[0]);
    }

    public synchronized void detachOnephasePrepared() {
        long l = (long)Destination.RECONNECT_MULTIPLIER * ((long)(timeoutsec * 1000) + Globals.getConnectionManager().getMaxReconnectInterval());
        TransactionState transactionState = null;
        TransactionUID transactionUID2 = null;
        for (TransactionUID transactionUID2 : this.txns) {
            transactionState = this.translist.retrieveState(transactionUID2);
            if (transactionState == null || transactionState.getState() != 5 || !transactionState.getOnephasePrepare() || transactionState.isDetachedFromConnection()) continue;
            transactionState.detachedFromConnection();
            this.logger.log(8, this.br.getKString("B1432", transactionUID2 + "[" + transactionState + "]", l));
        }
    }

    public synchronized void destroy() {
        this.destroyed = true;
        if (this.mytimer != null) {
            this.removeTimer();
        }
        this.txns.clear();
    }

    private void addTimer(int n) {
        assert (Thread.holdsLock(this));
        assert (this.mytimer == null);
        this.mytimer = new DetachedTransactionTimerTask(n);
        try {
            long l = n * 1000;
            Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1281", n));
            timer.schedule(this.mytimer, l, l);
        }
        catch (IllegalStateException illegalStateException) {
            Globals.getLogger().logStack(8, "B3100", (Object)("Failed to schedule detached-transaction reaper " + this), (Throwable)illegalStateException);
        }
    }

    private void removeTimer() {
        assert (Thread.holdsLock(this));
        try {
            if (this.mytimer != null) {
                this.mytimer.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            Globals.getLogger().logStack(4, "Failed to cancel detached-transaction reaper timer ", (Throwable)illegalStateException);
        }
        this.mytimer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("imq.transaction.detachedTimeout", String.valueOf(timeoutsec));
        hashtable.put("reconnectionMultiplier", String.valueOf(Destination.RECONNECT_MULTIPLIER));
        hashtable.put("maxConnectionReconnectInterval(ms)", Globals.getConnectionManager().getMaxReconnectInterval());
        ArrayList arrayList = null;
        Object object2 = this;
        synchronized (object2) {
            arrayList = new ArrayList(this.txns);
        }
        hashtable.put("DetachedTransactionCount", arrayList.size());
        object2 = null;
        TransactionState transactionState = null;
        for (Object object2 : arrayList) {
            transactionState = this.translist.retrieveState((TransactionUID)object2, true);
            hashtable.put(((TransactionUID)object2).toString(), "" + transactionState);
        }
        return hashtable;
    }

    class DetachedTransactionTimerTask
    extends TimerTask {
        private long timeout;

        public DetachedTransactionTimerTask(int n) {
            this.timeout = (long)n * 1000L;
        }

        public void run() {
            TransactionHandler transactionHandler = (TransactionHandler)Globals.getPacketRouter(0).getHandler(48);
            long l = System.currentTimeMillis();
            TransactionUID[] transactionUIDArray = DetachedTransactionReaper.this.getDetachedTIDs();
            for (int i = 0; i < transactionUIDArray.length && !DetachedTransactionReaper.this.destroyed; ++i) {
                long l2;
                TransactionState transactionState = DetachedTransactionReaper.this.translist.retrieveState(transactionUIDArray[i]);
                if (transactionState == null) {
                    if (DetachedTransactionReaper.this.translist.retrieveState(transactionUIDArray[i], true) != null) continue;
                    DetachedTransactionReaper.this.removeDetachedTID(transactionUIDArray[i]);
                    continue;
                }
                if (transactionState.getState() == 5) {
                    if (!transactionState.getOnephasePrepare()) {
                        DetachedTransactionReaper.this.removeDetachedTID(transactionUIDArray[i]);
                        continue;
                    }
                } else if (transactionState.getState() != 3 && transactionState.getState() != 4) {
                    DetachedTransactionReaper.this.removeDetachedTID(transactionUIDArray[i]);
                    continue;
                }
                if (!transactionState.isDetachedFromConnection() || this.timeout <= 0L) continue;
                long l3 = this.timeout;
                if (transactionState.getState() == 5) {
                    l3 = (long)Destination.RECONNECT_MULTIPLIER * (this.timeout + Globals.getConnectionManager().getMaxReconnectInterval());
                }
                if (l < (l2 = transactionState.getDetachedTime() + l3)) continue;
                try {
                    Object[] objectArray = new String[]{transactionUIDArray[i] + "[" + TransactionState.toString(transactionState.getState()) + "]" + (transactionState.getOnephasePrepare() ? "onephase=true" : ""), String.valueOf(transactionState.getCreationTime()), String.valueOf(transactionState.getDetachedTime())};
                    Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B2185", objectArray));
                    transactionHandler.doRollback(transactionUIDArray[i], transactionState.getXid(), null, transactionState, null, null, RollbackReason.TIMEOUT);
                    DetachedTransactionReaper.this.removeDetachedTID(transactionUIDArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    Globals.getLogger().logStack(16, Globals.getBrokerResources().getKString("B2186", transactionUIDArray[i] + "[" + TransactionState.toString(transactionState.getState()) + "]"), (Throwable)exception);
                }
            }
        }
    }
}

