/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.net.http;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.net.ProtocolCallback;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.net.http.HTTPStreams;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelServerSocket;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelSocket;
import com.sun.messaging.jmq.transport.httptunnel.server.HttpTunnelServerDriver;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Hashtable;

public class HTTPProtocol
implements Protocol {
    private static boolean HTTP_ALLOWED = false;
    protected boolean nodelay = true;
    protected static final int defaultPullPeriod = -1;
    protected static final int defaultConnectionTimeout = 300;
    protected String servletHost = null;
    protected int servletPort = -1;
    protected int pullPeriod = -1;
    protected int connectionTimeout = 300;
    protected int rxBufSize = Globals.getConfig().getIntProperty("imq.httptunnel.rxBufSize", 0);
    protected HttpTunnelServerDriver driver = null;
    protected HttpTunnelServerSocket serversocket = null;
    protected ProtocolCallback cb = null;
    protected Object callback_data = null;
    protected int inputBufferSize = 2048;
    protected int outputBufferSize = 2048;

    public HTTPProtocol() {
        if (!HTTP_ALLOWED) {
            Globals.getLogger().log(32, "B3123", (Object)Globals.getBrokerResources().getString("B0037"));
            Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3123", Globals.getBrokerResources().getString("B0037")), BrokerEvent.Type.FATAL_ERROR);
        }
    }

    public void registerProtocolCallback(ProtocolCallback protocolCallback, Object object) {
        this.cb = protocolCallback;
        this.callback_data = object;
    }

    protected void notifyProtocolCallback() {
        if (this.cb != null) {
            this.cb.socketUpdated(this.callback_data, this.getLocalPort(), null);
        }
    }

    public String getHostName() {
        return null;
    }

    public boolean canPause() {
        return true;
    }

    public AbstractSelectableChannel getChannel() throws IOException {
        return null;
    }

    public void configureBlocking(boolean bl) throws UnsupportedOperationException, IOException {
        throw new UnsupportedOperationException("HttpProtocol is not a channel, can not change blocking state");
    }

    protected void createDriver() throws IOException {
        String string = InetAddress.getLocalHost().getHostName() + ":" + Globals.getConfigName();
        if (this.servletHost != null || this.servletPort != -1) {
            int n;
            String string2 = this.servletHost;
            if (string2 == null) {
                string2 = InetAddress.getLocalHost().getHostAddress();
            }
            if ((n = this.servletPort) == -1) {
                n = 7675;
            }
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetAddress inetAddress2 = InetAddress.getByName(string2);
            InetAddress inetAddress3 = InetAddress.getByName("localhost");
            if (n == Globals.getPortMapper().getPort() && (inetAddress2.equals(inetAddress) || inetAddress2.equals(inetAddress3))) {
                throw new IOException(Globals.getBrokerResources().getString("B4130"));
            }
            this.driver = new HttpTunnelServerDriver(string, string2, n);
        } else {
            this.driver = new HttpTunnelServerDriver(string);
        }
        this.driver.setInactiveConnAbortInterval(this.connectionTimeout);
        this.driver.setRxBufSize(this.rxBufSize);
    }

    protected HttpTunnelServerSocket createSocket() throws IOException {
        if (this.driver == null) {
            this.createDriver();
        }
        HttpTunnelServerSocket httpTunnelServerSocket = new HttpTunnelServerSocket(this.driver);
        return httpTunnelServerSocket;
    }

    private HTTPStreams createConnection(HttpTunnelSocket httpTunnelSocket) {
        return new HTTPStreams(httpTunnelSocket, this.inputBufferSize, this.outputBufferSize);
    }

    public ProtocolStreams accept() throws IOException {
        if (this.serversocket == null) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "Unable to accept on un-opened protocol"));
        }
        HttpTunnelSocket httpTunnelSocket = this.serversocket.accept();
        httpTunnelSocket.setPullPeriod(this.pullPeriod);
        httpTunnelSocket.setConnectionTimeout(this.connectionTimeout);
        HTTPStreams hTTPStreams = this.createConnection(httpTunnelSocket);
        return hTTPStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException, IllegalStateException {
        if (this.serversocket != null) {
            throw new IOException(Globals.getBrokerResources().getString("B4117", "can not open already opened protocol"));
        }
        if (this.serversocket == null) {
            HTTPProtocol hTTPProtocol = this;
            synchronized (hTTPProtocol) {
                if (this.serversocket == null) {
                    this.serversocket = this.createSocket();
                }
            }
        }
        this.notifyProtocolCallback();
    }

    public boolean isOpen() {
        return this.serversocket != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, IllegalStateException {
        HTTPProtocol hTTPProtocol = this;
        synchronized (hTTPProtocol) {
            if (this.serversocket == null) {
                throw new IOException(Globals.getBrokerResources().getString("B4117", "can not close un-opened protocol"));
            }
            this.serversocket.close();
            this.serversocket = null;
        }
    }

    public int getLocalPort() {
        return 0;
    }

    public void checkParameters(Hashtable hashtable) throws IllegalArgumentException {
    }

    public void setParameters(Hashtable hashtable) {
        boolean bl = this.serversocket != null;
        String string = this.getStringValue("servletHost", hashtable, null);
        int n = this.getIntValue("servletPort", hashtable, -1);
        this.pullPeriod = this.getIntValue("pullPeriod", hashtable, this.pullPeriod);
        this.connectionTimeout = this.getIntValue("connectionTimeout", hashtable, this.connectionTimeout);
        if (this.servletHost != null && !this.servletHost.equalsIgnoreCase(string) || this.servletPort != n) {
            this.servletHost = string;
            this.servletPort = n;
        }
    }

    private int getIntValue(String string, Hashtable hashtable, int n) {
        String string2 = (String)hashtable.get(string);
        if (string2 == null) {
            return n;
        }
        try {
            int n2 = Integer.parseInt(string2);
            return n2;
        }
        catch (Exception exception) {
            return n;
        }
    }

    private String getStringValue(String string, Hashtable hashtable, String string2) {
        String string3 = (String)hashtable.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public String toString() {
        return "http [ " + this.serversocket + "]";
    }

    public void setNoDelay(boolean bl) {
        this.nodelay = bl;
    }

    public void setTimeout(int n) {
    }

    public void setInputBufferSize(int n) {
        this.inputBufferSize = n;
    }

    public void setOutputBufferSize(int n) {
        this.outputBufferSize = n;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public boolean getBlocking() {
        return true;
    }

    static {
        try {
            LicenseBase licenseBase = Globals.getCurrentLicense(null);
            HTTP_ALLOWED = licenseBase.getBooleanProperty("imq.enable_http", false);
        }
        catch (BrokerException brokerException) {
            HTTP_ALLOWED = false;
        }
    }
}

