/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.util.Util301To350;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigChangeRecord {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    protected BrokerConfig config = Globals.getConfig();
    static final String BASENAME = "configrecord";
    static final int MAGIC = 305419896;
    private ArrayList timeList = new ArrayList();
    private ArrayList recordList = new ArrayList();
    private File backingFile = null;
    private RandomAccessFile raf = null;

    ConfigChangeRecord(File file, boolean bl) throws BrokerException {
        try {
            this.backingFile = new File(file, BASENAME);
            this.raf = new RandomAccessFile(this.backingFile, "rw");
            if (bl) {
                this.clearAll(false);
                if (Store.getDEBUG()) {
                    this.logger.log(1, "ConfigChangeRecord initialized with clear option");
                }
            } else {
                this.loadData(this.backingFile, this.raf, this.timeList, this.recordList, true);
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4082", (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4082"), iOException);
        }
    }

    ConfigChangeRecord(FileStore fileStore, File file, File file2) throws BrokerException {
        File file3 = new File(file2, BASENAME);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file3, "r");
            this.loadData(file3, randomAccessFile, arrayList, arrayList2);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4159", (Object)file3, (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4159", file3), iOException);
        }
        this.backingFile = new File(file, BASENAME);
        int n = 0;
        try {
            this.raf = new RandomAccessFile(this.backingFile, "rw");
            this.raf.writeInt(305419896);
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                Long l = (Long)arrayList.get(n);
                byte[] byArray = (byte[])arrayList2.get(n);
                byte[] byArray2 = Util301To350.upgradeConfigChangeRecord(byArray);
                this.appendFile(l, byArray2, false);
                this.timeList.add(l);
                this.recordList.add(byArray2);
            }
            arrayList.clear();
            arrayList2.clear();
            if (Store.getDEBUG()) {
                this.logger.log(4, "UPGRADED " + this.timeList.size() + " change records");
            }
            if (fileStore.upgradeNoBackup() && !file3.delete()) {
                this.logger.log(32, "B1044", (Object)file3);
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4142", (Throwable)iOException);
            throw new BrokerException(this.br.getString("B4142"), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeConfigChangeRecord(long l, byte[] byArray, boolean bl) throws BrokerException {
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.add(new Long(l));
            this.recordList.add(byArray);
            try {
                this.appendFile(l, byArray, bl);
            }
            catch (IOException iOException) {
                this.timeList.remove(this.timeList.size() - 1);
                this.recordList.remove(this.recordList.size() - 1);
                this.logger.log(32, "B4083", (Object)String.valueOf(l));
                throw new BrokerException(this.br.getString("B4083", String.valueOf(l)), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long l) {
        ArrayList<ChangeRecordInfo> arrayList = new ArrayList<ChangeRecordInfo>();
        ArrayList arrayList2 = this.timeList;
        synchronized (arrayList2) {
            Long l2;
            int n;
            int n2 = this.timeList.size();
            for (n = 0; n < n2 && (l2 = (Long)this.timeList.get(n)) <= l; ++n) {
            }
            while (n < n2) {
                arrayList.add(new ChangeRecordInfo((byte[])this.recordList.get(n), (Long)this.timeList.get(n)));
                ++n;
            }
            return arrayList;
        }
    }

    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        ArrayList<ChangeRecordInfo> arrayList = new ArrayList<ChangeRecordInfo>();
        for (int i = 0; i < this.timeList.size(); ++i) {
            arrayList.add(new ChangeRecordInfo((byte[])this.recordList.get(i), (Long)this.timeList.get(i)));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll(boolean bl) throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(1, "ConfigChangeRecord.clearAll() called");
        }
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.clear();
            this.recordList.clear();
        }
        try {
            this.raf.setLength(0L);
            this.raf.writeInt(305419896);
            if (bl) {
                this.sync();
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4096", (Throwable)iOException);
        }
    }

    void close(boolean bl) {
        block3: {
            if (Store.getDEBUG()) {
                this.logger.log(1, "ConfigChangeRecord: closing, " + this.timeList.size() + " persisted records");
            }
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                if (!Store.getDEBUG()) break block3;
                this.logger.log(4, "Got IOException while closing:" + this.backingFile, (Throwable)iOException);
                iOException.printStackTrace();
            }
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("Config change records", String.valueOf(this.timeList.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\nConfiguration Change Record");
        printStream.println("---------------------------");
        printStream.println("backing file: " + this.backingFile);
        printStream.println("number of records: " + this.timeList.size());
    }

    void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String string = "ConfigChangeRecord sync()";
                this.logger.log(4, string);
            }
            this.raf.getChannel().force(false);
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, iOException);
        }
    }

    private void loadData(File file, RandomAccessFile randomAccessFile, ArrayList arrayList, ArrayList arrayList2, boolean bl) throws IOException {
        if (randomAccessFile.length() == 0L) {
            if (bl) {
                randomAccessFile.writeInt(305419896);
                if (Store.getDEBUG()) {
                    this.logger.log(1, "initialized new file with magic number, " + file);
                }
            }
            return;
        }
        this.loadData(file, randomAccessFile, arrayList, arrayList2);
    }

    private void loadData(File file, RandomAccessFile randomAccessFile, ArrayList arrayList, ArrayList arrayList2) throws IOException {
        boolean bl = false;
        if (randomAccessFile.length() == 0L) {
            return;
        }
        int n = randomAccessFile.readInt();
        if (n != 305419896) {
            throw new StreamCorruptedException(this.br.getString("B3116", file));
        }
        long l = randomAccessFile.getFilePointer();
        while (!bl) {
            try {
                long l2 = randomAccessFile.readLong();
                int n2 = randomAccessFile.readInt();
                byte[] byArray = new byte[n2];
                randomAccessFile.read(byArray, 0, n2);
                l = randomAccessFile.getFilePointer();
                arrayList.add(new Long(l2));
                arrayList2.add(byArray);
            }
            catch (EOFException eOFException) {
                if (l != randomAccessFile.getFilePointer()) {
                    randomAccessFile.setLength(l);
                    this.logger.log(16, "B2074", (Object)file, (Object)new Long(l));
                }
                bl = true;
                break;
            }
            catch (IOException iOException) {
                this.logger.log(16, "B2073", (Object)new Integer(arrayList.size()), (Object)new Long(l), (Throwable)iOException);
                randomAccessFile.setLength(l);
                bl = true;
                break;
            }
        }
        if (Store.getDEBUG()) {
            this.logger.log(1, "loaded " + arrayList.size() + " records from " + file);
        }
    }

    private void appendFile(long l, byte[] byArray, boolean bl) throws IOException, BrokerException {
        long l2 = this.raf.getFilePointer();
        try {
            this.raf.writeLong(l);
            this.raf.writeInt(byArray.length);
            this.raf.write(byArray);
            if (bl) {
                this.sync();
            }
        }
        catch (IOException iOException) {
            this.raf.setLength(l2);
            throw iOException;
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "configrecord: appended ts=" + l + "; and record of " + byArray.length + " bytes to file");
        }
    }
}

