/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.bridge.BridgeServiceManager;
import com.sun.messaging.bridge.service.JMSBridgeStore;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.persist.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.StoreManager;
import com.sun.messaging.jmq.jmsserver.persist.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.PropertyDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.StoreSessionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeHAStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.VersionDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.TableSchema;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigChangeDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.sharecc.ShareConfigRecordDAOImpl;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DBTool
implements DBConstants {
    static final String SQLFILEDIR_PROP = "imq.persist.jdbcsqlfile.dirpath";
    static final String SQLFILENAME_PROP = "imq.persist.jdbcsqlfile.name";
    static final String STORE_PROPERTY_HABROKERS = "imq.cluster.haBrokers";
    static final String STORE_PROPERTY_SUPPORT_JMSBRIDGE = "imq.bridge.jmsbridge.tables";
    private static int EXTRA_CMD_SPECIFIED = 0;
    private static int BAD_CMD_ARG = 1;
    private static int BAD_OPT = 2;
    private static int BAD_OPT_ARG = 3;
    private static int MISSING_OPT_ARG = 4;
    private static int MISSING_CMD_ARG = 5;
    private static int MISSING_OPT = 6;
    private static String CMD_NAME = "dbmgrcmd";
    private static String CREATE_ALL_CMD = "createall";
    private static String CREATE_TBL_CMD = "createtbl";
    private static String CREATE_SHARECCTBL_CMD = "create sharecc_tbl";
    private static String DELETE_TBL_CMD = "deletetbl";
    private static String DELETE_SHARECCTBL_CMD = "delete sharecc_tbl";
    private static String RECREATE_TBL_CMD = "recreatetbl";
    private static String RECREATE_SHARECCTBL_CMD = "recreate sharecc_tbl";
    private static String REMOVE_BKR_CMD = "removebkr";
    private static String REMOVE_JMSBRIDGE_CMD = "removejmsbridge";
    private static String DUMP_CMD = "dump";
    private static String DUMP_SHARECCTBL_CMD = "dump sharecc_tbl";
    private static String DROPTBL_CMD = "droptbl";
    private static String RESET_CMD = "reset";
    private static String BACKUP_CMD = "backup";
    private static String BACKUP_SHARECCTBL_CMD = "backup sharecc_tbl";
    private static String RESTORE_CMD = "restore";
    private static String RESTORE_SHARECCTBL_CMD = "restore sharecc_tbl";
    private static String UPGRADE_STORE_CMD = "upgradestore";
    private static String UPGRADE_HASTORE_CMD = "upgradehastore";
    private static String QUERY_CMD = "query";
    private static String ARG_NAME = "dbmgrarg";
    private static String CREATE_CMD_STR = "create";
    private static String DELETE_CMD_STR = "delete";
    private static String RECREATE_CMD_STR = "recreate";
    private static String REMOVE_CMD_STR = "remove";
    private static String UPGRADE_CMD_STR = "upgrade";
    private static String ARGU_ALL = "all";
    private static String ARGU_TBL = "tbl";
    private static String ARGU_SHARECCTBL = "sharecc_tbl";
    private static String ARGU_BKR = "bkr";
    private static String ARGU_JMSBRIDGE = "jmsbridge";
    private static String ARGU_OLDTBL = "oldtbl";
    private static String ARGU_LCK = "lck";
    private static String ARGU_STORE = "store";
    private static String ARGU_HASTORE = "hastore";
    private static String OPT_H = "-h";
    private static String OPT_LH = "-help";
    private static String OPT_V = "-v";
    private static String OPT_LV = "-version";
    private static String OPT_B = "-b";
    private static String OPT_N = "-n";
    private static String OPT_U = "-u";
    private static String OPT_P = "-p";
    private static String OPT_PW = "-pw";
    private static String OPT_PASSFILE = "-passfile";
    private static String OPT_D = "-D";
    private static String OPT_VARHOME = "-varhome";
    private static String OPT_VERBOSE = "-verbose";
    private static String OPT_DEBUG = "-debug";
    private static String OPT_DIR = "-dir";
    private static String OPT_FILE = "-file";
    private static String OPT_FORCE = "-f";
    private static String JMSBRIDGE_NAME_PROPERTY = "jmsbridge.name";
    private static BrokerResources br = Globals.getBrokerResources();
    private static BrokerConfig config;
    private static Logger logger;
    private Version version = new Version();
    private DBManager dbmgr = null;
    private boolean standalone = true;
    private boolean cliPasswdSpecified = false;
    private boolean debugSpecified = false;
    private boolean forceSpecified = false;

    DBTool(boolean bl) {
        this.standalone = bl;
    }

    private void doCreate(boolean bl) throws BrokerException {
        this.doCreate(bl, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCreate(boolean bl, CommDBManager commDBManager) throws BrokerException {
        CommDBManager commDBManager2 = commDBManager == null ? this.dbmgr : commDBManager;
        Connection connection = null;
        try {
            block15: {
                try {
                    if (bl) {
                        connection = commDBManager2.connectToCreate();
                        connection.setAutoCommit(true);
                    } else {
                        connection = commDBManager2.getNewConnection(true);
                    }
                    boolean bl2 = false;
                    int n = commDBManager2.checkStoreExists(connection);
                    if (n > 0) {
                        if (commDBManager2 instanceof ShareConfigChangeDBManager) throw new BrokerException(br.getKString("B3263", Globals.getClusterID()));
                        throw new BrokerException(br.getKString("B3210"));
                    }
                    if (n < 0) {
                        bl2 = true;
                    }
                    DBTool.createTables(connection, bl2, commDBManager2);
                    if (!this.standalone) break block15;
                    if (Globals.getHAEnabled()) {
                        System.out.println(br.getString("B1165", Globals.getClusterID()));
                        break block15;
                    }
                    if (commDBManager2 instanceof ShareConfigChangeDBManager) {
                        System.out.println(br.getString("B1362", Globals.getClusterID()));
                    } else {
                        System.out.println(br.getString("B1046"));
                    }
                }
                catch (Throwable throwable) {
                    String string;
                    if (bl) {
                        string = commDBManager2.getCreateDBURL();
                        throw new BrokerException(br.getKString("B3073", string), throwable);
                    }
                    string = commDBManager2.getOpenDBURL();
                    throw new BrokerException(br.getKString("B3073", string), throwable);
                }
            }
            Object var8_9 = null;
            if (!bl) return;
            if (connection == null) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (!bl) throw throwable;
            if (connection == null) throw throwable;
            try {
                connection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException));
            }
        }
        try {}
        catch (SQLException sQLException) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException));
        }
        connection.close();
    }

    static void createTables(Connection connection) throws BrokerException {
        DBTool.createTables(connection, false);
    }

    static void createTables(Connection connection, boolean bl) throws BrokerException {
        DBTool.createTables(connection, bl, null, null);
    }

    public static void createTables(Connection connection, boolean bl, CommDBManager commDBManager) throws BrokerException {
        DBTool.createTables(connection, bl, null, commDBManager);
    }

    static void createTables(Connection connection, boolean bl, ArrayList arrayList) throws BrokerException {
        DBTool.createTables(connection, bl, arrayList, null);
    }

    static void createTables(Connection connection, boolean bl, ArrayList arrayList, CommDBManager commDBManager) throws BrokerException {
        Object object;
        Object object2;
        CommDBManager commDBManager2 = commDBManager;
        if (commDBManager2 == null) {
            commDBManager2 = DBManager.getDBManager();
        }
        Iterator iterator = null;
        iterator = arrayList != null ? arrayList.iterator() : commDBManager2.allDAOIterator();
        block8: while (iterator.hasNext()) {
            object2 = (BaseDAO)iterator.next();
            try {
                object = null;
                while (true) {
                    try {
                        object2.createTable(connection);
                        continue block8;
                    }
                    catch (Exception exception) {
                        if (object == null) {
                            object = new Util.RetryStrategy(commDBManager2);
                        }
                        ((Util.RetryStrategy)object).assertShouldRetry(exception);
                        continue;
                    }
                    break;
                }
            }
            catch (BrokerException brokerException) {
                if (Globals.getHAEnabled() || commDBManager2 instanceof ShareConfigChangeDBManager) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (commDBManager2.checkStoreExists(connection) > 0) {
                    if (arrayList == null) {
                        Globals.getLogger().log(16, "B3073", (Object)Globals.getBrokerResources().getString("B3210"));
                        bl = true;
                        break;
                    }
                    Globals.getLogger().log(16, "B3073", (Object)Globals.getBrokerResources().getString("B3237", object2.getTableName()));
                    break;
                }
                if (bl) {
                    Globals.getLogger().log(16, brokerException.toString(), brokerException.getCause());
                    continue;
                }
                throw brokerException;
            }
        }
        if (arrayList != null || !(commDBManager2 instanceof DBManager)) {
            return;
        }
        object2 = ((DBManager)commDBManager2).getDAOFactory();
        object = ((DAOFactory)object2).getVersionDAO();
        try {
            if (bl) {
                int n = object.getStoreVersion(connection);
                if (n != 410) {
                    object.insert(connection, 410);
                }
            } else {
                object.insert(connection, 410);
            }
        }
        catch (BrokerException brokerException) {
            if (Globals.getHAEnabled()) {
                int n = object.getStoreVersion(connection);
                if (n != 410) {
                    throw brokerException;
                }
            }
            throw brokerException;
        }
        if (!Globals.getHAEnabled()) {
            String string = Globals.getBrokerID();
            StoreSessionDAO storeSessionDAO = ((DAOFactory)object2).getStoreSessionDAO();
            if (storeSessionDAO.getStoreSession(connection, string) <= 0L) {
                storeSessionDAO.insert(connection, string, new UID().longValue(), true);
            }
        }
        PropertyDAO propertyDAO = ((DAOFactory)object2).getPropertyDAO();
        propertyDAO.update(connection, STORE_PROPERTY_SUPPORT_JMSBRIDGE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateStoreVersion410IfNecessary(Connection connection) throws BrokerException {
        try {
            DBManager dBManager;
            DAOFactory dAOFactory;
            VersionDAO versionDAO;
            int n;
            if (!Globals.getHAEnabled()) {
                DBManager.lockTables(connection, true);
            }
            if ((n = (versionDAO = (dAOFactory = (dBManager = DBManager.getDBManager()).getDAOFactory()).getVersionDAO()).getStoreVersion(connection)) != 410) {
                throw new BrokerException(br.getKString("B3092", String.valueOf(n), String.valueOf(410)));
            }
            PropertyDAO propertyDAO = dAOFactory.getPropertyDAO();
            if (!propertyDAO.hasProperty(connection, STORE_PROPERTY_SUPPORT_JMSBRIDGE)) {
                ArrayList<BaseDAO> arrayList = new ArrayList<BaseDAO>();
                arrayList.add(dAOFactory.getTMLogRecordDAOJMSBG());
                arrayList.add(dAOFactory.getJMSBGDAO());
                DBTool.createTables(connection, false, arrayList);
                propertyDAO.update(connection, STORE_PROPERTY_SUPPORT_JMSBRIDGE, true);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!Globals.getHAEnabled()) {
                DBManager.lockTables(connection, false);
            }
            throw throwable;
        }
        if (!Globals.getHAEnabled()) {
            DBManager.lockTables(connection, false);
        }
    }

    private void doReset() throws BrokerException {
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            try {
                connection = this.dbmgr.getConnection(true);
                DBManager.lockTables(connection, false);
            }
            catch (BrokerException brokerException2) {
                brokerException = brokerException2;
                throw brokerException2;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Util.close(null, null, connection, brokerException);
            throw throwable;
        }
        Util.close(null, null, connection, brokerException);
    }

    private void doDelete(String string) throws BrokerException {
        this.doDelete(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDelete(String string, CommDBManager commDBManager) throws BrokerException {
        CommDBManager commDBManager2 = commDBManager == null ? this.dbmgr : commDBManager;
        boolean bl = false;
        Connection connection = null;
        Exception exception = null;
        try {
            block25: {
                try {
                    connection = commDBManager2.getConnection(true);
                    if (string == null || string.length() == 0) {
                        boolean bl2 = false;
                        int n = commDBManager2.checkStoreExists(connection);
                        if (n > 0 && !(commDBManager2 instanceof ShareConfigChangeDBManager)) {
                            if (!this.forceSpecified && Globals.getHAEnabled() && ((DBManager)commDBManager2).isHAClusterActive(connection)) {
                                throw new BrokerException(br.getKString("B3209", this.dbmgr.getClusterID()));
                            }
                            try {
                                if (!this.forceSpecified) {
                                    DBManager cfr_ignored_0 = (DBManager)commDBManager2;
                                    DBManager.lockTables(connection, true);
                                }
                            }
                            catch (BrokerException brokerException) {
                                if (brokerException.getStatusCode() != 404) throw brokerException;
                                bl2 = true;
                            }
                        } else if (n > 0 && commDBManager2 instanceof ShareConfigChangeDBManager) {
                            try {
                                if (!this.forceSpecified) {
                                    ((ShareConfigChangeDBManager)commDBManager2).lockTable(connection, true);
                                }
                            }
                            catch (BrokerException brokerException) {
                                if (brokerException.getStatusCode() != 404) throw brokerException;
                                bl2 = true;
                            }
                        } else {
                            if (n >= 0) {
                                if (commDBManager2 instanceof ShareConfigChangeDBManager) throw new BrokerException(br.getKString("B3258", Globals.getClusterID()));
                                throw new BrokerException(br.getKString("B3211"));
                            }
                            bl2 = true;
                        }
                        bl = DBTool.dropTables(connection, null, bl2, commDBManager);
                    } else if (string.equals(ARGU_OLDTBL)) {
                        int n = -1;
                        if (DBTool.checkVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID())) {
                            n = 370;
                        } else {
                            if (!DBTool.checkVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID())) throw new BrokerException("Old persistent store (version 370) not found");
                            n = 350;
                        }
                        bl = DBTool.dropTables(connection, this.dbmgr.getTableNames(n));
                    }
                    if (!this.standalone || !bl) break block25;
                    if (Globals.getHAEnabled()) {
                        System.out.println(br.getString("B1166", Globals.getClusterID()));
                        break block25;
                    }
                    if (commDBManager2 instanceof ShareConfigChangeDBManager) {
                        System.out.println(br.getString("B1363", Globals.getClusterID()));
                        break block25;
                    }
                    System.out.println(br.getString("B1051"));
                }
                catch (Exception exception2) {
                    exception = exception2;
                    if (this.debugSpecified) {
                        exception2.printStackTrace();
                    }
                    if (commDBManager2 instanceof ShareConfigChangeDBManager) throw new BrokerException(br.getKString("B3257", Globals.getClusterID(), commDBManager2.getOpenDBURL()), exception2);
                    throw new BrokerException(br.getKString("B3075", commDBManager2.getOpenDBURL()), exception2);
                }
            }
            Object var11_13 = null;
            Util.close(null, null, connection, exception, commDBManager);
            return;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            Util.close(null, null, connection, exception, commDBManager);
            throw throwable;
        }
    }

    static boolean dropTables(Connection connection, String[] stringArray) throws SQLException, BrokerException {
        return DBTool.dropTables(connection, stringArray, false);
    }

    static boolean dropTables(Connection connection, String[] stringArray, boolean bl) throws SQLException, BrokerException {
        return DBTool.dropTables(connection, stringArray, bl, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean dropTables(Connection connection, String[] stringArray, boolean bl, CommDBManager commDBManager) throws SQLException, BrokerException {
        CommDBManager commDBManager2 = commDBManager == null ? DBManager.getDBManager() : commDBManager;
        boolean bl2 = false;
        SQLException sQLException = null;
        try {
            Statement statement;
            block18: {
                if (stringArray != null && stringArray.length > 0) {
                    statement = null;
                    try {
                        try {
                            statement = connection.createStatement();
                            for (String string : stringArray) {
                                Globals.getLogger().logToAll(8, br.getString("B1164", string));
                                statement.executeUpdate("DROP TABLE " + string);
                                if (!commDBManager2.hasSupplementForCreateDrop(string)) continue;
                                TableSchema tableSchema = commDBManager2.getTableSchema(string);
                                commDBManager2.dropTableSupplement(statement, tableSchema, string, true);
                            }
                            Object var13_19 = null;
                        }
                        catch (SQLException sQLException2) {
                            sQLException = sQLException2;
                            throw sQLException2;
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var13_20 = null;
                        Util.close(null, statement, null, sQLException, commDBManager2);
                        throw throwable;
                    }
                }
                Iterator iterator = commDBManager2.allDAOIterator();
                block11: while (iterator.hasNext()) {
                    BaseDAO baseDAO = (BaseDAO)iterator.next();
                    try {
                        Util.RetryStrategy retryStrategy = null;
                        while (true) {
                            try {
                                baseDAO.dropTable(connection);
                                continue block11;
                            }
                            catch (Exception exception) {
                                if (retryStrategy == null) {
                                    retryStrategy = new Util.RetryStrategy(commDBManager2);
                                }
                                retryStrategy.assertShouldRetry(exception);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (BrokerException brokerException) {
                        if (!bl) throw brokerException;
                        Globals.getLogger().log(16, brokerException.toString(), brokerException.getCause());
                    }
                }
                return true;
            }
            Util.close(null, statement, null, sQLException, commDBManager2);
            return true;
        }
        catch (Exception exception) {
            if (!(commDBManager2 instanceof ShareConfigChangeDBManager)) {
                Globals.getLogger().log(32, "B3075", (Object)exception.toString(), (Throwable)exception);
            } else {
                Globals.getLogger().log(32, "B3257", (Object)Globals.getClusterID(), (Object)exception.toString(), (Throwable)exception);
            }
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            if (!(exception instanceof BrokerException)) throw new BrokerException(exception.getMessage(), exception);
            throw (BrokerException)exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkVersion(Connection connection, String string) throws BrokerException {
        String string2 = "SELECT * FROM " + string;
        Statement statement = null;
        ResultSet resultSet = null;
        SQLException sQLException = null;
        try {
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string2);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                boolean bl = false;
                Object var9_7 = null;
                Util.close(resultSet, statement, null, sQLException);
                return bl;
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            Util.close(resultSet, statement, null, sQLException);
            throw throwable;
        }
        Util.close(resultSet, statement, null, sQLException);
        return true;
    }

    private void doRecreate() throws BrokerException {
        this.doRecreate(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRecreate(CommDBManager commDBManager) throws BrokerException {
        CommDBManager commDBManager2 = commDBManager == null ? this.dbmgr : commDBManager;
        Connection connection = null;
        Throwable throwable = null;
        try {
            block21: {
                try {
                    connection = commDBManager2.getConnection(true);
                    boolean bl = false;
                    boolean bl2 = false;
                    int n = commDBManager2.checkStoreExists(connection);
                    if (n > 0 && !(commDBManager2 instanceof ShareConfigChangeDBManager)) {
                        if (!this.forceSpecified && Globals.getHAEnabled() && ((DBManager)commDBManager2).isHAClusterActive(connection)) {
                            throw new BrokerException(br.getKString("B3209", this.dbmgr.getClusterID()));
                        }
                        try {
                            if (!this.forceSpecified) {
                                DBManager cfr_ignored_0 = (DBManager)commDBManager2;
                                DBManager.lockTables(connection, true);
                            }
                        }
                        catch (BrokerException brokerException) {
                            if (brokerException.getStatusCode() != 404) throw brokerException;
                            bl2 = true;
                        }
                    } else if (n > 0 && commDBManager2 instanceof ShareConfigChangeDBManager) {
                        try {
                            if (!this.forceSpecified) {
                                ((ShareConfigChangeDBManager)commDBManager2).lockTable(connection, true);
                            }
                        }
                        catch (BrokerException brokerException) {
                            if (brokerException.getStatusCode() != 404) throw brokerException;
                            bl2 = true;
                        }
                    } else if (n < 0) {
                        bl2 = true;
                    } else {
                        bl = true;
                    }
                    if (!bl) {
                        DBTool.dropTables(connection, null, bl2, commDBManager);
                    }
                    DBTool.createTables(connection, false, commDBManager);
                    if (!this.standalone) break block21;
                    if (Globals.getHAEnabled()) {
                        System.out.println(br.getString("B1165", Globals.getClusterID()));
                        break block21;
                    }
                    if (commDBManager2 instanceof ShareConfigChangeDBManager) {
                        System.out.println(br.getString("B1362", Globals.getClusterID()));
                        break block21;
                    }
                    System.out.println(br.getString("B1046"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    if (commDBManager2 instanceof ShareConfigChangeDBManager) throw new BrokerException(br.getKString("B3256", Globals.getClusterID(), commDBManager2.getOpenDBURL()), throwable2);
                    throw new BrokerException(br.getKString("B3076", commDBManager2.getOpenDBURL()), throwable2);
                }
            }
            Object var10_11 = null;
            Util.close(null, null, connection, throwable, commDBManager);
            return;
        }
        catch (Throwable throwable3) {
            Object var10_12 = null;
            Util.close(null, null, connection, throwable, commDBManager);
            throw throwable3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveBkr() throws BrokerException {
        String string = Globals.getBrokerID();
        Connection connection = null;
        String string2 = null;
        Exception exception = null;
        try {
            try {
                connection = this.dbmgr.getConnection(true);
                DBManager.lockTables(connection, true);
                try {
                    block12: {
                        DAOFactory dAOFactory = this.dbmgr.getDAOFactory();
                        BrokerDAO brokerDAO = dAOFactory.getBrokerDAO();
                        BrokerState brokerState = brokerDAO.getState(connection, string);
                        if (!brokerState.isActiveState()) {
                            try {
                                connection.setAutoCommit(false);
                                dAOFactory.getConsumerStateDAO().deleteAll(connection);
                                dAOFactory.getMessageDAO().deleteAll(connection);
                                dAOFactory.getDestinationDAO().deleteAll(connection);
                                dAOFactory.getTransactionDAO().deleteAll(connection);
                                dAOFactory.getStoreSessionDAO().deleteByBrokerID(connection, string);
                                brokerDAO.delete(connection, string);
                                dAOFactory.getTMLogRecordDAOJMSBG().deleteAll(connection);
                                dAOFactory.getJMSBGDAO().deleteAll(connection);
                                connection.commit();
                                Object var9_9 = null;
                            }
                            catch (Throwable throwable) {
                                Object var9_10 = null;
                                connection.setAutoCommit(true);
                                throw throwable;
                            }
                            connection.setAutoCommit(true);
                            {
                                break block12;
                            }
                        }
                        string2 = br.getString("B3182", string, "broker is still active - " + brokerState);
                    }
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    DBManager.lockTables(connection, false);
                    throw throwable;
                }
                DBManager.lockTables(connection, false);
                Object var13_15 = null;
            }
            catch (Exception exception2) {
                exception = exception2;
                throw new BrokerException(br.getKString("B3183", string), exception2);
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            Util.close(null, null, connection, exception);
            throw throwable;
        }
        Util.close(null, null, connection, exception);
        if (this.standalone) {
            if (string2 == null) {
                System.out.println(br.getString("B1167", string));
            } else {
                System.out.println(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRemoveJMSBridge(String string) throws BrokerException {
        Exception exception;
        String string2;
        Connection connection;
        block16: {
            block15: {
                if (string == null) {
                    try {
                        this.checkArg(null, null, OPT_N, 0, 0);
                    }
                    catch (ParserException parserException) {
                        this.handleParserException(parserException);
                        this.exit(1);
                    }
                }
                String string3 = Globals.getBrokerID();
                connection = null;
                string2 = null;
                exception = null;
                try {
                    try {
                        if (!this.askConfirmation("Removing JMS Bridge " + string + ".")) {
                            Object var14_7 = null;
                            break block15;
                        }
                        connection = this.dbmgr.getConnection(true);
                        DBManager.lockTables(connection, true);
                        try {
                            DAOFactory dAOFactory = this.dbmgr.getDAOFactory();
                            BrokerDAO brokerDAO = dAOFactory.getBrokerDAO();
                            BrokerState brokerState = brokerDAO.getState(connection, string3);
                            if (!brokerState.isActiveState()) {
                                try {
                                    connection.setAutoCommit(false);
                                    dAOFactory.getJMSBGDAO().delete(connection, string, null);
                                    dAOFactory.getTMLogRecordDAOJMSBG().deleteAllByName(connection, string, null);
                                    connection.commit();
                                    Object var10_14 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var10_15 = null;
                                    connection.setAutoCommit(true);
                                    throw throwable;
                                }
                                connection.setAutoCommit(true);
                            } else {
                                string2 = br.getString("B3238");
                            }
                            Object var12_17 = null;
                        }
                        catch (Throwable throwable) {
                            Object var12_18 = null;
                            DBManager.lockTables(connection, false);
                            throw throwable;
                        }
                        DBManager.lockTables(connection, false);
                        break block16;
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        throw new BrokerException(br.getString("B3239", string, exception2.getMessage()), exception2);
                    }
                }
                catch (Throwable throwable) {
                    Object var14_9 = null;
                    Util.close(null, null, connection, exception);
                    throw throwable;
                }
            }
            Util.close(null, null, connection, exception);
            return;
        }
        Object var14_8 = null;
        Util.close(null, null, connection, exception);
        if (!this.standalone) return;
        if (string2 == null) {
            System.out.println(br.getString("B1323", string));
            return;
        }
        System.out.println(string2);
    }

    private void doUpgrade(boolean bl) throws BrokerException {
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            block11: {
                try {
                    connection = this.dbmgr.getConnection(true);
                    if (bl) {
                        new UpgradeHAStore().upgradeStore(connection);
                        break block11;
                    }
                    JDBCStore jDBCStore = (JDBCStore)StoreManager.getStore();
                    int n = -1;
                    if (jDBCStore.checkOldStoreVersion(connection, this.dbmgr.getTableName("MQVER40"), "STORE_VERSION", 400)) {
                        n = 400;
                    } else if (jDBCStore.checkOldStoreVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID(), "STOREVERSION", 370)) {
                        n = 370;
                    } else if (jDBCStore.checkOldStoreVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID(), "STOREVERSION", 350)) {
                        n = 350;
                    } else {
                        throw new BrokerException("Old persistent store (version 400) not found");
                    }
                    new UpgradeStore(jDBCStore, n).upgradeStore(connection);
                }
                catch (BrokerException brokerException2) {
                    brokerException = brokerException2;
                    throw brokerException2;
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Util.close(null, null, connection, brokerException);
            throw throwable;
        }
        Util.close(null, null, connection, brokerException);
    }

    private void doDump(String string, CommDBManager commDBManager) throws SQLException, BrokerException {
        CommDBManager commDBManager2 = commDBManager == null ? this.dbmgr : commDBManager;
        String[] stringArray = null;
        if (!(commDBManager2 instanceof ShareConfigChangeDBManager)) {
            int n = 410;
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 0;
                }
            }
            if (n != 410 && ((stringArray = commDBManager2.getTableNames(n)) == null || stringArray.length == 0)) {
                throw new BrokerException("version " + string + " not supported");
            }
        }
        Connection connection = null;
        Exception exception = null;
        try {
            try {
                connection = commDBManager2.getConnection(true);
                DBTool.doDump(connection, stringArray, commDBManager2);
            }
            catch (SQLException sQLException) {
                exception = sQLException;
                throw sQLException;
            }
            catch (BrokerException brokerException) {
                exception = brokerException;
                throw brokerException;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Util.close(null, null, connection, exception, commDBManager2);
            throw throwable;
        }
        Util.close(null, null, connection, exception, commDBManager2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void doDump(Connection connection, String[] stringArray, CommDBManager commDBManager) throws BrokerException, SQLException {
        CommDBManager commDBManager2 = commDBManager;
        if (stringArray != null && stringArray.length > 0) {
            Statement statement = null;
            SQLException sQLException = null;
            try {
                try {
                    statement = connection.createStatement();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ResultSet resultSet = null;
                        String string = stringArray[i];
                        String string2 = "SELECT COUNT(*) FROM " + string;
                        try {
                            resultSet = statement.executeQuery(string2);
                            if (resultSet.next()) {
                                System.out.println(string + ": number of row=" + resultSet.getInt(1));
                            }
                            resultSet.close();
                            continue;
                        }
                        catch (SQLException sQLException2) {
                            SQLException sQLException3 = CommDBManager.wrapSQLException("[" + string2 + "]", sQLException2);
                            logger.log(32, "failed to dump tables", (Throwable)sQLException3);
                        }
                    }
                    Object var13_15 = null;
                }
                catch (SQLException sQLException4) {
                    sQLException = sQLException4;
                    throw sQLException4;
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                Util.close(null, statement, null, sQLException, commDBManager2);
                throw throwable;
            }
            Util.close(null, statement, null, sQLException, commDBManager2);
            return;
        }
        Iterator iterator = commDBManager2.allDAOIterator();
        while (iterator.hasNext()) {
            BaseDAO baseDAO = (BaseDAO)iterator.next();
            System.out.println(baseDAO.getDebugInfo(connection).toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDropTablesByPattern(String string) throws BrokerException {
        Exception exception;
        Connection connection;
        block10: {
            block9: {
                block8: {
                    connection = null;
                    exception = null;
                    try {
                        try {
                            connection = this.dbmgr.getConnection(true);
                            Map map = this.dbmgr.getTableNamesFromDB(connection, string, false);
                            String[] stringArray = map.values().toArray(new String[0]);
                            if (stringArray == null || stringArray.length == 0) {
                                System.out.println("There were no tables that match the name pattern 'MQ*" + string + "'.");
                                Object var9_7 = null;
                                break block8;
                            }
                            System.out.println("Tables matching the name pattern 'MQ*" + string + "':");
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                System.out.println("\t" + stringArray[i]);
                            }
                            if (!this.askConfirmation("Remove all tables that match 'MQ*" + string + "'.")) {
                                break block9;
                            }
                            DBTool.dropTables(connection, stringArray, true);
                            break block10;
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            System.err.println("Failed to drop tables by name pattern: " + exception2.getMessage());
                            throw new BrokerException(br.getKString("B3075", "table name pattern '" + string + "'"), exception2);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        Util.close(null, null, connection, exception);
                        throw throwable;
                    }
                }
                Util.close(null, null, connection, exception);
                return;
            }
            Object var9_8 = null;
            Util.close(null, null, connection, exception);
            return;
        }
        Object var9_9 = null;
        Util.close(null, null, connection, exception);
    }

    private boolean askConfirmation(String string) throws IOException {
        if (this.forceSpecified) {
            return true;
        }
        System.out.println(string + "\nDo you wish to proceed? [y/n] ");
        System.out.flush();
        String string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
        return "y".equalsIgnoreCase(string2) || "yes".equalsIgnoreCase(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void doBackup() throws BrokerException {
        block28: {
            Object object2;
            if (!Globals.getHAEnabled()) {
                throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
            }
            Properties properties = System.getProperties();
            String string = Globals.getClusterID();
            String string2 = (String)properties.get("imq.backupdir") + File.separator + string;
            logger.logToAll(8, "Backup persistent store for HA cluster " + string);
            FileStore fileStore = new FileStore(string2, false);
            fileStore.clearAll(false);
            JDBCStore jDBCStore = null;
            jDBCStore = (JDBCStore)StoreManager.getStore();
            Properties properties2 = jDBCStore.getAllProperties();
            for (Object object2 : properties2.entrySet()) {
                fileStore.updateProperty((String)object2.getKey(), object2.getValue(), false);
            }
            Iterator<Map.Entry<Object, Object>> iterator = null;
            properties2 = null;
            object2 = jDBCStore.getAllConfigRecords();
            int n = object2.size();
            for (int i = 0; i < n; ++i) {
                fileStore.storeConfigChangeRecord(((ChangeRecordInfo)object2.get(i)).getTimestamp(), ((ChangeRecordInfo)object2.get(i)).getRecord(), false);
            }
            object2 = null;
            Consumer[] consumerArray = jDBCStore.getAllInterests();
            for (n = 0; n < consumerArray.length; ++n) {
                fileStore.storeInterest(consumerArray[n], false);
            }
            consumerArray = null;
            HashMap hashMap = jDBCStore.getAllBrokerInfos(true);
            ArrayList arrayList = new ArrayList(hashMap.values());
            fileStore.updateProperty(STORE_PROPERTY_HABROKERS, arrayList, true);
            for (HABrokerInfo hABrokerInfo : arrayList) {
                Object var35_43;
                String string3 = hABrokerInfo.getId();
                logger.logToAll(8, "Backup persistent data for broker " + string3);
                Store store = null;
                JMSBridgeStore jMSBridgeStore = null;
                try {
                    Object object3;
                    Object[] objectArray;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object82;
                    int n2;
                    String string4 = string2 + File.separator + string3;
                    store = new FileStore(string4, false);
                    ((FileStore)store).clearAll(false);
                    Destination[] destinationArray = jDBCStore.getAllDestinations(string3);
                    int n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object82 = destinationArray[n2].getDestinationUID();
                        object7 = ((FileStore)store).getDestination((DestinationUID)object82);
                        if (object7 != null) continue;
                        ((FileStore)store).storeDestination(destinationArray[n2], false);
                    }
                    n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        Object var33_42;
                        object82 = jDBCStore.messageEnumeration(destinationArray[n2]);
                        try {
                            while (object82.hasMoreElements()) {
                                object7 = destinationArray[n2].getDestinationUID();
                                object4 = jDBCStore.getInterestStates((DestinationUID)object7, (SysMessageID)(object6 = (object5 = (TransactionAcknowledgement[])object82.nextElement()).getSysMessageID()));
                                if (object4 == null || ((HashMap)object4).isEmpty()) {
                                    ((FileStore)store).storeMessage((DestinationUID)object7, (Packet)object5, false);
                                    continue;
                                }
                                int n4 = ((HashMap)object4).size();
                                objectArray = new ConsumerUID[n4];
                                object3 = new int[n4];
                                Iterator iterator2 = ((HashMap)object4).entrySet().iterator();
                                int n5 = 0;
                                while (iterator2.hasNext()) {
                                    Map.Entry entry = iterator2.next();
                                    objectArray[n5] = (ConsumerUID)entry.getKey();
                                    object3[n5] = (Integer)entry.getValue();
                                    ++n5;
                                }
                                ((FileStore)store).storeMessage((DestinationUID)object7, (Packet)object5, (ConsumerUID[])objectArray, (int[])object3, false);
                            }
                            var33_42 = null;
                            jDBCStore.closeEnumeration((Enumeration)object82);
                            continue;
                        }
                        catch (Throwable throwable) {
                            var33_42 = null;
                            jDBCStore.closeEnumeration((Enumeration)object82);
                            throw throwable;
                        }
                    }
                    Collection collection = jDBCStore.getTransactions(string3);
                    for (Object object82 : collection) {
                        object7 = jDBCStore.getTransactionInfo((TransactionUID)object82);
                        object5 = jDBCStore.getTransactionAcks((TransactionUID)object82);
                        ((FileStore)store).storeTransaction((TransactionUID)object82, (TransactionInfo)object7, false);
                        int n6 = ((TransactionAcknowledgement[])object5).length;
                        for (int i = 0; i < n6; ++i) {
                            ((FileStore)store).storeTransactionAck((TransactionUID)object82, object5[i], false);
                        }
                    }
                    object82 = new Properties();
                    ((Properties)object82).setProperty("instanceRootDir", string4);
                    ((Properties)object82).setProperty("reset", "true");
                    ((Properties)object82).setProperty("logdomain", "imqdbmgr");
                    ((Properties)object82).setProperty("identityName", Globals.getIdentityName());
                    BridgeServiceManager.getExportedService("com.sun.messaging.bridge.service.JMSBridgeStore", "JMS", (Properties)object82);
                    object7 = jDBCStore.getJMSBridgesByBroker(string3, null);
                    Collections.sort(object7);
                    object5 = null;
                    object6 = null;
                    object4 = object7.iterator();
                    while (object4.hasNext()) {
                        object5 = (String)object4.next();
                        if (object6 != null && ((String)object6).equals(object5)) continue;
                        object6 = object5;
                        ((Properties)object82).setProperty("jmsbridge", (String)object5);
                        if (jMSBridgeStore != null) {
                            jMSBridgeStore.closeJMSBridgeStore();
                            jMSBridgeStore = null;
                        }
                        logger.logToAll(8, "Backup JMS bridge " + (String)object5);
                        jMSBridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService("com.sun.messaging.bridge.service.JMSBridgeStore", "JMS", (Properties)object82);
                        List list = jDBCStore.getLogRecordsByNameByBroker((String)object5, string3, null);
                        logger.logToAll(8, "\tBackup JMS bridge " + (String)object5 + " with " + list.size() + " TM log records");
                        objectArray = null;
                        object3 = list.iterator();
                        while (object3.hasNext()) {
                            objectArray = (byte[])object3.next();
                            jMSBridgeStore.storeTMLogRecord(null, (byte[])objectArray, (String)object6, true, null);
                        }
                    }
                    var35_43 = null;
                }
                catch (Throwable throwable) {
                    var35_43 = null;
                    store.close();
                    if (jMSBridgeStore != null) {
                        jMSBridgeStore.closeJMSBridgeStore();
                    }
                    throw throwable;
                }
                store.close();
                if (jMSBridgeStore == null) continue;
                jMSBridgeStore.closeJMSBridgeStore();
                {
                }
            }
            logger.logToAll(8, "Backup persistent store complete.");
            Object var37_46 = null;
            if (fileStore == null) break block28;
            try {
                fileStore.close();
                break block28;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            {
                break block28;
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new BrokerException(throwable.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var37_47 = null;
                if (fileStore != null) {
                    try {
                        fileStore.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                StoreManager.releaseStore(true);
                throw throwable;
            }
        }
        StoreManager.releaseStore(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doRestore() throws BrokerException {
        block32: {
            Map.Entry<Object, Object> entry2222;
            if (!Globals.getHAEnabled()) {
                throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
            }
            Properties properties = System.getProperties();
            String string = Globals.getClusterID();
            String string2 = (String)properties.get("imq.backupdir") + File.separator + string;
            logger.logToAll(8, "Restore persistent store for HA cluster " + string + " from backup dir: " + string2);
            FileStore fileStore = new FileStore(string2, false);
            JDBCStore jDBCStore = null;
            this.doRecreate();
            jDBCStore = (JDBCStore)StoreManager.getStore();
            List list = null;
            Properties properties2 = fileStore.getAllProperties();
            for (Map.Entry<Object, Object> entry2222 : properties2.entrySet()) {
                String string3 = (String)entry2222.getKey();
                if (string3.equals(STORE_PROPERTY_HABROKERS)) {
                    list = (List)entry2222.getValue();
                    continue;
                }
                jDBCStore.updateProperty(string3, entry2222.getValue(), false);
            }
            Iterator<Map.Entry<Object, Object>> iterator = null;
            properties2 = null;
            if (list == null || list.isEmpty()) {
                throw new BrokerException(br.getKString("B4221"));
            }
            entry2222 = fileStore.getAllConfigRecords();
            int n = entry2222.size();
            for (int i = 0; i < n; ++i) {
                jDBCStore.storeConfigChangeRecord(((ChangeRecordInfo)entry2222.get(i)).getTimestamp(), ((ChangeRecordInfo)entry2222.get(i)).getRecord(), false);
            }
            entry2222 = null;
            Consumer[] consumerArray = fileStore.getAllInterests();
            for (n = 0; n < consumerArray.length; ++n) {
                jDBCStore.storeInterest(consumerArray[n], false);
            }
            consumerArray = null;
            for (HABrokerInfo hABrokerInfo : list) {
                jDBCStore.addBrokerInfo(hABrokerInfo, false);
            }
            for (HABrokerInfo hABrokerInfo : list) {
                Object var34_43;
                String string4 = hABrokerInfo.getId();
                long l = hABrokerInfo.getSessionID();
                logger.logToAll(8, "Restore persistent data for broker " + string4);
                Store store = null;
                JMSBridgeStore jMSBridgeStore = null;
                try {
                    Object object;
                    Object[] objectArray;
                    Object object2;
                    Object object3;
                    Object object42222;
                    int n2;
                    String string5 = string2 + File.separator + string4;
                    store = new FileStore(string5, false);
                    Destination[] destinationArray = ((FileStore)store).getAllDestinations();
                    int n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object42222 = destinationArray[n2].getDestinationUID();
                        object3 = jDBCStore.getDestination((DestinationUID)object42222);
                        if (object3 != null) continue;
                        jDBCStore.storeDestination(destinationArray[n2], l);
                    }
                    n3 = destinationArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object42222 = ((FileStore)store).messageEnumeration(destinationArray[n2]);
                        while (object42222.hasMoreElements()) {
                            SysMessageID sysMessageID;
                            object3 = destinationArray[n2].getDestinationUID();
                            HashMap hashMap = ((FileStore)store).getInterestStates((DestinationUID)object3, sysMessageID = (object2 = (TransactionAcknowledgement[])object42222.nextElement()).getSysMessageID());
                            if (hashMap == null || hashMap.isEmpty()) {
                                jDBCStore.storeMessage((DestinationUID)object3, (Packet)object2, null, null, l, false);
                                continue;
                            }
                            int n4 = hashMap.size();
                            objectArray = new ConsumerUID[n4];
                            object = new int[n4];
                            Iterator iterator2 = hashMap.entrySet().iterator();
                            int n5 = 0;
                            while (iterator2.hasNext()) {
                                Map.Entry entry3 = iterator2.next();
                                objectArray[n5] = (ConsumerUID)entry3.getKey();
                                object[n5] = (Integer)entry3.getValue();
                                ++n5;
                            }
                            jDBCStore.storeMessage((DestinationUID)object3, (Packet)object2, (ConsumerUID[])objectArray, (int[])object, l, false);
                        }
                    }
                    Collection collection = ((FileStore)store).getTransactions(string4);
                    for (Object object42222 : collection) {
                        object3 = ((FileStore)store).getTransactionInfo((TransactionUID)object42222);
                        object2 = ((FileStore)store).getTransactionAcks((TransactionUID)object42222);
                        jDBCStore.storeTransaction((TransactionUID)object42222, (TransactionInfo)object3, l);
                        int n6 = ((TransactionAcknowledgement[])object2).length;
                        for (int i = 0; i < n6; ++i) {
                            jDBCStore.storeTransactionAck((TransactionUID)object42222, object2[i], false);
                        }
                    }
                    object42222 = new Properties();
                    ((Properties)object42222).setProperty("instanceRootDir", string5);
                    ((Properties)object42222).setProperty("reset", "false");
                    ((Properties)object42222).setProperty("logdomain", "imqdbmgr");
                    jMSBridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService("com.sun.messaging.bridge.service.JMSBridgeStore", "JMS", (Properties)object42222);
                    if (jMSBridgeStore != null) {
                        object3 = jMSBridgeStore.getJMSBridges(null);
                        object2 = null;
                        Iterator iterator3 = object3.iterator();
                        while (iterator3.hasNext()) {
                            object2 = (String)iterator3.next();
                            jDBCStore.addJMSBridge((String)object2, true, null);
                        }
                        jMSBridgeStore.closeJMSBridgeStore();
                        jMSBridgeStore = null;
                        object2 = null;
                        iterator3 = object3.iterator();
                        while (iterator3.hasNext()) {
                            object2 = (String)iterator3.next();
                            ((Properties)object42222).setProperty("jmsbridge", (String)object2);
                            if (jMSBridgeStore != null) {
                                jMSBridgeStore.closeJMSBridgeStore();
                                jMSBridgeStore = null;
                            }
                            logger.logToAll(8, "Restore JMS bridge " + (String)object2);
                            jMSBridgeStore = (JMSBridgeStore)BridgeServiceManager.getExportedService("com.sun.messaging.bridge.service.JMSBridgeStore", "JMS", (Properties)object42222);
                            List list2 = jMSBridgeStore.getTMLogRecordKeysByName((String)object2, null);
                            logger.logToAll(8, "\tRestore JMS bridge " + (String)object2 + " with " + list2.size() + " TM log records");
                            String string6 = null;
                            objectArray = null;
                            object = list2.iterator();
                            while (object.hasNext()) {
                                string6 = (String)object.next();
                                objectArray = jMSBridgeStore.getTMLogRecord(string6, (String)object2, null);
                                if (objectArray == null) {
                                    logger.logToAll(8, "JMSBridge TM log record not found for " + string6);
                                    continue;
                                }
                                jDBCStore.storeTMLogRecord(string6, (byte[])objectArray, (String)object2, true, null);
                            }
                        }
                    }
                    var34_43 = null;
                }
                catch (Throwable throwable) {
                    var34_43 = null;
                    store.close();
                    if (jMSBridgeStore != null) {
                        jMSBridgeStore.closeJMSBridgeStore();
                    }
                    throw throwable;
                }
                store.close();
                if (jMSBridgeStore == null) continue;
                jMSBridgeStore.closeJMSBridgeStore();
                {
                }
            }
            logger.logToAll(8, "Restore persistent store complete.");
            Object var36_45 = null;
            if (fileStore == null) break block32;
            try {
                fileStore.close();
                break block32;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            {
                break block32;
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new BrokerException(throwable.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var36_46 = null;
                if (fileStore != null) {
                    try {
                        fileStore.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                StoreManager.releaseStore(true);
                throw throwable;
            }
        }
        StoreManager.releaseStore(true);
    }

    private void doBackupSharecc() throws BrokerException {
        Properties properties = System.getProperties();
        String string = Globals.getClusterID();
        String string2 = (String)properties.get("imq.cluster.sharecc.backupfile");
        logger.logToAll(8, br.getKString("B1373", string, string2));
        ShareConfigChangeDBManager shareConfigChangeDBManager = ShareConfigChangeDBManager.getDBManager();
        ShareConfigRecordDAO shareConfigRecordDAO = shareConfigChangeDBManager.getDAOFactory().getShareConfigRecordDAO();
        try {
            List<ChangeRecordInfo> list = null;
            Util.RetryStrategy retryStrategy = null;
            while (true) {
                try {
                    list = shareConfigRecordDAO.getAllRecords(null);
                }
                catch (Exception exception) {
                    if (retryStrategy == null) {
                        retryStrategy = new Util.RetryStrategy(shareConfigChangeDBManager);
                    }
                    retryStrategy.assertShouldRetry(exception);
                    continue;
                }
                break;
            }
            Globals.getLogger().logToAll(8, br.getKString("B1370", String.valueOf(list.size()), shareConfigRecordDAO.getTableName()));
            ChangeRecord.backupRecords(list, string2, true);
            Globals.getLogger().logToAll(8, br.getKString("B1371", Globals.getClusterID(), string2));
        }
        catch (BrokerException brokerException) {
            String string3 = br.getKString("B3265", brokerException.getMessage());
            Globals.getLogger().logToAll(32, string3, (Object)brokerException);
            throw brokerException;
        }
    }

    private void doRestoreSharecc() throws BrokerException {
        Properties properties = System.getProperties();
        String string = Globals.getClusterID();
        String string2 = (String)properties.get("imq.cluster.sharecc.backupfile");
        logger.logToAll(8, br.getKString("B1374", string, string2));
        ShareConfigChangeDBManager shareConfigChangeDBManager = ShareConfigChangeDBManager.getDBManager();
        Connection connection = null;
        Exception exception = null;
        try {
            try {
                List<ChangeRecordInfo> list = ChangeRecord.prepareRestoreRecords(string2);
                ShareConfigRecordDAO shareConfigRecordDAO = shareConfigChangeDBManager.getDAOFactory().getShareConfigRecordDAO();
                Globals.getLogger().logToAll(8, br.getKString("B1375", String.valueOf(list.size()), string2));
                connection = shareConfigChangeDBManager.getConnection(false);
                Util.RetryStrategy retryStrategy = null;
                while (true) {
                    try {
                        ChangeRecordInfo changeRecordInfo = ChangeRecord.makeResetRecord(true);
                        shareConfigRecordDAO.insertResetRecord(connection, changeRecordInfo, false);
                        Iterator<ChangeRecordInfo> iterator = list.iterator();
                        ChangeRecordInfo changeRecordInfo2 = null;
                        while (iterator.hasNext()) {
                            changeRecordInfo2 = iterator.next();
                            if (changeRecordInfo2.getType() == 31) {
                                iterator.remove();
                                continue;
                            }
                            changeRecordInfo2.setResetUUID(changeRecordInfo.getUUID());
                            changeRecordInfo2.setTimestamp(System.currentTimeMillis());
                            ((ShareConfigRecordDAOImpl)shareConfigRecordDAO).insert(connection, changeRecordInfo2, false);
                        }
                        ((ShareConfigRecordDAOImpl)shareConfigRecordDAO).setResetRecordFLAGNULL(connection);
                        connection.commit();
                    }
                    catch (Exception exception2) {
                        if (retryStrategy == null) {
                            retryStrategy = new Util.RetryStrategy(shareConfigChangeDBManager);
                        }
                        retryStrategy.assertShouldRetry(exception2);
                        continue;
                    }
                    break;
                }
                Globals.getLogger().logToAll(8, br.getKString("B1376", Globals.getClusterID(), string2));
            }
            catch (Exception exception3) {
                exception = exception3;
                String string3 = br.getKString("B3267", exception3.getMessage());
                Globals.getLogger().logToAll(32, string3, (Object)exception3);
                if (exception3 instanceof BrokerException) {
                    throw (BrokerException)exception3;
                }
                throw new BrokerException(string3, exception3);
            }
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            Util.close(null, null, connection, exception, shareConfigChangeDBManager);
            throw throwable;
        }
        Util.close(null, null, connection, exception, shareConfigChangeDBManager);
    }

    private void doQuery() throws BrokerException {
        Connection connection = null;
        BrokerException brokerException = null;
        try {
            block8: {
                try {
                    connection = this.dbmgr.getConnection(true);
                    if (Globals.getHAEnabled()) {
                        System.out.println(br.getString("B1202", Globals.getBrokerID(), Globals.getClusterID()));
                    } else {
                        System.out.println(br.getString("B1042"));
                    }
                    DBTool.updateStoreVersion410IfNecessary(connection);
                    int n = this.dbmgr.checkStoreExists(connection);
                    if (n == 0) {
                        System.out.println(br.getString("B3132"));
                        break block8;
                    }
                    if (n > 0) {
                        System.out.println(br.getString("B3210"));
                        break block8;
                    }
                    System.out.println(br.getString("B3213"));
                }
                catch (BrokerException brokerException2) {
                    brokerException = brokerException2;
                    throw brokerException2;
                }
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Util.close(null, null, connection, brokerException);
            throw throwable;
        }
        Util.close(null, null, connection, brokerException);
    }

    private boolean printHelp(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_H) && !stringArray[i].equals(OPT_LH)) continue;
            return true;
        }
        return false;
    }

    private boolean printVersion(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_V) && !stringArray[i].equals(OPT_LV)) continue;
            return true;
        }
        return false;
    }

    private void checkArg(String string, String string2, int n, int n2) throws ParserException {
        this.checkArg(string, string2, null, n, n2);
    }

    private void checkArg(String string, String string2, String string3, int n, int n2) throws ParserException {
        if (n >= n2) {
            ParserException parserException;
            if (string != null) {
                parserException = new ParserException(MISSING_CMD_ARG);
                parserException.cmd = string;
            } else if (string3 != null) {
                parserException = new ParserException(MISSING_OPT);
                parserException.opt = string3;
            } else {
                parserException = new ParserException(MISSING_OPT_ARG);
                parserException.opt = string2;
            }
            throw parserException;
        }
    }

    private void throwParserException(int n, String string, String string2, String string3, String string4) throws ParserException {
        this.throwParserException(n, string, string2, string3, string4, null);
    }

    private void throwParserException(int n, String string, String string2, String string3, String string4, Throwable throwable) throws ParserException {
        ParserException parserException = new ParserException(n, throwable);
        parserException.cmd = string;
        parserException.cmdarg = string2;
        parserException.opt = string3;
        parserException.optarg = string4;
        throw parserException;
    }

    private void handleParserException(ParserException parserException) {
        if (parserException.reason == MISSING_CMD_ARG) {
            System.out.println(br.getString("B3083", parserException.cmd));
        } else if (parserException.reason == MISSING_OPT_ARG) {
            System.out.println(br.getString("B3080", parserException.opt));
        } else if (parserException.reason == MISSING_OPT) {
            System.out.println(br.getString("B3240", parserException.opt));
        } else if (parserException.reason == BAD_CMD_ARG) {
            System.out.println(br.getString("B3078", parserException.cmd, parserException.cmdarg));
        } else if (parserException.reason == BAD_OPT) {
            if (parserException.opt.equals(OPT_P)) {
                System.out.println(br.getString("B3217", parserException.opt));
            } else {
                System.out.println(br.getString("B3079", parserException.opt));
            }
        } else if (parserException.reason == BAD_OPT_ARG) {
            System.out.println(br.getString("B3081", parserException.opt, parserException.optarg));
        } else if (parserException.reason == EXTRA_CMD_SPECIFIED) {
            System.out.println(br.getString("B3077", parserException.cmd));
        }
    }

    private Properties parseArgs(String[] stringArray) throws ParserException {
        Properties properties = System.getProperties();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(CREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_ALL)) {
                    properties.put(CMD_NAME, CREATE_ALL_CMD);
                } else if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, CREATE_TBL_CMD);
                } else if (stringArray[i].equals(ARGU_SHARECCTBL)) {
                    properties.put(CMD_NAME, CREATE_SHARECCTBL_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, CREATE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(DELETE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                } else if (stringArray[i].equals(ARGU_SHARECCTBL)) {
                    properties.put(CMD_NAME, DELETE_SHARECCTBL_CMD);
                } else if (stringArray[i].equals(ARGU_OLDTBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                    properties.put(ARG_NAME, ARGU_OLDTBL);
                } else {
                    this.throwParserException(BAD_CMD_ARG, DELETE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(RECREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, RECREATE_TBL_CMD);
                } else if (stringArray[i].equals(ARGU_SHARECCTBL)) {
                    properties.put(CMD_NAME, RECREATE_SHARECCTBL_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, RECREATE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(REMOVE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_BKR)) {
                    properties.put(CMD_NAME, REMOVE_BKR_CMD);
                } else if (stringArray[i].equals(ARGU_JMSBRIDGE)) {
                    properties.put(CMD_NAME, REMOVE_JMSBRIDGE_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, REMOVE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(DUMP_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_SHARECCTBL)) {
                    properties.put(CMD_NAME, DUMP_SHARECCTBL_CMD);
                } else {
                    try {
                        Integer.parseInt(stringArray[i]);
                    }
                    catch (Exception exception) {
                        this.throwParserException(BAD_CMD_ARG, DUMP_CMD, stringArray[i], null, null, exception);
                    }
                    properties.put(CMD_NAME, DUMP_CMD);
                    properties.put(ARG_NAME, stringArray[i]);
                }
            } else if (stringArray[i].equals(DROPTBL_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                properties.put(CMD_NAME, DROPTBL_CMD);
                properties.put(ARG_NAME, stringArray[i]);
            } else if (stringArray[i].equals(RESET_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_LCK)) {
                    properties.put(CMD_NAME, RESET_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, RESET_CMD, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(BACKUP_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(OPT_DIR)) {
                    properties.put(CMD_NAME, BACKUP_CMD);
                    this.checkArg(stringArray[i], null, ++i, stringArray.length);
                    properties.put("imq.backupdir", stringArray[i]);
                } else if (stringArray[i].equals(ARGU_SHARECCTBL)) {
                    properties.put(CMD_NAME, BACKUP_SHARECCTBL_CMD);
                    this.checkArg(null, null, OPT_FILE, ++i, stringArray.length);
                    if (stringArray[i].equals(OPT_FILE)) {
                        this.checkArg(null, stringArray[i], null, ++i, stringArray.length);
                        properties.put("imq.cluster.sharecc.backupfile", stringArray[i]);
                    } else {
                        this.throwParserException(BAD_CMD_ARG, BACKUP_SHARECCTBL_CMD, stringArray[i], null, null);
                    }
                } else {
                    this.throwParserException(BAD_CMD_ARG, BACKUP_CMD, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(RESTORE_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(OPT_DIR)) {
                    properties.put(CMD_NAME, RESTORE_CMD);
                    this.checkArg(stringArray[i], null, ++i, stringArray.length);
                    properties.put("imq.backupdir", stringArray[i]);
                } else if (stringArray[i].equals(ARGU_SHARECCTBL)) {
                    properties.put(CMD_NAME, RESTORE_SHARECCTBL_CMD);
                    this.checkArg(null, null, OPT_FILE, ++i, stringArray.length);
                    if (stringArray[i].equals(OPT_FILE)) {
                        this.checkArg(null, stringArray[i], null, ++i, stringArray.length);
                        properties.put("imq.cluster.sharecc.backupfile", stringArray[i]);
                    } else {
                        this.throwParserException(BAD_CMD_ARG, RESTORE_SHARECCTBL_CMD, stringArray[i], null, null);
                    }
                } else {
                    this.throwParserException(BAD_CMD_ARG, RESTORE_CMD, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(UPGRADE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_STORE)) {
                    properties.put(CMD_NAME, UPGRADE_STORE_CMD);
                } else if (stringArray[i].equals(ARGU_HASTORE)) {
                    properties.put(CMD_NAME, UPGRADE_HASTORE_CMD);
                } else {
                    this.throwParserException(BAD_CMD_ARG, UPGRADE_CMD_STR, stringArray[i], null, null);
                }
            } else if (stringArray[i].equals(QUERY_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                properties.put(CMD_NAME, QUERY_CMD);
            } else if (stringArray[i].equals(OPT_B)) {
                this.checkArg(null, OPT_B, ++i, stringArray.length);
                properties.put("imq.instancename", stringArray[i]);
            } else if (stringArray[i].equals(OPT_N)) {
                this.checkArg(null, OPT_N, ++i, stringArray.length);
                properties.put("imq.brokerid", stringArray[i]);
                properties.put(JMSBRIDGE_NAME_PROPERTY, stringArray[i]);
            } else if (stringArray[i].equals(OPT_U)) {
                this.checkArg(null, OPT_U, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.user", stringArray[i]);
            } else if (stringArray[i].equals(OPT_PW)) {
                this.checkArg(null, OPT_PW, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.password", stringArray[i]);
                this.cliPasswdSpecified = true;
            } else if (stringArray[i].equals(OPT_PASSFILE)) {
                this.checkArg(null, OPT_PASSFILE, ++i, stringArray.length);
                File file = null;
                try {
                    file = new File(stringArray[i]).getCanonicalFile();
                }
                catch (Exception exception) {
                    this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
                }
                properties.put("imq.passfile.enabled", "true");
                properties.put("imq.passfile.dirpath", file.getParent());
                properties.put("imq.passfile.name", file.getName());
            } else if (!stringArray[i].equals(OPT_VERBOSE)) {
                if (stringArray[i].equals(OPT_DEBUG)) {
                    this.debugSpecified = true;
                } else if (stringArray[i].equals(OPT_FORCE)) {
                    this.forceSpecified = true;
                } else if (stringArray[i].equals(OPT_VARHOME)) {
                    ++i;
                } else if (stringArray[i].startsWith(OPT_D)) {
                    int n = 0;
                    String string = null;
                    String string2 = "";
                    n = stringArray[i].indexOf(61);
                    if (stringArray[i].length() <= 2) continue;
                    if (n < 0) {
                        string = stringArray[i].substring(2);
                    } else if (n == stringArray[i].length() - 1) {
                        string = stringArray[i].substring(2, n);
                    } else {
                        string = stringArray[i].substring(2, n);
                        string2 = stringArray[i].substring(n + 1);
                    }
                    properties.put(string, string2);
                } else {
                    this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
                }
            }
            if (properties.getProperty(REMOVE_JMSBRIDGE_CMD) == null || properties.getProperty(JMSBRIDGE_NAME_PROPERTY) != null) continue;
            this.checkArg(null, null, OPT_N, 0, 0);
        }
        return properties;
    }

    private void parsePassfile() throws FileNotFoundException {
        Properties properties;
        String string = null;
        String string2 = null;
        String string3 = null;
        string3 = config.getProperty("imq.passfile.enabled");
        if (string3 == null || !string3.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return;
        }
        string = config.getProperty("imq.passfile.dirpath");
        string2 = string != null ? (string = StringUtil.expandVariables((String)string, (Properties)config)) : config.getProperty("imq.etchome") + File.separator + "security";
        String string4 = string2 + File.separator + config.getProperty("imq.passfile.name");
        File file = new File(string4);
        if (file.exists()) {
            properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string4);
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                logger.log(32, br.getKString("B4023"), (Throwable)iOException);
            }
        } else {
            throw new FileNotFoundException(br.getKString("B3020", string4));
        }
        config.putAll((Map)properties);
    }

    private void exit(int n) {
        if (this.standalone) {
            System.exit(n);
        }
    }

    void doCommand(String[] stringArray) throws SQLException, BrokerException, FileNotFoundException {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        if (stringArray.length == 0) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printHelp(stringArray)) {
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printVersion(stringArray)) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
            System.out.println(br.getString("B1054") + System.getProperty("java.class.path"));
            this.exit(0);
        }
        Properties properties = null;
        try {
            properties = this.parseArgs(stringArray);
        }
        catch (ParserException parserException) {
            this.handleParserException(parserException);
            this.exit(1);
        }
        properties.getProperty("imq.persist.jdbc.connection.limit", "2");
        if (this.cliPasswdSpecified) {
            System.err.println(br.getString("B2088", OPT_PW));
            System.err.println("");
        }
        if ((string4 = properties.getProperty("imq.instancename")) != null && string4.length() > 0) {
            Globals.pathinit(null);
            string3 = Globals.JMQ_INSTANCES_HOME + File.separator + string4;
            if (!new File(string3).exists()) {
                System.err.println(br.getString("B3119", string4));
                System.exit(1);
            }
        }
        Globals.init(properties, false, false);
        config = Globals.getConfig();
        logger = Globals.getLogger();
        this.parsePassfile();
        string3 = config.getProperty("imq.persist.jdbc.dbVendor");
        String string5 = "imq.persist.jdbc." + string3;
        String string6 = properties.getProperty("imq.persist.jdbc.user");
        if (string6 != null && string6.length() > 0) {
            config.put(string5 + ".user", string6);
        }
        if ((string2 = properties.getProperty("imq.persist.jdbc.password")) != null && string2.length() > 0) {
            config.put(string5 + ".password", string2);
        }
        String string7 = properties.getProperty(CMD_NAME);
        CommDBManager commDBManager = null;
        if (DELETE_SHARECCTBL_CMD.equals(string7) || RECREATE_SHARECCTBL_CMD.equals(string7) || CREATE_SHARECCTBL_CMD.equals(string7) || DUMP_SHARECCTBL_CMD.equals(string7) || BACKUP_SHARECCTBL_CMD.equals(string7) || RESTORE_SHARECCTBL_CMD.equals(string7)) {
            if (this.debugSpecified) {
                System.out.println("cmd=" + string7 + ", use sharecc");
            }
            if (!Globals.useSharedConfigRecord()) {
                if (Globals.getHAEnabled()) {
                    logger.logToAll(32, br.getKString("B3260"));
                } else {
                    logger.logToAll(32, br.getKString("B3259", "imq.cluster.nomasterbroker"));
                }
                this.exit(1);
            }
            commDBManager = ShareConfigChangeDBManager.getDBManager();
        } else {
            this.dbmgr = DBManager.getDBManager();
            commDBManager = this.dbmgr;
        }
        String string8 = null;
        if (commDBManager instanceof DBManager) {
            string8 = ((DBManager)commDBManager).getBrokerID();
        }
        if ((string = CREATE_ALL_CMD.equals(string7) ? commDBManager.getCreateDBURL() : commDBManager.getOpenDBURL()) == null) {
            string = "not specified";
        }
        if ((string6 = commDBManager.getUser()) == null) {
            string6 = "not specified";
        }
        if (!(commDBManager instanceof ShareConfigChangeDBManager)) {
            object = new String[]{String.valueOf(410), string8, string, string6};
            logger.logToAll(8, br.getString("B1067", (Object[])object));
        } else {
            object = new String[]{"", String.valueOf("45"), Globals.getClusterID(), string, string6};
            logger.logToAll(8, br.getKString("B1351", (Object[])object));
        }
        if (this.debugSpecified) {
            System.out.println("cmd=" + string7);
        }
        if (CREATE_ALL_CMD.equals(string7)) {
            this.doCreate(true);
        } else if (CREATE_TBL_CMD.equals(string7)) {
            this.doCreate(false);
        } else if (CREATE_SHARECCTBL_CMD.equals(string7)) {
            this.doCreate(false, ShareConfigChangeDBManager.getDBManager());
        } else if (DELETE_TBL_CMD.equals(string7)) {
            this.doDelete(properties.getProperty(ARG_NAME), null);
        } else if (DELETE_SHARECCTBL_CMD.equals(string7)) {
            this.doDelete(properties.getProperty(ARG_NAME), ShareConfigChangeDBManager.getDBManager());
        } else if (RECREATE_TBL_CMD.equals(string7)) {
            this.doRecreate();
        } else if (RECREATE_SHARECCTBL_CMD.equals(string7)) {
            this.doRecreate(ShareConfigChangeDBManager.getDBManager());
        } else if (REMOVE_BKR_CMD.equals(string7)) {
            this.doRemoveBkr();
        } else if (REMOVE_JMSBRIDGE_CMD.equals(string7)) {
            this.doRemoveJMSBridge(properties.getProperty(JMSBRIDGE_NAME_PROPERTY));
        } else if (DUMP_CMD.equals(string7)) {
            object = properties.getProperty(ARG_NAME);
            this.doDump((String)object, null);
        } else if (DUMP_SHARECCTBL_CMD.equals(string7)) {
            this.doDump(null, ShareConfigChangeDBManager.getDBManager());
        } else if (DROPTBL_CMD.equals(string7)) {
            object = properties.getProperty(ARG_NAME);
            this.doDropTablesByPattern((String)object);
        } else if (RESET_CMD.equals(string7)) {
            this.doReset();
        } else if (BACKUP_CMD.equals(string7)) {
            this.doBackup();
        } else if (BACKUP_SHARECCTBL_CMD.equals(string7)) {
            this.doBackupSharecc();
        } else if (RESTORE_CMD.equals(string7)) {
            this.doRestore();
        } else if (RESTORE_SHARECCTBL_CMD.equals(string7)) {
            this.doRestoreSharecc();
        } else if (UPGRADE_STORE_CMD.equals(string7)) {
            this.doUpgrade(false);
        } else if (UPGRADE_HASTORE_CMD.equals(string7)) {
            this.doUpgrade(true);
        } else if (QUERY_CMD.equals(string7)) {
            this.doQuery();
        } else if (string7 == null) {
            System.out.println(br.getString("B3105"));
        } else {
            System.out.println(br.getString("B3104", string7));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n = 0;
        DBTool dBTool = new DBTool(true);
        try {
            try {
                dBTool.doCommand(stringArray);
            }
            catch (Exception exception) {
                if (exception instanceof BrokerException) {
                    Globals.getLogger().logStack(32, exception.getMessage(), (Throwable)exception);
                } else {
                    Globals.getLogger().logStack(32, exception.getMessage(), (Throwable)exception);
                }
                if (dBTool.debugSpecified) {
                    exception.printStackTrace();
                }
                n = 1;
                Object var5_4 = null;
                if (dBTool.dbmgr != null) {
                    dBTool.dbmgr.close();
                }
            }
            Object var5_3 = null;
            if (dBTool.dbmgr != null) {
                dBTool.dbmgr.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (dBTool.dbmgr != null) {
                dBTool.dbmgr.close();
            }
            throw throwable;
        }
        System.exit(n);
    }

    private static class ParserException
    extends Exception {
        String cmd;
        String cmdarg;
        String opt;
        String optarg;
        int reason;

        ParserException(int n) {
            this(n, null);
        }

        ParserException(int n, Throwable throwable) {
            super(throwable);
            this.reason = n;
        }
    }
}

