/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.bridge.service.DupKeyException;
import com.sun.messaging.bridge.service.KeyNotFoundException;
import com.sun.messaging.jmq.io.MQObjectInputStream;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.CommDBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.comm.MQSQLException;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class Util
implements DBConstants {
    static int insertDstDIDIndex = 1;
    static int insertDstDestIndex = 2;
    static int insertMsgMIDIndex = 1;
    static int insertMsgDIDIndex = 2;
    static int insertMsgSizeIndex = 3;
    static int insertMsgMsgIndex = 4;
    static int deleteStatesMIDIndex = 1;
    static int insertMsgStateMIDIndex = 1;
    static int insertMsgStateCUIDIndex = 2;
    static int insertMsgStateDIDIndex = 3;
    static int insertMsgStateStateIndex = 4;
    static int insertInterestCUIDIndex = 1;
    static int insertInterestIntIndex = 2;
    static int insertTxnTidIndex = 1;
    static int insertTxnStateIndex = 2;
    static int insertTxnStateObjIndex = 3;
    static int insertTxnAckTidIndex = 1;
    static int insertTxnAckAckIndex = 2;
    static int insertCCRTimeIndex = 1;
    static int insertCCRRecordIndex = 2;
    static int insertPropertyNameIndex = 1;
    static int insertPropertyValueIndex = 2;
    static boolean OracleBLOB_initialized = false;
    static Method OracleBLOB_empty_lob_method = null;
    static Method OracleBLOB_getBinaryOutputStream_method = null;
    static Method OraclePreparedStatement_setBLOB_method = null;

    static void setString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        if (string != null && string.length() > 0) {
            preparedStatement.setString(n, string);
        } else {
            preparedStatement.setNull(n, 12);
        }
    }

    static void setInt(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        if (n2 >= 0) {
            preparedStatement.setInt(n, n2);
        } else {
            preparedStatement.setNull(n, 4);
        }
    }

    static void setLong(PreparedStatement preparedStatement, int n, long l) throws SQLException {
        if (l >= 0L) {
            preparedStatement.setLong(n, l);
        } else {
            preparedStatement.setNull(n, -5);
        }
    }

    static void setObject(PreparedStatement preparedStatement, int n, Object object) throws IOException, SQLException {
        if (object == null) {
            preparedStatement.setNull(n, -4);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Util.setBytes(preparedStatement, n, byArray);
        }
    }

    public static void setBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws IOException, SQLException {
        if (byArray == null) {
            preparedStatement.setNull(n, -4);
        } else {
            preparedStatement.setBytes(n, byArray);
        }
    }

    static void setBytesAsBinaryStream(PreparedStatement preparedStatement, int n, byte[] byArray) throws IOException, SQLException {
        if (byArray == null) {
            preparedStatement.setNull(n, -4);
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, byArray.length);
            byteArrayInputStream.close();
        }
    }

    static Object readObject(ResultSet resultSet, int n) throws IOException, SQLException, ClassNotFoundException {
        InputStream inputStream = resultSet.getBinaryStream(n);
        if (inputStream == null) {
            return null;
        }
        MQObjectInputStream mQObjectInputStream = new MQObjectInputStream(inputStream);
        Object object = mQObjectInputStream.readObject();
        mQObjectInputStream.close();
        return object;
    }

    public static byte[] readBytes(ResultSet resultSet, int n) throws IOException, SQLException {
        InputStream inputStream = resultSet.getBinaryStream(n);
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, 256)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (EOFException eOFException) {
        }
        return byteArrayOutputStream.toByteArray();
    }

    static String getInsertDestinationSQL(String string) {
        return "INSERT INTO " + string + " (" + "DID" + ", " + "DEST" + ") VALUES ( ?,? )";
    }

    static String getInsertMessageSQL(String string) {
        return "INSERT INTO " + string + " (" + "MID" + ", " + "DID" + ", " + "MSGSIZE" + ", " + "MSG" + ") VALUES ( ?,?,?,? )";
    }

    static String getDeleteStatesSQL(String string) {
        return "DELETE FROM " + string + " WHERE " + "MID" + "=?";
    }

    static String getInsertMessageStateSQL(String string) {
        return "INSERT INTO " + string + " (" + "MID" + ", " + "CUID" + ", " + "DID" + ", " + "STATE" + ") " + "VALUES ( ?,?,?,? )";
    }

    static String getInsertInterestSQL(String string) {
        return "INSERT INTO " + string + " (" + "CUID" + ", " + "INTEREST" + ") VALUES ( ?,? )";
    }

    static PreparedStatement getPreparedStatement(Connection connection, String string) throws BrokerException {
        try {
            return connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            Globals.getLogger().log(32, "B4151", (Object)string, (Throwable)sQLException);
            throw new BrokerException(Globals.getBrokerResources().getString("B4151", string), sQLException);
        }
    }

    static String getInsertTxnSQL(String string) {
        return "INSERT INTO " + string + " (" + "TUID" + ", " + "STATE" + ", " + "TSTATEOBJ" + ") VALUES ( ?,?,? )";
    }

    static String getInsertTxnAckSQL(String string) {
        return "INSERT INTO " + string + " (" + "TUID" + ", " + "TXNACK" + ") VALUES ( ?,? )";
    }

    static String getInsertConfigRecordSQL(String string) {
        return "INSERT INTO " + string + " ( " + "RECORDTIME" + ", " + "RECORD" + ") " + "VALUES ( ?,? )";
    }

    static String getInsertPropertySQL(String string) {
        return "INSERT INTO " + string + " (" + "PROPNAME" + ", " + "PROPVALUE" + ") VALUES ( ?,? )";
    }

    public static void close(ResultSet resultSet, Statement statement, Connection connection, Throwable throwable) throws BrokerException {
        Util.close(resultSet, statement, connection, throwable, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void close(ResultSet resultSet, Statement statement, Connection connection, Throwable throwable, CommDBManager commDBManager) throws BrokerException {
        block8: {
            try {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException));
                }
                Object var7_5 = null;
                if (connection == null) return;
                if (commDBManager != null) break block8;
            }
            catch (Throwable throwable2) {
                Object var7_6 = null;
                if (connection == null) throw throwable2;
                if (commDBManager == null) {
                    DBManager.getDBManager().freeConnection(connection, throwable);
                    throw throwable2;
                }
                commDBManager.freeConnection(connection, throwable);
                throw throwable2;
            }
            DBManager.getDBManager().freeConnection(connection, throwable);
            return;
        }
        commDBManager.freeConnection(connection, throwable);
    }

    public static boolean isAlphanumericString(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            char c;
            int n = string.length();
            for (int i = 0; i < n && ((bl = Character.isLetterOrDigit(c = string.charAt(i))) || c == '_'); ++i) {
            }
        }
        return bl;
    }

    static final void OracleBLOB_init() throws BrokerException {
        if (!OracleBLOB_initialized) {
            try {
                Class<?> clazz = Class.forName("oracle.sql.BLOB");
                OracleBLOB_empty_lob_method = clazz.getMethod("empty_lob", null);
                Class[] classArray = new Class[]{Integer.TYPE};
                OracleBLOB_getBinaryOutputStream_method = clazz.getMethod("getBinaryOutputStream", null);
                Class<?> clazz2 = Class.forName("oracle.jdbc.OraclePreparedStatement");
                classArray = new Class[]{Integer.TYPE, clazz};
                OraclePreparedStatement_setBLOB_method = clazz2.getMethod("setBLOB", classArray);
                OracleBLOB_initialized = true;
            }
            catch (Exception exception) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Oracle LOB extension APIs not found"), exception);
            }
        }
    }

    static final Blob OracleBLOB_empty_lob() throws Exception {
        if (!OracleBLOB_initialized) {
            Util.OracleBLOB_init();
        }
        Blob blob = (Blob)OracleBLOB_empty_lob_method.invoke(null, null);
        return blob;
    }

    static final OutputStream OracleBLOB_getBinaryOutputStream(Blob blob) throws Exception {
        if (!OracleBLOB_initialized) {
            Util.OracleBLOB_init();
        }
        OutputStream outputStream = (OutputStream)OracleBLOB_getBinaryOutputStream_method.invoke((Object)blob, null);
        return outputStream;
    }

    static void OraclePreparedStatement_setBLOB(PreparedStatement preparedStatement, int n, Blob blob) throws Exception {
        if (!OracleBLOB_initialized) {
            Util.OracleBLOB_init();
        }
        Object[] objectArray = new Object[]{new Integer(n), blob};
        OraclePreparedStatement_setBLOB_method.invoke((Object)preparedStatement, objectArray);
    }

    static final Blob setOracleBLOB(PreparedStatement preparedStatement, int n) throws Exception {
        Blob blob = null;
        blob = Util.OracleBLOB_empty_lob();
        Util.OraclePreparedStatement_setBLOB(preparedStatement, n, blob);
        return blob;
    }

    static boolean isHADBTooManyLockError(Throwable throwable) {
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            return n == 2080 || n == 2096;
        }
        return false;
    }

    public static List getChunkDelimiters(ResultSet resultSet, int n, int n2) throws SQLException {
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        int n3 = 0;
        while (resultSet.next()) {
            if (++n3 != n2) continue;
            n3 = 0;
            arrayList.add(new Long(resultSet.getLong(n)));
        }
        arrayList.add(new Long(System.currentTimeMillis() + 60000L));
        return arrayList;
    }

    public static boolean isConnectionError(Throwable throwable, CommDBManager commDBManager) {
        return Util.isConnectionError(throwable, commDBManager, true);
    }

    public static boolean isConnectionError(Throwable throwable, CommDBManager commDBManager, boolean bl) {
        Throwable throwable2 = throwable;
        if (throwable instanceof DestinationNotFoundException || throwable instanceof TakeoverLockException || throwable instanceof StoreBeingTakenOverException || throwable instanceof TransactionAckExistException || throwable instanceof DupKeyException || throwable instanceof KeyNotFoundException) {
            return false;
        }
        if (throwable instanceof BrokerException) {
            throwable2 = throwable.getCause();
        }
        if (throwable2 instanceof MQSQLException) {
            throwable2 = ((MQSQLException)throwable2).getNextException();
        }
        if (!(throwable2 instanceof SQLException) && !(throwable2 instanceof IOException)) {
            return false;
        }
        if (bl && !commDBManager.isPoolDataSource()) {
            return true;
        }
        int n = 0;
        String string = null;
        String string2 = throwable2.getMessage();
        if (throwable2 instanceof SQLException) {
            n = ((SQLException)throwable2).getErrorCode();
            string = ((SQLException)throwable2).getSQLState();
        }
        if (CommDBManager.TRANSIENT_CONNECTION_SQLEX_CLASS != null) {
            if (CommDBManager.TRANSIENT_CONNECTION_SQLEX_CLASS.isInstance(throwable2)) {
                return true;
            }
        }
        if (CommDBManager.RECOVERABLE_SQLEX_CLASS != null) {
            if (CommDBManager.RECOVERABLE_SQLEX_CLASS.isInstance(throwable2)) {
                return true;
            }
        }
        if (commDBManager.isMysql()) {
            if (string2.contains("Communication link failure")) {
                return true;
            }
            if (string2.contains("No operations allowed after connection closed")) {
                return true;
            }
            if (string2.startsWith("Got temporary error") && string2.endsWith("from NDB")) {
                return true;
            }
            if (n == 1205 || string2.contains("Lock wait timeout exceeded")) {
                return true;
            }
        } else if (commDBManager.isOracle()) {
            if (string2.toLowerCase().contains("connection timed out")) {
                return true;
            }
            if (n == 30006 || n == 54 || n == 28 || n == 12514 || n == 12505 || n == 1089 || n == 1033 || n == 12528) {
                return true;
            }
        }
        if (string != null) {
            if (commDBManager.getSQLStateType() == 2) {
                return string.startsWith("08") || string.equals("01002") || string.equals("04501") || string.equals("HYT00") || string.equals("HYT01") || string.equals("S1T00");
            }
            if (commDBManager.getSQLStateType() == 1) {
                return string.startsWith("08");
            }
        }
        return false;
    }

    public static String brokerNotTakenOverClause(DBManager dBManager) throws BrokerException {
        return Globals.getHAEnabled() ? " AND NOT EXISTS (" + ((BrokerDAOImpl)dBManager.getDAOFactory().getBrokerDAO()).selectIsBeingTakenOverSQL + ")" : "";
    }

    public static void checkBeingTakenOver(Connection connection, DBManager dBManager, Logger logger, java.util.logging.Logger logger2) throws BrokerException {
        if (!Globals.getHAEnabled()) {
            return;
        }
        String string = dBManager.getBrokerID();
        BrokerDAO brokerDAO = dBManager.getDAOFactory().getBrokerDAO();
        if (brokerDAO.isBeingTakenOver(connection, string)) {
            StoreBeingTakenOverException storeBeingTakenOverException = new StoreBeingTakenOverException(Globals.getBrokerResources().getKString("B3223"));
            try {
                HABrokerInfo hABrokerInfo = brokerDAO.getBrokerInfo(connection, string);
                String string2 = Globals.getBrokerResources().getKString("B4117", hABrokerInfo.toString());
                logger.log(32, string2, (Throwable)storeBeingTakenOverException);
                Util.logExt(logger2, Level.SEVERE, string2, storeBeingTakenOverException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw storeBeingTakenOverException;
        }
    }

    public static void logExt(java.util.logging.Logger logger, Level level, String string, Throwable throwable) {
        if (logger == null) {
            return;
        }
        if (throwable != null) {
            logger.log(level, string, throwable);
        } else {
            logger.log(level, string);
        }
    }

    public static class RetryStrategy {
        CommDBManager dbMgr = null;
        Exception originalException = null;
        int retryCount = 0;
        int retryMax;
        long delayTime;
        boolean retryConnect = false;
        boolean retryConnectRequestOnly = false;

        public RetryStrategy() throws BrokerException {
            this(DBManager.getDBManager());
        }

        public RetryStrategy(CommDBManager commDBManager) {
            this(commDBManager, commDBManager.txnRetryDelay, commDBManager.txnRetryMax, false, false);
        }

        public RetryStrategy(CommDBManager commDBManager, long l, int n, boolean bl) {
            this(commDBManager, l, n, bl, false);
        }

        public RetryStrategy(CommDBManager commDBManager, long l, int n, boolean bl, boolean bl2) {
            this.dbMgr = commDBManager;
            this.delayTime = l;
            this.retryMax = n;
            this.retryConnect = bl;
            this.retryConnectRequestOnly = bl2;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public boolean assertShouldRetry(Exception var1_1) throws BrokerException {
            block42: {
                block50: {
                    block51: {
                        block43: {
                            block49: {
                                block48: {
                                    block47: {
                                        block46: {
                                            block45: {
                                                block44: {
                                                    var2_2 = false;
                                                    var3_3 = false;
                                                    var4_4 = false;
                                                    var5_5 = false;
                                                    if (this.originalException == null) {
                                                        this.originalException = var1_1;
                                                    }
                                                    if (var1_1 instanceof StoreBeingTakenOverException && Globals.getHAEnabled()) {
                                                        var6_6 = Globals.getBrokerResources().getKString("B3203");
                                                        Globals.getLogger().logStack(32, var6_6, (Throwable)var1_1);
                                                        Broker.getBroker().exit(BrokerStateHandler.getRestartCode(), var6_6, BrokerEvent.Type.RESTART, var1_1, true, false, true);
                                                        throw (StoreBeingTakenOverException)var1_1;
                                                    }
                                                    var6_7 = var1_1;
                                                    var7_8 /* !! */  = var1_1;
                                                    while (var7_8 /* !! */  instanceof BrokerException && (var7_8 /* !! */  = var7_8 /* !! */ .getCause()) != null) {
                                                        if (!(var7_8 /* !! */  instanceof SQLException) && !(var7_8 /* !! */  instanceof IOException)) continue;
                                                        var6_7 = var7_8 /* !! */ ;
                                                        break;
                                                    }
                                                    if (var6_7 instanceof MQSQLException) {
                                                        var6_7 = ((SQLException)var6_7).getNextException();
                                                    } else if (var6_7 instanceof IOException && Util.isConnectionError(var6_7, this.dbMgr, false)) {
                                                        var6_7 = new SQLException(var6_7.getMessage());
                                                    }
                                                    var8_9 = false;
                                                    if (!(var6_7 instanceof SQLException)) break block42;
                                                    var9_10 = (SQLException)var6_7;
                                                    var10_12 = var9_10.getErrorCode();
                                                    var11_13 = var9_10.getSQLState();
                                                    if (!this.retryConnect && (!this.retryConnectRequestOnly || !(var1_1 instanceof BrokerException) || !((BrokerException)var1_1).getSQLReconnect())) break block43;
                                                    if (CommDBManager.TRANSIENT_CONNECTION_SQLEX_CLASS == null) break block44;
                                                    if (!CommDBManager.TRANSIENT_CONNECTION_SQLEX_CLASS.isInstance(var9_10)) break block44;
                                                    var8_9 = true;
                                                    var3_3 = true;
                                                    break block43;
                                                }
                                                if (CommDBManager.TRANSIENT_SQLEX_CLASS == null) break block45;
                                                if (CommDBManager.TRANSIENT_SQLEX_CLASS.isInstance(var9_10)) break block46;
                                            }
                                            if (var11_13 == null || !var11_13.startsWith("08") && !var11_13.startsWith("40")) break block47;
                                        }
                                        var8_9 = true;
                                        var3_3 = true;
                                        break block43;
                                    }
                                    if (CommDBManager.TIMEOUT_SQLEX_CLASS == null) break block48;
                                    if (!CommDBManager.TIMEOUT_SQLEX_CLASS.isInstance(var9_10)) break block48;
                                    var8_9 = true;
                                    break block43;
                                }
                                if (CommDBManager.TRANSACTION_ROLLBACK_SQLEX_CLASS == null) break block49;
                                if (!CommDBManager.TRANSACTION_ROLLBACK_SQLEX_CLASS.isInstance(var9_10)) break block49;
                                var8_9 = true;
                                break block43;
                            }
                            if (CommDBManager.RECOVERABLE_SQLEX_CLASS == null) ** GOTO lbl-1000
                            if (CommDBManager.RECOVERABLE_SQLEX_CLASS.isInstance(var9_10)) {
                                var8_9 = true;
                                var4_4 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var12_14 = this.dbMgr.getReconnectPatterns();
                                var13_15 = var12_14.iterator();
                                var14_16 = null;
                                while (var13_15.hasNext()) {
                                    try {
                                        var14_16 = (String)var13_15.next();
                                        if (!var9_10.getMessage().matches(var14_16)) continue;
                                        var5_5 = true;
                                        var8_9 = true;
                                        break;
                                    }
                                    catch (Exception var15_17) {
                                        Globals.getLogger().logStack(16, var15_17.getMessage(), (Throwable)var15_17);
                                    }
                                }
                            }
                        }
                        if (var8_9) break block50;
                        if (CommDBManager.TRANSIENT_SQLEX_CLASS == null) break block51;
                        if (!CommDBManager.TRANSIENT_SQLEX_CLASS.isInstance(var9_10)) break block51;
                        var8_9 = true;
                        var3_3 = true;
                        break block50;
                    }
                    if (CommDBManager.RECOVERABLE_SQLEX_CLASS == null) ** GOTO lbl-1000
                    if (CommDBManager.RECOVERABLE_SQLEX_CLASS.isInstance(var9_10)) {
                        if (var1_1 instanceof BrokerException) {
                            if (((BrokerException)var1_1).getSQLRecoverable()) {
                                var8_9 = true;
                                var4_4 = true;
                            }
                            if (((BrokerException)var1_1).getSQLReplayCheck()) {
                                var2_2 = true;
                            }
                        }
                    } else if (var11_13 != null) {
                        if ((var11_13.startsWith("40") || var11_13.startsWith("08")) && var1_1 instanceof BrokerException) {
                            if (((BrokerException)var1_1).getSQLRecoverable()) {
                                var8_9 = true;
                                var4_4 = true;
                            }
                            if (((BrokerException)var1_1).getSQLReplayCheck()) {
                                var2_2 = true;
                            }
                        }
                    } else if (Util.isConnectionError(var9_10, this.dbMgr, false) && var1_1 instanceof BrokerException) {
                        if (((BrokerException)var1_1).getSQLRecoverable()) {
                            var8_9 = true;
                            var4_4 = true;
                        }
                        if (((BrokerException)var1_1).getSQLReplayCheck()) {
                            var2_2 = true;
                        }
                    }
                }
                if (!var8_9 && var1_1 instanceof BrokerException && ((BrokerException)var1_1).getSQLRecoverable()) {
                    if (this.dbMgr.isOracle() && (var10_12 == 30006 || var10_12 == 28)) {
                        var8_9 = true;
                        var4_4 = true;
                    }
                    if (!var8_9 && this.dbMgr.isRetriableSQLErrorCode(var10_12)) {
                        var8_9 = true;
                        var4_4 = true;
                    }
                    if (((BrokerException)var1_1).getSQLReplayCheck()) {
                        var2_2 = true;
                    }
                }
                if (!var8_9) {
                    if (this.dbMgr.isHADB()) {
                        var8_9 = var10_12 == 224 || var10_12 == 2078 || var10_12 == 2080 || var10_12 == 2096 || var10_12 == 2097 || var10_12 == 4576 || var10_12 == 12815 || var10_12 == 25012 || var10_12 == 25017 || var10_12 == 25018;
                    } else if (this.dbMgr.isOracle()) {
                        var8_9 = var10_12 == 16 || var10_12 == 44 || var10_12 == 17008 || var10_12 == 17009 || var10_12 == 17016 || var10_12 == 12535;
                    } else if (this.dbMgr.isMysql()) {
                        var12_14 = var9_10.getMessage();
                        var8_9 = var10_12 == 1205 || var10_12 == 1213 || var12_14.trim().toLowerCase().contains("got temporary error") != false && var12_14.trim().toLowerCase().contains("from ndb") != false || var12_14.trim().toLowerCase().contains("no operations allowed after connection closed") != false || var12_14.trim().toLowerCase().contains("lock wait timeout exceeded") != false;
                    } else if (this.dbMgr.isDerby()) {
                        var8_9 = var11_13.equals("40001");
                    } else {
                        var12_14 = var9_10.getMessage();
                        v0 = var8_9 = var12_14 != null && var12_14.toLowerCase().indexOf("timed out") > 0;
                    }
                }
            }
            if (var8_9 && this.retryCount < this.retryMax) {
                ++this.retryCount;
                Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1339", this.retryCount + "," + this.delayTime, var6_7.getMessage() + (var6_7 instanceof SQLException != false ? "[" + ((SQLException)var6_7).getErrorCode() + "][" + ((SQLException)var6_7).getSQLState() + "]" : "")) + "(" + var3_3 + "," + var4_4 + "[" + var2_2 + "]" + "," + var5_5 + ")");
                try {
                    Thread.sleep(this.delayTime);
                }
                catch (Exception var9_11) {
                    // empty catch block
                }
                Globals.getLogger().logStack(4, "Attempt to retry database operation due to unexpected error [retryCount=" + this.retryCount + ", delayTime=" + this.delayTime + "]", (Throwable)var1_1);
                if (!this.retryConnect || this.retryConnectRequestOnly) {
                    this.delayTime *= 2L;
                }
                return var2_2;
            }
            if (!(this.originalException instanceof BrokerException)) {
                this.originalException = new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to retry database operation"), this.originalException);
            }
            throw (BrokerException)this.originalException;
        }
    }
}

