/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.BrowserConsumer;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionRecover;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.InterestTable;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.PacketDispatcher;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.QueueReceiverImpl;
import com.sun.messaging.jmq.jmsclient.ReadQTable;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.TopicSubscriberImpl;
import com.sun.messaging.jmq.util.DebugPrinter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;

public class ReadChannel
implements PacketDispatcher,
Runnable {
    private ConnectionImpl connection = null;
    private ProtocolHandler protocolHandler = null;
    protected ReadQTable readQTable = null;
    protected ReadQTable ackQTable = null;
    protected InterestTable interestTable = null;
    protected Hashtable requestMetaData = null;
    protected boolean isClosed = false;
    protected boolean receivedGoodByeReply = false;
    protected FlowControl flowControl = null;
    protected boolean protectMode = false;
    protected static final String iMQReadChannel = "iMQReadChannel-";
    private boolean isFatalErrorSet = false;
    private Throwable savedError = null;
    protected JMSException savedJMSException = null;
    private boolean fatalErrorIsProcessed = false;
    private boolean isBrokerNonResponsive = false;
    protected Thread readChannelThread = null;
    protected ConnectionRecover conrc = null;
    private boolean debug = Debug.debug;
    public static final int REQUEST_TYPE_STATUS = 1;
    public static final int REQUEST_TYPE_CLUSTER = 2;
    public static final int REQUEST_TYPE_CONSUMER = 3;

    ReadChannel(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        this.protocolHandler = connectionImpl.getProtocolHandler();
        this.protocolHandler.setReplyDispatcher(this);
        this.interestTable = connectionImpl.interestTable;
        this.readQTable = connectionImpl.readQTable;
        this.ackQTable = connectionImpl.ackQTable;
        this.requestMetaData = connectionImpl.requestMetaData;
        this.init();
    }

    private void init() {
        this.protectMode = this.connection.getProtectMode();
        this.connection.flowControl = this.flowControl = new FlowControl(this.connection);
        this.flowControl.start();
        this.readChannelThread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            this.readChannelThread.setDaemon(true);
        }
        this.readChannelThread.setName(iMQReadChannel + this.connection.getLocalID());
        this.readChannelThread.start();
    }

    public void dispatch(ReadWritePacket readWritePacket) throws JMSException {
        switch (readWritePacket.getPacketType()) {
            case 54: {
                this.processPing(readWritePacket);
                return;
            }
            case 55: {
                return;
            }
            case 73: {
                this.processInfoPacket(readWritePacket);
                break;
            }
            case 15: 
            case 27: {
                this.replaceConsumerID(readWritePacket);
                this.processAcknowledge(readWritePacket);
                break;
            }
            case 11: {
                this.checkRedirectStatus(readWritePacket);
                this.replaceConnectionID(readWritePacket);
                this.updateBrokerVersionInfo(readWritePacket);
                this.processAcknowledge(readWritePacket);
                this.connection.writeChannel.updateFlowControl(readWritePacket);
                break;
            }
            case 19: {
                this.replaceProducerID(readWritePacket);
                this.processAcknowledge(readWritePacket);
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 67: 
            case 69: 
            case 71: 
            case 77: 
            case 79: {
                this.processAcknowledge(readWritePacket);
                break;
            }
            case 29: {
                this.processAcknowledge(readWritePacket);
                this.receivedGoodByeReply = true;
                this.close();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.processJMSMessage(readWritePacket);
                break;
            }
            case 52: {
                this.processResumeFlow(readWritePacket);
                break;
            }
            case 28: {
                this.processBrokerGoodbye(readWritePacket);
                break;
            }
            case 74: {
                this.processDebug(readWritePacket);
                break;
            }
            default: {
                if (this.isClosed) break;
                String string = AdministeredObject.cr.getKString("W2000");
                Debug.getPrintStream().println(string);
                readWritePacket.dump(Debug.getPrintStream());
                this.checkConnectionState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnectionState() {
        try {
            if (this.protocolHandler.isClosed()) {
                Debug.getPrintStream().println("Fatal Error: ReadChannel closing due to protocol handler closed.");
                this.close();
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    private void processPing(ReadOnlyPacket readOnlyPacket) {
        try {
            if (readOnlyPacket.getFlag(16)) {
                this.protocolHandler.pingReply(readOnlyPacket);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.rootLogger.log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
    }

    private void processInfoPacket(ReadWritePacket readWritePacket) {
        try {
            Hashtable hashtable = readWritePacket.getProperties();
            int n = (Integer)hashtable.get("JMQRequestType");
            if (n == 1) {
                this.processStatusInfoPacket(readWritePacket);
            } else if (n == 2) {
                this.processClusterInfoPacket(readWritePacket);
            } else if (n == 3) {
                this.processConsumerInfoPacket(readWritePacket);
            } else {
                Debug.println("*** received unknown INFO packet: ");
                readWritePacket.dump(Debug.getPrintStream());
            }
            String string = (String)hashtable.get("JMQBrokerList");
            if (string != null) {
                this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
                this.connection.JMQBrokerList = string;
                this.connection.triggerConnectionAddressListChangedEvent(string);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            Debug.printStackTrace(exception);
            readWritePacket.dump(Debug.getPrintStream());
        }
    }

    private void processStatusInfoPacket(ReadWritePacket readWritePacket) {
        Hashtable hashtable = ReadChannel.getHashtableFromMessageBody(readWritePacket);
        this.processStatusInfo(hashtable);
    }

    private void processStatusInfo(Hashtable hashtable) {
        boolean bl = this.isLocalBroker(hashtable);
        if (bl) {
            int n = (Integer)hashtable.get("State");
            long l = 0L;
            if (n == 7) {
                Long l2 = (Long)hashtable.get("ShutdownMS");
                if (l2 != null) {
                    l = l2;
                }
                this.connection.triggerConnectionClosingEvent(l);
            }
        } else {
            Debug.println("INFO pkt is not for the local broker.");
        }
    }

    private boolean isLocalBroker(Hashtable hashtable) {
        boolean bl = (Boolean)hashtable.get("isLocal");
        return bl;
    }

    private void processClusterInfoPacket(ReadWritePacket readWritePacket) {
        boolean bl = false;
        Hashtable hashtable = ReadChannel.getHashtableFromMessageBody(readWritePacket);
        Iterator iterator = hashtable.values().iterator();
        boolean bl2 = false;
        Hashtable hashtable2 = null;
        while (iterator.hasNext() && !bl2) {
            Object v = iterator.next();
            if (!(v instanceof Hashtable) || !(bl = this.isLocalBroker(hashtable2 = (Hashtable)v))) continue;
            bl2 = true;
        }
        if (bl2) {
            this.processStatusInfo(hashtable2);
        } else {
            Debug.println("INFO pkt is not for the local broker.");
            readWritePacket.dump(Debug.getPrintStream());
        }
    }

    private void processConsumerInfoPacket(ReadWritePacket readWritePacket) {
        Hashtable hashtable = ReadChannel.getHashtableFromMessageBody(readWritePacket);
        String string = (String)hashtable.get("JMQDestination");
        int n = (Integer)hashtable.get("JMQDestType");
        int n2 = (Integer)hashtable.get("JMQConsumerInfoType");
        this.connection.triggerConsumerEvent(n2, string, n);
    }

    protected static Hashtable getHashtableFromMessageBody(ReadOnlyPacket readOnlyPacket) {
        Hashtable hashtable = null;
        try {
            InputStream inputStream = readOnlyPacket.getMessageBodyStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            Debug.printStackTrace(exception);
        }
        return hashtable;
    }

    protected void processDebug(ReadWritePacket readWritePacket) {
        try {
            Hashtable hashtable = ReadChannel.getHashtableFromMessageBody(readWritePacket);
            if (hashtable.get("kill.jvm") != null) {
                ConnectionImpl.connectionLogger.log(Level.INFO, "FAULT-INJECTION: BROKER REQUESTS CLIENT JVM to TERMINATE !");
                System.exit(1);
                return;
            }
            boolean bl = this.setLoggingConfig(hashtable);
            if (bl) {
                return;
            }
            DebugPrinter debugPrinter = new DebugPrinter(2);
            String string = (String)hashtable.get("file");
            debugPrinter.setFile(string);
            String string2 = (String)hashtable.get("verbose");
            boolean bl2 = Boolean.valueOf(string2);
            Hashtable hashtable2 = this.connection.getDebugState(bl2);
            hashtable2.put("DebugCmd", hashtable);
            debugPrinter.setHashtable(hashtable2);
            debugPrinter.println();
            debugPrinter.close();
        }
        catch (Throwable throwable) {
            ExceptionHandler.logCaughtException(throwable);
            throwable.printStackTrace();
        }
    }

    private boolean setLoggingConfig(Hashtable hashtable) {
        boolean bl = false;
        try {
            String string = (String)hashtable.get("logging.name");
            if (string != null) {
                Logger logger = Logger.getLogger(string);
                String string2 = (String)hashtable.get("logging.level");
                Level level = Level.parse(string2);
                logger.setLevel(level);
                System.out.println("***** set logger " + logger.getName() + " to level " + string2);
                String string3 = (String)hashtable.get("logging.handler");
                Handler handler = null;
                if (string3 != null) {
                    String string4;
                    System.out.println("**** Handler: " + string3);
                    if (string3.equals("java.util.logging.FileHandler")) {
                        string4 = (String)hashtable.get("logging.pattern");
                        if (string4 != null) {
                            System.out.println("**** logging pattern: " + string4);
                            handler = new FileHandler(string4);
                        } else {
                            handler = new FileHandler();
                        }
                    } else {
                        handler = (Handler)Class.forName(string3).newInstance();
                    }
                    handler.setLevel(level);
                    string4 = (String)hashtable.get("logging.formatter");
                    if (string4 != null) {
                        Formatter formatter = (Formatter)Class.forName(string4).newInstance();
                        System.out.println("*** setting formatter to handler: " + string4);
                        handler.setFormatter(formatter);
                    }
                    logger.addHandler(handler);
                    System.out.println("***** set handler " + string3 + " to logger " + string);
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    protected void processBrokerGoodbye(ReadWritePacket readWritePacket) throws JMSException {
        Serializable serializable;
        Object object;
        Boolean bl = null;
        String string = "E203";
        try {
            object = readWritePacket.getProperties();
            if (object != null) {
                bl = (Boolean)((Hashtable)object).get("JMQExit");
                serializable = (Integer)((Hashtable)object).get("JMQGoodbyeReason");
                int n = -1;
                if (serializable != null) {
                    n = serializable;
                    switch (n) {
                        case 1: {
                            string = "E201";
                            break;
                        }
                        case 2: {
                            string = "E202";
                            break;
                        }
                        case 3: {
                            string = "E204";
                            break;
                        }
                        case 4: {
                            string = "E203";
                            break;
                        }
                        case 5: {
                            string = "E206";
                            break;
                        }
                        default: {
                            string = "E203";
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            exception.printStackTrace();
        }
        this.connection.triggerConnectionClosedEvent(string, null);
        if (!this.connection.imqReconnect || bl != null && bl.booleanValue()) {
            object = AdministeredObject.cr.getKString("C4056");
            serializable = new JMSException((String)object, "C4056");
            this.exitConnection((JMSException)serializable);
        }
        if (this.protocolHandler.isDirectMode()) {
            this.protocolHandler.close();
        }
    }

    private void updateBrokerVersionInfo(ReadWritePacket readWritePacket) throws JMSException {
        try {
            Boolean bl;
            int n;
            Integer n2;
            Hashtable hashtable = readWritePacket.getProperties();
            String string = (String)hashtable.get("JMQVersion");
            if (string != null) {
                this.connection.setBrokerVersion(string);
            }
            if ((n2 = (Integer)hashtable.get("JMQProtocolLevel")) != null) {
                this.connection.setBrokerProtocolLevel(n2);
            }
            if ((n = ((Integer)hashtable.get("JMQStatus")).intValue()) == 505 && this.connection.checkBrokerProtocolLevel()) {
                this.connection.setNegotiateProtocolLevel(true);
                this.close();
            } else if (n == 200 && (bl = (Boolean)hashtable.get("JMQHA")) != null && bl.booleanValue()) {
                String string2;
                Long l;
                this.connection.setConnectedToHABroker();
                if (this.connection.JMQClusterID == null) {
                    this.connection.JMQClusterID = (String)hashtable.get("JMQClusterID");
                }
                if ((l = (Long)hashtable.get("JMQStoreSession")) != null) {
                    Debug.println("**** Previous JMQStoreSession: " + this.connection.JMQStoreSession);
                    Debug.println("**** Using JMQStoreSession: " + l);
                    this.connection.JMQStoreSession = l;
                }
                if ((string2 = (String)hashtable.get("JMQBrokerList")) != null) {
                    this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
                    this.connection.JMQBrokerList = string2;
                }
                Debug.println("*** connected to HA broker.  JMQClusterID=" + this.connection.JMQClusterID + " JMQStoreSession=" + this.connection.JMQStoreSession + " JMQBrokerList=" + this.connection.JMQBrokerList);
            }
        }
        catch (Exception exception) {
            ExceptionHandler cfr_ignored_0 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(exception, "C4000", true);
        }
    }

    protected void replaceConnectionID(ReadWritePacket readWritePacket) throws JMSException {
        try {
            Hashtable hashtable = readWritePacket.getProperties();
            Long l = (Long)hashtable.get("JMQConnectionID");
            if (l != null) {
                this.connection.setConnectionID(l);
            }
        }
        catch (Exception exception) {
            ExceptionHandler cfr_ignored_0 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(exception, "C4000", true);
        }
    }

    protected void replaceProducerID(ReadWritePacket readWritePacket) throws JMSException {
        try {
            Long l;
            Hashtable hashtable = readWritePacket.getProperties();
            Long l2 = new Long(readWritePacket.getConsumerID());
            Long l3 = (Long)hashtable.get("JMQProducerID");
            MessageProducerImpl messageProducerImpl = (MessageProducerImpl)this.requestMetaData.get(l2);
            this.requestMetaData.remove(l2);
            if (l3 == null) {
                if (this.debug) {
                    Debug.getPrintStream().println("**** No producer for packet: ");
                    readWritePacket.dump(Debug.getPrintStream());
                }
                return;
            }
            int n = -1;
            long l4 = -1L;
            Integer n2 = (Integer)hashtable.get("JMQSize");
            if (n2 != null) {
                n = n2;
            }
            if ((l = (Long)hashtable.get("JMQBytes")) != null) {
                l4 = l;
            }
            long l5 = l3;
            Destination destination = messageProducerImpl.addProducerDest;
            messageProducerImpl.setProducerID(destination, l5);
            messageProducerImpl.setFlowLimit(l5, n);
            messageProducerImpl.setFlowBytesLimit(l5, l4);
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            exception.printStackTrace(Debug.getPrintStream());
        }
    }

    protected void replaceConsumerID(ReadWritePacket readWritePacket) throws JMSException {
        try {
            int n;
            Hashtable hashtable = readWritePacket.getProperties();
            Long l = new Long(readWritePacket.getConsumerID());
            Long l2 = (Long)hashtable.get("JMQConsumerID");
            Consumer consumer = (Consumer)this.requestMetaData.get(l);
            this.requestMetaData.remove(l);
            if (l2 == null) {
                if (this.debug) {
                    Debug.getPrintStream().println("**** No consumer for packet: ");
                    readWritePacket.dump(Debug.getPrintStream());
                }
                return;
            }
            this.interestTable.removeInterest(consumer);
            consumer.setInterestId(l2);
            Integer n2 = (Integer)hashtable.get("JMQDestType");
            consumer.setDestType(n2);
            this.interestTable.addInterest(consumer);
            Integer n3 = (Integer)hashtable.get("JMQSize");
            if (n3 != null && (n = n3.intValue()) > 0) {
                consumer.setPrefetchMaxMsgCount(n);
            }
            this.connection.flowControl.addConsumerFlowControl(consumer);
            SessionImpl sessionImpl = null;
            if (readWritePacket.getPacketType() == 15) {
                if (consumer instanceof TopicSubscriberImpl) {
                    TopicSubscriberImpl topicSubscriberImpl = (TopicSubscriberImpl)consumer;
                    sessionImpl = topicSubscriberImpl.getSession();
                    sessionImpl.addMessageConsumer((MessageConsumerImpl)consumer);
                } else if (consumer instanceof QueueReceiverImpl) {
                    QueueReceiverImpl queueReceiverImpl = (QueueReceiverImpl)consumer;
                    sessionImpl = queueReceiverImpl.getSession();
                    sessionImpl.addMessageConsumer((MessageConsumerImpl)consumer);
                }
            } else {
                BrowserConsumer browserConsumer = (BrowserConsumer)consumer;
                sessionImpl = browserConsumer.getSession();
                sessionImpl.addBrowserConsumer(browserConsumer);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            exception.printStackTrace();
        }
    }

    protected void processResumeFlow(ReadWritePacket readWritePacket) throws JMSException {
        try {
            Hashtable hashtable = readWritePacket.getProperties();
            Integer n = (Integer)hashtable.get("JMQSize");
            Long l = (Long)hashtable.get("JMQBytes");
            Long l2 = (Long)hashtable.get("JMQProducerID");
            if (this.debug) {
                Debug.println("processResumeFlow() : JMQSize = " + n + ", JMQBytes = " + l + ", ProducerID = " + l2);
            }
            if (l2 != null) {
                MessageProducerImpl messageProducerImpl = this.connection.findMessageProducer(l2);
                if (messageProducerImpl != null) {
                    if (n != null) {
                        messageProducerImpl.setFlowLimit(l2, n);
                    }
                    if (l != null) {
                        messageProducerImpl.setFlowBytesLimit(l2, l);
                    }
                } else if (this.debug) {
                    Debug.info("*** warning: Cannot find producer for the resume pkt: ");
                    readWritePacket.dump(Debug.getPrintStream());
                    this.connection.printDebugState();
                }
            } else {
                if (this.debug) {
                    Debug.info("Connection Resume Flow pkt dump: ");
                    readWritePacket.dump(Debug.getPrintStream());
                }
                this.connection.writeChannel.updateFlowControl(readWritePacket);
            }
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            exception.printStackTrace();
            readWritePacket.dump(Debug.getPrintStream());
        }
    }

    protected void processJMSMessage(ReadWritePacket readWritePacket) throws JMSException {
        long l;
        SessionQueue sessionQueue = null;
        Consumer consumer = null;
        Long l2 = null;
        this.flowControl.messageReceived();
        if (readWritePacket.getFlowPaused()) {
            this.flowControl.requestConnectionFlowResume();
        }
        if ((consumer = this.interestTable.getConsumer(new Long(l = readWritePacket.getConsumerID()))) != null) {
            l2 = consumer.getReadQueueId();
            if (l2 != null) {
                sessionQueue = this.readQTable.get(l2);
                if (sessionQueue != null) {
                    this.flowControl.messageReceived(consumer);
                    if (readWritePacket.getConsumerFlow()) {
                        this.flowControl.requestResume(consumer);
                    }
                    if (consumer instanceof BrowserConsumer) {
                        this.deliverToBrowserConsumer((BrowserConsumer)consumer, readWritePacket);
                    } else {
                        sessionQueue.enqueueNotify(readWritePacket);
                    }
                } else {
                    String string = AdministeredObject.cr.getKString("W2001");
                    String string2 = string + "\n" + readWritePacket.toVerboseString();
                    ConnectionImpl.connectionLogger.log(Level.WARNING, string2);
                }
            } else {
                if (this.debug) {
                    Debug.getPrintStream().println("ERROR: NO session (null) for packet: ");
                    readWritePacket.dump(Debug.getPrintStream());
                }
                String string = "No Session for pkt: \n" + readWritePacket.toVerboseString();
                ConnectionImpl.connectionLogger.log(Level.FINE, string);
            }
        } else {
            if (this.debug) {
                Debug.getPrintStream().println("ERROR: NO consumer for packet: ");
                readWritePacket.dump(Debug.getPrintStream());
            }
            String string = "No consumer for pkt: \n" + readWritePacket.toVerboseString();
            ConnectionImpl.connectionLogger.log(Level.FINE, string);
        }
    }

    protected void deliverToBrowserConsumer(BrowserConsumer browserConsumer, ReadOnlyPacket readOnlyPacket) throws JMSException {
        MessageImpl messageImpl = this.protocolHandler.getJMSMessage(readOnlyPacket);
        SessionImpl sessionImpl = browserConsumer.session;
        messageImpl.setSession(sessionImpl);
        browserConsumer.onMessage(messageImpl);
    }

    protected void processAcknowledge(ReadWritePacket readWritePacket) {
        boolean bl;
        boolean bl2 = bl = this.protocolHandler.isDirectModeTwoThreadWithSyncReplies() && readWritePacket.getPacketType() != 23;
        if (bl) {
            return;
        }
        long l = readWritePacket.getConsumerID();
        SessionQueue sessionQueue = this.ackQTable.get(new Long(l));
        if (sessionQueue != null) {
            if (this.debug) {
                Debug.println("*** notify waiting queue ...." + readWritePacket);
            }
            sessionQueue.enqueueNotify(readWritePacket);
        } else if (!(this.connection.connectionIsBroken || this.connection.reconnecting || this.connection.isCloseCalled)) {
            String string = AdministeredObject.cr.getKString("W2001");
            String string2 = string + "\n" + readWritePacket.toVerboseString();
            ConnectionImpl.connectionLogger.log(Level.WARNING, string2);
        }
    }

    protected synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.flowControl.close();
    }

    public void run() {
        ReadWritePacket readWritePacket = null;
        while (!this.isClosed) {
            try {
                readWritePacket = this.protocolHandler.readPacket();
                this.dispatch(readWritePacket);
            }
            catch (JMSException jMSException) {
                if (this.debug) {
                    Debug.println("ReadChannel[connection closed=" + this.connection.isClosed + ", received goodbye-reply=" + this.receivedGoodByeReply + "] : " + jMSException.getMessage());
                    Debug.printStackTrace(jMSException);
                }
                if (this.isFatalErrorSet) {
                    this.fatalError(this.savedError);
                    return;
                }
                if (this.connection.isClosed || this.receivedGoodByeReply) {
                    this.connection.connectionIsBroken = true;
                    this.closeIOAndNotify();
                    return;
                }
                if (this.isBrokerNonResponsive) {
                    this.isBrokerNonResponsive = false;
                    this.connection.triggerConnectionClosedEvent("E207", null);
                } else {
                    this.connection.triggerConnectionClosedEvent("E206", jMSException);
                }
                this.recover2(jMSException);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
            catch (Throwable throwable) {
                this.fatalError(throwable);
            }
        }
        if (this.debug) {
            Debug.println("ReadChannel exit ...");
        }
    }

    protected synchronized void setFatalError(Throwable throwable) {
        try {
            if (this.isFatalErrorSet) {
                return;
            }
            this.isFatalErrorSet = true;
            this.savedError = throwable;
            this.protocolHandler.close();
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            Debug.printStackTrace(exception);
        }
    }

    protected void setBrokerNonResponsive() {
        try {
            if (this.debug) {
                Debug.println("*** broker is not responsive.  Closing I/O stream ...");
            }
            this.isBrokerNonResponsive = true;
            this.protocolHandler.close();
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fatalError(Throwable throwable) {
        try {
            ExceptionHandler.logError(throwable);
            Object object = this;
            synchronized (object) {
                block11: {
                    if (!this.fatalErrorIsProcessed) break block11;
                    return;
                }
                this.fatalErrorIsProcessed = true;
            }
            this.connection.connectionIsBroken = true;
            this.readQTable.closeAll();
            object = AdministeredObject.cr.getKString("C4089", throwable.toString());
            JMSException jMSException = new JMSException((String)object, "C4089");
            this.exitConnection(jMSException);
        }
        catch (Throwable throwable2) {
            if (Debug.debug) {
                throwable2.printStackTrace();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    private void recover2(JMSException jMSException) {
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.connection.setRecoverInProcess(true);
        boolean bl = false;
        if (this.connection.imqReconnect) {
            bl = this.doRecover();
        }
        this.connection.setRecoverInProcess(false);
        if (!bl) {
            this.exitConnection(jMSException);
        }
    }

    private boolean doRecover() {
        boolean bl = false;
        try {
            this.connection.setReconnecting(true);
            this.closeIOAndNotify();
            if (this.conrc == null) {
                this.conrc = new ConnectionRecover(this.connection);
            } else {
                this.conrc.waitUntilInactive();
                if (this.conrc.getRecoverState() == 7) {
                    return false;
                }
            }
            this.conrc.init();
            bl = true;
        }
        catch (Exception exception) {
            ExceptionHandler.logCaughtException(exception);
            this.connection.setReconnecting(false);
        }
        if (bl) {
            this.conrc.start();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitConnection(JMSException jMSException) {
        block8: {
            block9: {
                Exception exception;
                this.connection.connectionIsBroken = true;
                this.savedJMSException = jMSException;
                try {
                    this.closeIOAndNotify();
                    this.readQTable.closeAll();
                    this.connection.exitConnection();
                    this.flowControl.close();
                    Object var3_2 = null;
                    this.isClosed = true;
                    this.connection.triggerConnectionClosedEvent("E206", jMSException);
                    this.connection.logLifeCycle("E500");
                    if (this.connection.exceptionListener != null) {
                        this.connection.triggerConnectionExitEvent(jMSException);
                        break block8;
                    }
                    exception = jMSException.getLinkedException();
                    if (exception == null || !this.protocolHandler.authenticated) break block9;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.isClosed = true;
                    this.connection.triggerConnectionClosedEvent("E206", jMSException);
                    this.connection.logLifeCycle("E500");
                    if (this.connection.exceptionListener != null) {
                        this.connection.triggerConnectionExitEvent(jMSException);
                    } else {
                        Exception exception2 = jMSException.getLinkedException();
                        if (exception2 != null && this.protocolHandler.authenticated) {
                            Debug.printStackTrace(exception2);
                        }
                        if (this.protocolHandler.authenticated) {
                            Debug.printStackTrace(jMSException);
                        }
                    }
                    throw throwable;
                }
                Debug.printStackTrace(exception);
            }
            if (this.protocolHandler.authenticated) {
                Debug.printStackTrace(jMSException);
            }
        }
    }

    protected void closeIOAndNotify() {
        block2: {
            try {
                this.protocolHandler.close();
            }
            catch (Exception exception) {
                ExceptionHandler.logCaughtException(exception);
                if (!this.debug) break block2;
                Debug.printStackTrace(exception);
            }
        }
        this.readQTable.notifyAllQueues();
        this.ackQTable.notifyAllQueues();
    }

    private void checkRedirectStatus(ReadWritePacket readWritePacket) throws JMSException {
        if (this.connection.reconnecting) {
            try {
                Hashtable hashtable = readWritePacket.getProperties();
                int n = (Integer)hashtable.get("JMQStatus");
                if (n == 301) {
                    this.connection.JMQStoreOwner = (String)hashtable.get("JMQStoreOwner");
                    this.connection.initiator.setRedirectURL(this.connection.JMQStoreOwner);
                    this.protocolHandler.close();
                    String string = AdministeredObject.cr.getKString("I108", this.connection.getLastContactedBrokerAddress(), this.connection.JMQStoreOwner);
                    ConnectionImpl.connectionLogger.log(Level.INFO, string);
                    com.sun.messaging.jms.JMSException jMSException = new com.sun.messaging.jms.JMSException(string);
                    ExceptionHandler.throwJMSException(jMSException);
                } else if (n == 408) {
                    String string = AdministeredObject.cr.getKString("I109", this.connection.getLastContactedBrokerAddress());
                    ConnectionImpl.connectionLogger.log(Level.INFO, string);
                    this.protocolHandler.close();
                    com.sun.messaging.jms.JMSException jMSException = new com.sun.messaging.jms.JMSException(string);
                    ExceptionHandler.throwJMSException(jMSException);
                }
            }
            catch (JMSException jMSException) {
                throw jMSException;
            }
            catch (Exception exception) {
                com.sun.messaging.jms.JMSException jMSException = new com.sun.messaging.jms.JMSException(exception.toString());
                ExceptionHandler.throwJMSException(jMSException);
            }
        }
    }
}

